/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcmaps_runvars.h
    \brief  API of runvars structure
    \author Martijn Steenbakkers for the EU DataGrid.

    This module takes the data that are presented to LCMAPS (the global credential and Job request) and extracts the
    variables that will be used by the plugins from it and stores them into a list.
    The interface to the LCMAPS module is composed of:
    -# lcmaps_extractRunVars(): takes the global credential and Job request and extracts run variables from them
    -# lcmaps_setRunVars(): adds run variables to a list
    -# lcmaps_getRunVars(): gets run variables from list
*/

#ifndef _LCMAPS_RUNVARS_H
#define _LCMAPS_RUNVARS_H

/*****************************************************************************
                            Include header files
******************************************************************************/

/* LCMAPS includes */
#include "lcmaps_types.h"
#include "_lcmaps_credential.h"

/******************************************************************************
 *                 Module definition
 *****************************************************************************/

#ifndef LCMAPS_RUNVARS_C
#   define LCMAPS_RUNVARS_STORAGE_CLASS extern
#else
#   define LCMAPS_RUNVARS_STORAGE_CLASS
#endif

LCMAPS_RUNVARS_STORAGE_CLASS int lcmaps_extractRunVars(
        lcmaps_request_t request,
        lcmaps_cred_id_t lcmaps_cred
);

LCMAPS_RUNVARS_STORAGE_CLASS void * lcmaps_getRunVars(
        char *argName,
        char *argType
);

LCMAPS_RUNVARS_STORAGE_CLASS int lcmaps_setRunVars(
        char *argName,
        char *argType,
        void *value
);



/* static lcmaps_request_t job_request; */
/* static lcmaps_cred_id_t lcmaps_credential; */


#endif /* _LCMAPS_RUNVARS_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/src/grid_credential_handling/_lcmaps_runvars.h,v $
    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
    $Revision: 14868 $
    $Author: dennisvd $
******************************************************************************/
