<?php
/*
$Id: groupOfUniqueNames.inc,v 1.4 2008-02-14 17:38:13 roland Exp $

  This code is part of LDAP Account Manager (http://www.sourceforge.net/projects/lam)
  Copyright (C) 2006 - 2007  Roland Gruber

*/

/**
* Manages group members for the object class groupOfUniqueNames.
*
* @package modules
* @author Roland Gruber
*/

/** include parent class */
include_once("groupOfNames.inc");

/**
* Manages group members for the object class groupOfUniqueNames.
*
* @package modules
*/
class groupOfUniqueNames extends groupOfNames {
	
	/** name of managed object class */
	protected $OBJECT_CLASS_NAME = "groupOfUniqueNames";
	
	/** name of member attribute */
	protected $ATTR_MEMBER_NAME = "uniqueMember";
	
	/**
	* Returns meta data that is interpreted by parent class
	*
	* @return array array with meta data
	* 
	* @see baseModule::get_metaData()
	*/
	function get_metaData() {
		$ret = parent::get_metaData();
		$ret["alias"] = _("Group of unique names");
		return $ret;
	}

}

?>