<?php
/*
$Id: logout.php,v 1.21 2006/04/23 16:33:25 gruberroland Exp $

  This code is part of LDAP Account Manager (http://www.sourceforge.net/projects/lam)
  Copyright (C) 2003 - 2006  Roland Gruber

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/**
* User is logged off from LDAP server, session is destroyed.
*
* @package main
* @author Roland Gruber
*/ 


// delete key and iv in cookie
if (function_exists('mcrypt_create_iv')) {
	setcookie("Key", "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", 0, "/");
	setcookie("IV", "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", 0, "/");
}

/** security functions */
include_once("../lib/security.inc");
/** Used to display status messages */
include_once("../lib/status.inc");
/** LDAP settings are deleted at logout */
include_once("../lib/ldap.inc");

// start session
startSecureSession();

// log message
$ldapUser = $_SESSION['ldap']->decrypt_login();
logNewMessage(LOG_NOTICE, 'User ' . $ldapUser[0] . ' logged off.');

// close LDAP connection
@$_SESSION["ldap"]->destroy();

setlanguage();

echo $_SESSION['header'];

// destroy session
session_destroy();
unset($_SESSION);

// print logout message
?>

	<title>
		<?php echo _("Logout"); ?>
	</title>
	<link rel="stylesheet" type="text/css" href="../style/layout.css">
	</head>
	<body>
	<p align="center"><a href="http://lam.sourceforge.net" target="new_window">
		<img src="../graphics/banner.jpg" border=1 alt="LDAP Account Manager"></a>
	</p>
	<hr>
	<br>
	<p align="center"><big><b><?php echo _("You have been logged off from LDAP Account Manager."); ?></b></big></p>
	<br><br><br><br><br><a href="../templates/login.php" target="_top"> <?php echo _("Back to Login") ?> </a>
	</body>
</html>
