<?php
/*
	$Id: adminLogin.php,v 1.7 2008-01-01 13:05:30 roland Exp $

	This code is part of LDAP Account Manager Pro (http://www.sourceforge.net/projects/lam)
	Copyright (C) 2006 - 2007  Roland Gruber
*/

/**
* Login page for self service configuration.
*
* @package selfService
*
* @author Roland Gruber
*/

/** Access to self service profiles */
include_once('../../lib/selfService.inc');
/** status messages */
include_once('../../lib/status.inc');
/** Access config options */
include_once('../../lib/config.inc');

// start session
session_save_path("../../sess");
@session_start();

setlanguage();

// remove settings from session
$sessionKeys = array_keys($_SESSION);
for ($i = 0; $i < sizeof($sessionKeys); $i++) {
	if (substr($sessionKeys[$i], 0, 12) == "selfService_") unset($_SESSION[$sessionKeys[$i]]);
}

$errorMessage = null;

// check if user pushed Ok button
if (isset($_POST['submit'])) {
	$conf = new LAMCfgMain();
	if ($conf->checkPassword($_POST['passwd'])) {
		// password is correct, save user input in session
		$_SESSION['selfService_password'] = $_POST['passwd'];
		$parts = split(":", $_POST['filename']);
		$_SESSION['selfService_scope'] = $parts[0];
		$_SESSION['selfService_name'] = $parts[1];
		metaRefresh('adminMain.php');
		die();
	}
	else {
		$errorMessage = _("The password is invalid! Please try again.");
	}
}

echo $_SESSION['header'];

?>

	<title>
		<?php
			echo _("Login");
		?>
	</title>
	<link rel="stylesheet" type="text/css" href="../../style/layout.css">
	<link rel="shortcut icon" type="image/x-icon" href="../../graphics/favicon.ico">
</head>
<body>
	<?php
		// set focus on password field
		echo "<script type=\"text/javascript\" language=\"javascript\">\n";
		echo "<!--\n";
		echo "window.onload = function() {\n";
			echo "loginField = document.getElementsByName('passwd')[0];\n";
			echo "loginField.focus();\n";
		echo "}\n";
		echo "//-->\n";
		echo "</script>\n";
	?>
	<p align="center"><a href="http://lam.sourceforge.net" target="_blank">
		<img src="../../graphics/banner.jpg" border=1 alt="LDAP Account Manager"></a>
	</p>
	<hr>
	<br>
	<?PHP
		if (isset($errorMessage)) StatusMessage('ERROR', $errorMessage);
	?>
	<br>
	<!-- form to change existing profiles -->
	<form action="adminLogin.php" method="post">
	<table align="center" border="2" rules="none" bgcolor="white">
		<tr>
			<td style="border-style:none" rowspan="3" width="20"></td>
			<td style="border-style:none" height="20"></td>
			<td style="border-style:none" rowspan="3" width="20"></td>
		</tr>
		<tr>
			<td style="border-style:none" align="center"><b> <?php echo _("Please enter your master configuration password to change the self service profile:"); ?> </b></td>
		</tr>
		<tr><td style="border-style:none" >&nbsp;</td></tr>
<?php
$files = getSelfServiceProfiles();
?>
		<tr>
			<td style="border-style:none" rowspan="4" width="20"></td>
			<td style="border-style:none" align="center">
				<?php
					$types = array_keys($files);
					if (sizeof($types) > 0) {
						echo "<select size=1 name=\"filename\">\n";
						for ($t = 0; $t < sizeof($types); $t++) {
							for ($i = 0; $i < sizeof($files[$types[$t]]); $i++) {
								echo "<option value=\"" . $types[$t] . ":" . $files[$types[$t]][$i] . "\">";
									echo getTypeAlias($types[$t]) . ": " . $files[$types[$t]][$i];
								echo "</option>\n";
							}
						}
						echo "</select>\n";
					}
					else echo "<select disabled size=1 name=\"filename\">\n<option></option>\n</select>\n";
					if (sizeof($files) > 0) echo "<input type=\"password\" name=\"passwd\">\n";
					else echo "<input disabled type=\"password\" name=\"passwd\">\n";
					if (sizeof($files) > 0) echo "<input type=\"submit\" name=\"submit\" value=\"" . _("Ok") . "\">\n";
					else echo "<input disabled type=\"submit\" name=\"submit\" value=\"" . _("Ok") . "\">\n";
					// help link
					echo "&nbsp;<a href=\"../help.php?HelpNumber=236\" target=\"lamhelp\">";
					echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
					echo "</a>\n";
				?>
			</td>
			<td style="border-style:none" rowspan="4" width="20"></td>
		</tr>
		<tr>
			<td  style="border-style:none">&nbsp;</td>
		</tr>
		<tr>
			<td style="border-style:none" align="center">
				<b><a href="profManage.php"><?php echo _("Manage self service profiles") ?></a></b>
			</td>
		</tr>
		<tr>
			<td style="border-style:none" height="20"></td>
		</tr>
	</table>
	</form>

	<p><br><br><br><br><br></p>

	<!-- back to login page -->
	<p>
		<a href="../login.php"> <?php echo _("Back to Login"); ?> </a>
	</p>

</body>
</html>
