<?php
/*
$Id: profManage.php,v 1.11 2008-01-01 13:05:31 roland Exp $

  This code is part of LDAP Account Manager Pro (http://www.sourceforge.net/projects/lam)
  Copyright (C) 2006 - 2007  Roland Gruber

*/


/**
* Self service profile management.
*
* @package selfService
* @author Roland Gruber
*/


/** Access to self service functions */
include_once('../../lib/selfService.inc');
/** Used to print status messages */
include_once('../../lib/status.inc');

// start session
session_save_path("../../sess");
@session_start();

setlanguage();

echo $_SESSION['header'];

?>

		<title>
			<?php
				echo _("Profile management");
			?>
		</title>
		<link rel="stylesheet" type="text/css" href="../../style/layout.css">
		<link rel="shortcut icon" type="image/x-icon" href="../../graphics/favicon.ico">
	</head>
	<body>
		<p align="center"><a href="http://lam.sourceforge.net" target="_blank">
			<img src="../../graphics/banner.jpg" border=1 alt="LDAP Account Manager"></a>
		</p>
		<hr><br>

<?php

$cfg = new LAMCfgMain();
$profiles = getSelfServiceProfiles();
$types = getTypes();
// check if submit button was pressed
if ($_POST['submit']) {
	// check master password
	if (!$cfg->checkPassword($_POST['passwd'])) {
		$error = _("Master password is wrong!");
	}
	// add new profile
	elseif ($_POST['action'] == "add") {
		$scope = $_POST['addprofileType'];
		if (eregi("^[a-z0-9_-]+$", $_POST['addprofile']) && !in_array($_POST['addprofile'], $profiles) && eregi("^[a-z]+$", $scope)) {
			// create new profile file
			$profile = new selfServiceProfile();
			saveSelfServiceProfile($_POST['addprofile'], $scope, $profile);
			@chmod ("../../config/selfService/" . $_POST['addprofile'] . "." . $scope, 0600);
			$file = is_file("../../config/selfService/" . $_POST['addprofile'] . "." . $scope);
			if ($file) {
				$msg = _("Created new profile.");
			}
			else $error = _("Unable to create new profile!");
		}
		else $error = _("Profile name is invalid!");
	}
	// rename profile
	elseif ($_POST['action'] == "rename") {
		$parts = split(":", $_POST['oldfilename']);
		$scope = $parts[0];
		$oldName = $parts[1];
		if (eregi("^[a-z0-9_-]+$", $_POST['renfilename']) && !in_array($_POST['renfilename'], $profiles[$scope]) &&
		eregi("^[a-z]+$", $scope) && eregi("^[a-z0-9_-]+$", $oldName)) {
			if (@rename("../../config/selfService/" . $oldName . "." . $scope,
				"../../config/selfService/" . $_POST['renfilename'] . "." . $scope)) {
				$msg = _("Renamed profile.");
			}
			else $error = _("Could not rename file!");
		}
		else $error = _("Profile name is invalid!");
	}
	// delete profile
	elseif ($_POST['action'] == "delete") {
		$parts = split(":", $_POST['delfilename']);
		$scope = $parts[0];
		$delName = $parts[1];
		if (eregi("^[a-z]+$", $scope) && eregi("^[a-z0-9_-]+$", $delName) && in_array($delName, $profiles[$scope]) &&
		@unlink("../../config/selfService/" . $delName . "." . $scope)) {
			$msg = _("Profile deleted.");
		}
		else $error = _("Unable to delete profile!");
	}
	// print messages
	if ($error || $msg) {
		if ($error) StatusMessage("ERROR", $error);
		if ($msg) StatusMessage("INFO", $msg);
	}
	else exit;
	// reload profiles
	$profiles = getSelfServiceProfiles();
}


// check if config.cfg is valid
if (!isset($cfg->default)) {
	StatusMessage("ERROR", _("Please set up your master configuration file (config/config.cfg) first!"), "");
	echo "</body>\n</html>\n";
	die();
}

?>

		<br>
		<!-- form for adding/renaming/deleting profiles -->
		<form action="profManage.php" method="post">
		<table>
		<tr><td>
		<fieldset>
			<legend><b> <?php echo _("Profile management"); ?> </b></legend><br>
			<br>
			<table cellspacing=0 border=0>

				<!-- add profile -->
				<tr>
					<td>
						<input type="radio" name="action" value="add" checked>
					</td>
					<td>
						<b>
							<?php echo _("Add profile") . ":"; ?>
						</b>
					</td>
					<td align="left">&nbsp;&nbsp;
						<?php echo _("Profile name") . ":"; ?>
						<input type="text" name="addprofile">
						&nbsp;&nbsp;
						<?php echo _("Type") . ":"; ?>
						<SELECT size=1 name="addprofileType" >
						<?PHP
							for ($i = 0; $i < sizeof($types); $i++) {
								if (sizeof(getSelfServiceSearchAttributes($types[$i])) > 0) {
									echo "<option>" . $types[$i] . "</option>";
								}
							}
						?>
						</SELECT>
					</td>
					<td>&nbsp;
					<?PHP
						// help link
						echo "<a href=\"../help.php?HelpNumber=360\" target=\"lamhelp\">";
						echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
						echo "</a>\n";
					?>
					</td>
				</tr>

				<tr>
					<td colspan=4>&nbsp;</td>
				</tr>

				<!-- rename profile -->
				<tr>
					<td>
						<input type="radio" name="action" value="rename">
					</td>
					<td>
						<select size=1 name="oldfilename">
						<?php
							$availableTypes = array_keys($profiles);
							for ($t = 0; $t < sizeof($availableTypes); $t++) {
								for ($i = 0; $i < sizeof($profiles[$availableTypes[$t]]); $i++) {
									echo "<option value=\"" . $availableTypes[$t] . ":" . $profiles[$availableTypes[$t]][$i] . "\">";
										echo getTypeAlias($availableTypes[$t]) . ": " . $profiles[$availableTypes[$t]][$i];
									echo "</option>\n";
								}
							}
						?>
						</select>
						<b>
							<?php echo _("Rename profile"); ?>
						</b>
					</td>
					<td align="left">&nbsp;&nbsp;
						<?php echo _("Profile name") . ":"; ?>
						<input type="text" name="renfilename">
					</td>
					<td>&nbsp;
					<?PHP
						// help link
						echo "<a href=\"../help.php?HelpNumber=231\" target=\"lamhelp\">";
						echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
						echo "</a>\n";
					?>
					</td>
				</tr>

				<tr>
					<td colspan=4>&nbsp;</td>
				</tr>

				<!-- delete profile -->
				<tr>
					<td>
						<input type="radio" name="action" value="delete">
					</td>
					<td colspan=2>
						<select size=1 name="delfilename">
						<?php
							for ($t = 0; $t < sizeof($availableTypes); $t++) {
								for ($i = 0; $i < sizeof($profiles[$availableTypes[$t]]); $i++) {
									echo "<option value=\"" . $availableTypes[$t] . ":" . $profiles[$availableTypes[$t]][$i] . "\">";
										echo getTypeAlias($availableTypes[$t]) . ": " . $profiles[$availableTypes[$t]][$i];
									echo "</option>\n";
								}
							}
						?>
						</select>
						<b>
							<?php echo _("Delete profile"); ?>
						</b>
					</td>
					<td>&nbsp;
					<?PHP
						// help link
						echo "<a href=\"../help.php?HelpNumber=232\" target=\"lamhelp\">";
						echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
						echo "</a>\n";
					?>
					</td>
				</tr>

			</table>
			</fieldset>
			</td></tr>
			</table>
			<p>&nbsp;</p>

			<!-- password field and submit button -->
			<b>
				<?php echo _("Master password"); ?>:
			</b>
			&nbsp;
			<input type="password" name="passwd">
			&nbsp;
			<input type="submit" name="submit" value=" <?php echo _("Ok"); ?> ">
			&nbsp;
			<?PHP
				// help link
				echo "<a href=\"../help.php?HelpNumber=236\" target=\"lamhelp\">";
				echo "<img src=\"../../graphics/help.png\" alt=\"" . _('Help') . "\" title=\"" . _('Help') . "\">";
				echo "</a>\n";
			?>

		</form>
		<p><br></p>

		<!-- back to login page -->
		<p>
			<a href="adminLogin.php"> <?php echo _("Back to profile login"); ?> </a>
		</p>

	</body>
</html>

