/*
 *  Copyright 1994-2021 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"
#include "pthread_utils.h"


uint32_t version = 0;
uint32_t options = BO_GFX | BO_WEBCAM | BO_SCHEMES;
char desc[] = "Webcam plugin";
char dname[] = "TV webcam";

enum LayerMode mode = LM_OVERLAY;


void
run(Context_t *ctx)
{
  if (!xpthread_mutex_lock(&ctx->cam_mtx[ctx->cam])) {
    Buffer8_copy(ctx->cam_save[ctx->cam][0], passive_buffer(ctx));
    xpthread_mutex_unlock(&ctx->cam_mtx[ctx->cam]);
  }
}
