/*
 * GSList helper routines.
 * Why doesn't glib have a native g_slist_rotate function??
 */

#include "ledd.h"

#include <unistd.h>   /* close() */

/*
 * Rotates the list, ie. moves the first node to the end of the list and
 * returns the next one.
 */
GSList *gslist_rotate(GSList *list) {
	gpointer data;

	if (list==NULL)
		return NULL;

	data=list->data;
	list=g_slist_remove(list,data);
	list=g_slist_append(list,data);

	return list;
}



/*
 * Removes the first node in the list and returns the next one. Frees any
 * block residing in list->data by g_free().
 * There's no really clean way to do this...
 */
GSList *gslist_next_free(GSList *list) {
	if (list->data) {
		g_free(list->data);
		list->data=NULL;
	}
	return g_slist_remove(list,list->data);
}


/*
 * Frees the whole list and all blocks in ->data.
 */
void gslist_free_all(GSList *list) {
	GSList *next;
	
	for (next=list; next; next=g_slist_next(next)) {
		if (next->data) {
			g_free(next->data);
			next->data=NULL;
		}
	}
	g_slist_free(list);
	return;
}

/*
 * Frees the whole list. Assumes ->data blocks to be (File *) type, and
 * frees everything in it and closes all possible file descriptors.
 */
void gslist_free_all_files(GSList *list) {
	GSList *next;

	for (next=list; next; next=g_slist_next(next)) {
		File *f;
		if (next->data==NULL)
			continue;
		f=next->data;

		if (f->fd >= 0)
			close(f->fd);
		f->fd=-1;

		/* if (f->pid) this_its_just_too_bad(f->pid); */

		if (f->name)
			g_free(f->name);
		f->name=NULL;
	}
	g_slist_free(list);
	return;
}
