.\"
.\" $Id: rfio_fread.man,v 1.1 2005/03/31 13:13:02 baud Exp $
.\"
.\" @(#)$RCSfile: rfio_fread.man,v $ $Revision: 1.1 $ $Date: 2005/03/31 13:13:02 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 1999-2001 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH RFIO_FREAD 3 "$Date: 2005/03/31 13:13:02 $" CASTOR "Rfio Library Functions"
.SH NAME
rfio_fread \- reads in a file
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "rfio_api.h"\fR
.sp
.BI "int rfio_fread (void *" ptr ", int " size ", int " items ", FILE *" fd ");"
.SH DESCRIPTION
.B rfio_fread
reads
.BI items
times
.BI size
bytes, using the descriptor
.BI fd
generated by a previous
.B rfio_fopen
and strore them at location
.BR ptr .
.SH RETURN VALUE
This routine returns -1 if the operation failed or the number of items actually read. In case of failure, 
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B EBADF
.I fd
is a NULL pointer.
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SETIMEDOUT
Timed out.
.TP
.B SEBADVERSION
Version ID mismatch.
.TP
.B SECONNDROP
Connection closed by remote end.
.TP
.B SECOMERR
Communication error.
.TP
.B SENORCODE
Host did not return error number.
.SH SEE ALSO
.BR rfio_fopen(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
