/*

File: pallete.c
Project: W, Layer2 -- DOS32 application (DJGPP) and WIN32 console application
Started: 9th November, 1998
Descrition:
  Collor pallete.
  Borland pallete, Borland conservative pallete, Dark pallete,
  BW pallete, Classic termina pallete.

*/

#ifndef	PALLETE_H
#define PALLETE_H

enum Colors
{
  coStatus = 0,
  coError,
  coTabs,
  coReadOnly,
  coRecStored,
  coStatusTxt,
  coStatusShortCut,
  coEOF,
  coEdText,
  coEdBlock,
  coEdNumber,
  coEdComment,
  coEdReserved,
  coEdRegister,
  coEdInstruction,
  coEdString,
  coEdPreproc,
  coEdOper,
  coEdSFR,
  coEdPair,
  coSmallEdEOF,
  coSmallEdText,
  coSmallEdBlock,
  coSmallEdNumber,
  coSmallEditEdComment,
  coSmallEditEdReserved,
  coSmallEditEdRegister,
  coSmallEditEdInstruction,
  coSmallEditEdString,
  coSmallEditEdPreproc,
  coSmallEditEdOper,
  coSmallEditEdSFR,
  coSmallEditEdPair,
  coEnterLn,
  coUnchanged,
  coEnterLnPrompt,
  coEnterLnBraces,
  coUMenuFrame,
  coUMenuItems,
  coUMenuSelected,
  coUMenuTitle,
  coHelpFrame,
  coHelpItems,
  coHelpSelected,
  coHelpTitle,
  coHelpText,
  coHelpLink,
  coHelpHighlightLink,
  coHelpHighlightMenu,
  coHelpTextSelected,
  coMenu,
  coMenuShortCut,
  coMenuSelected,
  coMenuSeShortCt,
  coMenuDisabled,
  coMenuFrame,
  coMenuSeDisabl,
  coCtxHlpMenu,
  coCtxHlpMenuShortCut,
  coCtxHlpMenuSelected,
  coCtxHlpMenuSeShortCt,
  coCtxHlpMenuDisabled,
  coCtxHlpMenuFrame,
  coCtxHlpMenuSeDisabl,
  coTerm1,
  coTerm2,
  MAX_PALLETE
};

#define  SyntaxPalleteStart  coEOF
#define  SmallEditorPalleteStart coSmallEdEOF
#define  coUMenu  coUMenuFrame
#define  coHelpList coHelpFrame

#define _coUMenuFrame	0
#define _coUMenuItems	1
#define _coUMenuSelected	2
#define _coUMenuTitle	3

#define _co_Menu 0
#define _co_MenuShortCut 1
#define _co_MenuSelected 2
#define _co_MenuSeShortCt 3
#define _co_MenuDisabled 4
#define _co_MenuFrame 5
#define _co_MenuSeDisabl 6

#define GetColor(c) (CPallete[c])
extern BYTE *CPallete;        /* Current pallete */
extern BYTE BorlandPallete[MAX_PALLETE];

#endif  /* ifndef PALLETE_H */

