      subroutine LACGevolvep(xin,qin,p2in,ip2in,pdf)
      include 'parmsetup.inc'
      real*8 xin,qin,q2in,p2in,pdf(-6:6),xval(45),qcdl4,qcdl5
      character*16 name(nmxset)
      integer nmem(nmxset),ndef(nmxset),mmem
      common/NAME/name,nmem,ndef,mmem
      integer nset
      save 
      
      q2in=qin*qin
      call getnset(iset)
      call getnmem(iset,imem)
      
      if(imem.eq.1.or.imem.eq.0) then
        call PHLAC1(xin,q2in,pdf)

      elseif(imem.eq.2) then
        call PHLAC2(xin,q2in,pdf)

      elseif(imem.eq.3) then
        call PHLAC3(xin,q2in,pdf)

      elseif(imem.eq.4) then
        call PHGAL(xin,q2in,pdf)

      else
        CONTINUE
      endif     
      
      return
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      entry LACGread(nset)
      read(1,*)nmem(nset),ndef(nset)
      return
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      entry LACGalfa(alfas,qalfa)
        call getnset(iset)
	call GetOrderAsM(iset,iord)
        call Getlam4M(iset,imem,qcdl4)
        call Getlam5M(iset,imem,qcdl5)
        call aspdflib(alfas,Qalfa,iord,qcdl5)
      return
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      entry LACGinit(Eorder,Q2fit)
      return
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      entry LACGpdf(mem)
      call getnset(iset)
      call setnmem(iset,mem)
c      imem = mem
      return
c
 1000 format(5e13.5)
      end
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      SUBROUTINE PHLAC1(X,Q2,XPDF)
      implicit real*8 (a-h,o-z)
      PARAMETER(IX=100,IQ=7,NARG=2,NFUN=4)
      double precision
     +       DBFINT,
     +       XT(IX),Q2T(IQ),ARG(NARG),ENT(IX+IQ),
     +       XPV(IX,IQ,0:NFUN),XPDF(-6:6)
      DIMENSION NA(NARG)
      DATA ZEROD/0.D0/
C...100 x valuse; in (D-4,.77) log spaced (78 points)
C...              in (.78,.995) lineary spaced (22 points)
      DATA Q2T/4.D0,10.D0,50.D0,1.D2,1.D3,1.D4,1.D5/
      DATA XT/
     &0.1000D-03,0.1123D-03,0.1262D-03,0.1417D-03,0.1592D-03,0.1789D-03,
     &0.2009D-03,0.2257D-03,0.2535D-03,0.2848D-03,0.3199D-03,0.3593D-03,
     &0.4037D-03,0.4534D-03,0.5093D-03,0.5722D-03,0.6427D-03,0.7220D-03,
     &0.8110D-03,0.9110D-03,0.1023D-02,0.1150D-02,0.1291D-02,0.1451D-02,
     &0.1629D-02,0.1830D-02,0.2056D-02,0.2310D-02,0.2594D-02,0.2914D-02,
     &0.3274D-02,0.3677D-02,0.4131D-02,0.4640D-02,0.5212D-02,0.5855D-02,
     &0.6577D-02,0.7388D-02,0.8299D-02,0.9323D-02,0.1047D-01,0.1176D-01,
     &0.1321D-01,0.1484D-01,0.1667D-01,0.1873D-01,0.2104D-01,0.2363D-01,
     &0.2655D-01,0.2982D-01,0.3350D-01,0.3763D-01,0.4227D-01,0.4748D-01,
     &0.5334D-01,0.5992D-01,0.6731D-01,0.7560D-01,0.8493D-01,0.9540D-01,
     &0.1072D+00,0.1204D+00,0.1352D+00,0.1519D+00,0.1706D+00,0.1917D+00,
     &0.2153D+00,0.2419D+00,0.2717D+00,0.3052D+00,0.3428D+00,0.3851D+00,
     &0.4326D+00,0.4859D+00,0.5458D+00,0.6131D+00,0.6887D+00,0.7737D+00,
     &0.7837D+00,0.7937D+00,0.8037D+00,0.8137D+00,0.8237D+00,0.8337D+00,
     &0.8437D+00,0.8537D+00,0.8637D+00,0.8737D+00,0.8837D+00,0.8937D+00,
     &0.9037D+00,0.9137D+00,0.9237D+00,0.9337D+00,0.9437D+00,0.9537D+00,
     &0.9637D+00,0.9737D+00,0.9837D+00,0.9937D+00/

C...place for DATA blocks
      DATA (XPV(I,1,0),I=1,100)/
     &0.1565D+01,0.1506D+01,0.1448D+01,0.1391D+01,0.1338D+01,0.1286D+01,
     &0.1236D+01,0.1189D+01,0.1143D+01,0.1098D+01,0.1056D+01,0.1015D+01,
     &0.9745D+00,0.9371D+00,0.9004D+00,0.8646D+00,0.8312D+00,0.7984D+00,
     &0.7665D+00,0.7365D+00,0.7073D+00,0.6785D+00,0.6518D+00,0.6254D+00,
     &0.5998D+00,0.5756D+00,0.5519D+00,0.5287D+00,0.5068D+00,0.4854D+00,
     &0.4644D+00,0.4443D+00,0.4249D+00,0.4058D+00,0.3872D+00,0.3694D+00,
     &0.3519D+00,0.3348D+00,0.3181D+00,0.3020D+00,0.2861D+00,0.2705D+00,
     &0.2553D+00,0.2413D+00,0.2263D+00,0.2118D+00,0.1980D+00,0.1843D+00,
     &0.1706D+00,0.1573D+00,0.1442D+00,0.1315D+00,0.1190D+00,0.1070D+00,
     &0.9501D-01,0.8376D-01,0.7302D-01,0.6278D-01,0.5319D-01,0.4429D-01,
     &0.3613D-01,0.2884D-01,0.2246D-01,0.1692D-01,0.1231D-01,0.8569D-02,
     &0.5692D-02,0.3556D-02,0.2071D-02,0.1106D-02,0.5306D-03,0.2221D-03,
     &0.7821D-04,0.2192D-04,0.4488D-05,0.5808D-06,0.3699D-07,0.6624D-09,
     &0.3750D-09,0.2067D-09,0.1106D-09,0.5732D-10,0.2868D-10,0.1378D-10,
     &0.6286D-11,0.2737D-11,0.1123D-11,0.4323D-12,0.1545D-12,0.5043D-13,
     &0.1478D-13,0.3800D-14,0.8317D-15,0.1485D-15,0.2036D-16,0.1950D-17,
     &0.1118D-18,0.2870D-20,0.1704D-22,0.0000D+00/
      DATA (XPV(I,1,1),I=1,100)/
     &0.2916D-06,0.3304D-06,0.3747D-06,0.4246D-06,0.4815D-06,0.5462D-06,
     &0.6192D-06,0.7024D-06,0.7966D-06,0.9039D-06,0.1025D-05,0.1163D-05,
     &0.1321D-05,0.1499D-05,0.1701D-05,0.1932D-05,0.2193D-05,0.2490D-05,
     &0.2828D-05,0.3212D-05,0.3647D-05,0.4146D-05,0.4707D-05,0.5351D-05,
     &0.6077D-05,0.6906D-05,0.7851D-05,0.8925D-05,0.1014D-04,0.1153D-04,
     &0.1311D-04,0.1490D-04,0.1695D-04,0.1927D-04,0.2191D-04,0.2492D-04,
     &0.2834D-04,0.3223D-04,0.3666D-04,0.4169D-04,0.4740D-04,0.5389D-04,
     &0.6128D-04,0.6966D-04,0.7921D-04,0.9006D-04,0.1023D-03,0.1163D-03,
     &0.1321D-03,0.1500D-03,0.1703D-03,0.1933D-03,0.2192D-03,0.2485D-03,
     &0.2817D-03,0.3190D-03,0.3609D-03,0.4080D-03,0.4608D-03,0.5198D-03,
     &0.5859D-03,0.6591D-03,0.7400D-03,0.8298D-03,0.9282D-03,0.1036D-02,
     &0.1153D-02,0.1280D-02,0.1415D-02,0.1558D-02,0.1706D-02,0.1859D-02,
     &0.2011D-02,0.2158D-02,0.2291D-02,0.2397D-02,0.2457D-02,0.2434D-02,
     &0.2424D-02,0.2411D-02,0.2397D-02,0.2381D-02,0.2362D-02,0.2341D-02,
     &0.2317D-02,0.2291D-02,0.2262D-02,0.2230D-02,0.2194D-02,0.2154D-02,
     &0.2110D-02,0.2060D-02,0.2006D-02,0.1944D-02,0.1874D-02,0.1795D-02,
     &0.1702D-02,0.1592D-02,0.1567D-02,0.9891D-03/
      DATA (XPV(I,1,2),I=1,100)/
     &0.1611D-06,0.1839D-06,0.2101D-06,0.2397D-06,0.2738D-06,0.3129D-06,
     &0.3572D-06,0.4081D-06,0.4661D-06,0.5325D-06,0.6084D-06,0.6950D-06,
     &0.7944D-06,0.9077D-06,0.1037D-05,0.1186D-05,0.1355D-05,0.1550D-05,
     &0.1771D-05,0.2025D-05,0.2315D-05,0.2649D-05,0.3027D-05,0.3464D-05,
     &0.3959D-05,0.4528D-05,0.5180D-05,0.5926D-05,0.6776D-05,0.7751D-05,
     &0.8869D-05,0.1014D-04,0.1161D-04,0.1328D-04,0.1519D-04,0.1738D-04,
     &0.1988D-04,0.2274D-04,0.2602D-04,0.2976D-04,0.3404D-04,0.3893D-04,
     &0.4452D-04,0.5090D-04,0.5821D-04,0.6657D-04,0.7608D-04,0.8693D-04,
     &0.9936D-04,0.1135D-03,0.1296D-03,0.1479D-03,0.1688D-03,0.1925D-03,
     &0.2195D-03,0.2501D-03,0.2847D-03,0.3239D-03,0.3682D-03,0.4180D-03,
     &0.4743D-03,0.5371D-03,0.6071D-03,0.6855D-03,0.7721D-03,0.8679D-03,
     &0.9724D-03,0.1086D-02,0.1208D-02,0.1338D-02,0.1472D-02,0.1609D-02,
     &0.1742D-02,0.1864D-02,0.1962D-02,0.2019D-02,0.2006D-02,0.1875D-02,
     &0.1850D-02,0.1823D-02,0.1794D-02,0.1762D-02,0.1728D-02,0.1691D-02,
     &0.1651D-02,0.1609D-02,0.1563D-02,0.1514D-02,0.1462D-02,0.1405D-02,
     &0.1345D-02,0.1280D-02,0.1209D-02,0.1133D-02,0.1051D-02,0.9598D-03,
     &0.8591D-03,0.7454D-03,0.6438D-03,0.3654D-03/
      DATA (XPV(I,1,3),I=1,100)/
     &0.3274D-03,0.3407D-03,0.3547D-03,0.3691D-03,0.3843D-03,0.4000D-03,
     &0.4163D-03,0.4333D-03,0.4510D-03,0.4693D-03,0.4885D-03,0.5084D-03,
     &0.5291D-03,0.5506D-03,0.5730D-03,0.5963D-03,0.6205D-03,0.6456D-03,
     &0.6717D-03,0.6989D-03,0.7270D-03,0.7564D-03,0.7866D-03,0.8183D-03,
     &0.8507D-03,0.8847D-03,0.9198D-03,0.9561D-03,0.9936D-03,0.1032D-02,
     &0.1073D-02,0.1114D-02,0.1157D-02,0.1200D-02,0.1245D-02,0.1292D-02,
     &0.1339D-02,0.1387D-02,0.1436D-02,0.1486D-02,0.1537D-02,0.1588D-02,
     &0.1639D-02,0.1693D-02,0.1742D-02,0.1792D-02,0.1842D-02,0.1889D-02,
     &0.1933D-02,0.1974D-02,0.2011D-02,0.2043D-02,0.2070D-02,0.2090D-02,
     &0.2098D-02,0.2100D-02,0.2091D-02,0.2069D-02,0.2034D-02,0.1984D-02,
     &0.1918D-02,0.1835D-02,0.1738D-02,0.1621D-02,0.1490D-02,0.1344D-02,
     &0.1189D-02,0.1026D-02,0.8614D-03,0.7006D-03,0.5505D-03,0.4173D-03,
     &0.3076D-03,0.2258D-03,0.1743D-03,0.1526D-03,0.1584D-03,0.1876D-03,
     &0.1921D-03,0.1968D-03,0.2016D-03,0.2066D-03,0.2117D-03,0.2169D-03,
     &0.2222D-03,0.2276D-03,0.2331D-03,0.2385D-03,0.2441D-03,0.2495D-03,
     &0.2550D-03,0.2603D-03,0.2654D-03,0.2702D-03,0.2746D-03,0.2783D-03,
     &0.2811D-03,0.2822D-03,0.3078D-03,0.2079D-03/
      DATA (XPV(I,1,4),I=1,100)/
     &0.1280D-03,0.1332D-03,0.1387D-03,0.1444D-03,0.1503D-03,0.1565D-03,
     &0.1629D-03,0.1696D-03,0.1765D-03,0.1837D-03,0.1913D-03,0.1991D-03,
     &0.2072D-03,0.2157D-03,0.2245D-03,0.2337D-03,0.2433D-03,0.2532D-03,
     &0.2636D-03,0.2743D-03,0.2855D-03,0.2971D-03,0.3092D-03,0.3218D-03,
     &0.3347D-03,0.3483D-03,0.3624D-03,0.3770D-03,0.3920D-03,0.4077D-03,
     &0.4239D-03,0.4407D-03,0.4581D-03,0.4759D-03,0.4944D-03,0.5134D-03,
     &0.5330D-03,0.5531D-03,0.5736D-03,0.5947D-03,0.6162D-03,0.6379D-03,
     &0.6601D-03,0.6836D-03,0.7055D-03,0.7279D-03,0.7508D-03,0.7728D-03,
     &0.7940D-03,0.8146D-03,0.8342D-03,0.8524D-03,0.8689D-03,0.8834D-03,
     &0.8941D-03,0.9028D-03,0.9080D-03,0.9090D-03,0.9056D-03,0.8971D-03,
     &0.8831D-03,0.8635D-03,0.8385D-03,0.8068D-03,0.7698D-03,0.7276D-03,
     &0.6819D-03,0.6336D-03,0.5849D-03,0.5382D-03,0.4968D-03,0.4641D-03,
     &0.4444D-03,0.4423D-03,0.4636D-03,0.5150D-03,0.6053D-03,0.7458D-03,
     &0.7649D-03,0.7844D-03,0.8043D-03,0.8247D-03,0.8455D-03,0.8667D-03,
     &0.8883D-03,0.9100D-03,0.9320D-03,0.9540D-03,0.9761D-03,0.9981D-03,
     &0.1020D-02,0.1041D-02,0.1062D-02,0.1081D-02,0.1098D-02,0.1113D-02,
     &0.1124D-02,0.1129D-02,0.1231D-02,0.8316D-03/
      DATA (XPV(I,2,0),I=1,100)/
     &0.2212D+01,0.2119D+01,0.2028D+01,0.1939D+01,0.1857D+01,0.1776D+01,
     &0.1698D+01,0.1624D+01,0.1553D+01,0.1484D+01,0.1419D+01,0.1356D+01,
     &0.1294D+01,0.1237D+01,0.1181D+01,0.1127D+01,0.1076D+01,0.1027D+01,
     &0.9785D+00,0.9336D+00,0.8899D+00,0.8471D+00,0.8075D+00,0.7686D+00,
     &0.7310D+00,0.6957D+00,0.6613D+00,0.6278D+00,0.5965D+00,0.5661D+00,
     &0.5364D+00,0.5083D+00,0.4813D+00,0.4551D+00,0.4298D+00,0.4058D+00,
     &0.3825D+00,0.3599D+00,0.3382D+00,0.3174D+00,0.2974D+00,0.2780D+00,
     &0.2592D+00,0.2421D+00,0.2243D+00,0.2074D+00,0.1915D+00,0.1760D+00,
     &0.1608D+00,0.1463D+00,0.1324D+00,0.1192D+00,0.1064D+00,0.9439D-01,
     &0.8268D-01,0.7190D-01,0.6185D-01,0.5247D-01,0.4390D-01,0.3611D-01,
     &0.2914D-01,0.2306D-01,0.1786D-01,0.1344D-01,0.9848D-02,0.7000D-02,
     &0.4846D-02,0.3270D-02,0.2179D-02,0.1460D-02,0.1009D-02,0.7343D-03,
     &0.5643D-03,0.4488D-03,0.3576D-03,0.2761D-03,0.1995D-03,0.1267D-03,
     &0.1190D-03,0.1115D-03,0.1041D-03,0.9690D-04,0.8988D-04,0.8302D-04,
     &0.7627D-04,0.6975D-04,0.6340D-04,0.5723D-04,0.5123D-04,0.4542D-04,
     &0.3981D-04,0.3439D-04,0.2918D-04,0.2419D-04,0.1944D-04,0.1495D-04,
     &0.1075D-04,0.6861D-05,0.3406D-05,0.5274D-06/
      DATA (XPV(I,2,1),I=1,100)/
     &0.1934D-01,0.1855D-01,0.1777D-01,0.1701D-01,0.1631D-01,0.1562D-01,
     &0.1494D-01,0.1432D-01,0.1370D-01,0.1310D-01,0.1254D-01,0.1200D-01,
     &0.1146D-01,0.1097D-01,0.1048D-01,0.1000D-01,0.9557D-02,0.9122D-02,
     &0.8698D-02,0.8300D-02,0.7912D-02,0.7530D-02,0.7176D-02,0.6826D-02,
     &0.6487D-02,0.6168D-02,0.5856D-02,0.5551D-02,0.5264D-02,0.4985D-02,
     &0.4712D-02,0.4451D-02,0.4202D-02,0.3959D-02,0.3723D-02,0.3500D-02,
     &0.3284D-02,0.3075D-02,0.2874D-02,0.2684D-02,0.2502D-02,0.2326D-02,
     &0.2160D-02,0.2010D-02,0.1857D-02,0.1716D-02,0.1588D-02,0.1467D-02,
     &0.1354D-02,0.1252D-02,0.1160D-02,0.1080D-02,0.1011D-02,0.9547D-03,
     &0.9083D-03,0.8767D-03,0.8586D-03,0.8538D-03,0.8634D-03,0.8871D-03,
     &0.9256D-03,0.9785D-03,0.1046D-02,0.1127D-02,0.1222D-02,0.1329D-02,
     &0.1448D-02,0.1578D-02,0.1715D-02,0.1859D-02,0.2008D-02,0.2158D-02,
     &0.2307D-02,0.2450D-02,0.2584D-02,0.2700D-02,0.2788D-02,0.2821D-02,
     &0.2820D-02,0.2817D-02,0.2812D-02,0.2806D-02,0.2798D-02,0.2788D-02,
     &0.2776D-02,0.2762D-02,0.2745D-02,0.2725D-02,0.2702D-02,0.2676D-02,
     &0.2645D-02,0.2609D-02,0.2568D-02,0.2519D-02,0.2461D-02,0.2392D-02,
     &0.2304D-02,0.2214D-02,0.2038D-02,0.1660D-02/
      DATA (XPV(I,2,2),I=1,100)/
     &0.1934D-01,0.1855D-01,0.1777D-01,0.1701D-01,0.1631D-01,0.1562D-01,
     &0.1494D-01,0.1431D-01,0.1370D-01,0.1310D-01,0.1254D-01,0.1200D-01,
     &0.1146D-01,0.1096D-01,0.1048D-01,0.1000D-01,0.9555D-02,0.9120D-02,
     &0.8695D-02,0.8297D-02,0.7909D-02,0.7526D-02,0.7172D-02,0.6822D-02,
     &0.6483D-02,0.6162D-02,0.5850D-02,0.5544D-02,0.5256D-02,0.4976D-02,
     &0.4702D-02,0.4441D-02,0.4190D-02,0.3945D-02,0.3708D-02,0.3483D-02,
     &0.3266D-02,0.3054D-02,0.2851D-02,0.2659D-02,0.2473D-02,0.2295D-02,
     &0.2124D-02,0.1970D-02,0.1813D-02,0.1667D-02,0.1533D-02,0.1406D-02,
     &0.1286D-02,0.1177D-02,0.1077D-02,0.9879D-03,0.9093D-03,0.8417D-03,
     &0.7835D-03,0.7391D-03,0.7071D-03,0.6872D-03,0.6807D-03,0.6873D-03,
     &0.7074D-03,0.7409D-03,0.7879D-03,0.8480D-03,0.9206D-03,0.1005D-02,
     &0.1101D-02,0.1206D-02,0.1319D-02,0.1437D-02,0.1558D-02,0.1676D-02,
     &0.1786D-02,0.1880D-02,0.1947D-02,0.1969D-02,0.1924D-02,0.1773D-02,
     &0.1748D-02,0.1721D-02,0.1691D-02,0.1660D-02,0.1627D-02,0.1592D-02,
     &0.1555D-02,0.1515D-02,0.1473D-02,0.1429D-02,0.1382D-02,0.1332D-02,
     &0.1279D-02,0.1222D-02,0.1162D-02,0.1098D-02,0.1028D-02,0.9527D-03,
     &0.8688D-03,0.7804D-03,0.6649D-03,0.4897D-03/
      DATA (XPV(I,2,3),I=1,100)/
     &0.1968D-01,0.1890D-01,0.1814D-01,0.1740D-01,0.1671D-01,0.1604D-01,
     &0.1538D-01,0.1477D-01,0.1418D-01,0.1359D-01,0.1305D-01,0.1253D-01,
     &0.1202D-01,0.1154D-01,0.1108D-01,0.1062D-01,0.1020D-01,0.9794D-02,
     &0.9396D-02,0.9025D-02,0.8666D-02,0.8313D-02,0.7989D-02,0.7671D-02,
     &0.7364D-02,0.7078D-02,0.6800D-02,0.6530D-02,0.6279D-02,0.6037D-02,
     &0.5802D-02,0.5581D-02,0.5371D-02,0.5168D-02,0.4973D-02,0.4791D-02,
     &0.4616D-02,0.4448D-02,0.4290D-02,0.4140D-02,0.3998D-02,0.3862D-02,
     &0.3733D-02,0.3622D-02,0.3502D-02,0.3391D-02,0.3291D-02,0.3192D-02,
     &0.3095D-02,0.3004D-02,0.2916D-02,0.2830D-02,0.2745D-02,0.2662D-02,
     &0.2572D-02,0.2486D-02,0.2397D-02,0.2302D-02,0.2203D-02,0.2098D-02,
     &0.1984D-02,0.1863D-02,0.1735D-02,0.1597D-02,0.1451D-02,0.1298D-02,
     &0.1142D-02,0.9853D-03,0.8318D-03,0.6865D-03,0.5549D-03,0.4424D-03,
     &0.3541D-03,0.2939D-03,0.2636D-03,0.2636D-03,0.2924D-03,0.3480D-03,
     &0.3556D-03,0.3634D-03,0.3713D-03,0.3793D-03,0.3875D-03,0.3956D-03,
     &0.4039D-03,0.4120D-03,0.4203D-03,0.4282D-03,0.4362D-03,0.4438D-03,
     &0.4511D-03,0.4579D-03,0.4641D-03,0.4694D-03,0.4735D-03,0.4760D-03,
     &0.4749D-03,0.4752D-03,0.4578D-03,0.3923D-03/
      DATA (XPV(I,2,4),I=1,100)/
     &0.1947D-01,0.1869D-01,0.1792D-01,0.1717D-01,0.1646D-01,0.1578D-01,
     &0.1511D-01,0.1449D-01,0.1389D-01,0.1329D-01,0.1274D-01,0.1220D-01,
     &0.1168D-01,0.1119D-01,0.1071D-01,0.1024D-01,0.9809D-02,0.9384D-02,
     &0.8970D-02,0.8582D-02,0.8205D-02,0.7835D-02,0.7492D-02,0.7155D-02,
     &0.6828D-02,0.6521D-02,0.6223D-02,0.5931D-02,0.5657D-02,0.5393D-02,
     &0.5134D-02,0.4889D-02,0.4653D-02,0.4425D-02,0.4205D-02,0.3997D-02,
     &0.3796D-02,0.3602D-02,0.3416D-02,0.3241D-02,0.3072D-02,0.2910D-02,
     &0.2755D-02,0.2618D-02,0.2475D-02,0.2342D-02,0.2220D-02,0.2103D-02,
     &0.1991D-02,0.1887D-02,0.1789D-02,0.1699D-02,0.1614D-02,0.1536D-02,
     &0.1460D-02,0.1393D-02,0.1331D-02,0.1273D-02,0.1220D-02,0.1169D-02,
     &0.1122D-02,0.1077D-02,0.1035D-02,0.9924D-03,0.9517D-03,0.9118D-03,
     &0.8737D-03,0.8375D-03,0.8050D-03,0.7782D-03,0.7598D-03,0.7539D-03,
     &0.7655D-03,0.8012D-03,0.8696D-03,0.9820D-03,0.1152D-02,0.1396D-02,
     &0.1427D-02,0.1459D-02,0.1492D-02,0.1525D-02,0.1558D-02,0.1592D-02,
     &0.1625D-02,0.1659D-02,0.1692D-02,0.1724D-02,0.1757D-02,0.1787D-02,
     &0.1817D-02,0.1845D-02,0.1869D-02,0.1891D-02,0.1907D-02,0.1915D-02,
     &0.1910D-02,0.1909D-02,0.1831D-02,0.1563D-02/
      DATA (XPV(I,3,0),I=1,100)/
     &0.3308D+01,0.3150D+01,0.2995D+01,0.2845D+01,0.2706D+01,0.2570D+01,
     &0.2439D+01,0.2318D+01,0.2200D+01,0.2086D+01,0.1980D+01,0.1877D+01,
     &0.1778D+01,0.1685D+01,0.1596D+01,0.1510D+01,0.1429D+01,0.1352D+01,
     &0.1277D+01,0.1207D+01,0.1140D+01,0.1074D+01,0.1014D+01,0.9560D+00,
     &0.8999D+00,0.8477D+00,0.7974D+00,0.7487D+00,0.7036D+00,0.6603D+00,
     &0.6186D+00,0.5793D+00,0.5421D+00,0.5064D+00,0.4722D+00,0.4403D+00,
     &0.4097D+00,0.3805D+00,0.3528D+00,0.3267D+00,0.3020D+00,0.2783D+00,
     &0.2558D+00,0.2356D+00,0.2151D+00,0.1960D+00,0.1783D+00,0.1614D+00,
     &0.1452D+00,0.1302D+00,0.1160D+00,0.1028D+00,0.9044D-01,0.7901D-01,
     &0.6820D-01,0.5850D-01,0.4968D-01,0.4167D-01,0.3454D-01,0.2823D-01,
     &0.2273D-01,0.1806D-01,0.1416D-01,0.1093D-01,0.8342D-02,0.6321D-02,
     &0.4798D-02,0.3669D-02,0.2855D-02,0.2271D-02,0.1847D-02,0.1524D-02,
     &0.1262D-02,0.1035D-02,0.8272D-03,0.6323D-03,0.4496D-03,0.2797D-03,
     &0.2619D-03,0.2446D-03,0.2277D-03,0.2113D-03,0.1953D-03,0.1798D-03,
     &0.1645D-03,0.1498D-03,0.1356D-03,0.1218D-03,0.1085D-03,0.9565D-04,
     &0.8330D-04,0.7145D-04,0.6013D-04,0.4938D-04,0.3923D-04,0.2974D-04,
     &0.2099D-04,0.1303D-04,0.6225D-05,0.9782D-06/
      DATA (XPV(I,3,1),I=1,100)/
     &0.5631D-01,0.5377D-01,0.5129D-01,0.4888D-01,0.4664D-01,0.4445D-01,
     &0.4233D-01,0.4035D-01,0.3843D-01,0.3656D-01,0.3482D-01,0.3313D-01,
     &0.3148D-01,0.2994D-01,0.2845D-01,0.2700D-01,0.2565D-01,0.2434D-01,
     &0.2307D-01,0.2188D-01,0.2072D-01,0.1960D-01,0.1855D-01,0.1753D-01,
     &0.1655D-01,0.1563D-01,0.1474D-01,0.1387D-01,0.1306D-01,0.1227D-01,
     &0.1151D-01,0.1080D-01,0.1011D-01,0.9451D-02,0.8816D-02,0.8220D-02,
     &0.7648D-02,0.7097D-02,0.6576D-02,0.6084D-02,0.5618D-02,0.5172D-02,
     &0.4750D-02,0.4374D-02,0.3996D-02,0.3647D-02,0.3330D-02,0.3034D-02,
     &0.2756D-02,0.2506D-02,0.2281D-02,0.2081D-02,0.1906D-02,0.1756D-02,
     &0.1627D-02,0.1527D-02,0.1453D-02,0.1402D-02,0.1377D-02,0.1376D-02,
     &0.1398D-02,0.1442D-02,0.1507D-02,0.1591D-02,0.1692D-02,0.1808D-02,
     &0.1936D-02,0.2075D-02,0.2220D-02,0.2370D-02,0.2522D-02,0.2675D-02,
     &0.2827D-02,0.2977D-02,0.3127D-02,0.3276D-02,0.3425D-02,0.3559D-02,
     &0.3572D-02,0.3583D-02,0.3593D-02,0.3601D-02,0.3608D-02,0.3613D-02,
     &0.3616D-02,0.3616D-02,0.3614D-02,0.3609D-02,0.3600D-02,0.3586D-02,
     &0.3568D-02,0.3542D-02,0.3510D-02,0.3467D-02,0.3412D-02,0.3340D-02,
     &0.3240D-02,0.3140D-02,0.2881D-02,0.2260D-02/
      DATA (XPV(I,3,2),I=1,100)/
     &0.5631D-01,0.5377D-01,0.5129D-01,0.4888D-01,0.4664D-01,0.4445D-01,
     &0.4233D-01,0.4035D-01,0.3843D-01,0.3656D-01,0.3481D-01,0.3312D-01,
     &0.3147D-01,0.2994D-01,0.2845D-01,0.2700D-01,0.2565D-01,0.2433D-01,
     &0.2306D-01,0.2187D-01,0.2072D-01,0.1959D-01,0.1855D-01,0.1752D-01,
     &0.1654D-01,0.1562D-01,0.1472D-01,0.1385D-01,0.1304D-01,0.1226D-01,
     &0.1149D-01,0.1077D-01,0.1009D-01,0.9422D-02,0.8784D-02,0.8185D-02,
     &0.7608D-02,0.7054D-02,0.6527D-02,0.6030D-02,0.5558D-02,0.5105D-02,
     &0.4676D-02,0.4292D-02,0.3905D-02,0.3547D-02,0.3219D-02,0.2910D-02,
     &0.2620D-02,0.2356D-02,0.2115D-02,0.1897D-02,0.1703D-02,0.1533D-02,
     &0.1382D-02,0.1258D-02,0.1158D-02,0.1080D-02,0.1025D-02,0.9926D-03,
     &0.9811D-03,0.9900D-03,0.1018D-02,0.1064D-02,0.1125D-02,0.1200D-02,
     &0.1286D-02,0.1381D-02,0.1481D-02,0.1583D-02,0.1683D-02,0.1776D-02,
     &0.1857D-02,0.1917D-02,0.1949D-02,0.1938D-02,0.1870D-02,0.1718D-02,
     &0.1695D-02,0.1670D-02,0.1644D-02,0.1617D-02,0.1589D-02,0.1559D-02,
     &0.1527D-02,0.1494D-02,0.1459D-02,0.1423D-02,0.1385D-02,0.1344D-02,
     &0.1302D-02,0.1256D-02,0.1208D-02,0.1157D-02,0.1101D-02,0.1040D-02,
     &0.9712D-03,0.9017D-03,0.7902D-03,0.5856D-03/
      DATA (XPV(I,3,3),I=1,100)/
     &0.5668D-01,0.5415D-01,0.5169D-01,0.4930D-01,0.4707D-01,0.4490D-01,
     &0.4280D-01,0.4084D-01,0.3894D-01,0.3708D-01,0.3536D-01,0.3369D-01,
     &0.3207D-01,0.3056D-01,0.2909D-01,0.2766D-01,0.2634D-01,0.2505D-01,
     &0.2381D-01,0.2264D-01,0.2152D-01,0.2042D-01,0.1941D-01,0.1842D-01,
     &0.1747D-01,0.1658D-01,0.1572D-01,0.1489D-01,0.1411D-01,0.1337D-01,
     &0.1264D-01,0.1196D-01,0.1131D-01,0.1069D-01,0.1009D-01,0.9533D-02,
     &0.8998D-02,0.8483D-02,0.7997D-02,0.7540D-02,0.7105D-02,0.6689D-02,
     &0.6295D-02,0.5947D-02,0.5588D-02,0.5256D-02,0.4952D-02,0.4661D-02,
     &0.4382D-02,0.4123D-02,0.3879D-02,0.3650D-02,0.3434D-02,0.3232D-02,
     &0.3033D-02,0.2850D-02,0.2676D-02,0.2508D-02,0.2345D-02,0.2186D-02,
     &0.2029D-02,0.1875D-02,0.1723D-02,0.1569D-02,0.1416D-02,0.1264D-02,
     &0.1115D-02,0.9718D-03,0.8371D-03,0.7147D-03,0.6091D-03,0.5242D-03,
     &0.4643D-03,0.4324D-03,0.4307D-03,0.4600D-03,0.5208D-03,0.6116D-03,
     &0.6232D-03,0.6348D-03,0.6465D-03,0.6582D-03,0.6698D-03,0.6813D-03,
     &0.6927D-03,0.7037D-03,0.7145D-03,0.7247D-03,0.7344D-03,0.7433D-03,
     &0.7512D-03,0.7579D-03,0.7629D-03,0.7658D-03,0.7660D-03,0.7620D-03,
     &0.7516D-03,0.7414D-03,0.6912D-03,0.5511D-03/
      DATA (XPV(I,3,4),I=1,100)/
     &0.5645D-01,0.5392D-01,0.5144D-01,0.4905D-01,0.4681D-01,0.4462D-01,
     &0.4251D-01,0.4054D-01,0.3863D-01,0.3676D-01,0.3503D-01,0.3335D-01,
     &0.3171D-01,0.3018D-01,0.2870D-01,0.2726D-01,0.2592D-01,0.2462D-01,
     &0.2335D-01,0.2217D-01,0.2103D-01,0.1992D-01,0.1889D-01,0.1788D-01,
     &0.1691D-01,0.1600D-01,0.1512D-01,0.1426D-01,0.1347D-01,0.1270D-01,
     &0.1195D-01,0.1125D-01,0.1058D-01,0.9929D-02,0.9308D-02,0.8726D-02,
     &0.8167D-02,0.7630D-02,0.7121D-02,0.6641D-02,0.6185D-02,0.5749D-02,
     &0.5336D-02,0.4968D-02,0.4595D-02,0.4249D-02,0.3933D-02,0.3635D-02,
     &0.3352D-02,0.3093D-02,0.2854D-02,0.2635D-02,0.2436D-02,0.2256D-02,
     &0.2089D-02,0.1945D-02,0.1818D-02,0.1706D-02,0.1610D-02,0.1528D-02,
     &0.1458D-02,0.1400D-02,0.1353D-02,0.1314D-02,0.1283D-02,0.1259D-02,
     &0.1242D-02,0.1231D-02,0.1228D-02,0.1235D-02,0.1254D-02,0.1291D-02,
     &0.1351D-02,0.1446D-02,0.1586D-02,0.1789D-02,0.2074D-02,0.2452D-02,
     &0.2500D-02,0.2547D-02,0.2594D-02,0.2642D-02,0.2689D-02,0.2735D-02,
     &0.2781D-02,0.2826D-02,0.2869D-02,0.2910D-02,0.2950D-02,0.2985D-02,
     &0.3017D-02,0.3044D-02,0.3065D-02,0.3076D-02,0.3077D-02,0.3062D-02,
     &0.3020D-02,0.2980D-02,0.2782D-02,0.2225D-02/
      DATA (XPV(I,4,0),I=1,100)/
     &0.3752D+01,0.3563D+01,0.3380D+01,0.3204D+01,0.3040D+01,0.2881D+01,
     &0.2728D+01,0.2585D+01,0.2448D+01,0.2314D+01,0.2191D+01,0.2072D+01,
     &0.1957D+01,0.1850D+01,0.1747D+01,0.1648D+01,0.1556D+01,0.1467D+01,
     &0.1381D+01,0.1302D+01,0.1226D+01,0.1152D+01,0.1084D+01,0.1018D+01,
     &0.9554D+00,0.8969D+00,0.8408D+00,0.7867D+00,0.7367D+00,0.6889D+00,
     &0.6429D+00,0.5998D+00,0.5591D+00,0.5202D+00,0.4832D+00,0.4487D+00,
     &0.4159D+00,0.3845D+00,0.3551D+00,0.3274D+00,0.3013D+00,0.2764D+00,
     &0.2529D+00,0.2319D+00,0.2108D+00,0.1912D+00,0.1731D+00,0.1560D+00,
     &0.1397D+00,0.1246D+00,0.1106D+00,0.9755D-01,0.8546D-01,0.7436D-01,
     &0.6395D-01,0.5468D-01,0.4632D-01,0.3879D-01,0.3214D-01,0.2631D-01,
     &0.2126D-01,0.1701D-01,0.1348D-01,0.1056D-01,0.8234D-02,0.6412D-02,
     &0.5029D-02,0.3987D-02,0.3214D-02,0.2636D-02,0.2192D-02,0.1833D-02,
     &0.1527D-02,0.1252D-02,0.9989D-03,0.7610D-03,0.5388D-03,0.3334D-03,
     &0.3120D-03,0.2911D-03,0.2708D-03,0.2511D-03,0.2319D-03,0.2132D-03,
     &0.1950D-03,0.1774D-03,0.1603D-03,0.1439D-03,0.1280D-03,0.1127D-03,
     &0.9795D-04,0.8387D-04,0.7044D-04,0.5771D-04,0.4573D-04,0.3455D-04,
     &0.2427D-04,0.1497D-04,0.7094D-05,0.1118D-05/
      DATA (XPV(I,4,1),I=1,100)/
     &0.7267D-01,0.6928D-01,0.6597D-01,0.6277D-01,0.5978D-01,0.5687D-01,
     &0.5406D-01,0.5144D-01,0.4890D-01,0.4643D-01,0.4414D-01,0.4191D-01,
     &0.3975D-01,0.3774D-01,0.3579D-01,0.3389D-01,0.3213D-01,0.3042D-01,
     &0.2877D-01,0.2723D-01,0.2574D-01,0.2428D-01,0.2294D-01,0.2163D-01,
     &0.2037D-01,0.1919D-01,0.1805D-01,0.1695D-01,0.1592D-01,0.1493D-01,
     &0.1397D-01,0.1306D-01,0.1220D-01,0.1138D-01,0.1059D-01,0.9845D-02,
     &0.9136D-02,0.8456D-02,0.7814D-02,0.7210D-02,0.6639D-02,0.6096D-02,
     &0.5583D-02,0.5128D-02,0.4672D-02,0.4253D-02,0.3873D-02,0.3519D-02,
     &0.3189D-02,0.2893D-02,0.2627D-02,0.2391D-02,0.2185D-02,0.2009D-02,
     &0.1858D-02,0.1741D-02,0.1654D-02,0.1594D-02,0.1563D-02,0.1558D-02,
     &0.1580D-02,0.1625D-02,0.1693D-02,0.1781D-02,0.1887D-02,0.2008D-02,
     &0.2141D-02,0.2284D-02,0.2434D-02,0.2587D-02,0.2742D-02,0.2898D-02,
     &0.3053D-02,0.3209D-02,0.3370D-02,0.3537D-02,0.3715D-02,0.3891D-02,
     &0.3909D-02,0.3925D-02,0.3940D-02,0.3954D-02,0.3967D-02,0.3977D-02,
     &0.3985D-02,0.3990D-02,0.3993D-02,0.3992D-02,0.3987D-02,0.3977D-02,
     &0.3961D-02,0.3938D-02,0.3907D-02,0.3863D-02,0.3806D-02,0.3729D-02,
     &0.3619D-02,0.3510D-02,0.3213D-02,0.2499D-02/
      DATA (XPV(I,4,2),I=1,100)/
     &0.7267D-01,0.6928D-01,0.6597D-01,0.6277D-01,0.5978D-01,0.5687D-01,
     &0.5406D-01,0.5144D-01,0.4890D-01,0.4643D-01,0.4413D-01,0.4191D-01,
     &0.3974D-01,0.3773D-01,0.3578D-01,0.3389D-01,0.3213D-01,0.3042D-01,
     &0.2876D-01,0.2722D-01,0.2573D-01,0.2427D-01,0.2293D-01,0.2162D-01,
     &0.2035D-01,0.1917D-01,0.1803D-01,0.1693D-01,0.1590D-01,0.1490D-01,
     &0.1394D-01,0.1303D-01,0.1217D-01,0.1134D-01,0.1055D-01,0.9801D-02,
     &0.9086D-02,0.8401D-02,0.7753D-02,0.7143D-02,0.6564D-02,0.6013D-02,
     &0.5492D-02,0.5026D-02,0.4559D-02,0.4128D-02,0.3735D-02,0.3366D-02,
     &0.3020D-02,0.2707D-02,0.2422D-02,0.2165D-02,0.1936D-02,0.1736D-02,
     &0.1559D-02,0.1413D-02,0.1295D-02,0.1202D-02,0.1135D-02,0.1092D-02,
     &0.1073D-02,0.1077D-02,0.1101D-02,0.1143D-02,0.1201D-02,0.1274D-02,
     &0.1357D-02,0.1448D-02,0.1543D-02,0.1639D-02,0.1732D-02,0.1817D-02,
     &0.1888D-02,0.1938D-02,0.1960D-02,0.1941D-02,0.1870D-02,0.1725D-02,
     &0.1703D-02,0.1680D-02,0.1656D-02,0.1631D-02,0.1604D-02,0.1577D-02,
     &0.1548D-02,0.1517D-02,0.1485D-02,0.1452D-02,0.1417D-02,0.1380D-02,
     &0.1341D-02,0.1299D-02,0.1255D-02,0.1207D-02,0.1156D-02,0.1098D-02,
     &0.1033D-02,0.9674D-03,0.8541D-03,0.6354D-03/
      DATA (XPV(I,4,3),I=1,100)/
     &0.7305D-01,0.6967D-01,0.6638D-01,0.6319D-01,0.6022D-01,0.5733D-01,
     &0.5454D-01,0.5194D-01,0.4942D-01,0.4697D-01,0.4470D-01,0.4249D-01,
     &0.4035D-01,0.3836D-01,0.3644D-01,0.3457D-01,0.3283D-01,0.3115D-01,
     &0.2952D-01,0.2801D-01,0.2655D-01,0.2512D-01,0.2381D-01,0.2253D-01,
     &0.2130D-01,0.2016D-01,0.1905D-01,0.1798D-01,0.1698D-01,0.1603D-01,
     &0.1511D-01,0.1424D-01,0.1341D-01,0.1262D-01,0.1187D-01,0.1116D-01,
     &0.1049D-01,0.9841D-02,0.9231D-02,0.8659D-02,0.8117D-02,0.7599D-02,
     &0.7111D-02,0.6679D-02,0.6237D-02,0.5829D-02,0.5456D-02,0.5100D-02,
     &0.4761D-02,0.4448D-02,0.4155D-02,0.3882D-02,0.3626D-02,0.3388D-02,
     &0.3157D-02,0.2947D-02,0.2749D-02,0.2560D-02,0.2381D-02,0.2208D-02,
     &0.2041D-02,0.1879D-02,0.1722D-02,0.1566D-02,0.1413D-02,0.1263D-02,
     &0.1119D-02,0.9814D-03,0.8540D-03,0.7401D-03,0.6436D-03,0.5684D-03,
     &0.5183D-03,0.4963D-03,0.5046D-03,0.5445D-03,0.6168D-03,0.7197D-03,
     &0.7326D-03,0.7455D-03,0.7585D-03,0.7712D-03,0.7840D-03,0.7964D-03,
     &0.8087D-03,0.8205D-03,0.8319D-03,0.8426D-03,0.8525D-03,0.8614D-03,
     &0.8691D-03,0.8752D-03,0.8793D-03,0.8807D-03,0.8787D-03,0.8717D-03,
     &0.8570D-03,0.8420D-03,0.7795D-03,0.6128D-03/
      DATA (XPV(I,4,4),I=1,100)/
     &0.7282D-01,0.6943D-01,0.6613D-01,0.6293D-01,0.5995D-01,0.5705D-01,
     &0.5425D-01,0.5164D-01,0.4911D-01,0.4664D-01,0.4436D-01,0.4214D-01,
     &0.3998D-01,0.3798D-01,0.3604D-01,0.3416D-01,0.3240D-01,0.3071D-01,
     &0.2906D-01,0.2753D-01,0.2605D-01,0.2461D-01,0.2328D-01,0.2198D-01,
     &0.2073D-01,0.1957D-01,0.1844D-01,0.1735D-01,0.1633D-01,0.1535D-01,
     &0.1441D-01,0.1352D-01,0.1267D-01,0.1186D-01,0.1108D-01,0.1035D-01,
     &0.9656D-02,0.8988D-02,0.8358D-02,0.7765D-02,0.7204D-02,0.6669D-02,
     &0.6164D-02,0.5715D-02,0.5262D-02,0.4844D-02,0.4464D-02,0.4105D-02,
     &0.3767D-02,0.3460D-02,0.3177D-02,0.2920D-02,0.2687D-02,0.2479D-02,
     &0.2287D-02,0.2123D-02,0.1980D-02,0.1856D-02,0.1752D-02,0.1664D-02,
     &0.1592D-02,0.1534D-02,0.1490D-02,0.1456D-02,0.1432D-02,0.1417D-02,
     &0.1410D-02,0.1411D-02,0.1420D-02,0.1440D-02,0.1475D-02,0.1528D-02,
     &0.1609D-02,0.1726D-02,0.1895D-02,0.2133D-02,0.2459D-02,0.2886D-02,
     &0.2938D-02,0.2991D-02,0.3043D-02,0.3095D-02,0.3146D-02,0.3196D-02,
     &0.3246D-02,0.3294D-02,0.3340D-02,0.3382D-02,0.3423D-02,0.3458D-02,
     &0.3490D-02,0.3514D-02,0.3531D-02,0.3537D-02,0.3529D-02,0.3502D-02,
     &0.3443D-02,0.3384D-02,0.3138D-02,0.2476D-02/
      DATA (XPV(I,5,0),I=1,100)/
     &0.5090D+01,0.4807D+01,0.4532D+01,0.4269D+01,0.4025D+01,0.3790D+01,
     &0.3565D+01,0.3357D+01,0.3158D+01,0.2966D+01,0.2789D+01,0.2619D+01,
     &0.2456D+01,0.2306D+01,0.2162D+01,0.2024D+01,0.1896D+01,0.1775D+01,
     &0.1658D+01,0.1551D+01,0.1449D+01,0.1350D+01,0.1260D+01,0.1174D+01,
     &0.1092D+01,0.1017D+01,0.9446D+00,0.8759D+00,0.8129D+00,0.7532D+00,
     &0.6963D+00,0.6436D+00,0.5942D+00,0.5475D+00,0.5035D+00,0.4630D+00,
     &0.4248D+00,0.3887D+00,0.3552D+00,0.3241D+00,0.2952D+00,0.2679D+00,
     &0.2425D+00,0.2201D+00,0.1979D+00,0.1776D+00,0.1591D+00,0.1419D+00,
     &0.1258D+00,0.1112D+00,0.9780D-01,0.8557D-01,0.7444D-01,0.6440D-01,
     &0.5515D-01,0.4707D-01,0.3992D-01,0.3359D-01,0.2809D-01,0.2335D-01,
     &0.1929D-01,0.1591D-01,0.1311D-01,0.1080D-01,0.8928D-02,0.7425D-02,
     &0.6231D-02,0.5269D-02,0.4486D-02,0.3833D-02,0.3270D-02,0.2770D-02,
     &0.2314D-02,0.1893D-02,0.1501D-02,0.1135D-02,0.7972D-03,0.4881D-03,
     &0.4561D-03,0.4250D-03,0.3947D-03,0.3653D-03,0.3368D-03,0.3092D-03,
     &0.2821D-03,0.2562D-03,0.2311D-03,0.2068D-03,0.1835D-03,0.1611D-03,
     &0.1396D-03,0.1192D-03,0.9970D-04,0.8133D-04,0.6411D-04,0.4814D-04,
     &0.3357D-04,0.2049D-04,0.9589D-05,0.1523D-05/
      DATA (XPV(I,5,1),I=1,100)/
     &0.1266D+00,0.1201D+00,0.1139D+00,0.1078D+00,0.1022D+00,0.9680D-01,
     &0.9156D-01,0.8670D-01,0.8201D-01,0.7747D-01,0.7327D-01,0.6921D-01,
     &0.6529D-01,0.6166D-01,0.5816D-01,0.5478D-01,0.5165D-01,0.4863D-01,
     &0.4572D-01,0.4302D-01,0.4044D-01,0.3792D-01,0.3561D-01,0.3338D-01,
     &0.3124D-01,0.2925D-01,0.2735D-01,0.2551D-01,0.2381D-01,0.2218D-01,
     &0.2062D-01,0.1916D-01,0.1779D-01,0.1647D-01,0.1522D-01,0.1406D-01,
     &0.1296D-01,0.1192D-01,0.1094D-01,0.1003D-01,0.9174D-02,0.8369D-02,
     &0.7616D-02,0.6954D-02,0.6299D-02,0.5702D-02,0.5167D-02,0.4674D-02,
     &0.4219D-02,0.3817D-02,0.3459D-02,0.3147D-02,0.2878D-02,0.2651D-02,
     &0.2460D-02,0.2315D-02,0.2210D-02,0.2140D-02,0.2107D-02,0.2106D-02,
     &0.2137D-02,0.2196D-02,0.2281D-02,0.2387D-02,0.2512D-02,0.2652D-02,
     &0.2804D-02,0.2964D-02,0.3128D-02,0.3295D-02,0.3463D-02,0.3634D-02,
     &0.3808D-02,0.3993D-02,0.4196D-02,0.4430D-02,0.4706D-02,0.5014D-02,
     &0.5048D-02,0.5080D-02,0.5111D-02,0.5140D-02,0.5168D-02,0.5193D-02,
     &0.5215D-02,0.5233D-02,0.5248D-02,0.5257D-02,0.5261D-02,0.5258D-02,
     &0.5247D-02,0.5225D-02,0.5191D-02,0.5140D-02,0.5069D-02,0.4968D-02,
     &0.4823D-02,0.4671D-02,0.4254D-02,0.3263D-02/
      DATA (XPV(I,5,2),I=1,100)/
     &0.1266D+00,0.1201D+00,0.1139D+00,0.1078D+00,0.1022D+00,0.9679D-01,
     &0.9156D-01,0.8670D-01,0.8201D-01,0.7747D-01,0.7326D-01,0.6921D-01,
     &0.6528D-01,0.6166D-01,0.5815D-01,0.5477D-01,0.5164D-01,0.4862D-01,
     &0.4571D-01,0.4301D-01,0.4042D-01,0.3790D-01,0.3559D-01,0.3335D-01,
     &0.3121D-01,0.2922D-01,0.2731D-01,0.2547D-01,0.2377D-01,0.2214D-01,
     &0.2058D-01,0.1911D-01,0.1773D-01,0.1641D-01,0.1515D-01,0.1399D-01,
     &0.1288D-01,0.1182D-01,0.1083D-01,0.9913D-02,0.9047D-02,0.8227D-02,
     &0.7461D-02,0.6782D-02,0.6109D-02,0.5493D-02,0.4936D-02,0.4419D-02,
     &0.3940D-02,0.3509D-02,0.3121D-02,0.2776D-02,0.2470D-02,0.2205D-02,
     &0.1972D-02,0.1782D-02,0.1628D-02,0.1507D-02,0.1418D-02,0.1359D-02,
     &0.1328D-02,0.1323D-02,0.1340D-02,0.1377D-02,0.1429D-02,0.1495D-02,
     &0.1570D-02,0.1651D-02,0.1733D-02,0.1813D-02,0.1887D-02,0.1950D-02,
     &0.1998D-02,0.2025D-02,0.2028D-02,0.2000D-02,0.1934D-02,0.1821D-02,
     &0.1805D-02,0.1788D-02,0.1770D-02,0.1751D-02,0.1732D-02,0.1712D-02,
     &0.1691D-02,0.1668D-02,0.1645D-02,0.1620D-02,0.1594D-02,0.1566D-02,
     &0.1536D-02,0.1503D-02,0.1467D-02,0.1428D-02,0.1384D-02,0.1333D-02,
     &0.1271D-02,0.1209D-02,0.1082D-02,0.8147D-03/
      DATA (XPV(I,5,3),I=1,100)/
     &0.1270D+00,0.1206D+00,0.1143D+00,0.1083D+00,0.1027D+00,0.9728D-01,
     &0.9207D-01,0.8723D-01,0.8256D-01,0.7804D-01,0.7386D-01,0.6983D-01,
     &0.6593D-01,0.6233D-01,0.5885D-01,0.5549D-01,0.5239D-01,0.4939D-01,
     &0.4651D-01,0.4384D-01,0.4128D-01,0.3880D-01,0.3652D-01,0.3431D-01,
     &0.3221D-01,0.3025D-01,0.2838D-01,0.2657D-01,0.2490D-01,0.2331D-01,
     &0.2178D-01,0.2036D-01,0.1901D-01,0.1773D-01,0.1651D-01,0.1538D-01,
     &0.1431D-01,0.1329D-01,0.1233D-01,0.1144D-01,0.1061D-01,0.9815D-02,
     &0.9073D-02,0.8419D-02,0.7762D-02,0.7159D-02,0.6612D-02,0.6098D-02,
     &0.5612D-02,0.5170D-02,0.4761D-02,0.4384D-02,0.4038D-02,0.3721D-02,
     &0.3420D-02,0.3151D-02,0.2904D-02,0.2675D-02,0.2463D-02,0.2266D-02,
     &0.2081D-02,0.1908D-02,0.1746D-02,0.1589D-02,0.1442D-02,0.1302D-02,
     &0.1172D-02,0.1053D-02,0.9463D-03,0.8557D-03,0.7842D-03,0.7348D-03,
     &0.7109D-03,0.7155D-03,0.7513D-03,0.8206D-03,0.9250D-03,0.1061D-02,
     &0.1078D-02,0.1094D-02,0.1110D-02,0.1126D-02,0.1141D-02,0.1156D-02,
     &0.1170D-02,0.1183D-02,0.1196D-02,0.1207D-02,0.1217D-02,0.1225D-02,
     &0.1231D-02,0.1235D-02,0.1235D-02,0.1231D-02,0.1222D-02,0.1205D-02,
     &0.1177D-02,0.1147D-02,0.1049D-02,0.8076D-03/
      DATA (XPV(I,5,4),I=1,100)/
     &0.1268D+00,0.1203D+00,0.1141D+00,0.1080D+00,0.1024D+00,0.9699D-01,
     &0.9176D-01,0.8691D-01,0.8223D-01,0.7769D-01,0.7350D-01,0.6945D-01,
     &0.6554D-01,0.6192D-01,0.5843D-01,0.5506D-01,0.5194D-01,0.4893D-01,
     &0.4603D-01,0.4334D-01,0.4077D-01,0.3826D-01,0.3597D-01,0.3374D-01,
     &0.3162D-01,0.2964D-01,0.2775D-01,0.2592D-01,0.2423D-01,0.2262D-01,
     &0.2108D-01,0.1963D-01,0.1826D-01,0.1696D-01,0.1572D-01,0.1457D-01,
     &0.1348D-01,0.1245D-01,0.1148D-01,0.1058D-01,0.9728D-02,0.8927D-02,
     &0.8178D-02,0.7517D-02,0.6860D-02,0.6260D-02,0.5718D-02,0.5215D-02,
     &0.4746D-02,0.4325D-02,0.3945D-02,0.3604D-02,0.3300D-02,0.3034D-02,
     &0.2794D-02,0.2595D-02,0.2428D-02,0.2288D-02,0.2176D-02,0.2089D-02,
     &0.2024D-02,0.1980D-02,0.1955D-02,0.1945D-02,0.1948D-02,0.1963D-02,
     &0.1990D-02,0.2028D-02,0.2077D-02,0.2140D-02,0.2220D-02,0.2326D-02,
     &0.2465D-02,0.2653D-02,0.2905D-02,0.3246D-02,0.3695D-02,0.4254D-02,
     &0.4321D-02,0.4386D-02,0.4451D-02,0.4514D-02,0.4577D-02,0.4636D-02,
     &0.4694D-02,0.4748D-02,0.4799D-02,0.4844D-02,0.4884D-02,0.4917D-02,
     &0.4943D-02,0.4957D-02,0.4959D-02,0.4943D-02,0.4907D-02,0.4841D-02,
     &0.4729D-02,0.4609D-02,0.4221D-02,0.3255D-02/
      DATA (XPV(I,6,0),I=1,100)/
     &0.6237D+01,0.5864D+01,0.5504D+01,0.5161D+01,0.4844D+01,0.4540D+01,
     &0.4250D+01,0.3983D+01,0.3728D+01,0.3484D+01,0.3260D+01,0.3047D+01,
     &0.2842D+01,0.2655D+01,0.2476D+01,0.2305D+01,0.2149D+01,0.2000D+01,
     &0.1859D+01,0.1729D+01,0.1606D+01,0.1488D+01,0.1381D+01,0.1279D+01,
     &0.1183D+01,0.1094D+01,0.1011D+01,0.9315D+00,0.8593D+00,0.7912D+00,
     &0.7268D+00,0.6675D+00,0.6124D+00,0.5606D+00,0.5121D+00,0.4678D+00,
     &0.4264D+00,0.3876D+00,0.3518D+00,0.3190D+00,0.2886D+00,0.2603D+00,
     &0.2341D+00,0.2112D+00,0.1888D+00,0.1684D+00,0.1501D+00,0.1333D+00,
     &0.1177D+00,0.1036D+00,0.9087D-01,0.7939D-01,0.6905D-01,0.5982D-01,
     &0.5142D-01,0.4414D-01,0.3777D-01,0.3217D-01,0.2734D-01,0.2318D-01,
     &0.1963D-01,0.1666D-01,0.1417D-01,0.1208D-01,0.1035D-01,0.8900D-02,
     &0.7693D-02,0.6662D-02,0.5773D-02,0.4987D-02,0.4279D-02,0.3629D-02,
     &0.3029D-02,0.2471D-02,0.1953D-02,0.1472D-02,0.1029D-02,0.6270D-03,
     &0.5855D-03,0.5451D-03,0.5059D-03,0.4679D-03,0.4310D-03,0.3953D-03,
     &0.3604D-03,0.3269D-03,0.2945D-03,0.2634D-03,0.2334D-03,0.2046D-03,
     &0.1771D-03,0.1509D-03,0.1260D-03,0.1026D-03,0.8070D-04,0.6045D-04,
     &0.4202D-04,0.2555D-04,0.1191D-04,0.1897D-05/
      DATA (XPV(I,6,1),I=1,100)/
     &0.1781D+00,0.1684D+00,0.1591D+00,0.1501D+00,0.1418D+00,0.1337D+00,
     &0.1260D+00,0.1189D+00,0.1120D+00,0.1054D+00,0.9931D-01,0.9344D-01,
     &0.8779D-01,0.8258D-01,0.7757D-01,0.7276D-01,0.6832D-01,0.6405D-01,
     &0.5996D-01,0.5619D-01,0.5258D-01,0.4909D-01,0.4591D-01,0.4283D-01,
     &0.3990D-01,0.3720D-01,0.3462D-01,0.3214D-01,0.2986D-01,0.2770D-01,
     &0.2563D-01,0.2370D-01,0.2190D-01,0.2019D-01,0.1857D-01,0.1708D-01,
     &0.1567D-01,0.1434D-01,0.1310D-01,0.1196D-01,0.1090D-01,0.9901D-02,
     &0.8978D-02,0.8170D-02,0.7379D-02,0.6665D-02,0.6029D-02,0.5448D-02,
     &0.4919D-02,0.4455D-02,0.4047D-02,0.3695D-02,0.3396D-02,0.3149D-02,
     &0.2945D-02,0.2795D-02,0.2690D-02,0.2626D-02,0.2604D-02,0.2618D-02,
     &0.2666D-02,0.2744D-02,0.2850D-02,0.2977D-02,0.3122D-02,0.3283D-02,
     &0.3453D-02,0.3631D-02,0.3813D-02,0.3996D-02,0.4182D-02,0.4372D-02,
     &0.4572D-02,0.4792D-02,0.5045D-02,0.5351D-02,0.5725D-02,0.6156D-02,
     &0.6204D-02,0.6250D-02,0.6295D-02,0.6337D-02,0.6377D-02,0.6413D-02,
     &0.6446D-02,0.6474D-02,0.6498D-02,0.6514D-02,0.6523D-02,0.6523D-02,
     &0.6513D-02,0.6488D-02,0.6447D-02,0.6385D-02,0.6296D-02,0.6169D-02,
     &0.5986D-02,0.5790D-02,0.5259D-02,0.4013D-02/
      DATA (XPV(I,6,2),I=1,100)/
     &0.1781D+00,0.1684D+00,0.1591D+00,0.1501D+00,0.1418D+00,0.1337D+00,
     &0.1260D+00,0.1189D+00,0.1120D+00,0.1054D+00,0.9930D-01,0.9343D-01,
     &0.8778D-01,0.8257D-01,0.7756D-01,0.7274D-01,0.6830D-01,0.6403D-01,
     &0.5994D-01,0.5617D-01,0.5255D-01,0.4906D-01,0.4587D-01,0.4280D-01,
     &0.3987D-01,0.3716D-01,0.3457D-01,0.3209D-01,0.2981D-01,0.2764D-01,
     &0.2556D-01,0.2363D-01,0.2181D-01,0.2009D-01,0.1846D-01,0.1696D-01,
     &0.1554D-01,0.1420D-01,0.1295D-01,0.1179D-01,0.1071D-01,0.9697D-02,
     &0.8753D-02,0.7923D-02,0.7107D-02,0.6365D-02,0.5699D-02,0.5086D-02,
     &0.4521D-02,0.4018D-02,0.3569D-02,0.3171D-02,0.2823D-02,0.2522D-02,
     &0.2261D-02,0.2049D-02,0.1878D-02,0.1744D-02,0.1647D-02,0.1582D-02,
     &0.1547D-02,0.1538D-02,0.1553D-02,0.1587D-02,0.1636D-02,0.1697D-02,
     &0.1765D-02,0.1837D-02,0.1909D-02,0.1977D-02,0.2038D-02,0.2086D-02,
     &0.2120D-02,0.2137D-02,0.2134D-02,0.2109D-02,0.2062D-02,0.1987D-02,
     &0.1976D-02,0.1965D-02,0.1953D-02,0.1941D-02,0.1928D-02,0.1914D-02,
     &0.1899D-02,0.1884D-02,0.1867D-02,0.1848D-02,0.1828D-02,0.1806D-02,
     &0.1782D-02,0.1754D-02,0.1723D-02,0.1688D-02,0.1646D-02,0.1596D-02,
     &0.1533D-02,0.1467D-02,0.1321D-02,0.9997D-03/
      DATA (XPV(I,6,3),I=1,100)/
     &0.1785D+00,0.1689D+00,0.1595D+00,0.1506D+00,0.1423D+00,0.1342D+00,
     &0.1266D+00,0.1194D+00,0.1126D+00,0.1060D+00,0.9992D-01,0.9408D-01,
     &0.8845D-01,0.8327D-01,0.7828D-01,0.7350D-01,0.6908D-01,0.6484D-01,
     &0.6078D-01,0.5703D-01,0.5345D-01,0.4999D-01,0.4684D-01,0.4379D-01,
     &0.4090D-01,0.3822D-01,0.3567D-01,0.3322D-01,0.3097D-01,0.2884D-01,
     &0.2680D-01,0.2490D-01,0.2312D-01,0.2144D-01,0.1984D-01,0.1837D-01,
     &0.1699D-01,0.1567D-01,0.1445D-01,0.1332D-01,0.1227D-01,0.1128D-01,
     &0.1035D-01,0.9539D-02,0.8732D-02,0.7995D-02,0.7330D-02,0.6710D-02,
     &0.6131D-02,0.5606D-02,0.5125D-02,0.4686D-02,0.4286D-02,0.3924D-02,
     &0.3584D-02,0.3285D-02,0.3013D-02,0.2764D-02,0.2538D-02,0.2330D-02,
     &0.2139D-02,0.1964D-02,0.1804D-02,0.1652D-02,0.1512D-02,0.1383D-02,
     &0.1266D-02,0.1162D-02,0.1073D-02,0.1000D-02,0.9475D-03,0.9178D-03,
     &0.9140D-03,0.9394D-03,0.9971D-03,0.1091D-02,0.1222D-02,0.1386D-02,
     &0.1405D-02,0.1424D-02,0.1442D-02,0.1460D-02,0.1477D-02,0.1494D-02,
     &0.1510D-02,0.1524D-02,0.1537D-02,0.1549D-02,0.1558D-02,0.1565D-02,
     &0.1570D-02,0.1571D-02,0.1567D-02,0.1558D-02,0.1542D-02,0.1516D-02,
     &0.1476D-02,0.1432D-02,0.1303D-02,0.9967D-03/
      DATA (XPV(I,6,4),I=1,100)/
     &0.1783D+00,0.1686D+00,0.1592D+00,0.1503D+00,0.1420D+00,0.1339D+00,
     &0.1262D+00,0.1191D+00,0.1122D+00,0.1056D+00,0.9955D-01,0.9369D-01,
     &0.8805D-01,0.8285D-01,0.7785D-01,0.7305D-01,0.6862D-01,0.6436D-01,
     &0.6028D-01,0.5652D-01,0.5292D-01,0.4944D-01,0.4627D-01,0.4321D-01,
     &0.4029D-01,0.3760D-01,0.3503D-01,0.3256D-01,0.3030D-01,0.2814D-01,
     &0.2609D-01,0.2417D-01,0.2238D-01,0.2068D-01,0.1907D-01,0.1759D-01,
     &0.1619D-01,0.1486D-01,0.1363D-01,0.1250D-01,0.1144D-01,0.1044D-01,
     &0.9519D-02,0.8711D-02,0.7914D-02,0.7191D-02,0.6544D-02,0.5949D-02,
     &0.5400D-02,0.4912D-02,0.4476D-02,0.4091D-02,0.3753D-02,0.3461D-02,
     &0.3203D-02,0.2994D-02,0.2824D-02,0.2687D-02,0.2583D-02,0.2509D-02,
     &0.2462D-02,0.2439D-02,0.2438D-02,0.2455D-02,0.2487D-02,0.2534D-02,
     &0.2594D-02,0.2666D-02,0.2752D-02,0.2854D-02,0.2977D-02,0.3129D-02,
     &0.3321D-02,0.3571D-02,0.3898D-02,0.4329D-02,0.4884D-02,0.5555D-02,
     &0.5632D-02,0.5708D-02,0.5783D-02,0.5856D-02,0.5926D-02,0.5993D-02,
     &0.6056D-02,0.6115D-02,0.6168D-02,0.6214D-02,0.6254D-02,0.6283D-02,
     &0.6301D-02,0.6305D-02,0.6291D-02,0.6256D-02,0.6193D-02,0.6090D-02,
     &0.5930D-02,0.5755D-02,0.5242D-02,0.4010D-02/
      DATA (XPV(I,7,0),I=1,100)/
     &0.7226D+01,0.6770D+01,0.6333D+01,0.5916D+01,0.5533D+01,0.5167D+01,
     &0.4820D+01,0.4501D+01,0.4197D+01,0.3907D+01,0.3643D+01,0.3391D+01,
     &0.3151D+01,0.2932D+01,0.2724D+01,0.2526D+01,0.2345D+01,0.2174D+01,
     &0.2012D+01,0.1864D+01,0.1724D+01,0.1590D+01,0.1470D+01,0.1356D+01,
     &0.1248D+01,0.1150D+01,0.1057D+01,0.9701D+00,0.8910D+00,0.8168D+00,
     &0.7469D+00,0.6829D+00,0.6237D+00,0.5684D+00,0.5169D+00,0.4702D+00,
     &0.4266D+00,0.3861D+00,0.3490D+00,0.3152D+00,0.2841D+00,0.2552D+00,
     &0.2287D+00,0.2056D+00,0.1833D+00,0.1631D+00,0.1451D+00,0.1286D+00,
     &0.1134D+00,0.9989D-01,0.8770D-01,0.7678D-01,0.6701D-01,0.5835D-01,
     &0.5051D-01,0.4375D-01,0.3785D-01,0.3267D-01,0.2821D-01,0.2435D-01,
     &0.2104D-01,0.1823D-01,0.1585D-01,0.1380D-01,0.1205D-01,0.1054D-01,
     &0.9237D-02,0.8080D-02,0.7048D-02,0.6110D-02,0.5249D-02,0.4452D-02,
     &0.3711D-02,0.3023D-02,0.2385D-02,0.1794D-02,0.1252D-02,0.7601D-03,
     &0.7095D-03,0.6603D-03,0.6126D-03,0.5662D-03,0.5213D-03,0.4779D-03,
     &0.4354D-03,0.3948D-03,0.3555D-03,0.3177D-03,0.2813D-03,0.2465D-03,
     &0.2131D-03,0.1814D-03,0.1514D-03,0.1231D-03,0.9674D-04,0.7237D-04,
     &0.5023D-04,0.3050D-04,0.1418D-04,0.2263D-05/
      DATA (XPV(I,7,1),I=1,100)/
     &0.2263D+00,0.2134D+00,0.2010D+00,0.1891D+00,0.1781D+00,0.1675D+00,
     &0.1573D+00,0.1480D+00,0.1390D+00,0.1304D+00,0.1225D+00,0.1149D+00,
     &0.1076D+00,0.1009D+00,0.9446D-01,0.8830D-01,0.8265D-01,0.7723D-01,
     &0.7206D-01,0.6730D-01,0.6277D-01,0.5840D-01,0.5443D-01,0.5061D-01,
     &0.4699D-01,0.4365D-01,0.4048D-01,0.3745D-01,0.3468D-01,0.3205D-01,
     &0.2955D-01,0.2724D-01,0.2508D-01,0.2304D-01,0.2112D-01,0.1936D-01,
     &0.1771D-01,0.1615D-01,0.1472D-01,0.1340D-01,0.1217D-01,0.1103D-01,
     &0.9985D-02,0.9072D-02,0.8184D-02,0.7387D-02,0.6683D-02,0.6045D-02,
     &0.5467D-02,0.4966D-02,0.4530D-02,0.4157D-02,0.3846D-02,0.3593D-02,
     &0.3387D-02,0.3241D-02,0.3146D-02,0.3095D-02,0.3088D-02,0.3119D-02,
     &0.3187D-02,0.3286D-02,0.3412D-02,0.3561D-02,0.3727D-02,0.3908D-02,
     &0.4098D-02,0.4295D-02,0.4495D-02,0.4698D-02,0.4903D-02,0.5117D-02,
     &0.5346D-02,0.5605D-02,0.5913D-02,0.6292D-02,0.6763D-02,0.7310D-02,
     &0.7371D-02,0.7430D-02,0.7487D-02,0.7541D-02,0.7592D-02,0.7638D-02,
     &0.7681D-02,0.7717D-02,0.7747D-02,0.7769D-02,0.7783D-02,0.7784D-02,
     &0.7772D-02,0.7743D-02,0.7695D-02,0.7620D-02,0.7512D-02,0.7358D-02,
     &0.7137D-02,0.6896D-02,0.6255D-02,0.4763D-02/
      DATA (XPV(I,7,2),I=1,100)/
     &0.2263D+00,0.2134D+00,0.2010D+00,0.1891D+00,0.1780D+00,0.1675D+00,
     &0.1573D+00,0.1480D+00,0.1390D+00,0.1304D+00,0.1225D+00,0.1149D+00,
     &0.1076D+00,0.1009D+00,0.9444D-01,0.8828D-01,0.8263D-01,0.7721D-01,
     &0.7203D-01,0.6727D-01,0.6273D-01,0.5836D-01,0.5439D-01,0.5056D-01,
     &0.4694D-01,0.4360D-01,0.4042D-01,0.3738D-01,0.3460D-01,0.3197D-01,
     &0.2946D-01,0.2714D-01,0.2497D-01,0.2291D-01,0.2098D-01,0.1921D-01,
     &0.1754D-01,0.1597D-01,0.1451D-01,0.1317D-01,0.1193D-01,0.1076D-01,
     &0.9687D-02,0.8745D-02,0.7825D-02,0.6993D-02,0.6250D-02,0.5570D-02,
     &0.4947D-02,0.4395D-02,0.3905D-02,0.3475D-02,0.3100D-02,0.2779D-02,
     &0.2500D-02,0.2276D-02,0.2097D-02,0.1957D-02,0.1856D-02,0.1789D-02,
     &0.1752D-02,0.1742D-02,0.1755D-02,0.1786D-02,0.1832D-02,0.1888D-02,
     &0.1951D-02,0.2017D-02,0.2081D-02,0.2140D-02,0.2190D-02,0.2230D-02,
     &0.2256D-02,0.2268D-02,0.2266D-02,0.2252D-02,0.2228D-02,0.2192D-02,
     &0.2187D-02,0.2181D-02,0.2175D-02,0.2168D-02,0.2160D-02,0.2152D-02,
     &0.2143D-02,0.2132D-02,0.2120D-02,0.2107D-02,0.2091D-02,0.2074D-02,
     &0.2053D-02,0.2029D-02,0.2000D-02,0.1966D-02,0.1924D-02,0.1872D-02,
     &0.1804D-02,0.1733D-02,0.1564D-02,0.1186D-02/
      DATA (XPV(I,7,3),I=1,100)/
     &0.2267D+00,0.2139D+00,0.2014D+00,0.1896D+00,0.1786D+00,0.1680D+00,
     &0.1579D+00,0.1485D+00,0.1396D+00,0.1310D+00,0.1231D+00,0.1155D+00,
     &0.1083D+00,0.1016D+00,0.9519D-01,0.8906D-01,0.8343D-01,0.7804D-01,
     &0.7290D-01,0.6817D-01,0.6366D-01,0.5932D-01,0.5538D-01,0.5158D-01,
     &0.4799D-01,0.4469D-01,0.4154D-01,0.3854D-01,0.3579D-01,0.3319D-01,
     &0.3072D-01,0.2843D-01,0.2629D-01,0.2427D-01,0.2237D-01,0.2063D-01,
     &0.1899D-01,0.1745D-01,0.1602D-01,0.1470D-01,0.1348D-01,0.1233D-01,
     &0.1127D-01,0.1034D-01,0.9420D-02,0.8586D-02,0.7837D-02,0.7144D-02,
     &0.6498D-02,0.5917D-02,0.5388D-02,0.4909D-02,0.4474D-02,0.4084D-02,
     &0.3720D-02,0.3402D-02,0.3116D-02,0.2856D-02,0.2623D-02,0.2412D-02,
     &0.2219D-02,0.2045D-02,0.1888D-02,0.1743D-02,0.1611D-02,0.1491D-02,
     &0.1385D-02,0.1294D-02,0.1218D-02,0.1160D-02,0.1123D-02,0.1110D-02,
     &0.1122D-02,0.1165D-02,0.1242D-02,0.1357D-02,0.1512D-02,0.1701D-02,
     &0.1723D-02,0.1744D-02,0.1765D-02,0.1785D-02,0.1804D-02,0.1822D-02,
     &0.1839D-02,0.1854D-02,0.1868D-02,0.1880D-02,0.1889D-02,0.1895D-02,
     &0.1898D-02,0.1896D-02,0.1889D-02,0.1876D-02,0.1853D-02,0.1819D-02,
     &0.1768D-02,0.1711D-02,0.1554D-02,0.1185D-02/
      DATA (XPV(I,7,4),I=1,100)/
     &0.2265D+00,0.2136D+00,0.2012D+00,0.1893D+00,0.1783D+00,0.1677D+00,
     &0.1575D+00,0.1482D+00,0.1392D+00,0.1306D+00,0.1227D+00,0.1151D+00,
     &0.1078D+00,0.1012D+00,0.9474D-01,0.8860D-01,0.8296D-01,0.7755D-01,
     &0.7239D-01,0.6764D-01,0.6312D-01,0.5876D-01,0.5480D-01,0.5099D-01,
     &0.4738D-01,0.4406D-01,0.4090D-01,0.3788D-01,0.3512D-01,0.3250D-01,
     &0.3002D-01,0.2771D-01,0.2556D-01,0.2353D-01,0.2162D-01,0.1987D-01,
     &0.1822D-01,0.1667D-01,0.1524D-01,0.1392D-01,0.1270D-01,0.1156D-01,
     &0.1051D-01,0.9590D-02,0.8693D-02,0.7884D-02,0.7166D-02,0.6509D-02,
     &0.5909D-02,0.5380D-02,0.4911D-02,0.4502D-02,0.4147D-02,0.3845D-02,
     &0.3583D-02,0.3375D-02,0.3211D-02,0.3085D-02,0.2996D-02,0.2940D-02,
     &0.2914D-02,0.2914D-02,0.2939D-02,0.2982D-02,0.3044D-02,0.3121D-02,
     &0.3212D-02,0.3318D-02,0.3438D-02,0.3577D-02,0.3739D-02,0.3934D-02,
     &0.4176D-02,0.4483D-02,0.4880D-02,0.5394D-02,0.6046D-02,0.6819D-02,
     &0.6907D-02,0.6993D-02,0.7077D-02,0.7157D-02,0.7235D-02,0.7308D-02,
     &0.7377D-02,0.7439D-02,0.7495D-02,0.7542D-02,0.7580D-02,0.7605D-02,
     &0.7617D-02,0.7611D-02,0.7584D-02,0.7530D-02,0.7441D-02,0.7306D-02,
     &0.7101D-02,0.6875D-02,0.6245D-02,0.4762D-02/

C..fetching pdfs
      DO  5 IP=-6,6
        XPDF(IP)=ZEROD
 5    CONTINUE
      DO 2 I=1,IX
        ENT(I)=LOG10(XT(I))
  2   CONTINUE
      NA(1)=IX
      NA(2)=IQ
      DO 3 I=1,IQ
        ENT(IX+I)=LOG10(Q2T(I))
   3  CONTINUE
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(Q2)
C..VARIOUS FLAVOURS (u-->2,d-->1)
      XPDF(0)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,0))
      XPDF(1)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,2))
      XPDF(2)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,1))
      XPDF(3)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,3))
      XPDF(4)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,4))
      DO 21 JF=1,4
        XPDF(-JF)=XPDF(JF)
 21   CONTINUE
      RETURN
      END
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      DOUBLE PRECISION FUNCTION DBFINT(NARG,ARG,NA,ENT,TABLE)
      implicit real*8 (a-h,o-z)
      INTEGER NA(NARG), INDEX(32)
      double precision
     +       ARG(NARG),ENT(10),TABLE(10),WEIGHT(32)
      DATA ZEROD/0.D0/ONED/1.D0/
C
           DBFINT =  ZEROD
           IF(NARG .LT. 1  .OR.  NARG .GT. 5)  RETURN
C
           LMAX      =  0
           ISTEP     =  1
           KNOTS     =  1
           INDEX(1)  =  1
           WEIGHT(1) =  ONED
           DO 100    N  =  1, NARG
              X     =  ARG(N)
              NDIM  =  NA(N)
              LOCA  =  LMAX
              LMIN  =  LMAX + 1
              LMAX  =  LMAX + NDIM
              IF(NDIM .GT. 2)  GOTO 10
              IF(NDIM .EQ. 1)  GOTO 100
              H  =  X - ENT(LMIN)
              IF(H .EQ. ZEROD)  GOTO 90
              ISHIFT  =  ISTEP
              IF(X-ENT(LMIN+1) .EQ. ZEROD)  GOTO 21
              ISHIFT  =  0
              ETA     =  H / (ENT(LMIN+1) - ENT(LMIN))
              GOTO 30
   10         LOCB  =  LMAX + 1
   11         LOCC  =  (LOCA+LOCB) / 2
              IF(X-ENT(LOCC))  12, 20, 13
   12         LOCB  =  LOCC
              GOTO 14
   13         LOCA  =  LOCC
   14         IF(LOCB-LOCA .GT. 1)  GOTO 11
              LOCA    =  MIN ( MAX (LOCA,LMIN), LMAX-1 )
              ISHIFT  =  (LOCA - LMIN) * ISTEP
              ETA     =  (X - ENT(LOCA)) / (ENT(LOCA+1) - ENT(LOCA))
              GOTO 30
   20         ISHIFT  =  (LOCC - LMIN) * ISTEP
   21         DO 22  K  =  1, KNOTS
                 INDEX(K)  =  INDEX(K) + ISHIFT
   22            CONTINUE
              GOTO 90
   30         DO 31  K  =  1, KNOTS
                 INDEX(K)         =  INDEX(K) + ISHIFT
                 INDEX(K+KNOTS)   =  INDEX(K) + ISTEP
                 WEIGHT(K+KNOTS)  =  WEIGHT(K) * ETA
                 WEIGHT(K)        =  WEIGHT(K) - WEIGHT(K+KNOTS)
   31            CONTINUE
              KNOTS  =  2*KNOTS
   90         ISTEP  =  ISTEP * NDIM
  100         CONTINUE
           DO 200    K  =  1, KNOTS
              I  =  INDEX(K)
              DBFINT =  DBFINT + WEIGHT(K) * TABLE(I)
  200         CONTINUE
           RETURN
           END
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C-------------------------------------------------------------
      SUBROUTINE PHLAC2(X,Q2,XPDF)
      implicit real*8 (A-H,O-Z)
      PARAMETER(IX=100,IQ=7,NARG=2,NFUN=4)
      DOUBLE PRECISION
     +       DBFINT,
     +       XT(IX),Q2T(IQ),ARG(NARG),ENT(IX+IQ),
     +       XPV(IX,IQ,0:NFUN),XPDF(-6:6)
      DIMENSION NA(NARG)
      DATA ZEROD/0.D0/
C...100 x valuse; in (D-4,.77) log spaced (78 points)
C...              in (.78,.995) lineary spaced (22 points)
      DATA Q2T/4.,10.,50.,1.D2,1.D3,1.D4,1.D5/
      DATA XT/
     &0.1000D-03,0.1123D-03,0.1262D-03,0.1417D-03,0.1592D-03,0.1789D-03,
     &0.2009D-03,0.2257D-03,0.2535D-03,0.2848D-03,0.3199D-03,0.3593D-03,
     &0.4037D-03,0.4534D-03,0.5093D-03,0.5722D-03,0.6427D-03,0.7220D-03,
     &0.8110D-03,0.9110D-03,0.1023D-02,0.1150D-02,0.1291D-02,0.1451D-02,
     &0.1629D-02,0.1830D-02,0.2056D-02,0.2310D-02,0.2594D-02,0.2914D-02,
     &0.3274D-02,0.3677D-02,0.4131D-02,0.4640D-02,0.5212D-02,0.5855D-02,
     &0.6577D-02,0.7388D-02,0.8299D-02,0.9323D-02,0.1047D-01,0.1176D-01,
     &0.1321D-01,0.1484D-01,0.1667D-01,0.1873D-01,0.2104D-01,0.2363D-01,
     &0.2655D-01,0.2982D-01,0.3350D-01,0.3763D-01,0.4227D-01,0.4748D-01,
     &0.5334D-01,0.5992D-01,0.6731D-01,0.7560D-01,0.8493D-01,0.9540D-01,
     &0.1072D+00,0.1204D+00,0.1352D+00,0.1519D+00,0.1706D+00,0.1917D+00,
     &0.2153D+00,0.2419D+00,0.2717D+00,0.3052D+00,0.3428D+00,0.3851D+00,
     &0.4326D+00,0.4859D+00,0.5458D+00,0.6131D+00,0.6887D+00,0.7737D+00,
     &0.7837D+00,0.7937D+00,0.8037D+00,0.8137D+00,0.8237D+00,0.8337D+00,
     &0.8437D+00,0.8537D+00,0.8637D+00,0.8737D+00,0.8837D+00,0.8937D+00,
     &0.9037D+00,0.9137D+00,0.9237D+00,0.9337D+00,0.9437D+00,0.9537D+00,
     &0.9637D+00,0.9737D+00,0.9837D+00,0.9937D+00/

C...place for DATA blocks
      DATA (XPV(I,1,0),I=1,100)/
     &0.2589D+00,0.2589D+00,0.2588D+00,0.2587D+00,0.2587D+00,0.2586D+00,
     &0.2584D+00,0.2584D+00,0.2583D+00,0.2581D+00,0.2580D+00,0.2578D+00,
     &0.2576D+00,0.2574D+00,0.2572D+00,0.2568D+00,0.2566D+00,0.2562D+00,
     &0.2558D+00,0.2554D+00,0.2549D+00,0.2543D+00,0.2537D+00,0.2530D+00,
     &0.2522D+00,0.2514D+00,0.2504D+00,0.2492D+00,0.2480D+00,0.2467D+00,
     &0.2451D+00,0.2433D+00,0.2414D+00,0.2392D+00,0.2368D+00,0.2341D+00,
     &0.2312D+00,0.2278D+00,0.2241D+00,0.2201D+00,0.2157D+00,0.2108D+00,
     &0.2054D+00,0.2001D+00,0.1934D+00,0.1864D+00,0.1791D+00,0.1711D+00,
     &0.1623D+00,0.1531D+00,0.1433D+00,0.1330D+00,0.1223D+00,0.1113D+00,
     &0.9973D-01,0.8835D-01,0.7705D-01,0.6593D-01,0.5527D-01,0.4522D-01,
     &0.3597D-01,0.2775D-01,0.2067D-01,0.1471D-01,0.9973D-02,0.6363D-02,
     &0.3799D-02,0.2083D-02,0.1036D-02,0.4560D-03,0.1731D-03,0.5432D-04,
     &0.1340D-04,0.2403D-05,0.2784D-06,0.1701D-07,0.3872D-09,0.1511D-11,
     &0.6880D-12,0.3018D-12,0.1271D-12,0.5114D-13,0.1959D-13,0.7089D-14,
     &0.2386D-14,0.7514D-15,0.2177D-15,0.5781D-16,0.1392D-16,0.2956D-17,
     &0.5413D-18,0.8284D-19,0.1017D-19,0.9439D-21,0.6099D-22,0.2408D-23,
     &0.4675D-25,0.2960D-27,0.2410D-30,0.0000D+00/
      DATA (XPV(I,1,1),I=1,100)/
     &0.3845D-05,0.4208D-05,0.4608D-05,0.5043D-05,0.5522D-05,0.6047D-05,
     &0.6619D-05,0.7247D-05,0.7934D-05,0.8688D-05,0.9512D-05,0.1041D-04,
     &0.1141D-04,0.1249D-04,0.1367D-04,0.1498D-04,0.1640D-04,0.1796D-04,
     &0.1967D-04,0.2154D-04,0.2359D-04,0.2585D-04,0.2830D-04,0.3102D-04,
     &0.3396D-04,0.3720D-04,0.4076D-04,0.4466D-04,0.4891D-04,0.5358D-04,
     &0.5871D-04,0.6431D-04,0.7047D-04,0.7720D-04,0.8457D-04,0.9266D-04,
     &0.1015D-03,0.1112D-03,0.1219D-03,0.1335D-03,0.1462D-03,0.1602D-03,
     &0.1755D-03,0.1923D-03,0.2106D-03,0.2306D-03,0.2526D-03,0.2766D-03,
     &0.3028D-03,0.3314D-03,0.3627D-03,0.3968D-03,0.4340D-03,0.4744D-03,
     &0.5184D-03,0.5662D-03,0.6182D-03,0.6743D-03,0.7351D-03,0.8007D-03,
     &0.8715D-03,0.9472D-03,0.1028D-02,0.1115D-02,0.1206D-02,0.1303D-02,
     &0.1404D-02,0.1510D-02,0.1619D-02,0.1731D-02,0.1844D-02,0.1957D-02,
     &0.2068D-02,0.2173D-02,0.2271D-02,0.2355D-02,0.2418D-02,0.2443D-02,
     &0.2442D-02,0.2440D-02,0.2437D-02,0.2432D-02,0.2426D-02,0.2419D-02,
     &0.2410D-02,0.2400D-02,0.2387D-02,0.2372D-02,0.2355D-02,0.2335D-02,
     &0.2312D-02,0.2285D-02,0.2253D-02,0.2216D-02,0.2172D-02,0.2119D-02,
     &0.2054D-02,0.1973D-02,0.2027D-02,0.1319D-02/
      DATA (XPV(I,1,2),I=1,100)/
     &0.3745D-05,0.4096D-05,0.4482D-05,0.4901D-05,0.5362D-05,0.5868D-05,
     &0.6418D-05,0.7021D-05,0.7680D-05,0.8403D-05,0.9192D-05,0.1005D-04,
     &0.1100D-04,0.1203D-04,0.1317D-04,0.1440D-04,0.1576D-04,0.1724D-04,
     &0.1886D-04,0.2063D-04,0.2257D-04,0.2471D-04,0.2702D-04,0.2957D-04,
     &0.3233D-04,0.3538D-04,0.3871D-04,0.4236D-04,0.4633D-04,0.5068D-04,
     &0.5546D-04,0.6066D-04,0.6637D-04,0.7260D-04,0.7941D-04,0.8687D-04,
     &0.9503D-04,0.1039D-03,0.1137D-03,0.1243D-03,0.1360D-03,0.1487D-03,
     &0.1626D-03,0.1779D-03,0.1944D-03,0.2126D-03,0.2325D-03,0.2540D-03,
     &0.2776D-03,0.3033D-03,0.3313D-03,0.3619D-03,0.3951D-03,0.4312D-03,
     &0.4704D-03,0.5130D-03,0.5593D-03,0.6092D-03,0.6634D-03,0.7217D-03,
     &0.7848D-03,0.8522D-03,0.9245D-03,0.1002D-02,0.1084D-02,0.1171D-02,
     &0.1262D-02,0.1357D-02,0.1455D-02,0.1555D-02,0.1656D-02,0.1754D-02,
     &0.1847D-02,0.1930D-02,0.1995D-02,0.2033D-02,0.2025D-02,0.1941D-02,
     &0.1924D-02,0.1906D-02,0.1887D-02,0.1865D-02,0.1842D-02,0.1817D-02,
     &0.1789D-02,0.1759D-02,0.1727D-02,0.1692D-02,0.1654D-02,0.1612D-02,
     &0.1566D-02,0.1516D-02,0.1460D-02,0.1399D-02,0.1329D-02,0.1251D-02,
     &0.1159D-02,0.1050D-02,0.9681D-03,0.5785D-03/
      DATA (XPV(I,1,3),I=1,100)/
     &0.3363D-03,0.3490D-03,0.3624D-03,0.3761D-03,0.3904D-03,0.4053D-03,
     &0.4206D-03,0.4367D-03,0.4532D-03,0.4704D-03,0.4882D-03,0.5067D-03,
     &0.5259D-03,0.5458D-03,0.5664D-03,0.5878D-03,0.6100D-03,0.6330D-03,
     &0.6567D-03,0.6814D-03,0.7069D-03,0.7334D-03,0.7606D-03,0.7890D-03,
     &0.8180D-03,0.8483D-03,0.8795D-03,0.9116D-03,0.9447D-03,0.9788D-03,
     &0.1014D-02,0.1050D-02,0.1087D-02,0.1125D-02,0.1164D-02,0.1203D-02,
     &0.1244D-02,0.1284D-02,0.1326D-02,0.1368D-02,0.1410D-02,0.1452D-02,
     &0.1494D-02,0.1538D-02,0.1577D-02,0.1616D-02,0.1655D-02,0.1692D-02,
     &0.1724D-02,0.1754D-02,0.1780D-02,0.1800D-02,0.1816D-02,0.1825D-02,
     &0.1823D-02,0.1815D-02,0.1797D-02,0.1768D-02,0.1727D-02,0.1673D-02,
     &0.1605D-02,0.1524D-02,0.1431D-02,0.1322D-02,0.1203D-02,0.1073D-02,
     &0.9373D-03,0.7978D-03,0.6600D-03,0.5285D-03,0.4089D-03,0.3059D-03,
     &0.2241D-03,0.1662D-03,0.1329D-03,0.1233D-03,0.1354D-03,0.1682D-03,
     &0.1731D-03,0.1782D-03,0.1836D-03,0.1891D-03,0.1949D-03,0.2008D-03,
     &0.2070D-03,0.2134D-03,0.2200D-03,0.2268D-03,0.2339D-03,0.2411D-03,
     &0.2486D-03,0.2563D-03,0.2643D-03,0.2724D-03,0.2808D-03,0.2895D-03,
     &0.2984D-03,0.3075D-03,0.3530D-03,0.2469D-03/
      DATA (XPV(I,1,4),I=1,100)/
     &0.1032D-03,0.1071D-03,0.1112D-03,0.1155D-03,0.1199D-03,0.1245D-03,
     &0.1292D-03,0.1341D-03,0.1392D-03,0.1445D-03,0.1501D-03,0.1558D-03,
     &0.1617D-03,0.1679D-03,0.1743D-03,0.1809D-03,0.1878D-03,0.1949D-03,
     &0.2023D-03,0.2100D-03,0.2179D-03,0.2262D-03,0.2348D-03,0.2437D-03,
     &0.2528D-03,0.2623D-03,0.2721D-03,0.2823D-03,0.2928D-03,0.3036D-03,
     &0.3148D-03,0.3264D-03,0.3383D-03,0.3505D-03,0.3631D-03,0.3760D-03,
     &0.3892D-03,0.4027D-03,0.4165D-03,0.4306D-03,0.4448D-03,0.4592D-03,
     &0.4737D-03,0.4892D-03,0.5033D-03,0.5177D-03,0.5324D-03,0.5463D-03,
     &0.5595D-03,0.5723D-03,0.5841D-03,0.5949D-03,0.6045D-03,0.6125D-03,
     &0.6179D-03,0.6219D-03,0.6234D-03,0.6220D-03,0.6177D-03,0.6100D-03,
     &0.5989D-03,0.5841D-03,0.5662D-03,0.5443D-03,0.5194D-03,0.4919D-03,
     &0.4629D-03,0.4332D-03,0.4045D-03,0.3785D-03,0.3573D-03,0.3434D-03,
     &0.3399D-03,0.3503D-03,0.3796D-03,0.4345D-03,0.5257D-03,0.6703D-03,
     &0.6906D-03,0.7115D-03,0.7333D-03,0.7557D-03,0.7789D-03,0.8029D-03,
     &0.8279D-03,0.8535D-03,0.8800D-03,0.9073D-03,0.9354D-03,0.9645D-03,
     &0.9944D-03,0.1025D-02,0.1057D-02,0.1090D-02,0.1123D-02,0.1158D-02,
     &0.1193D-02,0.1230D-02,0.1412D-02,0.9878D-03/
      DATA (XPV(I,2,0),I=1,100)/
     &0.6395D+00,0.6278D+00,0.6160D+00,0.6041D+00,0.5928D+00,0.5814D+00,
     &0.5700D+00,0.5591D+00,0.5481D+00,0.5371D+00,0.5266D+00,0.5160D+00,
     &0.5053D+00,0.4952D+00,0.4850D+00,0.4747D+00,0.4649D+00,0.4551D+00,
     &0.4451D+00,0.4357D+00,0.4261D+00,0.4164D+00,0.4073D+00,0.3979D+00,
     &0.3886D+00,0.3795D+00,0.3704D+00,0.3612D+00,0.3523D+00,0.3433D+00,
     &0.3342D+00,0.3252D+00,0.3163D+00,0.3072D+00,0.2980D+00,0.2889D+00,
     &0.2796D+00,0.2702D+00,0.2607D+00,0.2511D+00,0.2413D+00,0.2313D+00,
     &0.2212D+00,0.2115D+00,0.2006D+00,0.1898D+00,0.1790D+00,0.1679D+00,
     &0.1563D+00,0.1447D+00,0.1330D+00,0.1213D+00,0.1095D+00,0.9788D-01,
     &0.8613D-01,0.7497D-01,0.6426D-01,0.5408D-01,0.4462D-01,0.3598D-01,
     &0.2826D-01,0.2161D-01,0.1605D-01,0.1149D-01,0.7956D-02,0.5325D-02,
     &0.3488D-02,0.2266D-02,0.1508D-02,0.1060D-02,0.8015D-03,0.6446D-03,
     &0.5352D-03,0.4451D-03,0.3626D-03,0.2837D-03,0.2078D-03,0.1348D-03,
     &0.1269D-03,0.1193D-03,0.1117D-03,0.1043D-03,0.9709D-04,0.9000D-04,
     &0.8299D-04,0.7618D-04,0.6953D-04,0.6302D-04,0.5666D-04,0.5047D-04,
     &0.4444D-04,0.3859D-04,0.3291D-04,0.2744D-04,0.2219D-04,0.1717D-04,
     &0.1243D-04,0.7989D-05,0.3996D-05,0.6174D-06/
      DATA (XPV(I,2,1),I=1,100)/
     &0.5642D-02,0.5571D-02,0.5499D-02,0.5424D-02,0.5354D-02,0.5281D-02,
     &0.5207D-02,0.5136D-02,0.5064D-02,0.4989D-02,0.4918D-02,0.4845D-02,
     &0.4770D-02,0.4698D-02,0.4624D-02,0.4547D-02,0.4473D-02,0.4397D-02,
     &0.4319D-02,0.4243D-02,0.4164D-02,0.4083D-02,0.4004D-02,0.3922D-02,
     &0.3837D-02,0.3754D-02,0.3668D-02,0.3579D-02,0.3491D-02,0.3401D-02,
     &0.3308D-02,0.3214D-02,0.3120D-02,0.3022D-02,0.2923D-02,0.2824D-02,
     &0.2723D-02,0.2620D-02,0.2517D-02,0.2414D-02,0.2311D-02,0.2207D-02,
     &0.2103D-02,0.2008D-02,0.1905D-02,0.1806D-02,0.1713D-02,0.1622D-02,
     &0.1534D-02,0.1452D-02,0.1377D-02,0.1309D-02,0.1250D-02,0.1201D-02,
     &0.1160D-02,0.1132D-02,0.1117D-02,0.1114D-02,0.1126D-02,0.1151D-02,
     &0.1190D-02,0.1242D-02,0.1308D-02,0.1385D-02,0.1472D-02,0.1569D-02,
     &0.1672D-02,0.1782D-02,0.1895D-02,0.2009D-02,0.2124D-02,0.2239D-02,
     &0.2351D-02,0.2460D-02,0.2567D-02,0.2671D-02,0.2770D-02,0.2853D-02,
     &0.2860D-02,0.2865D-02,0.2870D-02,0.2874D-02,0.2877D-02,0.2878D-02,
     &0.2878D-02,0.2876D-02,0.2872D-02,0.2865D-02,0.2856D-02,0.2843D-02,
     &0.2826D-02,0.2805D-02,0.2777D-02,0.2743D-02,0.2699D-02,0.2643D-02,
     &0.2566D-02,0.2487D-02,0.2308D-02,0.1892D-02/
      DATA (XPV(I,2,2),I=1,100)/
     &0.5642D-02,0.5571D-02,0.5498D-02,0.5424D-02,0.5353D-02,0.5281D-02,
     &0.5206D-02,0.5136D-02,0.5063D-02,0.4989D-02,0.4917D-02,0.4844D-02,
     &0.4769D-02,0.4697D-02,0.4622D-02,0.4546D-02,0.4472D-02,0.4395D-02,
     &0.4317D-02,0.4240D-02,0.4162D-02,0.4080D-02,0.4000D-02,0.3918D-02,
     &0.3833D-02,0.3749D-02,0.3663D-02,0.3573D-02,0.3485D-02,0.3394D-02,
     &0.3300D-02,0.3205D-02,0.3109D-02,0.3011D-02,0.2910D-02,0.2810D-02,
     &0.2707D-02,0.2603D-02,0.2497D-02,0.2392D-02,0.2286D-02,0.2179D-02,
     &0.2072D-02,0.1974D-02,0.1866D-02,0.1763D-02,0.1665D-02,0.1569D-02,
     &0.1475D-02,0.1387D-02,0.1304D-02,0.1229D-02,0.1161D-02,0.1102D-02,
     &0.1050D-02,0.1012D-02,0.9843D-03,0.9685D-03,0.9656D-03,0.9754D-03,
     &0.9981D-03,0.1033D-02,0.1080D-02,0.1138D-02,0.1206D-02,0.1282D-02,
     &0.1364D-02,0.1451D-02,0.1541D-02,0.1631D-02,0.1719D-02,0.1803D-02,
     &0.1878D-02,0.1939D-02,0.1980D-02,0.1991D-02,0.1957D-02,0.1849D-02,
     &0.1831D-02,0.1811D-02,0.1790D-02,0.1767D-02,0.1743D-02,0.1717D-02,
     &0.1688D-02,0.1658D-02,0.1625D-02,0.1590D-02,0.1553D-02,0.1512D-02,
     &0.1468D-02,0.1420D-02,0.1367D-02,0.1309D-02,0.1244D-02,0.1172D-02,
     &0.1087D-02,0.9940D-03,0.8584D-03,0.6289D-03/
      DATA (XPV(I,2,3),I=1,100)/
     &0.5990D-02,0.5932D-02,0.5873D-02,0.5812D-02,0.5755D-02,0.5698D-02,
     &0.5639D-02,0.5584D-02,0.5528D-02,0.5471D-02,0.5417D-02,0.5362D-02,
     &0.5305D-02,0.5253D-02,0.5198D-02,0.5142D-02,0.5090D-02,0.5035D-02,
     &0.4979D-02,0.4926D-02,0.4871D-02,0.4814D-02,0.4760D-02,0.4703D-02,
     &0.4645D-02,0.4588D-02,0.4530D-02,0.4468D-02,0.4409D-02,0.4347D-02,
     &0.4283D-02,0.4218D-02,0.4153D-02,0.4085D-02,0.4015D-02,0.3945D-02,
     &0.3872D-02,0.3797D-02,0.3721D-02,0.3644D-02,0.3565D-02,0.3483D-02,
     &0.3401D-02,0.3326D-02,0.3236D-02,0.3148D-02,0.3063D-02,0.2974D-02,
     &0.2882D-02,0.2790D-02,0.2696D-02,0.2602D-02,0.2506D-02,0.2410D-02,
     &0.2307D-02,0.2208D-02,0.2106D-02,0.2001D-02,0.1894D-02,0.1784D-02,
     &0.1669D-02,0.1551D-02,0.1430D-02,0.1303D-02,0.1172D-02,0.1039D-02,
     &0.9062D-03,0.7748D-03,0.6491D-03,0.5328D-03,0.4303D-03,0.3456D-03,
     &0.2823D-03,0.2428D-03,0.2282D-03,0.2383D-03,0.2730D-03,0.3327D-03,
     &0.3409D-03,0.3492D-03,0.3578D-03,0.3664D-03,0.3754D-03,0.3844D-03,
     &0.3936D-03,0.4028D-03,0.4122D-03,0.4214D-03,0.4309D-03,0.4400D-03,
     &0.4492D-03,0.4580D-03,0.4665D-03,0.4743D-03,0.4813D-03,0.4872D-03,
     &0.4894D-03,0.4958D-03,0.4830D-03,0.4112D-03/
      DATA (XPV(I,2,4),I=1,100)/
     &0.5746D-02,0.5678D-02,0.5610D-02,0.5539D-02,0.5472D-02,0.5404D-02,
     &0.5334D-02,0.5268D-02,0.5200D-02,0.5130D-02,0.5064D-02,0.4996D-02,
     &0.4925D-02,0.4858D-02,0.4789D-02,0.4718D-02,0.4650D-02,0.4579D-02,
     &0.4506D-02,0.4436D-02,0.4363D-02,0.4287D-02,0.4214D-02,0.4138D-02,
     &0.4060D-02,0.3982D-02,0.3902D-02,0.3819D-02,0.3737D-02,0.3653D-02,
     &0.3565D-02,0.3476D-02,0.3386D-02,0.3294D-02,0.3198D-02,0.3103D-02,
     &0.3005D-02,0.2905D-02,0.2803D-02,0.2701D-02,0.2597D-02,0.2491D-02,
     &0.2384D-02,0.2285D-02,0.2175D-02,0.2067D-02,0.1964D-02,0.1859D-02,
     &0.1754D-02,0.1653D-02,0.1555D-02,0.1459D-02,0.1368D-02,0.1282D-02,
     &0.1198D-02,0.1122D-02,0.1052D-02,0.9883D-03,0.9310D-03,0.8798D-03,
     &0.8347D-03,0.7955D-03,0.7619D-03,0.7321D-03,0.7064D-03,0.6839D-03,
     &0.6649D-03,0.6491D-03,0.6373D-03,0.6309D-03,0.6320D-03,0.6435D-03,
     &0.6699D-03,0.7168D-03,0.7928D-03,0.9097D-03,0.1084D-02,0.1336D-02,
     &0.1369D-02,0.1403D-02,0.1438D-02,0.1473D-02,0.1510D-02,0.1546D-02,
     &0.1583D-02,0.1621D-02,0.1658D-02,0.1696D-02,0.1734D-02,0.1771D-02,
     &0.1808D-02,0.1843D-02,0.1877D-02,0.1908D-02,0.1936D-02,0.1958D-02,
     &0.1969D-02,0.1988D-02,0.1933D-02,0.1674D-02/
      DATA (XPV(I,3,0),I=1,100)/
     &0.1386D+01,0.1342D+01,0.1299D+01,0.1256D+01,0.1215D+01,0.1174D+01,
     &0.1134D+01,0.1096D+01,0.1059D+01,0.1022D+01,0.9870D+00,0.9524D+00,
     &0.9181D+00,0.8858D+00,0.8538D+00,0.8222D+00,0.7924D+00,0.7628D+00,
     &0.7337D+00,0.7062D+00,0.6791D+00,0.6520D+00,0.6268D+00,0.6016D+00,
     &0.5770D+00,0.5536D+00,0.5305D+00,0.5077D+00,0.4861D+00,0.4649D+00,
     &0.4439D+00,0.4238D+00,0.4042D+00,0.3849D+00,0.3660D+00,0.3479D+00,
     &0.3300D+00,0.3124D+00,0.2953D+00,0.2787D+00,0.2625D+00,0.2464D+00,
     &0.2306D+00,0.2161D+00,0.2007D+00,0.1859D+00,0.1717D+00,0.1576D+00,
     &0.1437D+00,0.1303D+00,0.1173D+00,0.1047D+00,0.9264D-01,0.8116D-01,
     &0.7004D-01,0.5986D-01,0.5046D-01,0.4185D-01,0.3414D-01,0.2734D-01,
     &0.2148D-01,0.1659D-01,0.1262D-01,0.9443D-02,0.7030D-02,0.5248D-02,
     &0.3988D-02,0.3111D-02,0.2508D-02,0.2082D-02,0.1760D-02,0.1496D-02,
     &0.1262D-02,0.1046D-02,0.8417D-03,0.6478D-03,0.4647D-03,0.2925D-03,
     &0.2744D-03,0.2566D-03,0.2393D-03,0.2224D-03,0.2059D-03,0.1898D-03,
     &0.1740D-03,0.1587D-03,0.1439D-03,0.1295D-03,0.1155D-03,0.1020D-03,
     &0.8898D-04,0.7644D-04,0.6443D-04,0.5299D-04,0.4215D-04,0.3199D-04,
     &0.2259D-04,0.1402D-04,0.6692D-05,0.1051D-05/
      DATA (XPV(I,3,1),I=1,100)/
     &0.2133D-01,0.2081D-01,0.2030D-01,0.1978D-01,0.1929D-01,0.1880D-01,
     &0.1831D-01,0.1784D-01,0.1738D-01,0.1691D-01,0.1646D-01,0.1602D-01,
     &0.1557D-01,0.1515D-01,0.1472D-01,0.1430D-01,0.1389D-01,0.1348D-01,
     &0.1308D-01,0.1269D-01,0.1229D-01,0.1190D-01,0.1152D-01,0.1114D-01,
     &0.1076D-01,0.1040D-01,0.1003D-01,0.9657D-02,0.9299D-02,0.8941D-02,
     &0.8582D-02,0.8229D-02,0.7881D-02,0.7532D-02,0.7185D-02,0.6846D-02,
     &0.6509D-02,0.6172D-02,0.5842D-02,0.5519D-02,0.5201D-02,0.4886D-02,
     &0.4579D-02,0.4296D-02,0.4000D-02,0.3718D-02,0.3455D-02,0.3201D-02,
     &0.2956D-02,0.2729D-02,0.2520D-02,0.2329D-02,0.2158D-02,0.2010D-02,
     &0.1879D-02,0.1777D-02,0.1699D-02,0.1646D-02,0.1618D-02,0.1614D-02,
     &0.1634D-02,0.1676D-02,0.1738D-02,0.1817D-02,0.1911D-02,0.2016D-02,
     &0.2129D-02,0.2248D-02,0.2370D-02,0.2492D-02,0.2615D-02,0.2736D-02,
     &0.2859D-02,0.2984D-02,0.3117D-02,0.3264D-02,0.3430D-02,0.3609D-02,
     &0.3628D-02,0.3646D-02,0.3663D-02,0.3678D-02,0.3693D-02,0.3706D-02,
     &0.3716D-02,0.3725D-02,0.3731D-02,0.3733D-02,0.3732D-02,0.3726D-02,
     &0.3714D-02,0.3695D-02,0.3669D-02,0.3631D-02,0.3579D-02,0.3508D-02,
     &0.3406D-02,0.3304D-02,0.3023D-02,0.2344D-02/
      DATA (XPV(I,3,2),I=1,100)/
     &0.2133D-01,0.2081D-01,0.2030D-01,0.1978D-01,0.1929D-01,0.1880D-01,
     &0.1831D-01,0.1784D-01,0.1737D-01,0.1691D-01,0.1646D-01,0.1602D-01,
     &0.1557D-01,0.1515D-01,0.1472D-01,0.1430D-01,0.1389D-01,0.1348D-01,
     &0.1307D-01,0.1268D-01,0.1229D-01,0.1189D-01,0.1151D-01,0.1113D-01,
     &0.1075D-01,0.1038D-01,0.1001D-01,0.9643D-02,0.9283D-02,0.8924D-02,
     &0.8563D-02,0.8208D-02,0.7857D-02,0.7506D-02,0.7155D-02,0.6813D-02,
     &0.6473D-02,0.6132D-02,0.5797D-02,0.5469D-02,0.5146D-02,0.4825D-02,
     &0.4510D-02,0.4221D-02,0.3916D-02,0.3626D-02,0.3352D-02,0.3087D-02,
     &0.2830D-02,0.2590D-02,0.2366D-02,0.2159D-02,0.1971D-02,0.1803D-02,
     &0.1652D-02,0.1527D-02,0.1425D-02,0.1346D-02,0.1290D-02,0.1257D-02,
     &0.1245D-02,0.1254D-02,0.1281D-02,0.1324D-02,0.1379D-02,0.1445D-02,
     &0.1517D-02,0.1594D-02,0.1672D-02,0.1748D-02,0.1819D-02,0.1882D-02,
     &0.1933D-02,0.1969D-02,0.1983D-02,0.1969D-02,0.1915D-02,0.1799D-02,
     &0.1781D-02,0.1762D-02,0.1741D-02,0.1720D-02,0.1697D-02,0.1672D-02,
     &0.1646D-02,0.1618D-02,0.1588D-02,0.1556D-02,0.1522D-02,0.1486D-02,
     &0.1446D-02,0.1403D-02,0.1356D-02,0.1304D-02,0.1247D-02,0.1181D-02,
     &0.1105D-02,0.1025D-02,0.8897D-03,0.6390D-03/
      DATA (XPV(I,3,3),I=1,100)/
     &0.2170D-01,0.2120D-01,0.2069D-01,0.2019D-01,0.1972D-01,0.1924D-01,
     &0.1877D-01,0.1832D-01,0.1787D-01,0.1742D-01,0.1699D-01,0.1657D-01,
     &0.1614D-01,0.1573D-01,0.1533D-01,0.1492D-01,0.1454D-01,0.1415D-01,
     &0.1377D-01,0.1340D-01,0.1303D-01,0.1266D-01,0.1231D-01,0.1195D-01,
     &0.1160D-01,0.1126D-01,0.1092D-01,0.1057D-01,0.1024D-01,0.9910D-02,
     &0.9576D-02,0.9250D-02,0.8928D-02,0.8605D-02,0.8283D-02,0.7969D-02,
     &0.7655D-02,0.7340D-02,0.7030D-02,0.6725D-02,0.6424D-02,0.6122D-02,
     &0.5826D-02,0.5553D-02,0.5258D-02,0.4974D-02,0.4704D-02,0.4437D-02,
     &0.4170D-02,0.3915D-02,0.3668D-02,0.3430D-02,0.3202D-02,0.2984D-02,
     &0.2768D-02,0.2570D-02,0.2382D-02,0.2202D-02,0.2032D-02,0.1870D-02,
     &0.1715D-02,0.1568D-02,0.1427D-02,0.1289D-02,0.1156D-02,0.1027D-02,
     &0.9038D-03,0.7871D-03,0.6800D-03,0.5851D-03,0.5058D-03,0.4453D-03,
     &0.4065D-03,0.3917D-03,0.4024D-03,0.4400D-03,0.5058D-03,0.6008D-03,
     &0.6130D-03,0.6252D-03,0.6375D-03,0.6499D-03,0.6623D-03,0.6745D-03,
     &0.6867D-03,0.6987D-03,0.7104D-03,0.7216D-03,0.7325D-03,0.7425D-03,
     &0.7518D-03,0.7598D-03,0.7664D-03,0.7709D-03,0.7727D-03,0.7706D-03,
     &0.7622D-03,0.7542D-03,0.7051D-03,0.5640D-03/
      DATA (XPV(I,3,4),I=1,100)/
     &0.2144D-01,0.2093D-01,0.2041D-01,0.1990D-01,0.1942D-01,0.1893D-01,
     &0.1844D-01,0.1798D-01,0.1752D-01,0.1706D-01,0.1662D-01,0.1618D-01,
     &0.1574D-01,0.1532D-01,0.1490D-01,0.1448D-01,0.1408D-01,0.1367D-01,
     &0.1327D-01,0.1288D-01,0.1250D-01,0.1211D-01,0.1174D-01,0.1136D-01,
     &0.1099D-01,0.1063D-01,0.1026D-01,0.9898D-02,0.9545D-02,0.9192D-02,
     &0.8837D-02,0.8488D-02,0.8143D-02,0.7798D-02,0.7453D-02,0.7116D-02,
     &0.6779D-02,0.6443D-02,0.6112D-02,0.5786D-02,0.5465D-02,0.5145D-02,
     &0.4831D-02,0.4541D-02,0.4234D-02,0.3939D-02,0.3661D-02,0.3389D-02,
     &0.3122D-02,0.2871D-02,0.2632D-02,0.2409D-02,0.2200D-02,0.2009D-02,
     &0.1830D-02,0.1675D-02,0.1538D-02,0.1418D-02,0.1319D-02,0.1236D-02,
     &0.1171D-02,0.1122D-02,0.1087D-02,0.1064D-02,0.1051D-02,0.1047D-02,
     &0.1050D-02,0.1061D-02,0.1079D-02,0.1105D-02,0.1142D-02,0.1194D-02,
     &0.1267D-02,0.1372D-02,0.1520D-02,0.1729D-02,0.2019D-02,0.2410D-02,
     &0.2459D-02,0.2509D-02,0.2559D-02,0.2609D-02,0.2659D-02,0.2708D-02,
     &0.2757D-02,0.2805D-02,0.2853D-02,0.2898D-02,0.2942D-02,0.2982D-02,
     &0.3020D-02,0.3052D-02,0.3079D-02,0.3097D-02,0.3105D-02,0.3097D-02,
     &0.3063D-02,0.3033D-02,0.2839D-02,0.2269D-02/
      DATA (XPV(I,4,0),I=1,100)/
     &0.1713D+01,0.1653D+01,0.1593D+01,0.1534D+01,0.1478D+01,0.1423D+01,
     &0.1369D+01,0.1318D+01,0.1268D+01,0.1219D+01,0.1172D+01,0.1126D+01,
     &0.1081D+01,0.1038D+01,0.9964D+00,0.9552D+00,0.9163D+00,0.8781D+00,
     &0.8407D+00,0.8054D+00,0.7708D+00,0.7365D+00,0.7045D+00,0.6729D+00,
     &0.6421D+00,0.6129D+00,0.5844D+00,0.5563D+00,0.5298D+00,0.5040D+00,
     &0.4786D+00,0.4543D+00,0.4309D+00,0.4080D+00,0.3857D+00,0.3645D+00,
     &0.3437D+00,0.3235D+00,0.3039D+00,0.2850D+00,0.2668D+00,0.2489D+00,
     &0.2315D+00,0.2155D+00,0.1989D+00,0.1830D+00,0.1679D+00,0.1532D+00,
     &0.1388D+00,0.1250D+00,0.1118D+00,0.9925D-01,0.8729D-01,0.7605D-01,
     &0.6530D-01,0.5557D-01,0.4669D-01,0.3863D-01,0.3151D-01,0.2530D-01,
     &0.1999D-01,0.1560D-01,0.1206D-01,0.9245D-02,0.7105D-02,0.5513D-02,
     &0.4368D-02,0.3544D-02,0.2948D-02,0.2497D-02,0.2133D-02,0.1819D-02,
     &0.1533D-02,0.1267D-02,0.1016D-02,0.7782D-03,0.5551D-03,0.3467D-03,
     &0.3248D-03,0.3035D-03,0.2826D-03,0.2623D-03,0.2426D-03,0.2233D-03,
     &0.2044D-03,0.1862D-03,0.1685D-03,0.1514D-03,0.1348D-03,0.1188D-03,
     &0.1033D-03,0.8856D-04,0.7444D-04,0.6102D-04,0.4836D-04,0.3654D-04,
     &0.2566D-04,0.1580D-04,0.7467D-05,0.1177D-05/
      DATA (XPV(I,4,1),I=1,100)/
     &0.2961D-01,0.2879D-01,0.2797D-01,0.2716D-01,0.2638D-01,0.2562D-01,
     &0.2485D-01,0.2413D-01,0.2341D-01,0.2269D-01,0.2201D-01,0.2134D-01,
     &0.2066D-01,0.2003D-01,0.1939D-01,0.1875D-01,0.1815D-01,0.1755D-01,
     &0.1695D-01,0.1638D-01,0.1582D-01,0.1525D-01,0.1471D-01,0.1417D-01,
     &0.1363D-01,0.1311D-01,0.1260D-01,0.1209D-01,0.1159D-01,0.1110D-01,
     &0.1061D-01,0.1014D-01,0.9670D-02,0.9205D-02,0.8745D-02,0.8300D-02,
     &0.7859D-02,0.7423D-02,0.6997D-02,0.6583D-02,0.6178D-02,0.5780D-02,
     &0.5394D-02,0.5041D-02,0.4673D-02,0.4326D-02,0.4002D-02,0.3692D-02,
     &0.3395D-02,0.3121D-02,0.2869D-02,0.2641D-02,0.2438D-02,0.2262D-02,
     &0.2107D-02,0.1986D-02,0.1894D-02,0.1830D-02,0.1795D-02,0.1787D-02,
     &0.1806D-02,0.1849D-02,0.1914D-02,0.1997D-02,0.2095D-02,0.2205D-02,
     &0.2323D-02,0.2447D-02,0.2573D-02,0.2700D-02,0.2827D-02,0.2953D-02,
     &0.3082D-02,0.3216D-02,0.3362D-02,0.3530D-02,0.3726D-02,0.3944D-02,
     &0.3968D-02,0.3990D-02,0.4012D-02,0.4032D-02,0.4051D-02,0.4068D-02,
     &0.4083D-02,0.4095D-02,0.4104D-02,0.4109D-02,0.4110D-02,0.4106D-02,
     &0.4095D-02,0.4076D-02,0.4048D-02,0.4007D-02,0.3951D-02,0.3872D-02,
     &0.3759D-02,0.3643D-02,0.3325D-02,0.2555D-02/
      DATA (XPV(I,4,2),I=1,100)/
     &0.2961D-01,0.2879D-01,0.2797D-01,0.2715D-01,0.2638D-01,0.2561D-01,
     &0.2485D-01,0.2413D-01,0.2341D-01,0.2269D-01,0.2201D-01,0.2133D-01,
     &0.2066D-01,0.2002D-01,0.1938D-01,0.1875D-01,0.1815D-01,0.1754D-01,
     &0.1695D-01,0.1637D-01,0.1581D-01,0.1524D-01,0.1470D-01,0.1415D-01,
     &0.1362D-01,0.1310D-01,0.1258D-01,0.1207D-01,0.1157D-01,0.1108D-01,
     &0.1059D-01,0.1011D-01,0.9639D-02,0.9172D-02,0.8708D-02,0.8258D-02,
     &0.7813D-02,0.7372D-02,0.6940D-02,0.6520D-02,0.6109D-02,0.5703D-02,
     &0.5308D-02,0.4946D-02,0.4568D-02,0.4209D-02,0.3874D-02,0.3550D-02,
     &0.3237D-02,0.2948D-02,0.2678D-02,0.2430D-02,0.2205D-02,0.2006D-02,
     &0.1826D-02,0.1678D-02,0.1556D-02,0.1460D-02,0.1392D-02,0.1348D-02,
     &0.1329D-02,0.1332D-02,0.1354D-02,0.1393D-02,0.1446D-02,0.1508D-02,
     &0.1578D-02,0.1651D-02,0.1724D-02,0.1795D-02,0.1860D-02,0.1916D-02,
     &0.1960D-02,0.1988D-02,0.1995D-02,0.1975D-02,0.1918D-02,0.1805D-02,
     &0.1788D-02,0.1770D-02,0.1750D-02,0.1729D-02,0.1708D-02,0.1684D-02,
     &0.1660D-02,0.1633D-02,0.1605D-02,0.1575D-02,0.1543D-02,0.1508D-02,
     &0.1471D-02,0.1430D-02,0.1385D-02,0.1336D-02,0.1281D-02,0.1218D-02,
     &0.1144D-02,0.1067D-02,0.9312D-03,0.6726D-03/
      DATA (XPV(I,4,3),I=1,100)/
     &0.2998D-01,0.2918D-01,0.2837D-01,0.2758D-01,0.2682D-01,0.2607D-01,
     &0.2532D-01,0.2461D-01,0.2391D-01,0.2321D-01,0.2255D-01,0.2189D-01,
     &0.2124D-01,0.2062D-01,0.2000D-01,0.1939D-01,0.1881D-01,0.1823D-01,
     &0.1765D-01,0.1711D-01,0.1656D-01,0.1602D-01,0.1550D-01,0.1499D-01,
     &0.1447D-01,0.1398D-01,0.1350D-01,0.1301D-01,0.1254D-01,0.1208D-01,
     &0.1161D-01,0.1116D-01,0.1072D-01,0.1028D-01,0.9842D-02,0.9419D-02,
     &0.9000D-02,0.8583D-02,0.8174D-02,0.7776D-02,0.7384D-02,0.6996D-02,
     &0.6616D-02,0.6268D-02,0.5896D-02,0.5541D-02,0.5206D-02,0.4876D-02,
     &0.4551D-02,0.4242D-02,0.3945D-02,0.3662D-02,0.3393D-02,0.3138D-02,
     &0.2890D-02,0.2664D-02,0.2453D-02,0.2253D-02,0.2067D-02,0.1893D-02,
     &0.1730D-02,0.1576D-02,0.1432D-02,0.1293D-02,0.1161D-02,0.1035D-02,
     &0.9167D-03,0.8059D-03,0.7058D-03,0.6185D-03,0.5474D-03,0.4952D-03,
     &0.4650D-03,0.4588D-03,0.4786D-03,0.5261D-03,0.6032D-03,0.7103D-03,
     &0.7238D-03,0.7373D-03,0.7508D-03,0.7642D-03,0.7777D-03,0.7909D-03,
     &0.8039D-03,0.8165D-03,0.8288D-03,0.8404D-03,0.8514D-03,0.8613D-03,
     &0.8702D-03,0.8774D-03,0.8828D-03,0.8855D-03,0.8849D-03,0.8794D-03,
     &0.8664D-03,0.8526D-03,0.7906D-03,0.6244D-03/
      DATA (XPV(I,4,4),I=1,100)/
     &0.2972D-01,0.2890D-01,0.2809D-01,0.2728D-01,0.2651D-01,0.2575D-01,
     &0.2499D-01,0.2427D-01,0.2356D-01,0.2284D-01,0.2217D-01,0.2150D-01,
     &0.2083D-01,0.2019D-01,0.1956D-01,0.1893D-01,0.1834D-01,0.1774D-01,
     &0.1715D-01,0.1658D-01,0.1602D-01,0.1546D-01,0.1492D-01,0.1439D-01,
     &0.1386D-01,0.1335D-01,0.1284D-01,0.1233D-01,0.1184D-01,0.1135D-01,
     &0.1087D-01,0.1039D-01,0.9930D-02,0.9468D-02,0.9010D-02,0.8565D-02,
     &0.8125D-02,0.7688D-02,0.7260D-02,0.6843D-02,0.6433D-02,0.6029D-02,
     &0.5635D-02,0.5273D-02,0.4893D-02,0.4531D-02,0.4191D-02,0.3861D-02,
     &0.3540D-02,0.3240D-02,0.2958D-02,0.2695D-02,0.2452D-02,0.2232D-02,
     &0.2027D-02,0.1851D-02,0.1698D-02,0.1567D-02,0.1459D-02,0.1373D-02,
     &0.1307D-02,0.1259D-02,0.1229D-02,0.1211D-02,0.1206D-02,0.1212D-02,
     &0.1226D-02,0.1247D-02,0.1277D-02,0.1316D-02,0.1368D-02,0.1436D-02,
     &0.1529D-02,0.1656D-02,0.1832D-02,0.2076D-02,0.2410D-02,0.2849D-02,
     &0.2903D-02,0.2958D-02,0.3013D-02,0.3067D-02,0.3121D-02,0.3174D-02,
     &0.3227D-02,0.3278D-02,0.3327D-02,0.3374D-02,0.3419D-02,0.3459D-02,
     &0.3494D-02,0.3524D-02,0.3546D-02,0.3557D-02,0.3555D-02,0.3534D-02,
     &0.3481D-02,0.3429D-02,0.3184D-02,0.2507D-02/
      DATA (XPV(I,5,0),I=1,100)/
     &0.2770D+01,0.2649D+01,0.2529D+01,0.2413D+01,0.2304D+01,0.2198D+01,
     &0.2094D+01,0.1997D+01,0.1902D+01,0.1810D+01,0.1724D+01,0.1640D+01,
     &0.1558D+01,0.1481D+01,0.1407D+01,0.1334D+01,0.1266D+01,0.1201D+01,
     &0.1137D+01,0.1077D+01,0.1019D+01,0.9629D+00,0.9107D+00,0.8597D+00,
     &0.8105D+00,0.7646D+00,0.7201D+00,0.6769D+00,0.6367D+00,0.5980D+00,
     &0.5605D+00,0.5252D+00,0.4916D+00,0.4592D+00,0.4281D+00,0.3990D+00,
     &0.3711D+00,0.3442D+00,0.3187D+00,0.2947D+00,0.2718D+00,0.2498D+00,
     &0.2289D+00,0.2101D+00,0.1910D+00,0.1731D+00,0.1566D+00,0.1408D+00,
     &0.1257D+00,0.1117D+00,0.9867D-01,0.8653D-01,0.7529D-01,0.6501D-01,
     &0.5545D-01,0.4701D-01,0.3952D-01,0.3288D-01,0.2715D-01,0.2225D-01,
     &0.1814D-01,0.1478D-01,0.1208D-01,0.9909D-02,0.8219D-02,0.6899D-02,
     &0.5872D-02,0.5047D-02,0.4368D-02,0.3783D-02,0.3261D-02,0.2780D-02,
     &0.2333D-02,0.1914D-02,0.1522D-02,0.1155D-02,0.8143D-03,0.5006D-03,
     &0.4680D-03,0.4362D-03,0.4053D-03,0.3753D-03,0.3461D-03,0.3178D-03,
     &0.2901D-03,0.2634D-03,0.2377D-03,0.2128D-03,0.1888D-03,0.1657D-03,
     &0.1436D-03,0.1225D-03,0.1025D-03,0.8355D-04,0.6581D-04,0.4937D-04,
     &0.3437D-04,0.2094D-04,0.9768D-05,0.1553D-05/
      DATA (XPV(I,5,1),I=1,100)/
     &0.6050D-01,0.5833D-01,0.5619D-01,0.5409D-01,0.5210D-01,0.5014D-01,
     &0.4822D-01,0.4640D-01,0.4462D-01,0.4287D-01,0.4121D-01,0.3959D-01,
     &0.3799D-01,0.3648D-01,0.3500D-01,0.3354D-01,0.3216D-01,0.3080D-01,
     &0.2947D-01,0.2822D-01,0.2698D-01,0.2576D-01,0.2462D-01,0.2348D-01,
     &0.2237D-01,0.2132D-01,0.2029D-01,0.1927D-01,0.1830D-01,0.1736D-01,
     &0.1643D-01,0.1554D-01,0.1468D-01,0.1384D-01,0.1301D-01,0.1223D-01,
     &0.1147D-01,0.1072D-01,0.1001D-01,0.9326D-02,0.8669D-02,0.8032D-02,
     &0.7423D-02,0.6873D-02,0.6313D-02,0.5792D-02,0.5314D-02,0.4862D-02,
     &0.4437D-02,0.4053D-02,0.3705D-02,0.3395D-02,0.3124D-02,0.2892D-02,
     &0.2694D-02,0.2542D-02,0.2430D-02,0.2354D-02,0.2316D-02,0.2312D-02,
     &0.2341D-02,0.2397D-02,0.2478D-02,0.2579D-02,0.2696D-02,0.2825D-02,
     &0.2961D-02,0.3102D-02,0.3244D-02,0.3387D-02,0.3531D-02,0.3677D-02,
     &0.3831D-02,0.3999D-02,0.4196D-02,0.4435D-02,0.4730D-02,0.5071D-02,
     &0.5109D-02,0.5145D-02,0.5181D-02,0.5214D-02,0.5246D-02,0.5274D-02,
     &0.5300D-02,0.5322D-02,0.5340D-02,0.5352D-02,0.5358D-02,0.5357D-02,
     &0.5347D-02,0.5325D-02,0.5291D-02,0.5238D-02,0.5164D-02,0.5059D-02,
     &0.4907D-02,0.4746D-02,0.4309D-02,0.3281D-02/
      DATA (XPV(I,5,2),I=1,100)/
     &0.6050D-01,0.5833D-01,0.5619D-01,0.5408D-01,0.5209D-01,0.5014D-01,
     &0.4822D-01,0.4640D-01,0.4462D-01,0.4286D-01,0.4121D-01,0.3958D-01,
     &0.3798D-01,0.3647D-01,0.3499D-01,0.3353D-01,0.3215D-01,0.3079D-01,
     &0.2946D-01,0.2820D-01,0.2697D-01,0.2574D-01,0.2460D-01,0.2346D-01,
     &0.2235D-01,0.2129D-01,0.2026D-01,0.1924D-01,0.1827D-01,0.1732D-01,
     &0.1639D-01,0.1549D-01,0.1463D-01,0.1378D-01,0.1295D-01,0.1216D-01,
     &0.1139D-01,0.1063D-01,0.9910D-02,0.9216D-02,0.8547D-02,0.7898D-02,
     &0.7274D-02,0.6709D-02,0.6132D-02,0.5593D-02,0.5094D-02,0.4620D-02,
     &0.4170D-02,0.3759D-02,0.3382D-02,0.3040D-02,0.2734D-02,0.2465D-02,
     &0.2226D-02,0.2030D-02,0.1871D-02,0.1746D-02,0.1654D-02,0.1594D-02,
     &0.1562D-02,0.1555D-02,0.1571D-02,0.1603D-02,0.1649D-02,0.1705D-02,
     &0.1765D-02,0.1828D-02,0.1889D-02,0.1946D-02,0.1994D-02,0.2033D-02,
     &0.2060D-02,0.2071D-02,0.2065D-02,0.2038D-02,0.1987D-02,0.1896D-02,
     &0.1883D-02,0.1868D-02,0.1853D-02,0.1837D-02,0.1820D-02,0.1802D-02,
     &0.1783D-02,0.1762D-02,0.1739D-02,0.1715D-02,0.1689D-02,0.1661D-02,
     &0.1629D-02,0.1595D-02,0.1556D-02,0.1513D-02,0.1464D-02,0.1406D-02,
     &0.1336D-02,0.1263D-02,0.1120D-02,0.8288D-03/
      DATA (XPV(I,5,3),I=1,100)/
     &0.6090D-01,0.5875D-01,0.5662D-01,0.5453D-01,0.5256D-01,0.5062D-01,
     &0.4871D-01,0.4691D-01,0.4515D-01,0.4341D-01,0.4178D-01,0.4017D-01,
     &0.3859D-01,0.3710D-01,0.3564D-01,0.3420D-01,0.3284D-01,0.3151D-01,
     &0.3020D-01,0.2897D-01,0.2776D-01,0.2656D-01,0.2544D-01,0.2433D-01,
     &0.2324D-01,0.2221D-01,0.2120D-01,0.2021D-01,0.1926D-01,0.1834D-01,
     &0.1744D-01,0.1657D-01,0.1572D-01,0.1490D-01,0.1410D-01,0.1333D-01,
     &0.1258D-01,0.1185D-01,0.1114D-01,0.1046D-01,0.9808D-02,0.9169D-02,
     &0.8554D-02,0.7996D-02,0.7417D-02,0.6872D-02,0.6364D-02,0.5875D-02,
     &0.5402D-02,0.4961D-02,0.4545D-02,0.4157D-02,0.3795D-02,0.3461D-02,
     &0.3143D-02,0.2860D-02,0.2602D-02,0.2365D-02,0.2152D-02,0.1957D-02,
     &0.1780D-02,0.1620D-02,0.1474D-02,0.1339D-02,0.1214D-02,0.1100D-02,
     &0.9956D-03,0.9020D-03,0.8211D-03,0.7547D-03,0.7054D-03,0.6757D-03,
     &0.6684D-03,0.6859D-03,0.7308D-03,0.8062D-03,0.9148D-03,0.1055D-02,
     &0.1072D-02,0.1089D-02,0.1105D-02,0.1121D-02,0.1137D-02,0.1153D-02,
     &0.1167D-02,0.1182D-02,0.1195D-02,0.1207D-02,0.1217D-02,0.1226D-02,
     &0.1233D-02,0.1237D-02,0.1239D-02,0.1235D-02,0.1227D-02,0.1211D-02,
     &0.1184D-02,0.1153D-02,0.1055D-02,0.8147D-03/
      DATA (XPV(I,5,4),I=1,100)/
     &0.6062D-01,0.5845D-01,0.5631D-01,0.5421D-01,0.5223D-01,0.5028D-01,
     &0.4836D-01,0.4655D-01,0.4478D-01,0.4302D-01,0.4138D-01,0.3976D-01,
     &0.3816D-01,0.3666D-01,0.3518D-01,0.3372D-01,0.3235D-01,0.3100D-01,
     &0.2967D-01,0.2842D-01,0.2719D-01,0.2597D-01,0.2484D-01,0.2371D-01,
     &0.2260D-01,0.2155D-01,0.2052D-01,0.1951D-01,0.1855D-01,0.1761D-01,
     &0.1668D-01,0.1579D-01,0.1493D-01,0.1409D-01,0.1327D-01,0.1248D-01,
     &0.1172D-01,0.1097D-01,0.1025D-01,0.9561D-02,0.8895D-02,0.8249D-02,
     &0.7629D-02,0.7067D-02,0.6490D-02,0.5951D-02,0.5451D-02,0.4976D-02,
     &0.4523D-02,0.4107D-02,0.3724D-02,0.3375D-02,0.3059D-02,0.2780D-02,
     &0.2527D-02,0.2317D-02,0.2141D-02,0.1997D-02,0.1886D-02,0.1803D-02,
     &0.1748D-02,0.1717D-02,0.1709D-02,0.1717D-02,0.1741D-02,0.1778D-02,
     &0.1825D-02,0.1883D-02,0.1951D-02,0.2031D-02,0.2127D-02,0.2246D-02,
     &0.2396D-02,0.2592D-02,0.2852D-02,0.3200D-02,0.3657D-02,0.4230D-02,
     &0.4298D-02,0.4365D-02,0.4432D-02,0.4498D-02,0.4563D-02,0.4625D-02,
     &0.4685D-02,0.4741D-02,0.4795D-02,0.4843D-02,0.4887D-02,0.4923D-02,
     &0.4951D-02,0.4968D-02,0.4973D-02,0.4961D-02,0.4927D-02,0.4864D-02,
     &0.4754D-02,0.4636D-02,0.4245D-02,0.3267D-02/
      DATA (XPV(I,6,0),I=1,100)/
     &0.3742D+01,0.3556D+01,0.3375D+01,0.3200D+01,0.3037D+01,0.2878D+01,
     &0.2725D+01,0.2582D+01,0.2444D+01,0.2310D+01,0.2185D+01,0.2065D+01,
     &0.1949D+01,0.1840D+01,0.1736D+01,0.1635D+01,0.1541D+01,0.1451D+01,
     &0.1364D+01,0.1283D+01,0.1205D+01,0.1130D+01,0.1061D+01,0.9934D+00,
     &0.9293D+00,0.8698D+00,0.8128D+00,0.7578D+00,0.7071D+00,0.6586D+00,
     &0.6121D+00,0.5687D+00,0.5278D+00,0.4887D+00,0.4517D+00,0.4173D+00,
     &0.3846D+00,0.3535D+00,0.3244D+00,0.2973D+00,0.2717D+00,0.2475D+00,
     &0.2247D+00,0.2045D+00,0.1843D+00,0.1656D+00,0.1486D+00,0.1327D+00,
     &0.1176D+00,0.1039D+00,0.9130D-01,0.7978D-01,0.6928D-01,0.5984D-01,
     &0.5118D-01,0.4366D-01,0.3707D-01,0.3131D-01,0.2638D-01,0.2219D-01,
     &0.1867D-01,0.1577D-01,0.1341D-01,0.1147D-01,0.9882D-02,0.8574D-02,
     &0.7485D-02,0.6547D-02,0.5722D-02,0.4975D-02,0.4289D-02,0.3649D-02,
     &0.3052D-02,0.2495D-02,0.1975D-02,0.1492D-02,0.1045D-02,0.6378D-03,
     &0.5956D-03,0.5547D-03,0.5148D-03,0.4761D-03,0.4386D-03,0.4023D-03,
     &0.3667D-03,0.3326D-03,0.2997D-03,0.2679D-03,0.2373D-03,0.2080D-03,
     &0.1800D-03,0.1533D-03,0.1280D-03,0.1041D-03,0.8181D-04,0.6122D-04,
     &0.4250D-04,0.2581D-04,0.1200D-04,0.1914D-05/
      DATA (XPV(I,6,1),I=1,100)/
     &0.9375D-01,0.8988D-01,0.8607D-01,0.8236D-01,0.7887D-01,0.7546D-01,
     &0.7213D-01,0.6901D-01,0.6596D-01,0.6297D-01,0.6018D-01,0.5745D-01,
     &0.5478D-01,0.5228D-01,0.4984D-01,0.4745D-01,0.4522D-01,0.4304D-01,
     &0.4091D-01,0.3892D-01,0.3697D-01,0.3506D-01,0.3329D-01,0.3155D-01,
     &0.2986D-01,0.2827D-01,0.2672D-01,0.2520D-01,0.2378D-01,0.2241D-01,
     &0.2106D-01,0.1979D-01,0.1857D-01,0.1738D-01,0.1624D-01,0.1516D-01,
     &0.1412D-01,0.1312D-01,0.1217D-01,0.1127D-01,0.1041D-01,0.9586D-02,
     &0.8807D-02,0.8113D-02,0.7414D-02,0.6771D-02,0.6188D-02,0.5645D-02,
     &0.5140D-02,0.4689D-02,0.4287D-02,0.3934D-02,0.3630D-02,0.3376D-02,
     &0.3163D-02,0.3005D-02,0.2894D-02,0.2825D-02,0.2798D-02,0.2809D-02,
     &0.2854D-02,0.2930D-02,0.3031D-02,0.3152D-02,0.3289D-02,0.3437D-02,
     &0.3593D-02,0.3752D-02,0.3913D-02,0.4075D-02,0.4238D-02,0.4408D-02,
     &0.4592D-02,0.4800D-02,0.5051D-02,0.5364D-02,0.5755D-02,0.6211D-02,
     &0.6262D-02,0.6311D-02,0.6359D-02,0.6403D-02,0.6446D-02,0.6484D-02,
     &0.6519D-02,0.6549D-02,0.6574D-02,0.6591D-02,0.6601D-02,0.6601D-02,
     &0.6590D-02,0.6564D-02,0.6521D-02,0.6456D-02,0.6363D-02,0.6231D-02,
     &0.6041D-02,0.5835D-02,0.5289D-02,0.4021D-02/
      DATA (XPV(I,6,2),I=1,100)/
     &0.9375D-01,0.8987D-01,0.8607D-01,0.8236D-01,0.7887D-01,0.7545D-01,
     &0.7213D-01,0.6900D-01,0.6595D-01,0.6296D-01,0.6017D-01,0.5744D-01,
     &0.5477D-01,0.5227D-01,0.4983D-01,0.4744D-01,0.4520D-01,0.4302D-01,
     &0.4089D-01,0.3889D-01,0.3695D-01,0.3504D-01,0.3326D-01,0.3151D-01,
     &0.2982D-01,0.2823D-01,0.2667D-01,0.2515D-01,0.2373D-01,0.2235D-01,
     &0.2100D-01,0.1972D-01,0.1849D-01,0.1729D-01,0.1614D-01,0.1505D-01,
     &0.1400D-01,0.1299D-01,0.1202D-01,0.1110D-01,0.1023D-01,0.9390D-02,
     &0.8591D-02,0.7874D-02,0.7152D-02,0.6483D-02,0.5870D-02,0.5295D-02,
     &0.4756D-02,0.4268D-02,0.3824D-02,0.3427D-02,0.3075D-02,0.2770D-02,
     &0.2501D-02,0.2282D-02,0.2106D-02,0.1968D-02,0.1869D-02,0.1802D-02,
     &0.1766D-02,0.1756D-02,0.1768D-02,0.1797D-02,0.1838D-02,0.1888D-02,
     &0.1942D-02,0.1997D-02,0.2048D-02,0.2094D-02,0.2132D-02,0.2160D-02,
     &0.2176D-02,0.2180D-02,0.2171D-02,0.2150D-02,0.2114D-02,0.2055D-02,
     &0.2046D-02,0.2037D-02,0.2026D-02,0.2015D-02,0.2003D-02,0.1990D-02,
     &0.1976D-02,0.1960D-02,0.1943D-02,0.1924D-02,0.1903D-02,0.1879D-02,
     &0.1852D-02,0.1822D-02,0.1788D-02,0.1748D-02,0.1701D-02,0.1644D-02,
     &0.1574D-02,0.1500D-02,0.1342D-02,0.1006D-02/
      DATA (XPV(I,6,3),I=1,100)/
     &0.9417D-01,0.9031D-01,0.8652D-01,0.8282D-01,0.7935D-01,0.7595D-01,
     &0.7264D-01,0.6954D-01,0.6651D-01,0.6354D-01,0.6076D-01,0.5805D-01,
     &0.5540D-01,0.5292D-01,0.5050D-01,0.4814D-01,0.4593D-01,0.4376D-01,
     &0.4166D-01,0.3968D-01,0.3777D-01,0.3588D-01,0.3413D-01,0.3240D-01,
     &0.3074D-01,0.2917D-01,0.2764D-01,0.2614D-01,0.2474D-01,0.2339D-01,
     &0.2206D-01,0.2080D-01,0.1960D-01,0.1843D-01,0.1730D-01,0.1623D-01,
     &0.1520D-01,0.1420D-01,0.1324D-01,0.1234D-01,0.1147D-01,0.1064D-01,
     &0.9841D-02,0.9125D-02,0.8394D-02,0.7713D-02,0.7085D-02,0.6486D-02,
     &0.5916D-02,0.5390D-02,0.4900D-02,0.4449D-02,0.4033D-02,0.3655D-02,
     &0.3301D-02,0.2989D-02,0.2709D-02,0.2456D-02,0.2232D-02,0.2031D-02,
     &0.1851D-02,0.1692D-02,0.1550D-02,0.1421D-02,0.1305D-02,0.1201D-02,
     &0.1109D-02,0.1030D-02,0.9637D-03,0.9133D-03,0.8806D-03,0.8682D-03,
     &0.8786D-03,0.9148D-03,0.9803D-03,0.1079D-02,0.1214D-02,0.1381D-02,
     &0.1401D-02,0.1420D-02,0.1439D-02,0.1457D-02,0.1475D-02,0.1492D-02,
     &0.1508D-02,0.1523D-02,0.1537D-02,0.1549D-02,0.1559D-02,0.1567D-02,
     &0.1572D-02,0.1573D-02,0.1570D-02,0.1562D-02,0.1546D-02,0.1521D-02,
     &0.1481D-02,0.1437D-02,0.1308D-02,0.1001D-02/
      DATA (XPV(I,6,4),I=1,100)/
     &0.9387D-01,0.9000D-01,0.8620D-01,0.8249D-01,0.7901D-01,0.7560D-01,
     &0.7228D-01,0.6916D-01,0.6611D-01,0.6313D-01,0.6034D-01,0.5762D-01,
     &0.5495D-01,0.5246D-01,0.5002D-01,0.4764D-01,0.4541D-01,0.4324D-01,
     &0.4112D-01,0.3912D-01,0.3719D-01,0.3528D-01,0.3351D-01,0.3177D-01,
     &0.3009D-01,0.2850D-01,0.2695D-01,0.2544D-01,0.2402D-01,0.2265D-01,
     &0.2131D-01,0.2003D-01,0.1881D-01,0.1763D-01,0.1648D-01,0.1540D-01,
     &0.1436D-01,0.1335D-01,0.1239D-01,0.1148D-01,0.1061D-01,0.9775D-02,
     &0.8982D-02,0.8272D-02,0.7555D-02,0.6890D-02,0.6283D-02,0.5712D-02,
     &0.5175D-02,0.4690D-02,0.4249D-02,0.3854D-02,0.3504D-02,0.3199D-02,
     &0.2930D-02,0.2712D-02,0.2536D-02,0.2398D-02,0.2298D-02,0.2232D-02,
     &0.2197D-02,0.2189D-02,0.2207D-02,0.2243D-02,0.2296D-02,0.2364D-02,
     &0.2444D-02,0.2535D-02,0.2639D-02,0.2757D-02,0.2893D-02,0.3057D-02,
     &0.3260D-02,0.3518D-02,0.3853D-02,0.4291D-02,0.4854D-02,0.5537D-02,
     &0.5617D-02,0.5695D-02,0.5771D-02,0.5846D-02,0.5918D-02,0.5987D-02,
     &0.6052D-02,0.6113D-02,0.6168D-02,0.6217D-02,0.6258D-02,0.6289D-02,
     &0.6309D-02,0.6315D-02,0.6304D-02,0.6270D-02,0.6208D-02,0.6107D-02,
     &0.5948D-02,0.5772D-02,0.5256D-02,0.4016D-02/
      DATA (XPV(I,7,0),I=1,100)/
     &0.4620D+01,0.4371D+01,0.4130D+01,0.3898D+01,0.3682D+01,0.3473D+01,
     &0.3273D+01,0.3087D+01,0.2908D+01,0.2735D+01,0.2576D+01,0.2422D+01,
     &0.2274D+01,0.2137D+01,0.2006D+01,0.1879D+01,0.1763D+01,0.1651D+01,
     &0.1544D+01,0.1444D+01,0.1350D+01,0.1258D+01,0.1175D+01,0.1095D+01,
     &0.1018D+01,0.9480D+00,0.8808D+00,0.8166D+00,0.7576D+00,0.7016D+00,
     &0.6483D+00,0.5987D+00,0.5524D+00,0.5085D+00,0.4671D+00,0.4289D+00,
     &0.3930D+00,0.3591D+00,0.3276D+00,0.2984D+00,0.2712D+00,0.2456D+00,
     &0.2218D+00,0.2008D+00,0.1801D+00,0.1612D+00,0.1440D+00,0.1281D+00,
     &0.1133D+00,0.9995D-01,0.8778D-01,0.7678D-01,0.6687D-01,0.5803D-01,
     &0.5000D-01,0.4309D-01,0.3706D-01,0.3181D-01,0.2732D-01,0.2349D-01,
     &0.2025D-01,0.1754D-01,0.1529D-01,0.1336D-01,0.1174D-01,0.1033D-01,
     &0.9116D-02,0.8022D-02,0.7032D-02,0.6118D-02,0.5270D-02,0.4476D-02,
     &0.3736D-02,0.3047D-02,0.2407D-02,0.1812D-02,0.1266D-02,0.7693D-03,
     &0.7181D-03,0.6683D-03,0.6199D-03,0.5730D-03,0.5276D-03,0.4835D-03,
     &0.4405D-03,0.3993D-03,0.3595D-03,0.3212D-03,0.2843D-03,0.2490D-03,
     &0.2153D-03,0.1832D-03,0.1528D-03,0.1242D-03,0.9750D-04,0.7288D-04,
     &0.5054D-04,0.3065D-04,0.1424D-04,0.2274D-05/
      DATA (XPV(I,7,1),I=1,100)/
     &0.1273D+00,0.1215D+00,0.1159D+00,0.1104D+00,0.1052D+00,0.1002D+00,
     &0.9538D-01,0.9084D-01,0.8644D-01,0.8214D-01,0.7814D-01,0.7426D-01,
     &0.7047D-01,0.6695D-01,0.6352D-01,0.6020D-01,0.5710D-01,0.5408D-01,
     &0.5116D-01,0.4843D-01,0.4580D-01,0.4321D-01,0.4083D-01,0.3850D-01,
     &0.3626D-01,0.3416D-01,0.3213D-01,0.3016D-01,0.2832D-01,0.2655D-01,
     &0.2484D-01,0.2322D-01,0.2168D-01,0.2020D-01,0.1878D-01,0.1745D-01,
     &0.1618D-01,0.1496D-01,0.1381D-01,0.1273D-01,0.1172D-01,0.1075D-01,
     &0.9841D-02,0.9037D-02,0.8237D-02,0.7506D-02,0.6849D-02,0.6244D-02,
     &0.5686D-02,0.5195D-02,0.4761D-02,0.4386D-02,0.4068D-02,0.3807D-02,
     &0.3592D-02,0.3439D-02,0.3337D-02,0.3281D-02,0.3270D-02,0.3299D-02,
     &0.3364D-02,0.3460D-02,0.3582D-02,0.3724D-02,0.3881D-02,0.4050D-02,
     &0.4225D-02,0.4404D-02,0.4584D-02,0.4766D-02,0.4952D-02,0.5148D-02,
     &0.5364D-02,0.5615D-02,0.5922D-02,0.6309D-02,0.6796D-02,0.7362D-02,
     &0.7425D-02,0.7486D-02,0.7545D-02,0.7600D-02,0.7653D-02,0.7701D-02,
     &0.7744D-02,0.7781D-02,0.7812D-02,0.7833D-02,0.7846D-02,0.7846D-02,
     &0.7833D-02,0.7803D-02,0.7751D-02,0.7673D-02,0.7561D-02,0.7402D-02,
     &0.7174D-02,0.6925D-02,0.6273D-02,0.4767D-02/
      DATA (XPV(I,7,2),I=1,100)/
     &0.1273D+00,0.1215D+00,0.1158D+00,0.1104D+00,0.1052D+00,0.1002D+00,
     &0.9537D-01,0.9083D-01,0.8643D-01,0.8213D-01,0.7813D-01,0.7424D-01,
     &0.7046D-01,0.6693D-01,0.6351D-01,0.6018D-01,0.5707D-01,0.5406D-01,
     &0.5113D-01,0.4840D-01,0.4576D-01,0.4318D-01,0.4079D-01,0.3846D-01,
     &0.3621D-01,0.3411D-01,0.3207D-01,0.3009D-01,0.2825D-01,0.2647D-01,
     &0.2475D-01,0.2312D-01,0.2157D-01,0.2008D-01,0.1865D-01,0.1730D-01,
     &0.1602D-01,0.1478D-01,0.1362D-01,0.1252D-01,0.1148D-01,0.1049D-01,
     &0.9553D-02,0.8720D-02,0.7889D-02,0.7124D-02,0.6429D-02,0.5782D-02,
     &0.5181D-02,0.4640D-02,0.4154D-02,0.3722D-02,0.3342D-02,0.3014D-02,
     &0.2728D-02,0.2498D-02,0.2314D-02,0.2171D-02,0.2067D-02,0.1998D-02,
     &0.1960D-02,0.1948D-02,0.1958D-02,0.1984D-02,0.2021D-02,0.2066D-02,
     &0.2114D-02,0.2162D-02,0.2206D-02,0.2245D-02,0.2275D-02,0.2296D-02,
     &0.2307D-02,0.2309D-02,0.2304D-02,0.2293D-02,0.2279D-02,0.2254D-02,
     &0.2250D-02,0.2244D-02,0.2239D-02,0.2232D-02,0.2225D-02,0.2216D-02,
     &0.2207D-02,0.2195D-02,0.2183D-02,0.2168D-02,0.2151D-02,0.2131D-02,
     &0.2108D-02,0.2081D-02,0.2049D-02,0.2010D-02,0.1964D-02,0.1906D-02,
     &0.1832D-02,0.1753D-02,0.1576D-02,0.1190D-02/
      DATA (XPV(I,7,3),I=1,100)/
     &0.1277D+00,0.1220D+00,0.1163D+00,0.1108D+00,0.1057D+00,0.1007D+00,
     &0.9591D-01,0.9139D-01,0.8700D-01,0.8272D-01,0.7874D-01,0.7488D-01,
     &0.7111D-01,0.6761D-01,0.6420D-01,0.6090D-01,0.5781D-01,0.5482D-01,
     &0.5192D-01,0.4921D-01,0.4660D-01,0.4403D-01,0.4167D-01,0.3937D-01,
     &0.3714D-01,0.3506D-01,0.3305D-01,0.3110D-01,0.2928D-01,0.2752D-01,
     &0.2582D-01,0.2422D-01,0.2269D-01,0.2122D-01,0.1980D-01,0.1848D-01,
     &0.1721D-01,0.1598D-01,0.1483D-01,0.1374D-01,0.1270D-01,0.1171D-01,
     &0.1077D-01,0.9936D-02,0.9091D-02,0.8309D-02,0.7592D-02,0.6916D-02,
     &0.6277D-02,0.5693D-02,0.5155D-02,0.4662D-02,0.4213D-02,0.3808D-02,
     &0.3432D-02,0.3104D-02,0.2813D-02,0.2553D-02,0.2325D-02,0.2122D-02,
     &0.1944D-02,0.1788D-02,0.1651D-02,0.1528D-02,0.1420D-02,0.1325D-02,
     &0.1243D-02,0.1175D-02,0.1122D-02,0.1084D-02,0.1065D-02,0.1067D-02,
     &0.1092D-02,0.1144D-02,0.1228D-02,0.1347D-02,0.1506D-02,0.1698D-02,
     &0.1720D-02,0.1741D-02,0.1763D-02,0.1783D-02,0.1803D-02,0.1821D-02,
     &0.1838D-02,0.1854D-02,0.1868D-02,0.1880D-02,0.1890D-02,0.1897D-02,
     &0.1900D-02,0.1898D-02,0.1892D-02,0.1878D-02,0.1856D-02,0.1823D-02,
     &0.1771D-02,0.1715D-02,0.1557D-02,0.1187D-02/
      DATA (XPV(I,7,4),I=1,100)/
     &0.1274D+00,0.1216D+00,0.1160D+00,0.1105D+00,0.1054D+00,0.1004D+00,
     &0.9553D-01,0.9099D-01,0.8660D-01,0.8231D-01,0.7831D-01,0.7443D-01,
     &0.7065D-01,0.6713D-01,0.6371D-01,0.6039D-01,0.5729D-01,0.5428D-01,
     &0.5137D-01,0.4864D-01,0.4601D-01,0.4343D-01,0.4105D-01,0.3873D-01,
     &0.3649D-01,0.3439D-01,0.3236D-01,0.3039D-01,0.2856D-01,0.2679D-01,
     &0.2507D-01,0.2345D-01,0.2191D-01,0.2043D-01,0.1901D-01,0.1767D-01,
     &0.1640D-01,0.1517D-01,0.1401D-01,0.1293D-01,0.1190D-01,0.1091D-01,
     &0.9989D-02,0.9167D-02,0.8345D-02,0.7590D-02,0.6907D-02,0.6271D-02,
     &0.5680D-02,0.5152D-02,0.4677D-02,0.4258D-02,0.3891D-02,0.3578D-02,
     &0.3306D-02,0.3092D-02,0.2925D-02,0.2801D-02,0.2718D-02,0.2672D-02,
     &0.2660D-02,0.2677D-02,0.2720D-02,0.2784D-02,0.2866D-02,0.2964D-02,
     &0.3075D-02,0.3198D-02,0.3335D-02,0.3488D-02,0.3663D-02,0.3870D-02,
     &0.4121D-02,0.4436D-02,0.4840D-02,0.5361D-02,0.6022D-02,0.6806D-02,
     &0.6896D-02,0.6983D-02,0.7069D-02,0.7151D-02,0.7230D-02,0.7305D-02,
     &0.7376D-02,0.7439D-02,0.7497D-02,0.7546D-02,0.7585D-02,0.7612D-02,
     &0.7625D-02,0.7620D-02,0.7595D-02,0.7541D-02,0.7454D-02,0.7319D-02,
     &0.7113D-02,0.6886D-02,0.6254D-02,0.4765D-02/

C..fetching pdfs
      DO  5 IP=-6,6
        XPDF(IP)=ZEROD
 5    CONTINUE
      DO 2 I=1,IX
        ENT(I)=LOG10(XT(I))
  2   CONTINUE
      NA(1)=IX
      NA(2)=IQ
      DO 3 I=1,IQ
        ENT(IX+I)=LOG10(Q2T(I))
   3  CONTINUE
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(Q2)
C..VARIOUS FLAVOURS (u-->2,d-->1)
      XPDF(0)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,0))
      XPDF(1)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,2))
      XPDF(2)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,1))
      XPDF(3)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,3))
      XPDF(4)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,4))
      DO 21 JF=1,4
        XPDF(-JF)=XPDF(JF)
 21   CONTINUE
      RETURN
      END
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
C--------------------------------------------------------------
      SUBROUTINE PHLAC3(X,Q2,XPDF)
      implicit real*8 (a-h,o-z)
      PARAMETER(IX=100,IQ=7,NARG=2,NFUN=4)
      double precision
     +       DBFINT,
     +       XT(IX),Q2T(IQ),ARG(NARG),ENT(IX+IQ),
     +       XPV(IX,IQ,0:NFUN),XPDF(-6:6)
      DIMENSION NA(NARG)
      DATA ZEROD/0.D0/
C...100 x valuse; in (D-4,.77) log spaced (78 points)
C...              in (.78,.995) lineary spaced (22 points)
      DATA Q2T/1.,10.,50.,1.D2,1.D3,1.D4,1.D5/
      DATA XT/
     &0.1000D-03,0.1123D-03,0.1262D-03,0.1417D-03,0.1592D-03,0.1789D-03,
     &0.2009D-03,0.2257D-03,0.2535D-03,0.2848D-03,0.3199D-03,0.3593D-03,
     &0.4037D-03,0.4534D-03,0.5093D-03,0.5722D-03,0.6427D-03,0.7220D-03,
     &0.8110D-03,0.9110D-03,0.1023D-02,0.1150D-02,0.1291D-02,0.1451D-02,
     &0.1629D-02,0.1830D-02,0.2056D-02,0.2310D-02,0.2594D-02,0.2914D-02,
     &0.3274D-02,0.3677D-02,0.4131D-02,0.4640D-02,0.5212D-02,0.5855D-02,
     &0.6577D-02,0.7388D-02,0.8299D-02,0.9323D-02,0.1047D-01,0.1176D-01,
     &0.1321D-01,0.1484D-01,0.1667D-01,0.1873D-01,0.2104D-01,0.2363D-01,
     &0.2655D-01,0.2982D-01,0.3350D-01,0.3763D-01,0.4227D-01,0.4748D-01,
     &0.5334D-01,0.5992D-01,0.6731D-01,0.7560D-01,0.8493D-01,0.9540D-01,
     &0.1072D+00,0.1204D+00,0.1352D+00,0.1519D+00,0.1706D+00,0.1917D+00,
     &0.2153D+00,0.2419D+00,0.2717D+00,0.3052D+00,0.3428D+00,0.3851D+00,
     &0.4326D+00,0.4859D+00,0.5458D+00,0.6131D+00,0.6887D+00,0.7737D+00,
     &0.7837D+00,0.7937D+00,0.8037D+00,0.8137D+00,0.8237D+00,0.8337D+00,
     &0.8437D+00,0.8537D+00,0.8637D+00,0.8737D+00,0.8837D+00,0.8937D+00,
     &0.9037D+00,0.9137D+00,0.9237D+00,0.9337D+00,0.9437D+00,0.9537D+00,
     &0.9637D+00,0.9737D+00,0.9837D+00,0.9937D+00/

C...place for DATA blocks
      DATA (XPV(I,1,0),I=1,100)/
     &0.1007D-27,0.2075D-27,0.4426D-27,0.1128D-26,0.2333D-26,0.4999D-26,
     &0.1271D-25,0.2627D-25,0.5632D-25,0.1431D-24,0.2954D-24,0.6358D-24,
     &0.1610D-23,0.3324D-23,0.7182D-23,0.1813D-22,0.3751D-22,0.8117D-22,
     &0.2043D-21,0.4240D-21,0.9144D-21,0.2316D-20,0.4799D-20,0.1038D-19,
     &0.2610D-19,0.5465D-19,0.1173D-18,0.2878D-18,0.6255D-18,0.1334D-17,
     &0.3132D-17,0.7205D-17,0.1536D-16,0.3447D-16,0.8339D-16,0.1787D-15,
     &0.3904D-15,0.9044D-15,0.2099D-14,0.4566D-14,0.1007D-13,0.2303D-13,
     &0.5384D-13,0.1169D-12,0.2617D-12,0.5847D-12,0.1299D-11,0.2924D-11,
     &0.6607D-11,0.1484D-10,0.3329D-10,0.7451D-10,0.1668D-09,0.3728D-09,
     &0.8458D-09,0.1887D-08,0.4199D-08,0.9410D-08,0.2093D-07,0.4670D-07,
     &0.1044D-06,0.2319D-06,0.5128D-06,0.1139D-05,0.2523D-05,0.5592D-05,
     &0.1232D-04,0.2713D-04,0.5944D-04,0.1298D-03,0.2819D-03,0.6094D-03,
     &0.1307D-02,0.2770D-02,0.5792D-02,0.1188D-01,0.2357D-01,0.4425D-01,
     &0.4717D-01,0.5016D-01,0.5322D-01,0.5631D-01,0.5943D-01,0.6254D-01,
     &0.6564D-01,0.6864D-01,0.7153D-01,0.7424D-01,0.7672D-01,0.7888D-01,
     &0.8063D-01,0.8185D-01,0.8240D-01,0.8208D-01,0.8066D-01,0.7779D-01,
     &0.7302D-01,0.6561D-01,0.5572D-01,0.3029D-01/
      DATA (XPV(I,1,1),I=1,100)/
     &0.3424D-05,0.3802D-05,0.4225D-05,0.4691D-05,0.5211D-05,0.5789D-05,
     &0.6428D-05,0.7141D-05,0.7930D-05,0.8809D-05,0.9783D-05,0.1086D-04,
     &0.1207D-04,0.1340D-04,0.1488D-04,0.1653D-04,0.1836D-04,0.2039D-04,
     &0.2264D-04,0.2513D-04,0.2790D-04,0.3099D-04,0.3439D-04,0.3819D-04,
     &0.4236D-04,0.4701D-04,0.5217D-04,0.5789D-04,0.6419D-04,0.7118D-04,
     &0.7893D-04,0.8747D-04,0.9693D-04,0.1073D-03,0.1188D-03,0.1315D-03,
     &0.1455D-03,0.1608D-03,0.1777D-03,0.1962D-03,0.2163D-03,0.2384D-03,
     &0.2625D-03,0.2888D-03,0.3171D-03,0.3478D-03,0.3809D-03,0.4162D-03,
     &0.4540D-03,0.4939D-03,0.5361D-03,0.5801D-03,0.6258D-03,0.6727D-03,
     &0.7196D-03,0.7668D-03,0.8129D-03,0.8568D-03,0.8974D-03,0.9335D-03,
     &0.9636D-03,0.9862D-03,0.1001D-02,0.1005D-02,0.9999D-03,0.9845D-03,
     &0.9605D-03,0.9293D-03,0.8945D-03,0.8601D-03,0.8315D-03,0.8149D-03,
     &0.8173D-03,0.8465D-03,0.9115D-03,0.1023D-02,0.1196D-02,0.1446D-02,
     &0.1479D-02,0.1512D-02,0.1545D-02,0.1579D-02,0.1613D-02,0.1648D-02,
     &0.1682D-02,0.1716D-02,0.1750D-02,0.1784D-02,0.1816D-02,0.1848D-02,
     &0.1878D-02,0.1905D-02,0.1930D-02,0.1951D-02,0.1967D-02,0.1975D-02,
     &0.1973D-02,0.1954D-02,0.2080D-02,0.1381D-02/
      DATA (XPV(I,1,2),I=1,100)/
     &0.3137D-05,0.3480D-05,0.3862D-05,0.4284D-05,0.4753D-05,0.5276D-05,
     &0.5851D-05,0.6493D-05,0.7202D-05,0.7991D-05,0.8865D-05,0.9833D-05,
     &0.1091D-04,0.1210D-04,0.1342D-04,0.1489D-04,0.1651D-04,0.1831D-04,
     &0.2031D-04,0.2252D-04,0.2496D-04,0.2770D-04,0.3069D-04,0.3403D-04,
     &0.3770D-04,0.4178D-04,0.4629D-04,0.5128D-04,0.5678D-04,0.6286D-04,
     &0.6959D-04,0.7699D-04,0.8517D-04,0.9415D-04,0.1040D-03,0.1149D-03,
     &0.1269D-03,0.1400D-03,0.1543D-03,0.1699D-03,0.1870D-03,0.2055D-03,
     &0.2256D-03,0.2475D-03,0.2709D-03,0.2962D-03,0.3232D-03,0.3518D-03,
     &0.3821D-03,0.4137D-03,0.4468D-03,0.4807D-03,0.5153D-03,0.5499D-03,
     &0.5835D-03,0.6162D-03,0.6464D-03,0.6732D-03,0.6954D-03,0.7116D-03,
     &0.7207D-03,0.7212D-03,0.7125D-03,0.6928D-03,0.6625D-03,0.6217D-03,
     &0.5720D-03,0.5149D-03,0.4540D-03,0.3931D-03,0.3368D-03,0.2895D-03,
     &0.2557D-03,0.2384D-03,0.2393D-03,0.2595D-03,0.2999D-03,0.3616D-03,
     &0.3697D-03,0.3780D-03,0.3863D-03,0.3948D-03,0.4033D-03,0.4119D-03,
     &0.4205D-03,0.4291D-03,0.4376D-03,0.4459D-03,0.4541D-03,0.4619D-03,
     &0.4694D-03,0.4763D-03,0.4825D-03,0.4878D-03,0.4917D-03,0.4938D-03,
     &0.4932D-03,0.4886D-03,0.5200D-03,0.3453D-03/
      DATA (XPV(I,1,3),I=1,100)/
     &0.2308D-04,0.2495D-04,0.2699D-04,0.2918D-04,0.3156D-04,0.3413D-04,
     &0.3690D-04,0.3990D-04,0.4315D-04,0.4666D-04,0.5045D-04,0.5454D-04,
     &0.5898D-04,0.6376D-04,0.6894D-04,0.7454D-04,0.8058D-04,0.8711D-04,
     &0.9416D-04,0.1018D-03,0.1100D-03,0.1189D-03,0.1284D-03,0.1388D-03,
     &0.1499D-03,0.1620D-03,0.1749D-03,0.1889D-03,0.2039D-03,0.2201D-03,
     &0.2376D-03,0.2562D-03,0.2763D-03,0.2979D-03,0.3210D-03,0.3457D-03,
     &0.3721D-03,0.4003D-03,0.4303D-03,0.4623D-03,0.4961D-03,0.5318D-03,
     &0.5697D-03,0.6100D-03,0.6513D-03,0.6947D-03,0.7400D-03,0.7864D-03,
     &0.8337D-03,0.8816D-03,0.9298D-03,0.9773D-03,0.1024D-02,0.1068D-02,
     &0.1107D-02,0.1144D-02,0.1174D-02,0.1196D-02,0.1210D-02,0.1213D-02,
     &0.1203D-02,0.1180D-02,0.1144D-02,0.1091D-02,0.1024D-02,0.9420D-03,
     &0.8495D-03,0.7483D-03,0.6436D-03,0.5407D-03,0.4459D-03,0.3649D-03,
     &0.3034D-03,0.2653D-03,0.2522D-03,0.2644D-03,0.3011D-03,0.3617D-03,
     &0.3698D-03,0.3781D-03,0.3864D-03,0.3948D-03,0.4034D-03,0.4119D-03,
     &0.4205D-03,0.4291D-03,0.4376D-03,0.4459D-03,0.4541D-03,0.4619D-03,
     &0.4694D-03,0.4763D-03,0.4825D-03,0.4878D-03,0.4917D-03,0.4938D-03,
     &0.4932D-03,0.4886D-03,0.5200D-03,0.3453D-03/
      DATA (XPV(I,1,4),I=1,100)/
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00,
     &0.0000D+00,0.0000D+00,0.0000D+00,0.0000D+00/
      DATA (XPV(I,2,0),I=1,100)/
     &0.1356D+00,0.1323D+00,0.1291D+00,0.1259D+00,0.1228D+00,0.1197D+00,
     &0.1167D+00,0.1138D+00,0.1109D+00,0.1080D+00,0.1053D+00,0.1026D+00,
     &0.9987D-01,0.9730D-01,0.9474D-01,0.9219D-01,0.8977D-01,0.8736D-01,
     &0.8497D-01,0.8269D-01,0.8043D-01,0.7816D-01,0.7603D-01,0.7390D-01,
     &0.7178D-01,0.6977D-01,0.6777D-01,0.6577D-01,0.6388D-01,0.6200D-01,
     &0.6014D-01,0.5833D-01,0.5657D-01,0.5483D-01,0.5311D-01,0.5146D-01,
     &0.4983D-01,0.4821D-01,0.4664D-01,0.4512D-01,0.4362D-01,0.4214D-01,
     &0.4069D-01,0.3940D-01,0.3797D-01,0.3660D-01,0.3532D-01,0.3404D-01,
     &0.3275D-01,0.3151D-01,0.3030D-01,0.2912D-01,0.2796D-01,0.2684D-01,
     &0.2569D-01,0.2463D-01,0.2359D-01,0.2257D-01,0.2160D-01,0.2066D-01,
     &0.1976D-01,0.1891D-01,0.1812D-01,0.1738D-01,0.1671D-01,0.1612D-01,
     &0.1563D-01,0.1526D-01,0.1503D-01,0.1498D-01,0.1516D-01,0.1561D-01,
     &0.1641D-01,0.1763D-01,0.1929D-01,0.2127D-01,0.2302D-01,0.2306D-01,
     &0.2284D-01,0.2255D-01,0.2220D-01,0.2178D-01,0.2128D-01,0.2071D-01,
     &0.2004D-01,0.1930D-01,0.1846D-01,0.1753D-01,0.1651D-01,0.1539D-01,
     &0.1417D-01,0.1285D-01,0.1144D-01,0.9945D-02,0.8364D-02,0.6719D-02,
     &0.5030D-02,0.3305D-02,0.1711D-02,0.2728D-03/
      DATA (XPV(I,2,1),I=1,100)/
     &0.1580D-02,0.1552D-02,0.1523D-02,0.1495D-02,0.1467D-02,0.1440D-02,
     &0.1413D-02,0.1387D-02,0.1362D-02,0.1336D-02,0.1312D-02,0.1288D-02,
     &0.1264D-02,0.1241D-02,0.1219D-02,0.1197D-02,0.1176D-02,0.1155D-02,
     &0.1135D-02,0.1117D-02,0.1098D-02,0.1080D-02,0.1064D-02,0.1049D-02,
     &0.1034D-02,0.1020D-02,0.1008D-02,0.9958D-03,0.9857D-03,0.9769D-03,
     &0.9690D-03,0.9629D-03,0.9585D-03,0.9556D-03,0.9542D-03,0.9553D-03,
     &0.9582D-03,0.9630D-03,0.9702D-03,0.9801D-03,0.9924D-03,0.1007D-02,
     &0.1025D-02,0.1048D-02,0.1070D-02,0.1097D-02,0.1127D-02,0.1160D-02,
     &0.1196D-02,0.1235D-02,0.1276D-02,0.1320D-02,0.1366D-02,0.1414D-02,
     &0.1462D-02,0.1511D-02,0.1560D-02,0.1607D-02,0.1653D-02,0.1695D-02,
     &0.1734D-02,0.1768D-02,0.1797D-02,0.1821D-02,0.1840D-02,0.1856D-02,
     &0.1870D-02,0.1884D-02,0.1902D-02,0.1930D-02,0.1971D-02,0.2031D-02,
     &0.2118D-02,0.2236D-02,0.2391D-02,0.2582D-02,0.2803D-02,0.3029D-02,
     &0.3052D-02,0.3073D-02,0.3094D-02,0.3113D-02,0.3130D-02,0.3145D-02,
     &0.3158D-02,0.3169D-02,0.3176D-02,0.3181D-02,0.3181D-02,0.3178D-02,
     &0.3168D-02,0.3153D-02,0.3129D-02,0.3095D-02,0.3049D-02,0.2984D-02,
     &0.2897D-02,0.2785D-02,0.2548D-02,0.2093D-02/
      DATA (XPV(I,2,2),I=1,100)/
     &0.1579D-02,0.1550D-02,0.1522D-02,0.1493D-02,0.1465D-02,0.1438D-02,
     &0.1410D-02,0.1384D-02,0.1358D-02,0.1332D-02,0.1308D-02,0.1283D-02,
     &0.1259D-02,0.1236D-02,0.1213D-02,0.1190D-02,0.1168D-02,0.1147D-02,
     &0.1126D-02,0.1107D-02,0.1087D-02,0.1068D-02,0.1051D-02,0.1033D-02,
     &0.1017D-02,0.1001D-02,0.9867D-03,0.9726D-03,0.9600D-03,0.9484D-03,
     &0.9374D-03,0.9279D-03,0.9197D-03,0.9125D-03,0.9065D-03,0.9024D-03,
     &0.8996D-03,0.8981D-03,0.8984D-03,0.9006D-03,0.9045D-03,0.9099D-03,
     &0.9175D-03,0.9288D-03,0.9391D-03,0.9521D-03,0.9677D-03,0.9844D-03,
     &0.1002D-02,0.1021D-02,0.1041D-02,0.1062D-02,0.1083D-02,0.1104D-02,
     &0.1122D-02,0.1140D-02,0.1155D-02,0.1167D-02,0.1174D-02,0.1176D-02,
     &0.1172D-02,0.1162D-02,0.1145D-02,0.1122D-02,0.1092D-02,0.1058D-02,
     &0.1021D-02,0.9837D-03,0.9493D-03,0.9211D-03,0.9026D-03,0.8966D-03,
     &0.9045D-03,0.9256D-03,0.9554D-03,0.9845D-03,0.9981D-03,0.9751D-03,
     &0.9694D-03,0.9631D-03,0.9561D-03,0.9485D-03,0.9402D-03,0.9313D-03,
     &0.9217D-03,0.9114D-03,0.9006D-03,0.8890D-03,0.8766D-03,0.8634D-03,
     &0.8493D-03,0.8341D-03,0.8175D-03,0.7990D-03,0.7783D-03,0.7539D-03,
     &0.7241D-03,0.6938D-03,0.6252D-03,0.4746D-03/
      DATA (XPV(I,2,3),I=1,100)/
     &0.1607D-02,0.1581D-02,0.1554D-02,0.1528D-02,0.1503D-02,0.1478D-02,
     &0.1454D-02,0.1431D-02,0.1408D-02,0.1386D-02,0.1365D-02,0.1344D-02,
     &0.1324D-02,0.1306D-02,0.1288D-02,0.1270D-02,0.1254D-02,0.1239D-02,
     &0.1224D-02,0.1211D-02,0.1198D-02,0.1186D-02,0.1177D-02,0.1168D-02,
     &0.1160D-02,0.1154D-02,0.1149D-02,0.1145D-02,0.1143D-02,0.1142D-02,
     &0.1143D-02,0.1145D-02,0.1150D-02,0.1156D-02,0.1163D-02,0.1173D-02,
     &0.1185D-02,0.1198D-02,0.1214D-02,0.1231D-02,0.1250D-02,0.1271D-02,
     &0.1294D-02,0.1321D-02,0.1346D-02,0.1373D-02,0.1403D-02,0.1432D-02,
     &0.1461D-02,0.1490D-02,0.1518D-02,0.1545D-02,0.1570D-02,0.1592D-02,
     &0.1607D-02,0.1620D-02,0.1626D-02,0.1625D-02,0.1616D-02,0.1598D-02,
     &0.1569D-02,0.1531D-02,0.1485D-02,0.1427D-02,0.1362D-02,0.1290D-02,
     &0.1216D-02,0.1143D-02,0.1074D-02,0.1015D-02,0.9689D-03,0.9403D-03,
     &0.9308D-03,0.9395D-03,0.9616D-03,0.9867D-03,0.9986D-03,0.9752D-03,
     &0.9695D-03,0.9631D-03,0.9561D-03,0.9485D-03,0.9402D-03,0.9313D-03,
     &0.9217D-03,0.9114D-03,0.9006D-03,0.8890D-03,0.8766D-03,0.8634D-03,
     &0.8493D-03,0.8341D-03,0.8175D-03,0.7990D-03,0.7783D-03,0.7539D-03,
     &0.7241D-03,0.6938D-03,0.6252D-03,0.4746D-03/
      DATA (XPV(I,2,4),I=1,100)/
     &0.1415D-02,0.1387D-02,0.1359D-02,0.1331D-02,0.1305D-02,0.1278D-02,
     &0.1251D-02,0.1225D-02,0.1199D-02,0.1173D-02,0.1149D-02,0.1124D-02,
     &0.1099D-02,0.1076D-02,0.1052D-02,0.1028D-02,0.1006D-02,0.9831D-03,
     &0.9605D-03,0.9389D-03,0.9174D-03,0.8956D-03,0.8752D-03,0.8546D-03,
     &0.8341D-03,0.8146D-03,0.7951D-03,0.7757D-03,0.7572D-03,0.7389D-03,
     &0.7206D-03,0.7031D-03,0.6861D-03,0.6692D-03,0.6527D-03,0.6371D-03,
     &0.6218D-03,0.6068D-03,0.5925D-03,0.5789D-03,0.5660D-03,0.5535D-03,
     &0.5418D-03,0.5324D-03,0.5217D-03,0.5124D-03,0.5048D-03,0.4977D-03,
     &0.4913D-03,0.4863D-03,0.4825D-03,0.4799D-03,0.4788D-03,0.4791D-03,
     &0.4802D-03,0.4834D-03,0.4882D-03,0.4945D-03,0.5024D-03,0.5120D-03,
     &0.5231D-03,0.5359D-03,0.5503D-03,0.5660D-03,0.5831D-03,0.6017D-03,
     &0.6218D-03,0.6436D-03,0.6672D-03,0.6934D-03,0.7230D-03,0.7576D-03,
     &0.7992D-03,0.8507D-03,0.9158D-03,0.9997D-03,0.1110D-02,0.1257D-02,
     &0.1276D-02,0.1296D-02,0.1316D-02,0.1336D-02,0.1357D-02,0.1378D-02,
     &0.1400D-02,0.1421D-02,0.1443D-02,0.1465D-02,0.1488D-02,0.1509D-02,
     &0.1531D-02,0.1551D-02,0.1571D-02,0.1589D-02,0.1603D-02,0.1614D-02,
     &0.1612D-02,0.1626D-02,0.1559D-02,0.1269D-02/
      DATA (XPV(I,3,0),I=1,100)/
     &0.3292D+00,0.3189D+00,0.3087D+00,0.2986D+00,0.2890D+00,0.2796D+00,
     &0.2703D+00,0.2615D+00,0.2529D+00,0.2443D+00,0.2363D+00,0.2283D+00,
     &0.2205D+00,0.2131D+00,0.2058D+00,0.1986D+00,0.1918D+00,0.1851D+00,
     &0.1785D+00,0.1722D+00,0.1661D+00,0.1600D+00,0.1544D+00,0.1487D+00,
     &0.1432D+00,0.1380D+00,0.1329D+00,0.1278D+00,0.1231D+00,0.1184D+00,
     &0.1138D+00,0.1094D+00,0.1051D+00,0.1010D+00,0.9689D-01,0.9302D-01,
     &0.8924D-01,0.8553D-01,0.8196D-01,0.7853D-01,0.7521D-01,0.7196D-01,
     &0.6881D-01,0.6600D-01,0.6297D-01,0.6010D-01,0.5743D-01,0.5479D-01,
     &0.5218D-01,0.4969D-01,0.4729D-01,0.4498D-01,0.4274D-01,0.4060D-01,
     &0.3844D-01,0.3644D-01,0.3453D-01,0.3267D-01,0.3091D-01,0.2922D-01,
     &0.2762D-01,0.2611D-01,0.2471D-01,0.2338D-01,0.2216D-01,0.2105D-01,
     &0.2007D-01,0.1922D-01,0.1851D-01,0.1795D-01,0.1755D-01,0.1732D-01,
     &0.1724D-01,0.1727D-01,0.1727D-01,0.1699D-01,0.1590D-01,0.1312D-01,
     &0.1266D-01,0.1217D-01,0.1165D-01,0.1110D-01,0.1053D-01,0.9921D-02,
     &0.9286D-02,0.8628D-02,0.7952D-02,0.7250D-02,0.6536D-02,0.5804D-02,
     &0.5069D-02,0.4328D-02,0.3596D-02,0.2876D-02,0.2183D-02,0.1530D-02,
     &0.9314D-03,0.4198D-03,0.1184D-03,0.0000D+00/
      DATA (XPV(I,3,1),I=1,100)/
     &0.5070D-02,0.4938D-02,0.4806D-02,0.4675D-02,0.4552D-02,0.4429D-02,
     &0.4308D-02,0.4193D-02,0.4079D-02,0.3966D-02,0.3860D-02,0.3755D-02,
     &0.3650D-02,0.3552D-02,0.3454D-02,0.3358D-02,0.3268D-02,0.3178D-02,
     &0.3090D-02,0.3008D-02,0.2926D-02,0.2846D-02,0.2771D-02,0.2698D-02,
     &0.2626D-02,0.2559D-02,0.2494D-02,0.2430D-02,0.2371D-02,0.2315D-02,
     &0.2261D-02,0.2210D-02,0.2163D-02,0.2118D-02,0.2077D-02,0.2040D-02,
     &0.2006D-02,0.1975D-02,0.1948D-02,0.1926D-02,0.1907D-02,0.1892D-02,
     &0.1882D-02,0.1880D-02,0.1876D-02,0.1879D-02,0.1887D-02,0.1899D-02,
     &0.1914D-02,0.1934D-02,0.1958D-02,0.1986D-02,0.2017D-02,0.2051D-02,
     &0.2085D-02,0.2123D-02,0.2163D-02,0.2202D-02,0.2240D-02,0.2278D-02,
     &0.2314D-02,0.2347D-02,0.2379D-02,0.2407D-02,0.2433D-02,0.2459D-02,
     &0.2485D-02,0.2515D-02,0.2551D-02,0.2597D-02,0.2657D-02,0.2738D-02,
     &0.2843D-02,0.2978D-02,0.3148D-02,0.3354D-02,0.3592D-02,0.3839D-02,
     &0.3864D-02,0.3888D-02,0.3911D-02,0.3931D-02,0.3950D-02,0.3967D-02,
     &0.3980D-02,0.3991D-02,0.3999D-02,0.4002D-02,0.4000D-02,0.3993D-02,
     &0.3978D-02,0.3956D-02,0.3922D-02,0.3876D-02,0.3812D-02,0.3724D-02,
     &0.3606D-02,0.3465D-02,0.3134D-02,0.2451D-02/
      DATA (XPV(I,3,2),I=1,100)/
     &0.5067D-02,0.4935D-02,0.4803D-02,0.4672D-02,0.4548D-02,0.4425D-02,
     &0.4303D-02,0.4188D-02,0.4074D-02,0.3960D-02,0.3853D-02,0.3747D-02,
     &0.3642D-02,0.3543D-02,0.3445D-02,0.3347D-02,0.3256D-02,0.3165D-02,
     &0.3075D-02,0.2991D-02,0.2908D-02,0.2826D-02,0.2749D-02,0.2673D-02,
     &0.2599D-02,0.2529D-02,0.2461D-02,0.2393D-02,0.2331D-02,0.2270D-02,
     &0.2211D-02,0.2155D-02,0.2102D-02,0.2052D-02,0.2003D-02,0.1958D-02,
     &0.1916D-02,0.1876D-02,0.1839D-02,0.1805D-02,0.1774D-02,0.1746D-02,
     &0.1720D-02,0.1702D-02,0.1681D-02,0.1664D-02,0.1651D-02,0.1640D-02,
     &0.1629D-02,0.1622D-02,0.1616D-02,0.1612D-02,0.1608D-02,0.1605D-02,
     &0.1598D-02,0.1593D-02,0.1586D-02,0.1577D-02,0.1564D-02,0.1547D-02,
     &0.1525D-02,0.1499D-02,0.1470D-02,0.1434D-02,0.1396D-02,0.1355D-02,
     &0.1314D-02,0.1274D-02,0.1240D-02,0.1211D-02,0.1192D-02,0.1184D-02,
     &0.1185D-02,0.1194D-02,0.1206D-02,0.1211D-02,0.1198D-02,0.1157D-02,
     &0.1150D-02,0.1143D-02,0.1135D-02,0.1127D-02,0.1119D-02,0.1110D-02,
     &0.1101D-02,0.1091D-02,0.1081D-02,0.1070D-02,0.1059D-02,0.1046D-02,
     &0.1033D-02,0.1018D-02,0.1001D-02,0.9817D-03,0.9590D-03,0.9316D-03,
     &0.8950D-03,0.8607D-03,0.7722D-03,0.5564D-03/
      DATA (XPV(I,3,3),I=1,100)/
     &0.5100D-02,0.4971D-02,0.4841D-02,0.4713D-02,0.4592D-02,0.4472D-02,
     &0.4353D-02,0.4242D-02,0.4131D-02,0.4022D-02,0.3919D-02,0.3817D-02,
     &0.3716D-02,0.3622D-02,0.3529D-02,0.3438D-02,0.3352D-02,0.3268D-02,
     &0.3185D-02,0.3108D-02,0.3032D-02,0.2958D-02,0.2889D-02,0.2822D-02,
     &0.2757D-02,0.2696D-02,0.2638D-02,0.2582D-02,0.2530D-02,0.2481D-02,
     &0.2433D-02,0.2390D-02,0.2350D-02,0.2312D-02,0.2277D-02,0.2246D-02,
     &0.2218D-02,0.2192D-02,0.2169D-02,0.2150D-02,0.2133D-02,0.2119D-02,
     &0.2108D-02,0.2104D-02,0.2095D-02,0.2090D-02,0.2089D-02,0.2088D-02,
     &0.2086D-02,0.2085D-02,0.2084D-02,0.2082D-02,0.2079D-02,0.2073D-02,
     &0.2061D-02,0.2047D-02,0.2028D-02,0.2003D-02,0.1971D-02,0.1931D-02,
     &0.1884D-02,0.1830D-02,0.1769D-02,0.1701D-02,0.1628D-02,0.1553D-02,
     &0.1478D-02,0.1406D-02,0.1341D-02,0.1286D-02,0.1244D-02,0.1217D-02,
     &0.1205D-02,0.1204D-02,0.1210D-02,0.1212D-02,0.1199D-02,0.1157D-02,
     &0.1150D-02,0.1143D-02,0.1135D-02,0.1127D-02,0.1119D-02,0.1110D-02,
     &0.1101D-02,0.1091D-02,0.1081D-02,0.1070D-02,0.1059D-02,0.1046D-02,
     &0.1033D-02,0.1018D-02,0.1001D-02,0.9817D-03,0.9590D-03,0.9316D-03,
     &0.8950D-03,0.8607D-03,0.7722D-03,0.5564D-03/
      DATA (XPV(I,3,4),I=1,100)/
     &0.4904D-02,0.4772D-02,0.4641D-02,0.4511D-02,0.4387D-02,0.4264D-02,
     &0.4143D-02,0.4028D-02,0.3914D-02,0.3800D-02,0.3692D-02,0.3586D-02,
     &0.3480D-02,0.3380D-02,0.3281D-02,0.3182D-02,0.3089D-02,0.2997D-02,
     &0.2905D-02,0.2819D-02,0.2733D-02,0.2648D-02,0.2568D-02,0.2488D-02,
     &0.2409D-02,0.2335D-02,0.2261D-02,0.2189D-02,0.2120D-02,0.2052D-02,
     &0.1986D-02,0.1922D-02,0.1860D-02,0.1800D-02,0.1741D-02,0.1686D-02,
     &0.1632D-02,0.1579D-02,0.1529D-02,0.1481D-02,0.1435D-02,0.1391D-02,
     &0.1350D-02,0.1315D-02,0.1276D-02,0.1242D-02,0.1212D-02,0.1184D-02,
     &0.1157D-02,0.1135D-02,0.1115D-02,0.1098D-02,0.1085D-02,0.1075D-02,
     &0.1067D-02,0.1064D-02,0.1064D-02,0.1068D-02,0.1076D-02,0.1087D-02,
     &0.1101D-02,0.1119D-02,0.1141D-02,0.1165D-02,0.1193D-02,0.1223D-02,
     &0.1256D-02,0.1292D-02,0.1332D-02,0.1375D-02,0.1424D-02,0.1482D-02,
     &0.1551D-02,0.1637D-02,0.1748D-02,0.1896D-02,0.2095D-02,0.2365D-02,
     &0.2400D-02,0.2434D-02,0.2470D-02,0.2506D-02,0.2542D-02,0.2578D-02,
     &0.2614D-02,0.2649D-02,0.2685D-02,0.2718D-02,0.2752D-02,0.2783D-02,
     &0.2812D-02,0.2837D-02,0.2858D-02,0.2872D-02,0.2878D-02,0.2872D-02,
     &0.2841D-02,0.2821D-02,0.2656D-02,0.2138D-02/
      DATA (XPV(I,4,0),I=1,100)/
     &0.4299D+00,0.4154D+00,0.4011D+00,0.3870D+00,0.3736D+00,0.3605D+00,
     &0.3476D+00,0.3355D+00,0.3236D+00,0.3118D+00,0.3007D+00,0.2898D+00,
     &0.2791D+00,0.2690D+00,0.2591D+00,0.2494D+00,0.2402D+00,0.2312D+00,
     &0.2223D+00,0.2140D+00,0.2059D+00,0.1978D+00,0.1902D+00,0.1828D+00,
     &0.1755D+00,0.1687D+00,0.1619D+00,0.1553D+00,0.1491D+00,0.1430D+00,
     &0.1371D+00,0.1314D+00,0.1259D+00,0.1206D+00,0.1154D+00,0.1104D+00,
     &0.1056D+00,0.1009D+00,0.9641D-01,0.9210D-01,0.8793D-01,0.8386D-01,
     &0.7994D-01,0.7643D-01,0.7269D-01,0.6916D-01,0.6587D-01,0.6264D-01,
     &0.5946D-01,0.5644D-01,0.5353D-01,0.5074D-01,0.4805D-01,0.4548D-01,
     &0.4290D-01,0.4053D-01,0.3826D-01,0.3607D-01,0.3399D-01,0.3201D-01,
     &0.3012D-01,0.2836D-01,0.2672D-01,0.2516D-01,0.2372D-01,0.2241D-01,
     &0.2123D-01,0.2018D-01,0.1927D-01,0.1850D-01,0.1787D-01,0.1737D-01,
     &0.1696D-01,0.1658D-01,0.1608D-01,0.1522D-01,0.1354D-01,0.1041D-01,
     &0.9954D-02,0.9473D-02,0.8976D-02,0.8461D-02,0.7931D-02,0.7386D-02,
     &0.6825D-02,0.6255D-02,0.5681D-02,0.5098D-02,0.4516D-02,0.3934D-02,
     &0.3362D-02,0.2799D-02,0.2258D-02,0.1742D-02,0.1262D-02,0.8280D-03,
     &0.4482D-03,0.1620D-03,0.2992D-04,0.0000D+00/
      DATA (XPV(I,4,1),I=1,100)/
     &0.7160D-02,0.6955D-02,0.6751D-02,0.6550D-02,0.6360D-02,0.6172D-02,
     &0.5986D-02,0.5810D-02,0.5637D-02,0.5466D-02,0.5304D-02,0.5145D-02,
     &0.4987D-02,0.4839D-02,0.4693D-02,0.4548D-02,0.4413D-02,0.4279D-02,
     &0.4148D-02,0.4024D-02,0.3903D-02,0.3783D-02,0.3672D-02,0.3563D-02,
     &0.3456D-02,0.3356D-02,0.3259D-02,0.3163D-02,0.3075D-02,0.2990D-02,
     &0.2908D-02,0.2831D-02,0.2758D-02,0.2689D-02,0.2624D-02,0.2565D-02,
     &0.2509D-02,0.2458D-02,0.2411D-02,0.2370D-02,0.2334D-02,0.2302D-02,
     &0.2275D-02,0.2259D-02,0.2241D-02,0.2229D-02,0.2226D-02,0.2226D-02,
     &0.2229D-02,0.2239D-02,0.2253D-02,0.2272D-02,0.2295D-02,0.2322D-02,
     &0.2348D-02,0.2381D-02,0.2415D-02,0.2449D-02,0.2485D-02,0.2519D-02,
     &0.2554D-02,0.2586D-02,0.2618D-02,0.2648D-02,0.2676D-02,0.2705D-02,
     &0.2736D-02,0.2770D-02,0.2812D-02,0.2864D-02,0.2931D-02,0.3017D-02,
     &0.3129D-02,0.3270D-02,0.3447D-02,0.3662D-02,0.3913D-02,0.4178D-02,
     &0.4205D-02,0.4231D-02,0.4256D-02,0.4279D-02,0.4299D-02,0.4318D-02,
     &0.4333D-02,0.4345D-02,0.4353D-02,0.4357D-02,0.4355D-02,0.4348D-02,
     &0.4332D-02,0.4307D-02,0.4271D-02,0.4220D-02,0.4151D-02,0.4055D-02,
     &0.3924D-02,0.3774D-02,0.3409D-02,0.2626D-02/
      DATA (XPV(I,4,2),I=1,100)/
     &0.7157D-02,0.6952D-02,0.6748D-02,0.6546D-02,0.6356D-02,0.6167D-02,
     &0.5981D-02,0.5805D-02,0.5631D-02,0.5458D-02,0.5296D-02,0.5136D-02,
     &0.4978D-02,0.4828D-02,0.4681D-02,0.4535D-02,0.4398D-02,0.4263D-02,
     &0.4130D-02,0.4005D-02,0.3882D-02,0.3760D-02,0.3646D-02,0.3534D-02,
     &0.3424D-02,0.3321D-02,0.3220D-02,0.3120D-02,0.3028D-02,0.2938D-02,
     &0.2850D-02,0.2767D-02,0.2688D-02,0.2612D-02,0.2538D-02,0.2470D-02,
     &0.2405D-02,0.2343D-02,0.2285D-02,0.2231D-02,0.2181D-02,0.2133D-02,
     &0.2090D-02,0.2055D-02,0.2017D-02,0.1983D-02,0.1956D-02,0.1929D-02,
     &0.1905D-02,0.1883D-02,0.1864D-02,0.1846D-02,0.1830D-02,0.1815D-02,
     &0.1797D-02,0.1781D-02,0.1764D-02,0.1744D-02,0.1722D-02,0.1696D-02,
     &0.1666D-02,0.1633D-02,0.1597D-02,0.1556D-02,0.1513D-02,0.1468D-02,
     &0.1425D-02,0.1383D-02,0.1346D-02,0.1316D-02,0.1295D-02,0.1283D-02,
     &0.1281D-02,0.1284D-02,0.1288D-02,0.1286D-02,0.1269D-02,0.1228D-02,
     &0.1222D-02,0.1215D-02,0.1208D-02,0.1201D-02,0.1194D-02,0.1186D-02,
     &0.1177D-02,0.1169D-02,0.1159D-02,0.1149D-02,0.1139D-02,0.1127D-02,
     &0.1114D-02,0.1100D-02,0.1083D-02,0.1063D-02,0.1040D-02,0.1012D-02,
     &0.9728D-03,0.9358D-03,0.8403D-03,0.6078D-03/
      DATA (XPV(I,4,3),I=1,100)/
     &0.7192D-02,0.6990D-02,0.6788D-02,0.6589D-02,0.6402D-02,0.6216D-02,
     &0.6033D-02,0.5861D-02,0.5691D-02,0.5523D-02,0.5365D-02,0.5209D-02,
     &0.5055D-02,0.4912D-02,0.4770D-02,0.4630D-02,0.4499D-02,0.4370D-02,
     &0.4244D-02,0.4126D-02,0.4011D-02,0.3896D-02,0.3791D-02,0.3688D-02,
     &0.3587D-02,0.3494D-02,0.3403D-02,0.3314D-02,0.3233D-02,0.3154D-02,
     &0.3078D-02,0.3008D-02,0.2941D-02,0.2878D-02,0.2818D-02,0.2764D-02,
     &0.2713D-02,0.2664D-02,0.2620D-02,0.2581D-02,0.2544D-02,0.2510D-02,
     &0.2480D-02,0.2460D-02,0.2433D-02,0.2411D-02,0.2394D-02,0.2377D-02,
     &0.2359D-02,0.2343D-02,0.2328D-02,0.2312D-02,0.2295D-02,0.2276D-02,
     &0.2251D-02,0.2225D-02,0.2195D-02,0.2158D-02,0.2116D-02,0.2067D-02,
     &0.2012D-02,0.1950D-02,0.1883D-02,0.1810D-02,0.1733D-02,0.1655D-02,
     &0.1578D-02,0.1505D-02,0.1440D-02,0.1385D-02,0.1342D-02,0.1314D-02,
     &0.1298D-02,0.1293D-02,0.1292D-02,0.1288D-02,0.1269D-02,0.1228D-02,
     &0.1222D-02,0.1215D-02,0.1208D-02,0.1201D-02,0.1194D-02,0.1186D-02,
     &0.1177D-02,0.1169D-02,0.1159D-02,0.1149D-02,0.1139D-02,0.1127D-02,
     &0.1114D-02,0.1100D-02,0.1083D-02,0.1063D-02,0.1040D-02,0.1012D-02,
     &0.9728D-03,0.9358D-03,0.8403D-03,0.6078D-03/
      DATA (XPV(I,4,4),I=1,100)/
     &0.6994D-02,0.6789D-02,0.6586D-02,0.6385D-02,0.6194D-02,0.6006D-02,
     &0.5820D-02,0.5644D-02,0.5470D-02,0.5297D-02,0.5135D-02,0.4974D-02,
     &0.4815D-02,0.4665D-02,0.4516D-02,0.4369D-02,0.4231D-02,0.4094D-02,
     &0.3959D-02,0.3831D-02,0.3705D-02,0.3580D-02,0.3463D-02,0.3347D-02,
     &0.3233D-02,0.3125D-02,0.3019D-02,0.2914D-02,0.2815D-02,0.2718D-02,
     &0.2623D-02,0.2532D-02,0.2444D-02,0.2359D-02,0.2276D-02,0.2197D-02,
     &0.2121D-02,0.2047D-02,0.1976D-02,0.1909D-02,0.1845D-02,0.1784D-02,
     &0.1726D-02,0.1676D-02,0.1623D-02,0.1575D-02,0.1532D-02,0.1492D-02,
     &0.1455D-02,0.1422D-02,0.1393D-02,0.1368D-02,0.1348D-02,0.1332D-02,
     &0.1318D-02,0.1311D-02,0.1309D-02,0.1310D-02,0.1316D-02,0.1327D-02,
     &0.1342D-02,0.1361D-02,0.1385D-02,0.1412D-02,0.1443D-02,0.1477D-02,
     &0.1514D-02,0.1556D-02,0.1601D-02,0.1650D-02,0.1706D-02,0.1772D-02,
     &0.1851D-02,0.1951D-02,0.2081D-02,0.2254D-02,0.2490D-02,0.2807D-02,
     &0.2848D-02,0.2888D-02,0.2930D-02,0.2971D-02,0.3012D-02,0.3053D-02,
     &0.3094D-02,0.3133D-02,0.3173D-02,0.3210D-02,0.3246D-02,0.3278D-02,
     &0.3308D-02,0.3332D-02,0.3351D-02,0.3361D-02,0.3360D-02,0.3343D-02,
     &0.3298D-02,0.3256D-02,0.3045D-02,0.2439D-02/
      DATA (XPV(I,5,0),I=1,100)/
     &0.8093D+00,0.7773D+00,0.7460D+00,0.7153D+00,0.6865D+00,0.6584D+00,
     &0.6309D+00,0.6051D+00,0.5800D+00,0.5553D+00,0.5323D+00,0.5098D+00,
     &0.4878D+00,0.4672D+00,0.4471D+00,0.4274D+00,0.4091D+00,0.3911D+00,
     &0.3737D+00,0.3573D+00,0.3414D+00,0.3257D+00,0.3112D+00,0.2970D+00,
     &0.2832D+00,0.2703D+00,0.2577D+00,0.2454D+00,0.2339D+00,0.2228D+00,
     &0.2120D+00,0.2017D+00,0.1919D+00,0.1824D+00,0.1732D+00,0.1646D+00,
     &0.1562D+00,0.1481D+00,0.1404D+00,0.1331D+00,0.1261D+00,0.1193D+00,
     &0.1128D+00,0.1070D+00,0.1010D+00,0.9529D-01,0.9002D-01,0.8489D-01,
     &0.7989D-01,0.7519D-01,0.7070D-01,0.6643D-01,0.6235D-01,0.5848D-01,
     &0.5466D-01,0.5115D-01,0.4783D-01,0.4465D-01,0.4164D-01,0.3880D-01,
     &0.3612D-01,0.3361D-01,0.3128D-01,0.2906D-01,0.2701D-01,0.2510D-01,
     &0.2335D-01,0.2174D-01,0.2025D-01,0.1888D-01,0.1761D-01,0.1640D-01,
     &0.1519D-01,0.1391D-01,0.1244D-01,0.1063D-01,0.8288D-02,0.5319D-02,
     &0.4959D-02,0.4600D-02,0.4241D-02,0.3887D-02,0.3536D-02,0.3192D-02,
     &0.2851D-02,0.2522D-02,0.2202D-02,0.1896D-02,0.1603D-02,0.1327D-02,
     &0.1069D-02,0.8328D-03,0.6188D-03,0.4316D-03,0.2725D-03,0.1444D-03,
     &0.4859D-04,0.5429D-05,0.0000D+00,0.1955D-04/
      DATA (XPV(I,5,1),I=1,100)/
     &0.1593D-01,0.1538D-01,0.1484D-01,0.1431D-01,0.1382D-01,0.1333D-01,
     &0.1285D-01,0.1239D-01,0.1195D-01,0.1151D-01,0.1110D-01,0.1070D-01,
     &0.1031D-01,0.9936D-02,0.9572D-02,0.9216D-02,0.8882D-02,0.8554D-02,
     &0.8234D-02,0.7934D-02,0.7641D-02,0.7352D-02,0.7084D-02,0.6821D-02,
     &0.6565D-02,0.6326D-02,0.6094D-02,0.5867D-02,0.5655D-02,0.5452D-02,
     &0.5254D-02,0.5067D-02,0.4891D-02,0.4722D-02,0.4560D-02,0.4411D-02,
     &0.4269D-02,0.4134D-02,0.4008D-02,0.3894D-02,0.3787D-02,0.3688D-02,
     &0.3598D-02,0.3527D-02,0.3450D-02,0.3386D-02,0.3335D-02,0.3289D-02,
     &0.3249D-02,0.3219D-02,0.3197D-02,0.3182D-02,0.3175D-02,0.3175D-02,
     &0.3176D-02,0.3186D-02,0.3202D-02,0.3221D-02,0.3244D-02,0.3270D-02,
     &0.3298D-02,0.3328D-02,0.3361D-02,0.3394D-02,0.3429D-02,0.3468D-02,
     &0.3511D-02,0.3560D-02,0.3617D-02,0.3686D-02,0.3770D-02,0.3875D-02,
     &0.4005D-02,0.4169D-02,0.4375D-02,0.4632D-02,0.4943D-02,0.5288D-02,
     &0.5325D-02,0.5361D-02,0.5394D-02,0.5426D-02,0.5455D-02,0.5481D-02,
     &0.5503D-02,0.5521D-02,0.5534D-02,0.5542D-02,0.5542D-02,0.5535D-02,
     &0.5517D-02,0.5487D-02,0.5443D-02,0.5379D-02,0.5292D-02,0.5171D-02,
     &0.5002D-02,0.4819D-02,0.4353D-02,0.3292D-02/
      DATA (XPV(I,5,2),I=1,100)/
     &0.1593D-01,0.1538D-01,0.1484D-01,0.1431D-01,0.1381D-01,0.1332D-01,
     &0.1284D-01,0.1238D-01,0.1194D-01,0.1150D-01,0.1109D-01,0.1069D-01,
     &0.1029D-01,0.9919D-02,0.9554D-02,0.9196D-02,0.8860D-02,0.8530D-02,
     &0.8207D-02,0.7904D-02,0.7608D-02,0.7315D-02,0.7045D-02,0.6777D-02,
     &0.6517D-02,0.6273D-02,0.6035D-02,0.5802D-02,0.5584D-02,0.5373D-02,
     &0.5168D-02,0.4973D-02,0.4787D-02,0.4607D-02,0.4434D-02,0.4272D-02,
     &0.4116D-02,0.3966D-02,0.3825D-02,0.3692D-02,0.3565D-02,0.3445D-02,
     &0.3331D-02,0.3234D-02,0.3130D-02,0.3035D-02,0.2951D-02,0.2869D-02,
     &0.2790D-02,0.2718D-02,0.2650D-02,0.2586D-02,0.2526D-02,0.2469D-02,
     &0.2409D-02,0.2356D-02,0.2303D-02,0.2249D-02,0.2195D-02,0.2140D-02,
     &0.2084D-02,0.2027D-02,0.1970D-02,0.1911D-02,0.1852D-02,0.1794D-02,
     &0.1739D-02,0.1688D-02,0.1643D-02,0.1604D-02,0.1574D-02,0.1551D-02,
     &0.1534D-02,0.1523D-02,0.1512D-02,0.1500D-02,0.1483D-02,0.1462D-02,
     &0.1459D-02,0.1456D-02,0.1453D-02,0.1450D-02,0.1446D-02,0.1442D-02,
     &0.1438D-02,0.1433D-02,0.1427D-02,0.1421D-02,0.1413D-02,0.1404D-02,
     &0.1393D-02,0.1380D-02,0.1364D-02,0.1343D-02,0.1318D-02,0.1285D-02,
     &0.1239D-02,0.1192D-02,0.1073D-02,0.7970D-03/
      DATA (XPV(I,5,3),I=1,100)/
     &0.1597D-01,0.1542D-01,0.1488D-01,0.1436D-01,0.1386D-01,0.1337D-01,
     &0.1290D-01,0.1245D-01,0.1201D-01,0.1157D-01,0.1117D-01,0.1077D-01,
     &0.1038D-01,0.1001D-01,0.9654D-02,0.9302D-02,0.8972D-02,0.8649D-02,
     &0.8334D-02,0.8038D-02,0.7750D-02,0.7466D-02,0.7204D-02,0.6946D-02,
     &0.6696D-02,0.6462D-02,0.6234D-02,0.6012D-02,0.5805D-02,0.5606D-02,
     &0.5412D-02,0.5230D-02,0.5056D-02,0.4889D-02,0.4729D-02,0.4580D-02,
     &0.4438D-02,0.4301D-02,0.4173D-02,0.4053D-02,0.3939D-02,0.3831D-02,
     &0.3729D-02,0.3644D-02,0.3549D-02,0.3463D-02,0.3387D-02,0.3312D-02,
     &0.3238D-02,0.3168D-02,0.3101D-02,0.3036D-02,0.2971D-02,0.2907D-02,
     &0.2838D-02,0.2771D-02,0.2702D-02,0.2630D-02,0.2555D-02,0.2476D-02,
     &0.2393D-02,0.2308D-02,0.2221D-02,0.2130D-02,0.2040D-02,0.1951D-02,
     &0.1867D-02,0.1788D-02,0.1718D-02,0.1659D-02,0.1610D-02,0.1574D-02,
     &0.1547D-02,0.1529D-02,0.1515D-02,0.1501D-02,0.1484D-02,0.1462D-02,
     &0.1459D-02,0.1456D-02,0.1453D-02,0.1450D-02,0.1446D-02,0.1442D-02,
     &0.1438D-02,0.1433D-02,0.1427D-02,0.1421D-02,0.1413D-02,0.1404D-02,
     &0.1393D-02,0.1380D-02,0.1364D-02,0.1343D-02,0.1318D-02,0.1285D-02,
     &0.1239D-02,0.1192D-02,0.1073D-02,0.7970D-03/
      DATA (XPV(I,5,4),I=1,100)/
     &0.1576D-01,0.1522D-01,0.1468D-01,0.1415D-01,0.1365D-01,0.1316D-01,
     &0.1268D-01,0.1222D-01,0.1178D-01,0.1134D-01,0.1093D-01,0.1052D-01,
     &0.1013D-01,0.9753D-02,0.9387D-02,0.9027D-02,0.8689D-02,0.8357D-02,
     &0.8032D-02,0.7727D-02,0.7428D-02,0.7132D-02,0.6858D-02,0.6586D-02,
     &0.6323D-02,0.6074D-02,0.5831D-02,0.5593D-02,0.5369D-02,0.5152D-02,
     &0.4939D-02,0.4738D-02,0.4544D-02,0.4357D-02,0.4175D-02,0.4005D-02,
     &0.3840D-02,0.3681D-02,0.3530D-02,0.3388D-02,0.3253D-02,0.3123D-02,
     &0.3000D-02,0.2895D-02,0.2783D-02,0.2682D-02,0.2593D-02,0.2508D-02,
     &0.2428D-02,0.2357D-02,0.2294D-02,0.2239D-02,0.2192D-02,0.2153D-02,
     &0.2118D-02,0.2095D-02,0.2079D-02,0.2071D-02,0.2071D-02,0.2078D-02,
     &0.2093D-02,0.2115D-02,0.2144D-02,0.2178D-02,0.2219D-02,0.2264D-02,
     &0.2316D-02,0.2372D-02,0.2434D-02,0.2502D-02,0.2580D-02,0.2672D-02,
     &0.2784D-02,0.2928D-02,0.3119D-02,0.3377D-02,0.3729D-02,0.4189D-02,
     &0.4246D-02,0.4303D-02,0.4359D-02,0.4415D-02,0.4470D-02,0.4524D-02,
     &0.4576D-02,0.4626D-02,0.4674D-02,0.4717D-02,0.4757D-02,0.4790D-02,
     &0.4817D-02,0.4835D-02,0.4841D-02,0.4833D-02,0.4805D-02,0.4749D-02,
     &0.4653D-02,0.4545D-02,0.4183D-02,0.3280D-02/
      DATA (XPV(I,6,0),I=1,100)/
     &0.1231D+01,0.1178D+01,0.1126D+01,0.1075D+01,0.1027D+01,0.9810D+00,
     &0.9360D+00,0.8939D+00,0.8530D+00,0.8132D+00,0.7760D+00,0.7400D+00,
     &0.7048D+00,0.6721D+00,0.6402D+00,0.6093D+00,0.5805D+00,0.5525D+00,
     &0.5253D+00,0.5000D+00,0.4755D+00,0.4515D+00,0.4294D+00,0.4078D+00,
     &0.3869D+00,0.3675D+00,0.3487D+00,0.3304D+00,0.3134D+00,0.2970D+00,
     &0.2811D+00,0.2662D+00,0.2519D+00,0.2382D+00,0.2250D+00,0.2127D+00,
     &0.2008D+00,0.1894D+00,0.1786D+00,0.1684D+00,0.1587D+00,0.1493D+00,
     &0.1404D+00,0.1325D+00,0.1242D+00,0.1166D+00,0.1095D+00,0.1026D+00,
     &0.9603D-01,0.8984D-01,0.8397D-01,0.7840D-01,0.7313D-01,0.6816D-01,
     &0.6329D-01,0.5884D-01,0.5463D-01,0.5064D-01,0.4689D-01,0.4336D-01,
     &0.4003D-01,0.3692D-01,0.3405D-01,0.3131D-01,0.2878D-01,0.2641D-01,
     &0.2422D-01,0.2217D-01,0.2026D-01,0.1847D-01,0.1676D-01,0.1509D-01,
     &0.1343D-01,0.1172D-01,0.9883D-02,0.7845D-02,0.5581D-02,0.3172D-02,
     &0.2910D-02,0.2656D-02,0.2408D-02,0.2169D-02,0.1937D-02,0.1717D-02,
     &0.1503D-02,0.1304D-02,0.1115D-02,0.9399D-03,0.7768D-03,0.6289D-03,
     &0.4947D-03,0.3769D-03,0.2741D-03,0.1885D-03,0.1190D-03,0.6665D-04,
     &0.2993D-04,0.1309D-04,0.5951D-05,0.8951D-05/
      DATA (XPV(I,6,1),I=1,100)/
     &0.2693D-01,0.2590D-01,0.2489D-01,0.2390D-01,0.2298D-01,0.2207D-01,
     &0.2118D-01,0.2035D-01,0.1954D-01,0.1874D-01,0.1800D-01,0.1728D-01,
     &0.1656D-01,0.1590D-01,0.1525D-01,0.1462D-01,0.1402D-01,0.1344D-01,
     &0.1288D-01,0.1235D-01,0.1184D-01,0.1134D-01,0.1087D-01,0.1041D-01,
     &0.9974D-02,0.9562D-02,0.9162D-02,0.8773D-02,0.8412D-02,0.8064D-02,
     &0.7726D-02,0.7409D-02,0.7109D-02,0.6821D-02,0.6545D-02,0.6290D-02,
     &0.6047D-02,0.5816D-02,0.5600D-02,0.5401D-02,0.5215D-02,0.5039D-02,
     &0.4878D-02,0.4745D-02,0.4605D-02,0.4483D-02,0.4379D-02,0.4284D-02,
     &0.4198D-02,0.4126D-02,0.4065D-02,0.4016D-02,0.3978D-02,0.3950D-02,
     &0.3926D-02,0.3916D-02,0.3914D-02,0.3919D-02,0.3932D-02,0.3950D-02,
     &0.3974D-02,0.4003D-02,0.4038D-02,0.4077D-02,0.4120D-02,0.4169D-02,
     &0.4224D-02,0.4287D-02,0.4360D-02,0.4445D-02,0.4547D-02,0.4671D-02,
     &0.4824D-02,0.5016D-02,0.5261D-02,0.5573D-02,0.5961D-02,0.6401D-02,
     &0.6449D-02,0.6495D-02,0.6539D-02,0.6580D-02,0.6619D-02,0.6653D-02,
     &0.6683D-02,0.6708D-02,0.6727D-02,0.6738D-02,0.6742D-02,0.6735D-02,
     &0.6716D-02,0.6682D-02,0.6630D-02,0.6554D-02,0.6450D-02,0.6305D-02,
     &0.6100D-02,0.5879D-02,0.5316D-02,0.4016D-02/
      DATA (XPV(I,6,2),I=1,100)/
     &0.2692D-01,0.2589D-01,0.2488D-01,0.2389D-01,0.2297D-01,0.2206D-01,
     &0.2117D-01,0.2034D-01,0.1953D-01,0.1873D-01,0.1798D-01,0.1726D-01,
     &0.1654D-01,0.1588D-01,0.1522D-01,0.1459D-01,0.1399D-01,0.1341D-01,
     &0.1284D-01,0.1231D-01,0.1180D-01,0.1129D-01,0.1082D-01,0.1036D-01,
     &0.9909D-02,0.9490D-02,0.9083D-02,0.8686D-02,0.8316D-02,0.7959D-02,
     &0.7611D-02,0.7283D-02,0.6970D-02,0.6668D-02,0.6378D-02,0.6106D-02,
     &0.5845D-02,0.5595D-02,0.5358D-02,0.5135D-02,0.4923D-02,0.4720D-02,
     &0.4529D-02,0.4363D-02,0.4187D-02,0.4026D-02,0.3880D-02,0.3739D-02,
     &0.3603D-02,0.3478D-02,0.3360D-02,0.3248D-02,0.3143D-02,0.3044D-02,
     &0.2944D-02,0.2853D-02,0.2766D-02,0.2680D-02,0.2597D-02,0.2515D-02,
     &0.2435D-02,0.2356D-02,0.2280D-02,0.2204D-02,0.2130D-02,0.2060D-02,
     &0.1995D-02,0.1934D-02,0.1881D-02,0.1834D-02,0.1795D-02,0.1764D-02,
     &0.1739D-02,0.1720D-02,0.1706D-02,0.1698D-02,0.1697D-02,0.1707D-02,
     &0.1708D-02,0.1709D-02,0.1711D-02,0.1711D-02,0.1712D-02,0.1712D-02,
     &0.1712D-02,0.1710D-02,0.1708D-02,0.1704D-02,0.1700D-02,0.1692D-02,
     &0.1683D-02,0.1670D-02,0.1653D-02,0.1631D-02,0.1603D-02,0.1564D-02,
     &0.1512D-02,0.1455D-02,0.1312D-02,0.9886D-03/
      DATA (XPV(I,6,3),I=1,100)/
     &0.2696D-01,0.2594D-01,0.2493D-01,0.2395D-01,0.2302D-01,0.2212D-01,
     &0.2124D-01,0.2041D-01,0.1960D-01,0.1881D-01,0.1807D-01,0.1735D-01,
     &0.1664D-01,0.1598D-01,0.1533D-01,0.1470D-01,0.1411D-01,0.1354D-01,
     &0.1298D-01,0.1246D-01,0.1195D-01,0.1145D-01,0.1099D-01,0.1054D-01,
     &0.1010D-01,0.9691D-02,0.9294D-02,0.8909D-02,0.8550D-02,0.8204D-02,
     &0.7868D-02,0.7552D-02,0.7251D-02,0.6962D-02,0.6684D-02,0.6425D-02,
     &0.6177D-02,0.5939D-02,0.5714D-02,0.5503D-02,0.5303D-02,0.5111D-02,
     &0.4930D-02,0.4774D-02,0.4606D-02,0.4452D-02,0.4312D-02,0.4176D-02,
     &0.4042D-02,0.3918D-02,0.3798D-02,0.3683D-02,0.3571D-02,0.3464D-02,
     &0.3351D-02,0.3245D-02,0.3141D-02,0.3035D-02,0.2930D-02,0.2823D-02,
     &0.2716D-02,0.2609D-02,0.2504D-02,0.2398D-02,0.2295D-02,0.2196D-02,
     &0.2104D-02,0.2019D-02,0.1944D-02,0.1879D-02,0.1825D-02,0.1782D-02,
     &0.1749D-02,0.1725D-02,0.1708D-02,0.1698D-02,0.1697D-02,0.1707D-02,
     &0.1708D-02,0.1709D-02,0.1711D-02,0.1711D-02,0.1712D-02,0.1712D-02,
     &0.1712D-02,0.1710D-02,0.1708D-02,0.1704D-02,0.1700D-02,0.1692D-02,
     &0.1683D-02,0.1670D-02,0.1653D-02,0.1631D-02,0.1603D-02,0.1564D-02,
     &0.1512D-02,0.1455D-02,0.1312D-02,0.9886D-03/
      DATA (XPV(I,6,4),I=1,100)/
     &0.2676D-01,0.2573D-01,0.2472D-01,0.2373D-01,0.2280D-01,0.2189D-01,
     &0.2101D-01,0.2018D-01,0.1936D-01,0.1857D-01,0.1782D-01,0.1709D-01,
     &0.1638D-01,0.1571D-01,0.1506D-01,0.1442D-01,0.1382D-01,0.1324D-01,
     &0.1267D-01,0.1213D-01,0.1161D-01,0.1110D-01,0.1063D-01,0.1016D-01,
     &0.9714D-02,0.9291D-02,0.8880D-02,0.8479D-02,0.8104D-02,0.7741D-02,
     &0.7388D-02,0.7054D-02,0.6735D-02,0.6427D-02,0.6131D-02,0.5854D-02,
     &0.5587D-02,0.5331D-02,0.5088D-02,0.4860D-02,0.4644D-02,0.4438D-02,
     &0.4244D-02,0.4076D-02,0.3901D-02,0.3742D-02,0.3601D-02,0.3468D-02,
     &0.3343D-02,0.3232D-02,0.3133D-02,0.3046D-02,0.2971D-02,0.2908D-02,
     &0.2852D-02,0.2812D-02,0.2784D-02,0.2766D-02,0.2760D-02,0.2764D-02,
     &0.2779D-02,0.2803D-02,0.2838D-02,0.2881D-02,0.2931D-02,0.2989D-02,
     &0.3054D-02,0.3126D-02,0.3205D-02,0.3293D-02,0.3394D-02,0.3513D-02,
     &0.3660D-02,0.3850D-02,0.4103D-02,0.4446D-02,0.4907D-02,0.5494D-02,
     &0.5564D-02,0.5634D-02,0.5703D-02,0.5770D-02,0.5836D-02,0.5899D-02,
     &0.5960D-02,0.6016D-02,0.6069D-02,0.6115D-02,0.6155D-02,0.6187D-02,
     &0.6208D-02,0.6216D-02,0.6209D-02,0.6180D-02,0.6125D-02,0.6033D-02,
     &0.5886D-02,0.5722D-02,0.5226D-02,0.4038D-02/
      DATA (XPV(I,7,0),I=1,100)/
     &0.1677D+01,0.1599D+01,0.1523D+01,0.1449D+01,0.1381D+01,0.1314D+01,
     &0.1249D+01,0.1189D+01,0.1131D+01,0.1074D+01,0.1022D+01,0.9709D+00,
     &0.9215D+00,0.8757D+00,0.8313D+00,0.7884D+00,0.7484D+00,0.7098D+00,
     &0.6725D+00,0.6378D+00,0.6043D+00,0.5717D+00,0.5418D+00,0.5126D+00,
     &0.4847D+00,0.4586D+00,0.4335D+00,0.4092D+00,0.3867D+00,0.3651D+00,
     &0.3443D+00,0.3247D+00,0.3062D+00,0.2884D+00,0.2714D+00,0.2555D+00,
     &0.2403D+00,0.2257D+00,0.2120D+00,0.1991D+00,0.1868D+00,0.1751D+00,
     &0.1640D+00,0.1541D+00,0.1439D+00,0.1345D+00,0.1258D+00,0.1174D+00,
     &0.1094D+00,0.1019D+00,0.9482D-01,0.8815D-01,0.8185D-01,0.7594D-01,
     &0.7018D-01,0.6493D-01,0.5999D-01,0.5532D-01,0.5095D-01,0.4685D-01,
     &0.4299D-01,0.3941D-01,0.3609D-01,0.3294D-01,0.3001D-01,0.2728D-01,
     &0.2475D-01,0.2237D-01,0.2014D-01,0.1804D-01,0.1603D-01,0.1408D-01,
     &0.1216D-01,0.1023D-01,0.8245D-02,0.6190D-02,0.4106D-02,0.2133D-02,
     &0.1935D-02,0.1745D-02,0.1564D-02,0.1393D-02,0.1230D-02,0.1078D-02,
     &0.9340D-03,0.8018D-03,0.6796D-03,0.5685D-03,0.4677D-03,0.3782D-03,
     &0.2992D-03,0.2312D-03,0.1736D-03,0.1264D-03,0.8864D-04,0.6022D-04,
     &0.3944D-04,0.2460D-04,0.1450D-04,0.2966D-05/
      DATA (XPV(I,7,1),I=1,100)/
     &0.3968D-01,0.3804D-01,0.3644D-01,0.3488D-01,0.3341D-01,0.3198D-01,
     &0.3060D-01,0.2930D-01,0.2803D-01,0.2680D-01,0.2565D-01,0.2453D-01,
     &0.2343D-01,0.2242D-01,0.2142D-01,0.2046D-01,0.1956D-01,0.1868D-01,
     &0.1783D-01,0.1704D-01,0.1627D-01,0.1552D-01,0.1483D-01,0.1415D-01,
     &0.1350D-01,0.1289D-01,0.1231D-01,0.1174D-01,0.1121D-01,0.1070D-01,
     &0.1021D-01,0.9747D-02,0.9311D-02,0.8894D-02,0.8496D-02,0.8127D-02,
     &0.7777D-02,0.7443D-02,0.7132D-02,0.6844D-02,0.6574D-02,0.6320D-02,
     &0.6086D-02,0.5889D-02,0.5684D-02,0.5503D-02,0.5347D-02,0.5204D-02,
     &0.5072D-02,0.4959D-02,0.4862D-02,0.4780D-02,0.4712D-02,0.4660D-02,
     &0.4612D-02,0.4585D-02,0.4569D-02,0.4563D-02,0.4568D-02,0.4582D-02,
     &0.4605D-02,0.4636D-02,0.4677D-02,0.4723D-02,0.4776D-02,0.4838D-02,
     &0.4908D-02,0.4987D-02,0.5076D-02,0.5180D-02,0.5302D-02,0.5448D-02,
     &0.5628D-02,0.5855D-02,0.6147D-02,0.6522D-02,0.6993D-02,0.7534D-02,
     &0.7594D-02,0.7651D-02,0.7705D-02,0.7756D-02,0.7805D-02,0.7847D-02,
     &0.7886D-02,0.7917D-02,0.7942D-02,0.7958D-02,0.7964D-02,0.7958D-02,
     &0.7937D-02,0.7898D-02,0.7839D-02,0.7751D-02,0.7629D-02,0.7460D-02,
     &0.7219D-02,0.6959D-02,0.6295D-02,0.4764D-02/
      DATA (XPV(I,7,2),I=1,100)/
     &0.3967D-01,0.3803D-01,0.3643D-01,0.3486D-01,0.3340D-01,0.3197D-01,
     &0.3058D-01,0.2928D-01,0.2801D-01,0.2678D-01,0.2562D-01,0.2450D-01,
     &0.2341D-01,0.2239D-01,0.2139D-01,0.2042D-01,0.1952D-01,0.1864D-01,
     &0.1779D-01,0.1699D-01,0.1622D-01,0.1546D-01,0.1476D-01,0.1408D-01,
     &0.1342D-01,0.1280D-01,0.1221D-01,0.1163D-01,0.1109D-01,0.1057D-01,
     &0.1006D-01,0.9587D-02,0.9136D-02,0.8701D-02,0.8285D-02,0.7896D-02,
     &0.7524D-02,0.7166D-02,0.6828D-02,0.6511D-02,0.6211D-02,0.5923D-02,
     &0.5651D-02,0.5414D-02,0.5166D-02,0.4937D-02,0.4730D-02,0.4531D-02,
     &0.4339D-02,0.4161D-02,0.3994D-02,0.3837D-02,0.3689D-02,0.3551D-02,
     &0.3412D-02,0.3287D-02,0.3168D-02,0.3053D-02,0.2944D-02,0.2838D-02,
     &0.2736D-02,0.2639D-02,0.2547D-02,0.2456D-02,0.2371D-02,0.2290D-02,
     &0.2216D-02,0.2149D-02,0.2089D-02,0.2036D-02,0.1992D-02,0.1956D-02,
     &0.1927D-02,0.1907D-02,0.1898D-02,0.1901D-02,0.1923D-02,0.1966D-02,
     &0.1971D-02,0.1977D-02,0.1982D-02,0.1987D-02,0.1991D-02,0.1995D-02,
     &0.1998D-02,0.1999D-02,0.2000D-02,0.1999D-02,0.1996D-02,0.1990D-02,
     &0.1981D-02,0.1968D-02,0.1951D-02,0.1927D-02,0.1894D-02,0.1851D-02,
     &0.1790D-02,0.1723D-02,0.1556D-02,0.1179D-02/
      DATA (XPV(I,7,3),I=1,100)/
     &0.3972D-01,0.3809D-01,0.3648D-01,0.3492D-01,0.3346D-01,0.3204D-01,
     &0.3065D-01,0.2936D-01,0.2810D-01,0.2686D-01,0.2572D-01,0.2460D-01,
     &0.2351D-01,0.2250D-01,0.2151D-01,0.2055D-01,0.1965D-01,0.1878D-01,
     &0.1793D-01,0.1714D-01,0.1638D-01,0.1563D-01,0.1494D-01,0.1427D-01,
     &0.1362D-01,0.1301D-01,0.1243D-01,0.1186D-01,0.1133D-01,0.1082D-01,
     &0.1033D-01,0.9865D-02,0.9426D-02,0.9004D-02,0.8600D-02,0.8223D-02,
     &0.7863D-02,0.7517D-02,0.7191D-02,0.6885D-02,0.6594D-02,0.6316D-02,
     &0.6054D-02,0.5826D-02,0.5584D-02,0.5361D-02,0.5158D-02,0.4962D-02,
     &0.4770D-02,0.4591D-02,0.4421D-02,0.4258D-02,0.4102D-02,0.3953D-02,
     &0.3801D-02,0.3660D-02,0.3523D-02,0.3387D-02,0.3255D-02,0.3124D-02,
     &0.2996D-02,0.2871D-02,0.2751D-02,0.2632D-02,0.2519D-02,0.2411D-02,
     &0.2313D-02,0.2223D-02,0.2143D-02,0.2074D-02,0.2017D-02,0.1971D-02,
     &0.1935D-02,0.1911D-02,0.1899D-02,0.1901D-02,0.1923D-02,0.1966D-02,
     &0.1971D-02,0.1977D-02,0.1982D-02,0.1987D-02,0.1991D-02,0.1995D-02,
     &0.1998D-02,0.1999D-02,0.2000D-02,0.1999D-02,0.1996D-02,0.1990D-02,
     &0.1981D-02,0.1968D-02,0.1951D-02,0.1927D-02,0.1894D-02,0.1851D-02,
     &0.1790D-02,0.1723D-02,0.1556D-02,0.1179D-02/
      DATA (XPV(I,7,4),I=1,100)/
     &0.3951D-01,0.3787D-01,0.3626D-01,0.3470D-01,0.3324D-01,0.3181D-01,
     &0.3042D-01,0.2912D-01,0.2785D-01,0.2661D-01,0.2546D-01,0.2434D-01,
     &0.2324D-01,0.2222D-01,0.2122D-01,0.2025D-01,0.1935D-01,0.1847D-01,
     &0.1761D-01,0.1681D-01,0.1604D-01,0.1528D-01,0.1458D-01,0.1389D-01,
     &0.1323D-01,0.1261D-01,0.1201D-01,0.1142D-01,0.1088D-01,0.1036D-01,
     &0.9848D-02,0.9370D-02,0.8915D-02,0.8477D-02,0.8057D-02,0.7665D-02,
     &0.7290D-02,0.6930D-02,0.6592D-02,0.6274D-02,0.5975D-02,0.5689D-02,
     &0.5422D-02,0.5191D-02,0.4951D-02,0.4734D-02,0.4541D-02,0.4361D-02,
     &0.4191D-02,0.4042D-02,0.3908D-02,0.3791D-02,0.3689D-02,0.3604D-02,
     &0.3528D-02,0.3474D-02,0.3435D-02,0.3410D-02,0.3400D-02,0.3403D-02,
     &0.3420D-02,0.3450D-02,0.3493D-02,0.3545D-02,0.3608D-02,0.3680D-02,
     &0.3761D-02,0.3850D-02,0.3949D-02,0.4059D-02,0.4184D-02,0.4334D-02,
     &0.4519D-02,0.4757D-02,0.5073D-02,0.5499D-02,0.6065D-02,0.6768D-02,
     &0.6851D-02,0.6932D-02,0.7012D-02,0.7089D-02,0.7164D-02,0.7236D-02,
     &0.7303D-02,0.7366D-02,0.7422D-02,0.7470D-02,0.7510D-02,0.7539D-02,
     &0.7554D-02,0.7553D-02,0.7532D-02,0.7484D-02,0.7404D-02,0.7276D-02,
     &0.7082D-02,0.6866D-02,0.6248D-02,0.4789D-02/

C..fetching pdfs
      DO  5 IP=-6,6
        XPDF(IP)=ZEROD
 5    CONTINUE
      DO 2 I=1,IX
        ENT(I)=LOG10(XT(I))
  2   CONTINUE
      NA(1)=IX
      NA(2)=IQ
      DO 3 I=1,IQ
        ENT(IX+I)=LOG10(Q2T(I))
   3  CONTINUE
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(Q2)
C..VARIOUS FLAVOURS (u-->2,d-->1)
      XPDF(0)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,0))
      XPDF(1)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,2))
      XPDF(2)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,1))
      XPDF(3)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,3))
      XPDF(4)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,4))
      DO 21 JF=1,4
        XPDF(-JF)=XPDF(JF)
 21   CONTINUE
      RETURN
      END
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      SUBROUTINE PHGAL(X,Q2,XPDF)
      implicit real*8 (a-h,o-z)
      PARAMETER(IX=100,IQ=7,NARG=2,NFUN=4)
      double precision
     +       DBFINT,
     +       XT(IX),Q2T(IQ),ARG(NARG),ENT(IX+IQ),
     +       XPV(IX,IQ,0:NFUN),XPDF(-6:6)
      DIMENSION NA(NARG)
      DATA ZEROD/0.D0/
C...100 x values; in (D-4,.77) log spaced (78 points)
C...              in (.78,.995) lineary spaced (22 points)
      DATA Q2T/4.D0,10.D0,50.D0,1.D2,1.D3,1.D4,1.D5/
      DATA XT/
     &0.1000D-03,0.1123D-03,0.1262D-03,0.1417D-03,0.1592D-03,0.1789D-03,
     &0.2009D-03,0.2257D-03,0.2535D-03,0.2848D-03,0.3199D-03,0.3593D-03,
     &0.4037D-03,0.4534D-03,0.5093D-03,0.5722D-03,0.6427D-03,0.7220D-03,
     &0.8110D-03,0.9110D-03,0.1023D-02,0.1150D-02,0.1291D-02,0.1451D-02,
     &0.1629D-02,0.1830D-02,0.2056D-02,0.2310D-02,0.2594D-02,0.2914D-02,
     &0.3274D-02,0.3677D-02,0.4131D-02,0.4640D-02,0.5212D-02,0.5855D-02,
     &0.6577D-02,0.7388D-02,0.8299D-02,0.9323D-02,0.1047D-01,0.1176D-01,
     &0.1321D-01,0.1484D-01,0.1667D-01,0.1873D-01,0.2104D-01,0.2363D-01,
     &0.2655D-01,0.2982D-01,0.3350D-01,0.3763D-01,0.4227D-01,0.4748D-01,
     &0.5334D-01,0.5992D-01,0.6731D-01,0.7560D-01,0.8493D-01,0.9540D-01,
     &0.1072D+00,0.1204D+00,0.1352D+00,0.1519D+00,0.1706D+00,0.1917D+00,
     &0.2153D+00,0.2419D+00,0.2717D+00,0.3052D+00,0.3428D+00,0.3851D+00,
     &0.4326D+00,0.4859D+00,0.5458D+00,0.6131D+00,0.6887D+00,0.7737D+00,
     &0.7837D+00,0.7937D+00,0.8037D+00,0.8137D+00,0.8237D+00,0.8337D+00,
     &0.8437D+00,0.8537D+00,0.8637D+00,0.8737D+00,0.8837D+00,0.8937D+00,
     &0.9037D+00,0.9137D+00,0.9237D+00,0.9337D+00,0.9437D+00,0.9537D+00,
     &0.9637D+00,0.9737D+00,0.9837D+00,0.9937D+00/

C...place for DATA blocks
      DATA (XPV(I,1,0),I=1,100)/
     &0.6632D-01,0.6536D-01,0.6390D-01,0.6196D-01,0.5952D-01,0.5663D-01,
     &0.5339D-01,0.5124D-01,0.5029D-01,0.4893D-01,0.4718D-01,0.4505D-01,
     &0.4259D-01,0.4038D-01,0.3966D-01,0.3860D-01,0.3721D-01,0.3551D-01,
     &0.3354D-01,0.3206D-01,0.3134D-01,0.3031D-01,0.2902D-01,0.2747D-01,
     &0.2608D-01,0.2543D-01,0.2451D-01,0.2335D-01,0.2202D-01,0.2132D-01,
     &0.2051D-01,0.1950D-01,0.1851D-01,0.1783D-01,0.1696D-01,0.1609D-01,
     &0.1539D-01,0.1454D-01,0.1386D-01,0.1310D-01,0.1242D-01,0.1169D-01,
     &0.1104D-01,0.1036D-01,0.9694D-02,0.9046D-02,0.8400D-02,0.7792D-02,
     &0.7173D-02,0.6573D-02,0.5978D-02,0.5411D-02,0.4853D-02,0.4307D-02,
     &0.3791D-02,0.3292D-02,0.2818D-02,0.2382D-02,0.1976D-02,0.1606D-02,
     &0.1275D-02,0.9866D-03,0.7403D-03,0.5351D-03,0.3713D-03,0.2450D-03,
     &0.1524D-03,0.8849D-04,0.4730D-04,0.2278D-04,0.9707D-05,0.3518D-05,
     &0.1041D-05,0.2356D-06,0.3682D-07,0.3365D-08,0.1333D-09,0.1188D-11,
     &0.6095D-12,0.3031D-12,0.1457D-12,0.6733D-13,0.2986D-13,0.1262D-13,
     &0.5060D-14,0.1912D-14,0.6734D-15,0.2199D-15,0.6498D-16,0.1729D-16,
     &0.4059D-17,0.8091D-18,0.1324D-18,0.1691D-19,0.1518D-20,0.8785D-22,
     &0.2519D-23,0.2197D-25,0.2840D-28,0.1908D-33/
      DATA (XPV(I,1,1),I=1,100)/
     &0.5848D-03,0.5838D-03,0.5793D-03,0.5713D-03,0.5597D-03,0.5447D-03,
     &0.5270D-03,0.5167D-03,0.5143D-03,0.5087D-03,0.4998D-03,0.4879D-03,
     &0.4731D-03,0.4599D-03,0.4584D-03,0.4538D-03,0.4461D-03,0.4355D-03,
     &0.4223D-03,0.4133D-03,0.4109D-03,0.4053D-03,0.3970D-03,0.3859D-03,
     &0.3763D-03,0.3739D-03,0.3686D-03,0.3605D-03,0.3504D-03,0.3473D-03,
     &0.3426D-03,0.3355D-03,0.3286D-03,0.3253D-03,0.3196D-03,0.3138D-03,
     &0.3102D-03,0.3047D-03,0.3014D-03,0.2971D-03,0.2939D-03,0.2901D-03,
     &0.2875D-03,0.2849D-03,0.2824D-03,0.2805D-03,0.2787D-03,0.2780D-03,
     &0.2772D-03,0.2771D-03,0.2773D-03,0.2784D-03,0.2799D-03,0.2820D-03,
     &0.2850D-03,0.2886D-03,0.2930D-03,0.2985D-03,0.3050D-03,0.3126D-03,
     &0.3215D-03,0.3316D-03,0.3432D-03,0.3564D-03,0.3714D-03,0.3883D-03,
     &0.4073D-03,0.4287D-03,0.4526D-03,0.4794D-03,0.5092D-03,0.5425D-03,
     &0.5796D-03,0.6207D-03,0.6664D-03,0.7171D-03,0.7733D-03,0.8356D-03,
     &0.8429D-03,0.8502D-03,0.8574D-03,0.8647D-03,0.8719D-03,0.8791D-03,
     &0.8863D-03,0.8935D-03,0.9007D-03,0.9079D-03,0.9151D-03,0.9222D-03,
     &0.9294D-03,0.9365D-03,0.9436D-03,0.9508D-03,0.9579D-03,0.9650D-03,
     &0.9720D-03,0.9791D-03,0.9862D-03,0.9932D-03/
      DATA (XPV(I,1,2),I=1,100)/
     &0.2339D-02,0.2335D-02,0.2317D-02,0.2285D-02,0.2239D-02,0.2179D-02,
     &0.2108D-02,0.2067D-02,0.2057D-02,0.2035D-02,0.1999D-02,0.1951D-02,
     &0.1892D-02,0.1840D-02,0.1833D-02,0.1815D-02,0.1784D-02,0.1742D-02,
     &0.1689D-02,0.1653D-02,0.1643D-02,0.1621D-02,0.1588D-02,0.1544D-02,
     &0.1505D-02,0.1496D-02,0.1474D-02,0.1442D-02,0.1402D-02,0.1389D-02,
     &0.1370D-02,0.1342D-02,0.1314D-02,0.1301D-02,0.1278D-02,0.1255D-02,
     &0.1241D-02,0.1219D-02,0.1205D-02,0.1188D-02,0.1176D-02,0.1160D-02,
     &0.1150D-02,0.1139D-02,0.1130D-02,0.1122D-02,0.1115D-02,0.1112D-02,
     &0.1109D-02,0.1108D-02,0.1109D-02,0.1114D-02,0.1120D-02,0.1128D-02,
     &0.1140D-02,0.1154D-02,0.1172D-02,0.1194D-02,0.1220D-02,0.1251D-02,
     &0.1286D-02,0.1326D-02,0.1373D-02,0.1426D-02,0.1485D-02,0.1553D-02,
     &0.1629D-02,0.1715D-02,0.1811D-02,0.1917D-02,0.2037D-02,0.2170D-02,
     &0.2318D-02,0.2483D-02,0.2666D-02,0.2868D-02,0.3093D-02,0.3342D-02,
     &0.3372D-02,0.3401D-02,0.3430D-02,0.3459D-02,0.3488D-02,0.3517D-02,
     &0.3545D-02,0.3574D-02,0.3603D-02,0.3632D-02,0.3660D-02,0.3689D-02,
     &0.3717D-02,0.3746D-02,0.3775D-02,0.3803D-02,0.3831D-02,0.3860D-02,
     &0.3888D-02,0.3916D-02,0.3945D-02,0.3973D-02/
      DATA (XPV(I,1,3),I=1,100)/
     &0.1755D-03,0.1751D-03,0.1738D-03,0.1714D-03,0.1679D-03,0.1634D-03,
     &0.1581D-03,0.1550D-03,0.1543D-03,0.1526D-03,0.1499D-03,0.1464D-03,
     &0.1419D-03,0.1380D-03,0.1375D-03,0.1361D-03,0.1338D-03,0.1306D-03,
     &0.1267D-03,0.1240D-03,0.1233D-03,0.1216D-03,0.1191D-03,0.1158D-03,
     &0.1129D-03,0.1122D-03,0.1106D-03,0.1082D-03,0.1051D-03,0.1042D-03,
     &0.1028D-03,0.1006D-03,0.9857D-04,0.9759D-04,0.9587D-04,0.9414D-04,
     &0.9305D-04,0.9140D-04,0.9041D-04,0.8912D-04,0.8817D-04,0.8702D-04,
     &0.8626D-04,0.8546D-04,0.8472D-04,0.8415D-04,0.8362D-04,0.8339D-04,
     &0.8317D-04,0.8312D-04,0.8318D-04,0.8352D-04,0.8398D-04,0.8459D-04,
     &0.8550D-04,0.8658D-04,0.8789D-04,0.8956D-04,0.9151D-04,0.9379D-04,
     &0.9644D-04,0.9948D-04,0.1030D-03,0.1069D-03,0.1114D-03,0.1165D-03,
     &0.1222D-03,0.1286D-03,0.1358D-03,0.1438D-03,0.1528D-03,0.1628D-03,
     &0.1739D-03,0.1862D-03,0.1999D-03,0.2151D-03,0.2320D-03,0.2507D-03,
     &0.2529D-03,0.2551D-03,0.2572D-03,0.2594D-03,0.2616D-03,0.2637D-03,
     &0.2659D-03,0.2681D-03,0.2702D-03,0.2724D-03,0.2745D-03,0.2767D-03,
     &0.2788D-03,0.2810D-03,0.2831D-03,0.2852D-03,0.2874D-03,0.2895D-03,
     &0.2916D-03,0.2937D-03,0.2959D-03,0.2980D-03/
      DATA (XPV(I,1,4),I=1,100)/
     &0.7018D-03,0.7006D-03,0.6951D-03,0.6855D-03,0.6716D-03,0.6537D-03,
     &0.6324D-03,0.6200D-03,0.6172D-03,0.6104D-03,0.5998D-03,0.5854D-03,
     &0.5677D-03,0.5519D-03,0.5500D-03,0.5445D-03,0.5353D-03,0.5226D-03,
     &0.5068D-03,0.4960D-03,0.4930D-03,0.4864D-03,0.4764D-03,0.4631D-03,
     &0.4516D-03,0.4487D-03,0.4423D-03,0.4326D-03,0.4205D-03,0.4167D-03,
     &0.4111D-03,0.4026D-03,0.3943D-03,0.3903D-03,0.3835D-03,0.3765D-03,
     &0.3722D-03,0.3656D-03,0.3616D-03,0.3565D-03,0.3527D-03,0.3481D-03,
     &0.3450D-03,0.3418D-03,0.3389D-03,0.3366D-03,0.3345D-03,0.3336D-03,
     &0.3327D-03,0.3325D-03,0.3327D-03,0.3341D-03,0.3359D-03,0.3383D-03,
     &0.3420D-03,0.3463D-03,0.3516D-03,0.3582D-03,0.3660D-03,0.3752D-03,
     &0.3858D-03,0.3979D-03,0.4118D-03,0.4277D-03,0.4456D-03,0.4660D-03,
     &0.4887D-03,0.5145D-03,0.5432D-03,0.5752D-03,0.6111D-03,0.6510D-03,
     &0.6955D-03,0.7448D-03,0.7997D-03,0.8605D-03,0.9280D-03,0.1003D-02,
     &0.1011D-02,0.1020D-02,0.1029D-02,0.1038D-02,0.1046D-02,0.1055D-02,
     &0.1064D-02,0.1072D-02,0.1081D-02,0.1089D-02,0.1098D-02,0.1107D-02,
     &0.1115D-02,0.1124D-02,0.1132D-02,0.1141D-02,0.1149D-02,0.1158D-02,
     &0.1166D-02,0.1175D-02,0.1183D-02,0.1192D-02/
      DATA (XPV(I,2,0),I=1,100)/
     &0.1024D+00,0.1007D+00,0.9821D-01,0.9497D-01,0.9093D-01,0.8617D-01,
     &0.8086D-01,0.7731D-01,0.7566D-01,0.7338D-01,0.7048D-01,0.6700D-01,
     &0.6300D-01,0.5939D-01,0.5814D-01,0.5638D-01,0.5410D-01,0.5135D-01,
     &0.4819D-01,0.4580D-01,0.4460D-01,0.4293D-01,0.4087D-01,0.3843D-01,
     &0.3624D-01,0.3517D-01,0.3372D-01,0.3192D-01,0.2988D-01,0.2879D-01,
     &0.2755D-01,0.2602D-01,0.2454D-01,0.2352D-01,0.2224D-01,0.2097D-01,
     &0.1995D-01,0.1875D-01,0.1779D-01,0.1673D-01,0.1580D-01,0.1480D-01,
     &0.1393D-01,0.1305D-01,0.1218D-01,0.1136D-01,0.1055D-01,0.9801D-02,
     &0.9052D-02,0.8337D-02,0.7641D-02,0.6989D-02,0.6357D-02,0.5747D-02,
     &0.5179D-02,0.4637D-02,0.4127D-02,0.3663D-02,0.3232D-02,0.2840D-02,
     &0.2487D-02,0.2174D-02,0.1901D-02,0.1662D-02,0.1459D-02,0.1285D-02,
     &0.1137D-02,0.1010D-02,0.9006D-03,0.8023D-03,0.7126D-03,0.6276D-03,
     &0.5458D-03,0.4661D-03,0.3876D-03,0.3101D-03,0.2334D-03,0.1570D-03,
     &0.1486D-03,0.1404D-03,0.1322D-03,0.1242D-03,0.1162D-03,0.1084D-03,
     &0.1007D-03,0.9304D-04,0.8554D-04,0.7817D-04,0.7086D-04,0.6372D-04,
     &0.5670D-04,0.4982D-04,0.4307D-04,0.3647D-04,0.3005D-04,0.2382D-04,
     &0.1781D-04,0.1208D-04,0.6720D-05,0.1928D-05/
      DATA (XPV(I,2,1),I=1,100)/
     &0.1449D-02,0.1433D-02,0.1407D-02,0.1370D-02,0.1324D-02,0.1268D-02,
     &0.1204D-02,0.1163D-02,0.1147D-02,0.1123D-02,0.1089D-02,0.1048D-02,
     &0.1000D-02,0.9567D-03,0.9446D-03,0.9250D-03,0.8981D-03,0.8642D-03,
     &0.8244D-03,0.7951D-03,0.7821D-03,0.7623D-03,0.7362D-03,0.7043D-03,
     &0.6759D-03,0.6640D-03,0.6459D-03,0.6223D-03,0.5945D-03,0.5817D-03,
     &0.5660D-03,0.5455D-03,0.5256D-03,0.5132D-03,0.4963D-03,0.4794D-03,
     &0.4669D-03,0.4510D-03,0.4394D-03,0.4261D-03,0.4151D-03,0.4031D-03,
     &0.3934D-03,0.3838D-03,0.3747D-03,0.3666D-03,0.3591D-03,0.3533D-03,
     &0.3477D-03,0.3433D-03,0.3397D-03,0.3376D-03,0.3364D-03,0.3361D-03,
     &0.3375D-03,0.3399D-03,0.3437D-03,0.3492D-03,0.3562D-03,0.3648D-03,
     &0.3751D-03,0.3871D-03,0.4009D-03,0.4167D-03,0.4344D-03,0.4543D-03,
     &0.4760D-03,0.5003D-03,0.5268D-03,0.5558D-03,0.5876D-03,0.6226D-03,
     &0.6610D-03,0.7035D-03,0.7509D-03,0.8041D-03,0.8638D-03,0.9294D-03,
     &0.9367D-03,0.9440D-03,0.9511D-03,0.9581D-03,0.9648D-03,0.9714D-03,
     &0.9776D-03,0.9836D-03,0.9891D-03,0.9942D-03,0.9987D-03,0.1003D-02,
     &0.1006D-02,0.1008D-02,0.1008D-02,0.1007D-02,0.1004D-02,0.9977D-03,
     &0.9868D-03,0.9681D-03,0.9347D-03,0.8678D-03/
      DATA (XPV(I,2,2),I=1,100)/
     &0.3175D-02,0.3156D-02,0.3117D-02,0.3057D-02,0.2976D-02,0.2876D-02,
     &0.2760D-02,0.2689D-02,0.2666D-02,0.2625D-02,0.2566D-02,0.2489D-02,
     &0.2398D-02,0.2316D-02,0.2299D-02,0.2266D-02,0.2217D-02,0.2152D-02,
     &0.2073D-02,0.2018D-02,0.1998D-02,0.1962D-02,0.1911D-02,0.1847D-02,
     &0.1791D-02,0.1773D-02,0.1739D-02,0.1692D-02,0.1636D-02,0.1614D-02,
     &0.1586D-02,0.1545D-02,0.1506D-02,0.1485D-02,0.1452D-02,0.1420D-02,
     &0.1398D-02,0.1368D-02,0.1348D-02,0.1324D-02,0.1306D-02,0.1285D-02,
     &0.1271D-02,0.1256D-02,0.1243D-02,0.1233D-02,0.1224D-02,0.1220D-02,
     &0.1217D-02,0.1217D-02,0.1220D-02,0.1227D-02,0.1237D-02,0.1249D-02,
     &0.1267D-02,0.1288D-02,0.1313D-02,0.1345D-02,0.1381D-02,0.1422D-02,
     &0.1469D-02,0.1522D-02,0.1582D-02,0.1648D-02,0.1722D-02,0.1804D-02,
     &0.1893D-02,0.1992D-02,0.2099D-02,0.2216D-02,0.2345D-02,0.2486D-02,
     &0.2641D-02,0.2812D-02,0.3002D-02,0.3216D-02,0.3455D-02,0.3718D-02,
     &0.3748D-02,0.3777D-02,0.3806D-02,0.3833D-02,0.3861D-02,0.3887D-02,
     &0.3912D-02,0.3936D-02,0.3958D-02,0.3978D-02,0.3996D-02,0.4012D-02,
     &0.4024D-02,0.4032D-02,0.4035D-02,0.4031D-02,0.4018D-02,0.3993D-02,
     &0.3949D-02,0.3875D-02,0.3741D-02,0.3474D-02/
      DATA (XPV(I,2,3),I=1,100)/
     &0.1046D-02,0.1031D-02,0.1008D-02,0.9768D-03,0.9381D-03,0.8923D-03,
     &0.8410D-03,0.8074D-03,0.7928D-03,0.7720D-03,0.7450D-03,0.7121D-03,
     &0.6741D-03,0.6398D-03,0.6287D-03,0.6123D-03,0.5906D-03,0.5640D-03,
     &0.5332D-03,0.5101D-03,0.4988D-03,0.4827D-03,0.4624D-03,0.4380D-03,
     &0.4161D-03,0.4059D-03,0.3914D-03,0.3732D-03,0.3524D-03,0.3416D-03,
     &0.3290D-03,0.3133D-03,0.2981D-03,0.2878D-03,0.2747D-03,0.2616D-03,
     &0.2515D-03,0.2392D-03,0.2296D-03,0.2191D-03,0.2100D-03,0.2004D-03,
     &0.1923D-03,0.1842D-03,0.1764D-03,0.1694D-03,0.1627D-03,0.1571D-03,
     &0.1517D-03,0.1469D-03,0.1427D-03,0.1394D-03,0.1367D-03,0.1345D-03,
     &0.1333D-03,0.1327D-03,0.1329D-03,0.1340D-03,0.1360D-03,0.1387D-03,
     &0.1424D-03,0.1469D-03,0.1522D-03,0.1584D-03,0.1654D-03,0.1733D-03,
     &0.1819D-03,0.1915D-03,0.2019D-03,0.2132D-03,0.2257D-03,0.2396D-03,
     &0.2553D-03,0.2737D-03,0.2956D-03,0.3227D-03,0.3570D-03,0.4009D-03,
     &0.4064D-03,0.4119D-03,0.4175D-03,0.4231D-03,0.4287D-03,0.4344D-03,
     &0.4400D-03,0.4457D-03,0.4512D-03,0.4567D-03,0.4621D-03,0.4673D-03,
     &0.4723D-03,0.4769D-03,0.4811D-03,0.4848D-03,0.4875D-03,0.4891D-03,
     &0.4888D-03,0.4853D-03,0.4756D-03,0.4518D-03/
      DATA (XPV(I,2,4),I=1,100)/
     &0.1564D-02,0.1548D-02,0.1521D-02,0.1483D-02,0.1434D-02,0.1375D-02,
     &0.1308D-02,0.1265D-02,0.1249D-02,0.1223D-02,0.1188D-02,0.1145D-02,
     &0.1094D-02,0.1048D-02,0.1035D-02,0.1015D-02,0.9868D-03,0.9509D-03,
     &0.9086D-03,0.8776D-03,0.8644D-03,0.8436D-03,0.8161D-03,0.7822D-03,
     &0.7521D-03,0.7400D-03,0.7212D-03,0.6963D-03,0.6669D-03,0.6538D-03,
     &0.6377D-03,0.6163D-03,0.5956D-03,0.5832D-03,0.5658D-03,0.5486D-03,
     &0.5363D-03,0.5203D-03,0.5091D-03,0.4962D-03,0.4859D-03,0.4746D-03,
     &0.4661D-03,0.4578D-03,0.4502D-03,0.4441D-03,0.4387D-03,0.4355D-03,
     &0.4329D-03,0.4318D-03,0.4320D-03,0.4342D-03,0.4379D-03,0.4429D-03,
     &0.4503D-03,0.4594D-03,0.4704D-03,0.4839D-03,0.4996D-03,0.5177D-03,
     &0.5383D-03,0.5613D-03,0.5869D-03,0.6152D-03,0.6462D-03,0.6802D-03,
     &0.7167D-03,0.7565D-03,0.7995D-03,0.8461D-03,0.8972D-03,0.9538D-03,
     &0.1018D-02,0.1092D-02,0.1181D-02,0.1290D-02,0.1428D-02,0.1604D-02,
     &0.1626D-02,0.1649D-02,0.1671D-02,0.1694D-02,0.1716D-02,0.1739D-02,
     &0.1762D-02,0.1784D-02,0.1806D-02,0.1828D-02,0.1850D-02,0.1871D-02,
     &0.1891D-02,0.1909D-02,0.1926D-02,0.1941D-02,0.1952D-02,0.1958D-02,
     &0.1957D-02,0.1943D-02,0.1905D-02,0.1811D-02/
      DATA (XPV(I,3,0),I=1,100)/
     &0.1761D+00,0.1728D+00,0.1680D+00,0.1619D+00,0.1544D+00,0.1456D+00,
     &0.1358D+00,0.1292D+00,0.1260D+00,0.1218D+00,0.1165D+00,0.1101D+00,
     &0.1029D+00,0.9643D-01,0.9409D-01,0.9087D-01,0.8680D-01,0.8192D-01,
     &0.7638D-01,0.7217D-01,0.7000D-01,0.6708D-01,0.6352D-01,0.5934D-01,
     &0.5561D-01,0.5375D-01,0.5129D-01,0.4829D-01,0.4491D-01,0.4309D-01,
     &0.4104D-01,0.3857D-01,0.3618D-01,0.3454D-01,0.3252D-01,0.3053D-01,
     &0.2896D-01,0.2712D-01,0.2565D-01,0.2407D-01,0.2268D-01,0.2123D-01,
     &0.1997D-01,0.1870D-01,0.1748D-01,0.1634D-01,0.1523D-01,0.1422D-01,
     &0.1321D-01,0.1227D-01,0.1137D-01,0.1053D-01,0.9723D-02,0.8952D-02,
     &0.8241D-02,0.7563D-02,0.6926D-02,0.6345D-02,0.5801D-02,0.5298D-02,
     &0.4833D-02,0.4407D-02,0.4017D-02,0.3657D-02,0.3327D-02,0.3021D-02,
     &0.2735D-02,0.2469D-02,0.2217D-02,0.1976D-02,0.1746D-02,0.1522D-02,
     &0.1307D-02,0.1098D-02,0.8959D-03,0.7002D-03,0.5112D-03,0.3292D-03,
     &0.3097D-03,0.2906D-03,0.2718D-03,0.2534D-03,0.2354D-03,0.2178D-03,
     &0.2005D-03,0.1836D-03,0.1672D-03,0.1511D-03,0.1354D-03,0.1203D-03,
     &0.1055D-03,0.9128D-04,0.7756D-04,0.6440D-04,0.5185D-04,0.3998D-04,
     &0.2891D-04,0.1876D-04,0.9776D-05,0.2464D-05/
      DATA (XPV(I,3,1),I=1,100)/
     &0.3351D-02,0.3297D-02,0.3217D-02,0.3112D-02,0.2981D-02,0.2828D-02,
     &0.2656D-02,0.2543D-02,0.2493D-02,0.2422D-02,0.2332D-02,0.2223D-02,
     &0.2097D-02,0.1984D-02,0.1946D-02,0.1892D-02,0.1821D-02,0.1734D-02,
     &0.1635D-02,0.1560D-02,0.1523D-02,0.1471D-02,0.1406D-02,0.1329D-02,
     &0.1260D-02,0.1228D-02,0.1182D-02,0.1126D-02,0.1061D-02,0.1028D-02,
     &0.9902D-03,0.9426D-03,0.8967D-03,0.8664D-03,0.8274D-03,0.7890D-03,
     &0.7596D-03,0.7240D-03,0.6969D-03,0.6671D-03,0.6417D-03,0.6149D-03,
     &0.5928D-03,0.5708D-03,0.5502D-03,0.5317D-03,0.5144D-03,0.5002D-03,
     &0.4867D-03,0.4753D-03,0.4655D-03,0.4582D-03,0.4526D-03,0.4487D-03,
     &0.4475D-03,0.4480D-03,0.4506D-03,0.4559D-03,0.4632D-03,0.4729D-03,
     &0.4849D-03,0.4991D-03,0.5155D-03,0.5343D-03,0.5552D-03,0.5783D-03,
     &0.6033D-03,0.6307D-03,0.6600D-03,0.6915D-03,0.7256D-03,0.7626D-03,
     &0.8031D-03,0.8482D-03,0.8993D-03,0.9582D-03,0.1026D-02,0.1099D-02,
     &0.1107D-02,0.1115D-02,0.1122D-02,0.1129D-02,0.1136D-02,0.1142D-02,
     &0.1148D-02,0.1152D-02,0.1156D-02,0.1159D-02,0.1161D-02,0.1161D-02,
     &0.1160D-02,0.1156D-02,0.1150D-02,0.1141D-02,0.1127D-02,0.1107D-02,
     &0.1078D-02,0.1036D-02,0.9685D-03,0.8413D-03/
      DATA (XPV(I,3,2),I=1,100)/
     &0.5039D-02,0.4982D-02,0.4889D-02,0.4761D-02,0.4597D-02,0.4401D-02,
     &0.4179D-02,0.4036D-02,0.3979D-02,0.3893D-02,0.3777D-02,0.3634D-02,
     &0.3466D-02,0.3315D-02,0.3273D-02,0.3206D-02,0.3114D-02,0.2997D-02,
     &0.2860D-02,0.2760D-02,0.2717D-02,0.2650D-02,0.2562D-02,0.2454D-02,
     &0.2359D-02,0.2321D-02,0.2262D-02,0.2184D-02,0.2092D-02,0.2052D-02,
     &0.2003D-02,0.1938D-02,0.1875D-02,0.1839D-02,0.1787D-02,0.1736D-02,
     &0.1700D-02,0.1653D-02,0.1622D-02,0.1585D-02,0.1557D-02,0.1526D-02,
     &0.1504D-02,0.1483D-02,0.1464D-02,0.1450D-02,0.1438D-02,0.1433D-02,
     &0.1430D-02,0.1432D-02,0.1438D-02,0.1450D-02,0.1466D-02,0.1487D-02,
     &0.1515D-02,0.1547D-02,0.1585D-02,0.1631D-02,0.1683D-02,0.1742D-02,
     &0.1808D-02,0.1880D-02,0.1960D-02,0.2048D-02,0.2142D-02,0.2245D-02,
     &0.2354D-02,0.2471D-02,0.2596D-02,0.2729D-02,0.2872D-02,0.3025D-02,
     &0.3193D-02,0.3378D-02,0.3587D-02,0.3827D-02,0.4100D-02,0.4397D-02,
     &0.4429D-02,0.4461D-02,0.4490D-02,0.4519D-02,0.4545D-02,0.4570D-02,
     &0.4592D-02,0.4611D-02,0.4627D-02,0.4639D-02,0.4646D-02,0.4647D-02,
     &0.4642D-02,0.4628D-02,0.4604D-02,0.4566D-02,0.4510D-02,0.4431D-02,
     &0.4317D-02,0.4147D-02,0.3877D-02,0.3370D-02/
      DATA (XPV(I,3,3),I=1,100)/
     &0.2958D-02,0.2904D-02,0.2827D-02,0.2727D-02,0.2604D-02,0.2461D-02,
     &0.2301D-02,0.2195D-02,0.2146D-02,0.2079D-02,0.1995D-02,0.1894D-02,
     &0.1778D-02,0.1674D-02,0.1637D-02,0.1586D-02,0.1520D-02,0.1440D-02,
     &0.1349D-02,0.1280D-02,0.1245D-02,0.1197D-02,0.1138D-02,0.1068D-02,
     &0.1005D-02,0.9742D-03,0.9325D-03,0.8812D-03,0.8233D-03,0.7922D-03,
     &0.7568D-03,0.7138D-03,0.6722D-03,0.6438D-03,0.6084D-03,0.5735D-03,
     &0.5460D-03,0.5138D-03,0.4883D-03,0.4609D-03,0.4371D-03,0.4123D-03,
     &0.3912D-03,0.3704D-03,0.3507D-03,0.3327D-03,0.3158D-03,0.3012D-03,
     &0.2873D-03,0.2751D-03,0.2641D-03,0.2551D-03,0.2474D-03,0.2410D-03,
     &0.2365D-03,0.2334D-03,0.2318D-03,0.2321D-03,0.2339D-03,0.2372D-03,
     &0.2421D-03,0.2485D-03,0.2562D-03,0.2652D-03,0.2755D-03,0.2870D-03,
     &0.2995D-03,0.3131D-03,0.3278D-03,0.3438D-03,0.3615D-03,0.3814D-03,
     &0.4046D-03,0.4328D-03,0.4682D-03,0.5142D-03,0.5747D-03,0.6529D-03,
     &0.6625D-03,0.6722D-03,0.6819D-03,0.6916D-03,0.7012D-03,0.7107D-03,
     &0.7200D-03,0.7292D-03,0.7380D-03,0.7464D-03,0.7544D-03,0.7617D-03,
     &0.7681D-03,0.7735D-03,0.7776D-03,0.7798D-03,0.7796D-03,0.7761D-03,
     &0.7676D-03,0.7510D-03,0.7195D-03,0.6522D-03/
      DATA (XPV(I,3,4),I=1,100)/
     &0.3464D-02,0.3410D-02,0.3329D-02,0.3222D-02,0.3090D-02,0.2933D-02,
     &0.2758D-02,0.2643D-02,0.2593D-02,0.2521D-02,0.2430D-02,0.2318D-02,
     &0.2190D-02,0.2075D-02,0.2037D-02,0.1982D-02,0.1910D-02,0.1821D-02,
     &0.1720D-02,0.1643D-02,0.1607D-02,0.1554D-02,0.1489D-02,0.1410D-02,
     &0.1340D-02,0.1308D-02,0.1262D-02,0.1205D-02,0.1140D-02,0.1108D-02,
     &0.1070D-02,0.1023D-02,0.9772D-03,0.9482D-03,0.9103D-03,0.8732D-03,
     &0.8458D-03,0.8121D-03,0.7877D-03,0.7607D-03,0.7388D-03,0.7157D-03,
     &0.6981D-03,0.6812D-03,0.6662D-03,0.6540D-03,0.6438D-03,0.6377D-03,
     &0.6331D-03,0.6316D-03,0.6326D-03,0.6376D-03,0.6453D-03,0.6560D-03,
     &0.6708D-03,0.6887D-03,0.7102D-03,0.7361D-03,0.7656D-03,0.7991D-03,
     &0.8365D-03,0.8777D-03,0.9226D-03,0.9714D-03,0.1024D-02,0.1080D-02,
     &0.1138D-02,0.1201D-02,0.1267D-02,0.1338D-02,0.1415D-02,0.1501D-02,
     &0.1599D-02,0.1717D-02,0.1863D-02,0.2051D-02,0.2296D-02,0.2612D-02,
     &0.2650D-02,0.2689D-02,0.2729D-02,0.2767D-02,0.2806D-02,0.2844D-02,
     &0.2882D-02,0.2919D-02,0.2954D-02,0.2988D-02,0.3020D-02,0.3049D-02,
     &0.3075D-02,0.3097D-02,0.3114D-02,0.3123D-02,0.3122D-02,0.3108D-02,
     &0.3074D-02,0.3008D-02,0.2881D-02,0.2614D-02/
      DATA (XPV(I,4,0),I=1,100)/
     &0.2113D+00,0.2071D+00,0.2012D+00,0.1936D+00,0.1844D+00,0.1736D+00,
     &0.1616D+00,0.1536D+00,0.1497D+00,0.1445D+00,0.1380D+00,0.1303D+00,
     &0.1215D+00,0.1136D+00,0.1108D+00,0.1069D+00,0.1019D+00,0.9605D-01,
     &0.8939D-01,0.8432D-01,0.8171D-01,0.7821D-01,0.7395D-01,0.6897D-01,
     &0.6452D-01,0.6231D-01,0.5938D-01,0.5583D-01,0.5185D-01,0.4969D-01,
     &0.4728D-01,0.4438D-01,0.4158D-01,0.3967D-01,0.3731D-01,0.3500D-01,
     &0.3318D-01,0.3105D-01,0.2936D-01,0.2754D-01,0.2595D-01,0.2429D-01,
     &0.2285D-01,0.2141D-01,0.2003D-01,0.1874D-01,0.1749D-01,0.1635D-01,
     &0.1523D-01,0.1418D-01,0.1317D-01,0.1223D-01,0.1134D-01,0.1048D-01,
     &0.9692D-02,0.8938D-02,0.8227D-02,0.7578D-02,0.6967D-02,0.6398D-02,
     &0.5867D-02,0.5377D-02,0.4922D-02,0.4497D-02,0.4101D-02,0.3730D-02,
     &0.3379D-02,0.3048D-02,0.2732D-02,0.2429D-02,0.2139D-02,0.1858D-02,
     &0.1588D-02,0.1328D-02,0.1077D-02,0.8361D-03,0.6052D-03,0.3850D-03,
     &0.3616D-03,0.3387D-03,0.3162D-03,0.2943D-03,0.2728D-03,0.2518D-03,
     &0.2314D-03,0.2114D-03,0.1919D-03,0.1731D-03,0.1546D-03,0.1369D-03,
     &0.1197D-03,0.1032D-03,0.8729D-04,0.7214D-04,0.5778D-04,0.4429D-04,
     &0.3179D-04,0.2044D-04,0.1053D-04,0.2601D-05/
      DATA (XPV(I,4,1),I=1,100)/
     &0.4299D-02,0.4223D-02,0.4115D-02,0.3974D-02,0.3799D-02,0.3595D-02,
     &0.3367D-02,0.3216D-02,0.3148D-02,0.3054D-02,0.2934D-02,0.2790D-02,
     &0.2625D-02,0.2476D-02,0.2426D-02,0.2353D-02,0.2260D-02,0.2147D-02,
     &0.2018D-02,0.1920D-02,0.1871D-02,0.1804D-02,0.1720D-02,0.1620D-02,
     &0.1532D-02,0.1489D-02,0.1431D-02,0.1359D-02,0.1277D-02,0.1234D-02,
     &0.1185D-02,0.1125D-02,0.1067D-02,0.1028D-02,0.9791D-03,0.9308D-03,
     &0.8936D-03,0.8491D-03,0.8150D-03,0.7777D-03,0.7459D-03,0.7125D-03,
     &0.6849D-03,0.6575D-03,0.6318D-03,0.6088D-03,0.5872D-03,0.5693D-03,
     &0.5524D-03,0.5380D-03,0.5254D-03,0.5159D-03,0.5084D-03,0.5028D-03,
     &0.5003D-03,0.4998D-03,0.5017D-03,0.5066D-03,0.5139D-03,0.5237D-03,
     &0.5360D-03,0.5508D-03,0.5679D-03,0.5875D-03,0.6093D-03,0.6334D-03,
     &0.6593D-03,0.6876D-03,0.7177D-03,0.7500D-03,0.7848D-03,0.8225D-03,
     &0.8639D-03,0.9103D-03,0.9634D-03,0.1025D-02,0.1097D-02,0.1174D-02,
     &0.1183D-02,0.1191D-02,0.1199D-02,0.1206D-02,0.1212D-02,0.1219D-02,
     &0.1224D-02,0.1229D-02,0.1232D-02,0.1235D-02,0.1236D-02,0.1235D-02,
     &0.1232D-02,0.1227D-02,0.1219D-02,0.1207D-02,0.1190D-02,0.1167D-02,
     &0.1133D-02,0.1085D-02,0.1009D-02,0.8680D-03/
      DATA (XPV(I,4,2),I=1,100)/
     &0.5972D-02,0.5895D-02,0.5773D-02,0.5610D-02,0.5402D-02,0.5156D-02,
     &0.4878D-02,0.4698D-02,0.4623D-02,0.4513D-02,0.4369D-02,0.4191D-02,
     &0.3984D-02,0.3798D-02,0.3743D-02,0.3659D-02,0.3544D-02,0.3402D-02,
     &0.3235D-02,0.3113D-02,0.3058D-02,0.2976D-02,0.2870D-02,0.2740D-02,
     &0.2626D-02,0.2578D-02,0.2507D-02,0.2414D-02,0.2305D-02,0.2257D-02,
     &0.2198D-02,0.2121D-02,0.2046D-02,0.2003D-02,0.1942D-02,0.1882D-02,
     &0.1840D-02,0.1786D-02,0.1749D-02,0.1707D-02,0.1674D-02,0.1639D-02,
     &0.1613D-02,0.1589D-02,0.1567D-02,0.1551D-02,0.1538D-02,0.1533D-02,
     &0.1530D-02,0.1533D-02,0.1540D-02,0.1554D-02,0.1573D-02,0.1597D-02,
     &0.1628D-02,0.1665D-02,0.1709D-02,0.1760D-02,0.1818D-02,0.1884D-02,
     &0.1957D-02,0.2038D-02,0.2125D-02,0.2221D-02,0.2324D-02,0.2434D-02,
     &0.2551D-02,0.2676D-02,0.2807D-02,0.2946D-02,0.3095D-02,0.3254D-02,
     &0.3428D-02,0.3621D-02,0.3839D-02,0.4092D-02,0.4382D-02,0.4698D-02,
     &0.4731D-02,0.4764D-02,0.4795D-02,0.4824D-02,0.4851D-02,0.4876D-02,
     &0.4898D-02,0.4917D-02,0.4931D-02,0.4941D-02,0.4945D-02,0.4943D-02,
     &0.4933D-02,0.4913D-02,0.4881D-02,0.4833D-02,0.4766D-02,0.4671D-02,
     &0.4538D-02,0.4344D-02,0.4039D-02,0.3475D-02/
      DATA (XPV(I,4,3),I=1,100)/
     &0.3908D-02,0.3834D-02,0.3728D-02,0.3592D-02,0.3425D-02,0.3231D-02,
     &0.3015D-02,0.2871D-02,0.2804D-02,0.2714D-02,0.2600D-02,0.2464D-02,
     &0.2309D-02,0.2169D-02,0.2119D-02,0.2050D-02,0.1962D-02,0.1855D-02,
     &0.1735D-02,0.1643D-02,0.1596D-02,0.1532D-02,0.1453D-02,0.1361D-02,
     &0.1278D-02,0.1237D-02,0.1183D-02,0.1116D-02,0.1040D-02,0.9992D-03,
     &0.9531D-03,0.8972D-03,0.8434D-03,0.8065D-03,0.7608D-03,0.7159D-03,
     &0.6806D-03,0.6392D-03,0.6067D-03,0.5717D-03,0.5414D-03,0.5098D-03,
     &0.4831D-03,0.4567D-03,0.4317D-03,0.4090D-03,0.3877D-03,0.3693D-03,
     &0.3517D-03,0.3363D-03,0.3224D-03,0.3109D-03,0.3010D-03,0.2928D-03,
     &0.2869D-03,0.2826D-03,0.2801D-03,0.2799D-03,0.2814D-03,0.2848D-03,
     &0.2899D-03,0.2967D-03,0.3051D-03,0.3151D-03,0.3263D-03,0.3390D-03,
     &0.3528D-03,0.3678D-03,0.3841D-03,0.4018D-03,0.4214D-03,0.4437D-03,
     &0.4700D-03,0.5022D-03,0.5431D-03,0.5965D-03,0.6670D-03,0.7574D-03,
     &0.7684D-03,0.7795D-03,0.7905D-03,0.8015D-03,0.8124D-03,0.8230D-03,
     &0.8335D-03,0.8436D-03,0.8533D-03,0.8624D-03,0.8708D-03,0.8784D-03,
     &0.8849D-03,0.8901D-03,0.8934D-03,0.8945D-03,0.8925D-03,0.8863D-03,
     &0.8739D-03,0.8517D-03,0.8113D-03,0.7282D-03/
      DATA (XPV(I,4,4),I=1,100)/
     &0.4411D-02,0.4336D-02,0.4226D-02,0.4084D-02,0.3907D-02,0.3700D-02,
     &0.3469D-02,0.3316D-02,0.3248D-02,0.3153D-02,0.3032D-02,0.2886D-02,
     &0.2718D-02,0.2567D-02,0.2516D-02,0.2444D-02,0.2349D-02,0.2235D-02,
     &0.2103D-02,0.2004D-02,0.1956D-02,0.1888D-02,0.1804D-02,0.1703D-02,
     &0.1613D-02,0.1571D-02,0.1514D-02,0.1441D-02,0.1359D-02,0.1317D-02,
     &0.1269D-02,0.1210D-02,0.1153D-02,0.1116D-02,0.1069D-02,0.1022D-02,
     &0.9882D-03,0.9465D-03,0.9161D-03,0.8828D-03,0.8558D-03,0.8276D-03,
     &0.8060D-03,0.7854D-03,0.7672D-03,0.7526D-03,0.7404D-03,0.7330D-03,
     &0.7277D-03,0.7261D-03,0.7277D-03,0.7338D-03,0.7434D-03,0.7565D-03,
     &0.7745D-03,0.7963D-03,0.8222D-03,0.8532D-03,0.8886D-03,0.9283D-03,
     &0.9728D-03,0.1021D-02,0.1074D-02,0.1131D-02,0.1192D-02,0.1257D-02,
     &0.1325D-02,0.1397D-02,0.1473D-02,0.1554D-02,0.1642D-02,0.1739D-02,
     &0.1852D-02,0.1988D-02,0.2158D-02,0.2377D-02,0.2664D-02,0.3029D-02,
     &0.3074D-02,0.3119D-02,0.3163D-02,0.3207D-02,0.3251D-02,0.3294D-02,
     &0.3336D-02,0.3377D-02,0.3416D-02,0.3452D-02,0.3486D-02,0.3517D-02,
     &0.3543D-02,0.3564D-02,0.3578D-02,0.3582D-02,0.3574D-02,0.3549D-02,
     &0.3500D-02,0.3411D-02,0.3249D-02,0.2916D-02/
      DATA (XPV(I,5,0),I=1,100)/
     &0.3395D+00,0.3321D+00,0.3219D+00,0.3090D+00,0.2933D+00,0.2751D+00,
     &0.2550D+00,0.2414D+00,0.2348D+00,0.2261D+00,0.2153D+00,0.2025D+00,
     &0.1881D+00,0.1751D+00,0.1704D+00,0.1640D+00,0.1559D+00,0.1464D+00,
     &0.1357D+00,0.1276D+00,0.1233D+00,0.1178D+00,0.1110D+00,0.1032D+00,
     &0.9616D-01,0.9268D-01,0.8813D-01,0.8262D-01,0.7648D-01,0.7317D-01,
     &0.6948D-01,0.6506D-01,0.6083D-01,0.5795D-01,0.5442D-01,0.5097D-01,
     &0.4827D-01,0.4513D-01,0.4265D-01,0.4000D-01,0.3769D-01,0.3529D-01,
     &0.3322D-01,0.3117D-01,0.2920D-01,0.2737D-01,0.2561D-01,0.2402D-01,
     &0.2245D-01,0.2098D-01,0.1958D-01,0.1829D-01,0.1704D-01,0.1585D-01,
     &0.1476D-01,0.1370D-01,0.1270D-01,0.1178D-01,0.1090D-01,0.1007D-01,
     &0.9286D-02,0.8547D-02,0.7848D-02,0.7182D-02,0.6551D-02,0.5949D-02,
     &0.5372D-02,0.4823D-02,0.4298D-02,0.3794D-02,0.3314D-02,0.2852D-02,
     &0.2413D-02,0.1995D-02,0.1599D-02,0.1223D-02,0.8693D-03,0.5397D-03,
     &0.5052D-03,0.4716D-03,0.4388D-03,0.4068D-03,0.3757D-03,0.3454D-03,
     &0.3160D-03,0.2875D-03,0.2599D-03,0.2332D-03,0.2073D-03,0.1825D-03,
     &0.1587D-03,0.1359D-03,0.1142D-03,0.9370D-04,0.7445D-04,0.5655D-04,
     &0.4018D-04,0.2553D-04,0.1296D-04,0.3149D-05/
      DATA (XPV(I,5,1),I=1,100)/
     &0.7886D-02,0.7728D-02,0.7505D-02,0.7221D-02,0.6873D-02,0.6469D-02,
     &0.6022D-02,0.5723D-02,0.5585D-02,0.5398D-02,0.5164D-02,0.4885D-02,
     &0.4568D-02,0.4283D-02,0.4181D-02,0.4041D-02,0.3864D-02,0.3650D-02,
     &0.3408D-02,0.3225D-02,0.3131D-02,0.3005D-02,0.2850D-02,0.2668D-02,
     &0.2506D-02,0.2427D-02,0.2321D-02,0.2191D-02,0.2045D-02,0.1968D-02,
     &0.1880D-02,0.1774D-02,0.1672D-02,0.1604D-02,0.1519D-02,0.1435D-02,
     &0.1371D-02,0.1295D-02,0.1236D-02,0.1172D-02,0.1118D-02,0.1062D-02,
     &0.1015D-02,0.9690D-03,0.9257D-03,0.8867D-03,0.8503D-03,0.8197D-03,
     &0.7906D-03,0.7655D-03,0.7432D-03,0.7255D-03,0.7107D-03,0.6987D-03,
     &0.6911D-03,0.6864D-03,0.6850D-03,0.6876D-03,0.6934D-03,0.7025D-03,
     &0.7147D-03,0.7300D-03,0.7482D-03,0.7692D-03,0.7926D-03,0.8187D-03,
     &0.8465D-03,0.8768D-03,0.9089D-03,0.9431D-03,0.9801D-03,0.1020D-02,
     &0.1065D-02,0.1116D-02,0.1177D-02,0.1250D-02,0.1336D-02,0.1431D-02,
     &0.1441D-02,0.1451D-02,0.1460D-02,0.1468D-02,0.1476D-02,0.1483D-02,
     &0.1489D-02,0.1494D-02,0.1497D-02,0.1499D-02,0.1499D-02,0.1497D-02,
     &0.1492D-02,0.1483D-02,0.1471D-02,0.1454D-02,0.1430D-02,0.1398D-02,
     &0.1354D-02,0.1291D-02,0.1195D-02,0.1022D-02/
      DATA (XPV(I,5,2),I=1,100)/
     &0.9523D-02,0.9362D-02,0.9127D-02,0.8821D-02,0.8442D-02,0.7997D-02,
     &0.7501D-02,0.7174D-02,0.7029D-02,0.6828D-02,0.6569D-02,0.6258D-02,
     &0.5901D-02,0.5579D-02,0.5475D-02,0.5323D-02,0.5125D-02,0.4884D-02,
     &0.4606D-02,0.4399D-02,0.4301D-02,0.4162D-02,0.3986D-02,0.3776D-02,
     &0.3590D-02,0.3508D-02,0.3391D-02,0.3242D-02,0.3073D-02,0.2992D-02,
     &0.2897D-02,0.2777D-02,0.2663D-02,0.2592D-02,0.2499D-02,0.2408D-02,
     &0.2344D-02,0.2263D-02,0.2207D-02,0.2144D-02,0.2095D-02,0.2043D-02,
     &0.2005D-02,0.1970D-02,0.1939D-02,0.1917D-02,0.1898D-02,0.1891D-02,
     &0.1887D-02,0.1891D-02,0.1901D-02,0.1921D-02,0.1948D-02,0.1981D-02,
     &0.2025D-02,0.2076D-02,0.2134D-02,0.2204D-02,0.2281D-02,0.2367D-02,
     &0.2463D-02,0.2566D-02,0.2678D-02,0.2798D-02,0.2925D-02,0.3060D-02,
     &0.3199D-02,0.3347D-02,0.3500D-02,0.3659D-02,0.3827D-02,0.4007D-02,
     &0.4203D-02,0.4424D-02,0.4679D-02,0.4981D-02,0.5336D-02,0.5723D-02,
     &0.5764D-02,0.5803D-02,0.5840D-02,0.5875D-02,0.5906D-02,0.5934D-02,
     &0.5959D-02,0.5978D-02,0.5992D-02,0.6000D-02,0.6000D-02,0.5991D-02,
     &0.5971D-02,0.5938D-02,0.5890D-02,0.5821D-02,0.5726D-02,0.5597D-02,
     &0.5419D-02,0.5166D-02,0.4781D-02,0.4089D-02/
      DATA (XPV(I,5,3),I=1,100)/
     &0.7505D-02,0.7347D-02,0.7127D-02,0.6848D-02,0.6508D-02,0.6113D-02,
     &0.5677D-02,0.5385D-02,0.5248D-02,0.5065D-02,0.4837D-02,0.4566D-02,
     &0.4259D-02,0.3982D-02,0.3881D-02,0.3744D-02,0.3571D-02,0.3365D-02,
     &0.3131D-02,0.2953D-02,0.2861D-02,0.2738D-02,0.2589D-02,0.2414D-02,
     &0.2257D-02,0.2179D-02,0.2077D-02,0.1952D-02,0.1812D-02,0.1736D-02,
     &0.1651D-02,0.1549D-02,0.1451D-02,0.1384D-02,0.1302D-02,0.1222D-02,
     &0.1159D-02,0.1086D-02,0.1028D-02,0.9666D-03,0.9136D-03,0.8587D-03,
     &0.8123D-03,0.7666D-03,0.7236D-03,0.6846D-03,0.6479D-03,0.6163D-03,
     &0.5861D-03,0.5595D-03,0.5354D-03,0.5152D-03,0.4975D-03,0.4824D-03,
     &0.4710D-03,0.4620D-03,0.4558D-03,0.4530D-03,0.4527D-03,0.4552D-03,
     &0.4601D-03,0.4675D-03,0.4771D-03,0.4889D-03,0.5026D-03,0.5181D-03,
     &0.5351D-03,0.5540D-03,0.5746D-03,0.5972D-03,0.6228D-03,0.6525D-03,
     &0.6882D-03,0.7329D-03,0.7908D-03,0.8669D-03,0.9668D-03,0.1092D-02,
     &0.1106D-02,0.1121D-02,0.1136D-02,0.1150D-02,0.1164D-02,0.1178D-02,
     &0.1191D-02,0.1203D-02,0.1214D-02,0.1225D-02,0.1234D-02,0.1242D-02,
     &0.1247D-02,0.1250D-02,0.1251D-02,0.1247D-02,0.1239D-02,0.1224D-02,
     &0.1199D-02,0.1159D-02,0.1093D-02,0.9633D-03/
      DATA (XPV(I,5,4),I=1,100)/
     &0.7997D-02,0.7838D-02,0.7615D-02,0.7329D-02,0.6980D-02,0.6573D-02,
     &0.6123D-02,0.5823D-02,0.5684D-02,0.5497D-02,0.5261D-02,0.4981D-02,
     &0.4662D-02,0.4375D-02,0.4274D-02,0.4134D-02,0.3955D-02,0.3741D-02,
     &0.3497D-02,0.3313D-02,0.3221D-02,0.3095D-02,0.2940D-02,0.2758D-02,
     &0.2596D-02,0.2518D-02,0.2414D-02,0.2285D-02,0.2140D-02,0.2065D-02,
     &0.1981D-02,0.1877D-02,0.1779D-02,0.1715D-02,0.1634D-02,0.1555D-02,
     &0.1497D-02,0.1427D-02,0.1376D-02,0.1320D-02,0.1276D-02,0.1229D-02,
     &0.1194D-02,0.1161D-02,0.1131D-02,0.1108D-02,0.1089D-02,0.1077D-02,
     &0.1069D-02,0.1067D-02,0.1070D-02,0.1080D-02,0.1095D-02,0.1116D-02,
     &0.1144D-02,0.1178D-02,0.1218D-02,0.1265D-02,0.1318D-02,0.1378D-02,
     &0.1444D-02,0.1516D-02,0.1594D-02,0.1677D-02,0.1764D-02,0.1858D-02,
     &0.1954D-02,0.2056D-02,0.2162D-02,0.2275D-02,0.2398D-02,0.2536D-02,
     &0.2696D-02,0.2890D-02,0.3134D-02,0.3450D-02,0.3859D-02,0.4365D-02,
     &0.4425D-02,0.4485D-02,0.4544D-02,0.4602D-02,0.4658D-02,0.4713D-02,
     &0.4765D-02,0.4815D-02,0.4861D-02,0.4903D-02,0.4940D-02,0.4970D-02,
     &0.4993D-02,0.5007D-02,0.5008D-02,0.4994D-02,0.4961D-02,0.4900D-02,
     &0.4801D-02,0.4642D-02,0.4373D-02,0.3853D-02/
      DATA (XPV(I,6,0),I=1,100)/
     &0.4823D+00,0.4713D+00,0.4562D+00,0.4371D+00,0.4141D+00,0.3874D+00,
     &0.3580D+00,0.3381D+00,0.3284D+00,0.3157D+00,0.3000D+00,0.2816D+00,
     &0.2609D+00,0.2422D+00,0.2354D+00,0.2262D+00,0.2147D+00,0.2012D+00,
     &0.1860D+00,0.1744D+00,0.1685D+00,0.1606D+00,0.1511D+00,0.1401D+00,
     &0.1304D+00,0.1255D+00,0.1192D+00,0.1116D+00,0.1031D+00,0.9852D-01,
     &0.9345D-01,0.8740D-01,0.8162D-01,0.7769D-01,0.7289D-01,0.6822D-01,
     &0.6457D-01,0.6033D-01,0.5700D-01,0.5343D-01,0.5035D-01,0.4714D-01,
     &0.4439D-01,0.4166D-01,0.3905D-01,0.3663D-01,0.3429D-01,0.3219D-01,
     &0.3012D-01,0.2819D-01,0.2634D-01,0.2464D-01,0.2300D-01,0.2142D-01,
     &0.1997D-01,0.1857D-01,0.1723D-01,0.1600D-01,0.1482D-01,0.1370D-01,
     &0.1263D-01,0.1162D-01,0.1065D-01,0.9734D-02,0.8858D-02,0.8020D-02,
     &0.7218D-02,0.6455D-02,0.5727D-02,0.5031D-02,0.4372D-02,0.3743D-02,
     &0.3148D-02,0.2587D-02,0.2059D-02,0.1563D-02,0.1101D-02,0.6756D-03,
     &0.6315D-03,0.5886D-03,0.5468D-03,0.5062D-03,0.4667D-03,0.4284D-03,
     &0.3913D-03,0.3553D-03,0.3206D-03,0.2871D-03,0.2547D-03,0.2238D-03,
     &0.1942D-03,0.1660D-03,0.1392D-03,0.1139D-03,0.9030D-04,0.6843D-04,
     &0.4849D-04,0.3074D-04,0.1557D-04,0.3784D-05/
      DATA (XPV(I,6,1),I=1,100)/
     &0.1205D-01,0.1178D-01,0.1142D-01,0.1096D-01,0.1041D-01,0.9763D-02,
     &0.9053D-02,0.8577D-02,0.8354D-02,0.8057D-02,0.7688D-02,0.7251D-02,
     &0.6756D-02,0.6310D-02,0.6149D-02,0.5929D-02,0.5654D-02,0.5325D-02,
     &0.4953D-02,0.4670D-02,0.4526D-02,0.4332D-02,0.4097D-02,0.3822D-02,
     &0.3577D-02,0.3456D-02,0.3297D-02,0.3102D-02,0.2885D-02,0.2769D-02,
     &0.2639D-02,0.2483D-02,0.2333D-02,0.2232D-02,0.2107D-02,0.1985D-02,
     &0.1891D-02,0.1781D-02,0.1696D-02,0.1604D-02,0.1526D-02,0.1445D-02,
     &0.1377D-02,0.1310D-02,0.1248D-02,0.1192D-02,0.1139D-02,0.1094D-02,
     &0.1052D-02,0.1015D-02,0.9816D-03,0.9544D-03,0.9311D-03,0.9114D-03,
     &0.8975D-03,0.8872D-03,0.8810D-03,0.8801D-03,0.8830D-03,0.8899D-03,
     &0.9007D-03,0.9151D-03,0.9330D-03,0.9541D-03,0.9781D-03,0.1005D-02,
     &0.1034D-02,0.1065D-02,0.1099D-02,0.1135D-02,0.1174D-02,0.1217D-02,
     &0.1266D-02,0.1323D-02,0.1392D-02,0.1478D-02,0.1581D-02,0.1696D-02,
     &0.1708D-02,0.1720D-02,0.1731D-02,0.1741D-02,0.1751D-02,0.1759D-02,
     &0.1766D-02,0.1772D-02,0.1776D-02,0.1778D-02,0.1778D-02,0.1775D-02,
     &0.1769D-02,0.1759D-02,0.1744D-02,0.1723D-02,0.1695D-02,0.1657D-02,
     &0.1604D-02,0.1530D-02,0.1417D-02,0.1218D-02/
      DATA (XPV(I,6,2),I=1,100)/
     &0.1365D-01,0.1339D-01,0.1302D-01,0.1254D-01,0.1195D-01,0.1127D-01,
     &0.1051D-01,0.1001D-01,0.9777D-02,0.9465D-02,0.9073D-02,0.8604D-02,
     &0.8069D-02,0.7589D-02,0.7425D-02,0.7195D-02,0.6900D-02,0.6544D-02,
     &0.6138D-02,0.5834D-02,0.5686D-02,0.5481D-02,0.5226D-02,0.4925D-02,
     &0.4658D-02,0.4536D-02,0.4367D-02,0.4157D-02,0.3918D-02,0.3801D-02,
     &0.3667D-02,0.3499D-02,0.3340D-02,0.3241D-02,0.3112D-02,0.2987D-02,
     &0.2897D-02,0.2787D-02,0.2709D-02,0.2624D-02,0.2557D-02,0.2487D-02,
     &0.2436D-02,0.2387D-02,0.2346D-02,0.2315D-02,0.2290D-02,0.2279D-02,
     &0.2273D-02,0.2277D-02,0.2289D-02,0.2313D-02,0.2346D-02,0.2387D-02,
     &0.2441D-02,0.2503D-02,0.2575D-02,0.2660D-02,0.2755D-02,0.2859D-02,
     &0.2974D-02,0.3099D-02,0.3232D-02,0.3374D-02,0.3523D-02,0.3680D-02,
     &0.3841D-02,0.4010D-02,0.4183D-02,0.4363D-02,0.4552D-02,0.4754D-02,
     &0.4976D-02,0.5229D-02,0.5526D-02,0.5885D-02,0.6313D-02,0.6782D-02,
     &0.6832D-02,0.6879D-02,0.6924D-02,0.6966D-02,0.7004D-02,0.7038D-02,
     &0.7067D-02,0.7091D-02,0.7108D-02,0.7117D-02,0.7116D-02,0.7105D-02,
     &0.7081D-02,0.7041D-02,0.6982D-02,0.6899D-02,0.6786D-02,0.6631D-02,
     &0.6421D-02,0.6123D-02,0.5672D-02,0.4871D-02/
      DATA (XPV(I,6,3),I=1,100)/
     &0.1167D-01,0.1141D-01,0.1105D-01,0.1060D-01,0.1005D-01,0.9414D-02,
     &0.8715D-02,0.8245D-02,0.8024D-02,0.7730D-02,0.7367D-02,0.6937D-02,
     &0.6451D-02,0.6013D-02,0.5853D-02,0.5637D-02,0.5366D-02,0.5044D-02,
     &0.4680D-02,0.4403D-02,0.4259D-02,0.4069D-02,0.3839D-02,0.3571D-02,
     &0.3331D-02,0.3212D-02,0.3055D-02,0.2866D-02,0.2654D-02,0.2540D-02,
     &0.2413D-02,0.2260D-02,0.2114D-02,0.2014D-02,0.1892D-02,0.1773D-02,
     &0.1680D-02,0.1572D-02,0.1488D-02,0.1398D-02,0.1320D-02,0.1240D-02,
     &0.1173D-02,0.1106D-02,0.1044D-02,0.9874D-03,0.9342D-03,0.8881D-03,
     &0.8442D-03,0.8052D-03,0.7698D-03,0.7399D-03,0.7134D-03,0.6903D-03,
     &0.6722D-03,0.6574D-03,0.6463D-03,0.6397D-03,0.6365D-03,0.6368D-03,
     &0.6405D-03,0.6473D-03,0.6570D-03,0.6695D-03,0.6844D-03,0.7019D-03,
     &0.7213D-03,0.7431D-03,0.7673D-03,0.7943D-03,0.8253D-03,0.8617D-03,
     &0.9063D-03,0.9627D-03,0.1036D-02,0.1133D-02,0.1259D-02,0.1412D-02,
     &0.1430D-02,0.1448D-02,0.1465D-02,0.1482D-02,0.1499D-02,0.1514D-02,
     &0.1529D-02,0.1543D-02,0.1556D-02,0.1567D-02,0.1576D-02,0.1583D-02,
     &0.1587D-02,0.1588D-02,0.1586D-02,0.1578D-02,0.1563D-02,0.1539D-02,
     &0.1504D-02,0.1448D-02,0.1358D-02,0.1189D-02/
      DATA (XPV(I,6,4),I=1,100)/
     &0.1216D-01,0.1189D-01,0.1153D-01,0.1107D-01,0.1051D-01,0.9868D-02,
     &0.9154D-02,0.8677D-02,0.8454D-02,0.8157D-02,0.7787D-02,0.7349D-02,
     &0.6851D-02,0.6404D-02,0.6244D-02,0.6025D-02,0.5749D-02,0.5420D-02,
     &0.5047D-02,0.4764D-02,0.4621D-02,0.4429D-02,0.4195D-02,0.3920D-02,
     &0.3677D-02,0.3559D-02,0.3402D-02,0.3211D-02,0.2996D-02,0.2884D-02,
     &0.2759D-02,0.2608D-02,0.2463D-02,0.2369D-02,0.2251D-02,0.2138D-02,
     &0.2053D-02,0.1952D-02,0.1879D-02,0.1800D-02,0.1736D-02,0.1670D-02,
     &0.1619D-02,0.1572D-02,0.1531D-02,0.1498D-02,0.1470D-02,0.1454D-02,
     &0.1442D-02,0.1439D-02,0.1442D-02,0.1455D-02,0.1475D-02,0.1502D-02,
     &0.1539D-02,0.1584D-02,0.1637D-02,0.1699D-02,0.1769D-02,0.1847D-02,
     &0.1934D-02,0.2027D-02,0.2128D-02,0.2235D-02,0.2348D-02,0.2468D-02,
     &0.2591D-02,0.2721D-02,0.2857D-02,0.3001D-02,0.3158D-02,0.3333D-02,
     &0.3538D-02,0.3788D-02,0.4102D-02,0.4506D-02,0.5022D-02,0.5648D-02,
     &0.5720D-02,0.5792D-02,0.5862D-02,0.5931D-02,0.5997D-02,0.6060D-02,
     &0.6120D-02,0.6176D-02,0.6226D-02,0.6271D-02,0.6308D-02,0.6337D-02,
     &0.6354D-02,0.6359D-02,0.6348D-02,0.6316D-02,0.6257D-02,0.6163D-02,
     &0.6019D-02,0.5797D-02,0.5436D-02,0.4755D-02/
      DATA (XPV(I,7,0),I=1,100)/
     &0.6367D+00,0.6216D+00,0.6010D+00,0.5752D+00,0.5440D+00,0.5081D+00,
     &0.4686D+00,0.4418D+00,0.4287D+00,0.4116D+00,0.3907D+00,0.3662D+00,
     &0.3385D+00,0.3137D+00,0.3045D+00,0.2923D+00,0.2772D+00,0.2594D+00,
     &0.2393D+00,0.2241D+00,0.2163D+00,0.2060D+00,0.1936D+00,0.1792D+00,
     &0.1665D+00,0.1602D+00,0.1520D+00,0.1421D+00,0.1311D+00,0.1252D+00,
     &0.1187D+00,0.1109D+00,0.1035D+00,0.9842D-01,0.9228D-01,0.8630D-01,
     &0.8164D-01,0.7624D-01,0.7200D-01,0.6747D-01,0.6355D-01,0.5948D-01,
     &0.5601D-01,0.5255D-01,0.4926D-01,0.4620D-01,0.4326D-01,0.4061D-01,
     &0.3801D-01,0.3557D-01,0.3324D-01,0.3109D-01,0.2903D-01,0.2705D-01,
     &0.2521D-01,0.2344D-01,0.2175D-01,0.2018D-01,0.1868D-01,0.1725D-01,
     &0.1589D-01,0.1460D-01,0.1337D-01,0.1219D-01,0.1107D-01,0.9999D-02,
     &0.8975D-02,0.8003D-02,0.7079D-02,0.6199D-02,0.5369D-02,0.4581D-02,
     &0.3839D-02,0.3144D-02,0.2492D-02,0.1883D-02,0.1320D-02,0.8054D-03,
     &0.7523D-03,0.7006D-03,0.6504D-03,0.6016D-03,0.5543D-03,0.5084D-03,
     &0.4640D-03,0.4210D-03,0.3796D-03,0.3397D-03,0.3011D-03,0.2644D-03,
     &0.2292D-03,0.1957D-03,0.1640D-03,0.1342D-03,0.1063D-03,0.8046D-04,
     &0.5699D-04,0.3611D-04,0.1829D-04,0.4453D-05/
      DATA (XPV(I,7,1),I=1,100)/
     &0.1667D-01,0.1629D-01,0.1577D-01,0.1511D-01,0.1431D-01,0.1340D-01,
     &0.1239D-01,0.1171D-01,0.1139D-01,0.1097D-01,0.1045D-01,0.9835D-02,
     &0.9139D-02,0.8514D-02,0.8286D-02,0.7979D-02,0.7594D-02,0.7137D-02,
     &0.6621D-02,0.6230D-02,0.6029D-02,0.5762D-02,0.5438D-02,0.5061D-02,
     &0.4726D-02,0.4560D-02,0.4342D-02,0.4078D-02,0.3784D-02,0.3626D-02,
     &0.3451D-02,0.3240D-02,0.3038D-02,0.2902D-02,0.2735D-02,0.2572D-02,
     &0.2446D-02,0.2299D-02,0.2185D-02,0.2064D-02,0.1960D-02,0.1852D-02,
     &0.1762D-02,0.1673D-02,0.1591D-02,0.1516D-02,0.1446D-02,0.1386D-02,
     &0.1329D-02,0.1278D-02,0.1233D-02,0.1195D-02,0.1162D-02,0.1134D-02,
     &0.1113D-02,0.1096D-02,0.1084D-02,0.1078D-02,0.1077D-02,0.1081D-02,
     &0.1090D-02,0.1103D-02,0.1119D-02,0.1140D-02,0.1164D-02,0.1191D-02,
     &0.1220D-02,0.1253D-02,0.1288D-02,0.1325D-02,0.1367D-02,0.1413D-02,
     &0.1466D-02,0.1530D-02,0.1609D-02,0.1708D-02,0.1830D-02,0.1967D-02,
     &0.1981D-02,0.1995D-02,0.2008D-02,0.2021D-02,0.2032D-02,0.2042D-02,
     &0.2051D-02,0.2058D-02,0.2063D-02,0.2066D-02,0.2066D-02,0.2063D-02,
     &0.2057D-02,0.2045D-02,0.2029D-02,0.2005D-02,0.1973D-02,0.1929D-02,
     &0.1869D-02,0.1784D-02,0.1655D-02,0.1427D-02/
      DATA (XPV(I,7,2),I=1,100)/
     &0.1825D-01,0.1787D-01,0.1734D-01,0.1666D-01,0.1584D-01,0.1488D-01,
     &0.1382D-01,0.1312D-01,0.1280D-01,0.1236D-01,0.1182D-01,0.1117D-01,
     &0.1044D-01,0.9780D-02,0.9550D-02,0.9233D-02,0.8830D-02,0.8348D-02,
     &0.7799D-02,0.7387D-02,0.7184D-02,0.6906D-02,0.6565D-02,0.6163D-02,
     &0.5808D-02,0.5642D-02,0.5418D-02,0.5140D-02,0.4827D-02,0.4670D-02,
     &0.4493D-02,0.4274D-02,0.4067D-02,0.3936D-02,0.3769D-02,0.3607D-02,
     &0.3489D-02,0.3347D-02,0.3246D-02,0.3136D-02,0.3050D-02,0.2959D-02,
     &0.2893D-02,0.2830D-02,0.2777D-02,0.2736D-02,0.2703D-02,0.2687D-02,
     &0.2678D-02,0.2680D-02,0.2693D-02,0.2720D-02,0.2757D-02,0.2805D-02,
     &0.2867D-02,0.2940D-02,0.3024D-02,0.3123D-02,0.3233D-02,0.3355D-02,
     &0.3489D-02,0.3632D-02,0.3785D-02,0.3948D-02,0.4118D-02,0.4297D-02,
     &0.4479D-02,0.4668D-02,0.4863D-02,0.5063D-02,0.5274D-02,0.5499D-02,
     &0.5750D-02,0.6038D-02,0.6381D-02,0.6800D-02,0.7306D-02,0.7864D-02,
     &0.7924D-02,0.7980D-02,0.8034D-02,0.8085D-02,0.8131D-02,0.8172D-02,
     &0.8208D-02,0.8236D-02,0.8258D-02,0.8270D-02,0.8271D-02,0.8259D-02,
     &0.8233D-02,0.8188D-02,0.8122D-02,0.8027D-02,0.7897D-02,0.7721D-02,
     &0.7480D-02,0.7139D-02,0.6624D-02,0.5709D-02/
      DATA (XPV(I,7,3),I=1,100)/
     &0.1630D-01,0.1592D-01,0.1540D-01,0.1475D-01,0.1396D-01,0.1305D-01,
     &0.1205D-01,0.1138D-01,0.1107D-01,0.1065D-01,0.1013D-01,0.9526D-02,
     &0.8839D-02,0.8222D-02,0.7995D-02,0.7690D-02,0.7310D-02,0.6860D-02,
     &0.6352D-02,0.5966D-02,0.5766D-02,0.5502D-02,0.5183D-02,0.4813D-02,
     &0.4483D-02,0.4318D-02,0.4103D-02,0.3844D-02,0.3555D-02,0.3399D-02,
     &0.3225D-02,0.3018D-02,0.2820D-02,0.2685D-02,0.2521D-02,0.2360D-02,
     &0.2235D-02,0.2091D-02,0.1978D-02,0.1857D-02,0.1754D-02,0.1647D-02,
     &0.1557D-02,0.1468D-02,0.1385D-02,0.1310D-02,0.1239D-02,0.1177D-02,
     &0.1118D-02,0.1066D-02,0.1018D-02,0.9774D-03,0.9411D-03,0.9091D-03,
     &0.8835D-03,0.8619D-03,0.8450D-03,0.8338D-03,0.8268D-03,0.8242D-03,
     &0.8257D-03,0.8312D-03,0.8403D-03,0.8529D-03,0.8686D-03,0.8875D-03,
     &0.9087D-03,0.9331D-03,0.9605D-03,0.9915D-03,0.1028D-02,0.1070D-02,
     &0.1124D-02,0.1191D-02,0.1279D-02,0.1395D-02,0.1545D-02,0.1725D-02,
     &0.1746D-02,0.1766D-02,0.1786D-02,0.1805D-02,0.1823D-02,0.1841D-02,
     &0.1857D-02,0.1872D-02,0.1886D-02,0.1897D-02,0.1907D-02,0.1913D-02,
     &0.1916D-02,0.1915D-02,0.1909D-02,0.1897D-02,0.1877D-02,0.1846D-02,
     &0.1799D-02,0.1729D-02,0.1618D-02,0.1411D-02/
      DATA (XPV(I,7,4),I=1,100)/
     &0.1678D-01,0.1640D-01,0.1587D-01,0.1522D-01,0.1442D-01,0.1350D-01,
     &0.1249D-01,0.1181D-01,0.1149D-01,0.1107D-01,0.1055D-01,0.9935D-02,
     &0.9238D-02,0.8611D-02,0.8385D-02,0.8078D-02,0.7694D-02,0.7237D-02,
     &0.6721D-02,0.6331D-02,0.6132D-02,0.5867D-02,0.5545D-02,0.5170D-02,
     &0.4837D-02,0.4676D-02,0.4462D-02,0.4202D-02,0.3912D-02,0.3761D-02,
     &0.3592D-02,0.3388D-02,0.3194D-02,0.3068D-02,0.2911D-02,0.2759D-02,
     &0.2646D-02,0.2513D-02,0.2415D-02,0.2310D-02,0.2226D-02,0.2139D-02,
     &0.2072D-02,0.2010D-02,0.1955D-02,0.1911D-02,0.1875D-02,0.1852D-02,
     &0.1836D-02,0.1830D-02,0.1833D-02,0.1848D-02,0.1872D-02,0.1905D-02,
     &0.1950D-02,0.2004D-02,0.2069D-02,0.2145D-02,0.2231D-02,0.2327D-02,
     &0.2432D-02,0.2547D-02,0.2669D-02,0.2800D-02,0.2937D-02,0.3082D-02,
     &0.3232D-02,0.3389D-02,0.3553D-02,0.3727D-02,0.3917D-02,0.4130D-02,
     &0.4378D-02,0.4681D-02,0.5061D-02,0.5547D-02,0.6163D-02,0.6897D-02,
     &0.6981D-02,0.7063D-02,0.7144D-02,0.7221D-02,0.7296D-02,0.7367D-02,
     &0.7433D-02,0.7494D-02,0.7548D-02,0.7595D-02,0.7632D-02,0.7658D-02,
     &0.7671D-02,0.7667D-02,0.7644D-02,0.7595D-02,0.7513D-02,0.7388D-02,
     &0.7203D-02,0.6923D-02,0.6476D-02,0.5646D-02/

C..fetching pdfs
      DO  5 IP=-6,6
        XPDF(IP)=ZEROD
 5    CONTINUE
      DO 2 I=1,IX
        ENT(I)=LOG10(XT(I))
  2   CONTINUE
      NA(1)=IX
      NA(2)=IQ
      DO 3 I=1,IQ
        ENT(IX+I)=LOG10(Q2T(I))
   3  CONTINUE
      ARG(1)=LOG10(X)
      ARG(2)=LOG10(Q2)
C..VARIOUS FLAVOURS (u-->2,d-->1)
      XPDF(0)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,0))
      XPDF(1)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,1))
      XPDF(2)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,2))
      XPDF(3)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,3))
      XPDF(4)=DBFINT(NARG,ARG,NA,ENT,XPV(1,1,4))
      DO 21 JF=1,4
        XPDF(-JF)=XPDF(JF)
 21   CONTINUE
      RETURN
      END
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
