/* 
   Copyright (c) 1991-1999 Thomas T. Wetmore IV

   Permission is hereby granted, free of charge, to any person
   obtaining a copy of this software and associated documentation
   files (the "Software"), to deal in the Software without
   restriction, including without limitation the rights to use, copy,
   modify, merge, publish, distribute, sublicense, and/or sell copies
   of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be
   included in all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
   MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
   BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
   ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
   SOFTWARE.
*/
/*=============================================================
 * functab.c -- Table of builtin functions
 * Copyright(c) 1993-96 by T.T. Wetmore IV; all rights reserved
 *   2.3.4 - 24 Jun 93    2.3.5 - 26 Sep 93
 *   2.3.6 - 01 Jan 94    3.0.0 - 11 Oct 94
 *   3.0.3 - 02 Jul 96
 *===========================================================*/
/* modified 05 Jan 2000 by Paul B. McBride (pmcbride@tiac.net) */
/* modified 2000-01-28 J.F.Chandler */

#include "llstdlib.h"
#include "table.h"
#include "translat.h"
#include "gedcom.h"
#include "cache.h"
#include "interpi.h"

/*
 * The entries of builtins MUST be in alphabetic order (because an
 * alphabetic binary sort is performed directly on this list).
 *
 * interp/alloc.c/verify_builtins() checks them and calls
 * FATAL() if they are not in sorted order.
 */
BUILTINS builtins[] = {
	{"add",             2,    32,   llrpt_add},
	{"addnode",         3,    3,    llrpt_addnode},
	{"addtoset",        3,    3,    llrpt_addtoset},
	{"alpha",           1,    1,    llrpt_alpha},
	{"ancestorset",     1,    1,    llrpt_ancestorset},
	{"and",             2,    32,   llrpt_and},
	{"arccos",          1,    1,    llrpt_arccos},
	{"arcsin",          1,    1,    llrpt_arcsin},
	{"arctan",          1,    1,    llrpt_arctan},
	{"atoi",            1,    1,    llrpt_strtoint},
	{"baptism",         1,    1,    llrpt_bapt},
	{"birth",           1,    1,    llrpt_birt},
	{"burial",          1,    1,    llrpt_buri},
	{"bytecode",        1,    2,    llrpt_bytecode},
	{"capitalize",      1,    1,    llrpt_capitalize},
	{"card",            1,    1,    llrpt_card},
	{"child",           1,    1,    llrpt_child},
	{"childset",        1,    1,    llrpt_childset},
	{"choosechild",     1,    1,    llrpt_choosechild},
	{"choosefam",       1,    1,    llrpt_choosefam},
	{"chooseindi",      1,    1,    llrpt_chooseindi},
	{"choosespouse",    1,    1,    llrpt_choosespouse},
	{"choosesubset",    1,    1,    llrpt_choosesubset},
	{"clear",           1,    1,    llrpt_clear},
	{"col",             1,    1,    llrpt_col},
	{"complexdate",     1,    1,    llrpt_complexdate},
	{"complexformat",   1,    1,    llrpt_complexformat},
	{"complexpic",      2,    2,    llrpt_complexpic },
	{"concat",          1,    32,   llrpt_concat},
	{"convertcode",     2,    3,    llrpt_convertcode}, 
	{"copyfile",        1,    1,    llrpt_copyfile},
	{"cos",             1,    1,    llrpt_cos},
	{"createnode",      2,    2,    llrpt_createnode},
	{"d",               1,    1,    llrpt_d},
	{"database",        0,    1,    llrpt_database},
	{"date",            1,    1,    llrpt_date},
	{"dateformat",      1,    1,    llrpt_dateformat},
	{"datepic",         1,    1,    llrpt_datepic },
	{"dayformat",       1,    1,    llrpt_dayformat},
	{"death",           1,    1,    llrpt_deat},
	{"debug",           1,    1,    llrpt_debug},
	{"decr",            1,    2,    llrpt_decr},
	{"deg2dms",         4,    4,    llrpt_deg2dms},
	{"deletefromset",   3,    3,    llrpt_deletefromset},
	{"deletenode",      1,    1,    llrpt_detachnode},
	{"dequeue",         1,    1,    llrpt_dequeue},
	{"dereference",     1,    1,    llrpt_dereference},
	{"descendantset",   1,    1,    llrpt_descendentset},
	{"descendentset",   1,    1,    llrpt_descendentset},
	{"detachnode",      1,    1,    llrpt_detachnode},
	{"difference",      2,    2,    llrpt_difference},
	{"div",             2,    2,    llrpt_div},
	{"dms2deg",         4,    4,    llrpt_dms2deg},
	{"dup",             1,    1,    llrpt_dup},
	{"empty",           1,    1,    llrpt_empty},
	{"enqueue",         2,    2,    llrpt_enqueue},
	{"eq",              2,    2,    llrpt_eq},
	{"eqstr",           2,    2,    llrpt_eqstr},
	{"eraformat",       1,    1,   	llrpt_eraformat},
	{"exp",             2,    2,    llrpt_exp},
	{"extractdate",     4,    4,    llrpt_extractdate},
	{"extractdatestr",  5,    6,    llrpt_extractdatestr},
	{"extractnames",    4,    4,    llrpt_extractnames},
	{"extractplaces",   3,    3,    llrpt_extractplaces},
	{"extracttokens",   4,    4,    llrpt_extracttokens},
	{"f",               1,    2,    llrpt_f},
	{"fam",             1,    1,    llrpt_fam},
	{"father",          1,    1,    llrpt_fath},
	{"female",          1,    1,    llrpt_female},
	{"firstchild",      1,    1,    llrpt_firstchild},
	{"firstfam",        0,    0,    llrpt_firstfam},
	{"firstindi",       0,    0,    llrpt_firstindi},
	{"float",           1,    1,    llrpt_float},
	{"fnode",           1,    1,    llrpt_fnode},
	{"free",            1,    1,    llrpt_free},
	{"fullname",        4,    4,    llrpt_fullname},
	{"ge",              2,    2,    llrpt_ge},
	{"gengedcom",       1,    1,    llrpt_gengedcom},
	{"gengedcomstrong", 1,    1,    llrpt_gengedcomstrong},
	{"gengedcomweak",   1,    1,    llrpt_gengedcomweak},
	{"genindiset",      2,    2,    llrpt_genindiset},
	{"getcol",          0,    0,    llrpt_getcol},
	{"getel",           2,    2,    llrpt_getel},
	{"getfam",          1,    1,    llrpt_getfam},
	{"getindi",         1,    2,    llrpt_getindi},
	{"getindimsg",      2,    2,    llrpt_getindi},
	{"getindiset",      1,    2,    llrpt_getindiset},
	{"getint",          1,    2,    llrpt_getint},
	{"getintmsg",       2,    2,    llrpt_getint},
	{"getproperty",     1,    1,    llrpt_getproperty},
	{"getstr",          1,    2,    llrpt_getstr},
	{"getstrmsg",       2,    2,    llrpt_getstr},
	{"gettext",         1,    1,    llrpt_gettext},
	{"gettoday",        0,    0,    llrpt_gettoday},
	{"givens",          1,    1,    llrpt_givens},
	{"gt",              2,    2,    llrpt_gt},
	{"heapused",        0,    0,    llrpt_heapused},
	{"husband",         1,    1,    llrpt_husband},
	{"incr",            1,    2,    llrpt_incr},
	{"index",           3,    3,    llrpt_index},
	{"indi",            1,    1,    llrpt_indi},
	{"indiset",         1,    1,    llrpt_indiset},
	{"inlist",          2,    2,    llrpt_inlist},
	{"inode",           1,    1,    llrpt_inode},
	{"insert",          3,    3,    llrpt_insert},
	{"inset",           2,    2,    llrpt_inset},
	{"int",             1,    1,    llrpt_int},
	{"intersect",       2,    2,    llrpt_intersect},
	{"key",             1,    2,    llrpt_key},
	{"keysort",         1,    1,    llrpt_keysort},
	{"lastchild",       1,    1,    llrpt_lastchild},
	{"lastfam",         0,    0,    llrpt_lastfam},
	{"lastindi",        0,    0,    llrpt_lastindi},
	{"le",              2,    2,    llrpt_le},
	{"length",          1,    1,    llrpt_length},
	{"lengthset",       1,    1,    llrpt_lengthset},
	{"level",           1,    1,    llrpt_level},
	{"linemode",        0,    0,    llrpt_linemode},
	{"list",            1,    1,    llrpt_list},
	{"lock",            1,    1,    llrpt_lock},
	{"long",            1,    1,    llrpt_long},
	{"lookup",          2,    2,    llrpt_lookup},
	{"lower",           1,    1,    llrpt_lower},
	{"lt",              2,    2,    llrpt_lt},
	{"male",            1,    1,    llrpt_male},
	{"marriage",        1,    1,    llrpt_marr},
	{"menuchoose",      1,    2,    llrpt_menuchoose},
	{"mod",             2,    2,    llrpt_mod},
	{"monthformat",     1,    1,    llrpt_monthformat},
	{"mother",          1,    1,    llrpt_moth},
	{"mul",             2,    32,   llrpt_mul},
	{"name",            1,    2,    llrpt_name},
	{"namesort",        1,    1,    llrpt_namesort},
	{"nchildren",       1,    1,    llrpt_nchildren},
	{"ne",              2,    2,    llrpt_ne},
	{"neg",             1,    1,    llrpt_neg},
	{"nestr",           2,    2,    llrpt_nestr},
	{"newfile",         2,    2,    llrpt_newfile},
	{"nextfam",         1,    1,    llrpt_nextfam},
	{"nextindi",        1,    1,    llrpt_nextindi},
	{"nextsib",         1,    1,    llrpt_nextsib},
	{"nfamilies",       1,    1,    llrpt_nfamilies},
	{"nl",              0,    0,    llrpt_nl},
	{"not",             1,    1,    llrpt_not},
	{"nspouses",        1,    1,    llrpt_nspouses},
	{"or",              2,    32,   llrpt_or},
	{"ord",             1,    1,    llrpt_ord},
	{"outfile",         0,    0,    llrpt_outfile},
	{"pagemode",        2,    2,    llrpt_pagemode},
	{"pageout",         0,    0,    llrpt_pageout},
	{"parent",          1,    1,    llrpt_parent},
	{"parents",         1,    1,    llrpt_parents},
	{"parentset",       1,    1,    llrpt_parentset},
	{"place",           1,    1,    llrpt_place},
	{"pn",              2,    2,    llrpt_pn},
	{"pop",             1,    1,    llrpt_pop},
	{"pos",             2,    2,    llrpt_pos},
	{"prevfam",         1,    1,    llrpt_prevfam},
	{"previndi",        1,    1,    llrpt_previndi},
	{"prevsib",         1,    1,    llrpt_prevsib},
	{"print",           1,    32,   llrpt_print},
	{"program",         0,    0,    llrpt_program},
	{"push",            2,    2,    llrpt_push},
	{"pvalue",          1,    1,    llrpt_pvalue},
	{"qt",              0,    0,    llrpt_qt},
	{"reference",       1,    1,    llrpt_reference},
	{"requeue",         2,    2,    llrpt_requeue},
	{"rjustify",        2,    2,    llrpt_rjustify},
	{"roman",           1,    1,    llrpt_roman},
	{"root",            1,    1,    llrpt_rot},
	{"row",             1,    1,    llrpt_row},
	{"rsort",           1,    2,    llrpt_rsort},
	{"save",            1,    1,    llrpt_save},
	{"savenode",        1,    1,    llrpt_savenode},
	{"set",             2,    2,    llrpt_set},
	{"setel",           3,    3,    llrpt_setel},
	{"setlocale",       1,    1,    llrpt_setlocale},
	{"sex",             1,    1,    llrpt_sex},
	{"short",           1,    1,    llrpt_short},
	{"sibling",         1,    1,    llrpt_sibling},
	{"siblingset",      1,    1,    llrpt_siblingset},
	{"sin",             1,    1,    llrpt_sin},
	{"sort",            1,    2,    llrpt_sort},
	{"soundex",         1,    1,    llrpt_soundex},
	{"sp",              0,    0,    llrpt_space},
	{"spdist",          4,    4,    llrpt_spdist},
	{"spouseset",       1,    1,    llrpt_spouseset},
	{"stddate",         1,    1,    llrpt_stddate},
	{"strcmp",          2,    2,    llrpt_strcmp},
	{"strconcat",       1,    32,   llrpt_concat},
	{"strlen",          1,    1,    llrpt_strlen},
	{"strsave",         1,    1,    llrpt_save},
	{"strsoundex",      1,    1,    llrpt_strsoundex},
	{"strtoint",        1,    1,    llrpt_strtoint},
	{"sub",             2,    2,    llrpt_sub},
	{"substring",       3,    3,    llrpt_substring},
	{"surname",         1,    1,    llrpt_surname},
	{"system",          1,    1,    llrpt_runsystem},
	{"table",           1,    1,    llrpt_table},
	{"tag",             1,    1,    llrpt_tag},
	{"tan",             1,    1,    llrpt_tan},
	{"test",            2,    2,    llrpt_test},
	{"title",           1,    1,    llrpt_titl},
	{"titlecase",       1,    1,    llrpt_titlcase},
	{"trim",            2,    2,    llrpt_trim},
	{"trimname",        2,    2,    llrpt_trimname},
	{"union",           2,    2,    llrpt_union},
	{"uniqueset",       1,    1,    llrpt_uniqueset},
	{"unlock",          1,    1,    llrpt_unlock},
	{"upper",           1,    1,    llrpt_upper},
	{"value",           1,    1,    llrpt_value},
	{"valuesort",       1,    1,    llrpt_valuesort},
	{"version",         0,    0,    llrpt_version},
	{"wife",            1,    1,    llrpt_wife},
	{"writefam",        1,    1,    llrpt_writefam},
	{"writeindi",       1,    1,    llrpt_writeindi},
	{"xref",            1,    1,    llrpt_xref},
	{"year",            1,    1,    llrpt_year},
	{"yearformat",      1,    1,    llrpt_yearformat},
};

INT nobuiltins = ARRSIZE(builtins);
