/***********************************************************************************

	Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HEADER
#define LIFEOGRAPH_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <gtkmm.h>

#include "lifeobase.hpp"
#include "helpers.hpp"
#include "settings.hpp"
#include "panel_main.hpp"
#include "panel_diary.hpp"
#include "widget_textview.hpp"
#include "dialog_export.hpp"
#include "view_entry.hpp"
#include "view_login.hpp"
#include "undo.hpp"


namespace LIFEO
{
	// LONG AND EPIC TEXT MESSAGES
	namespace STRING
	{
		const char		SLOGAN[]    = N_(	"Personal, digital diary" );

		const char      SALUTATION[]    /*  TRANSLATORS: this is the message
                                            shown to the fist time users */
                                    = N_(	"Knowing others is intelligence;\n"
											"knowing yourself is true wisdom.\n"
											"Mastering others is strength;\n"
											"mastering yourself is true power.\n\n"
											"<i>--Lao Tzu</i>" );

		const char      CANNOT_WRITE[]
                                    = N_(	"Changes could not be written to diary!" );

		const char      CANNOT_WRITE_SUB[]
                                    = N_(	"Check if you have write permissions on the "
											"file and containing folder" );
	}


class Lifeograph : public Lifeobase
{
	public:
							Lifeograph( int, char** );
							~Lifeograph ();

		void				draw_welcomescreen( void );
		void				draw_loginscreen( void );

		void				update_title( void );

        void                freeze_auto_logout( void );
        void                unfreeze_auto_logout( void );

		bool				confirm_dismiss_element( void );
		Gtk::TreeRow		get_element_row( const DiaryElement* );

		void				login( void );
		bool				finish_editing( bool = true );
		void				logout( bool );

		// SIGNAL HANDLERS
		bool				handle_idle( void );
		void				show_about( void );

		bool				write_backup( void );

		void				handle_textview_entry_changed( void );

		void				handle_undo( void );
		void				handle_redo( void );

	protected:
		bool				on_delete_event( GdkEventAny* );
		bool				on_event( GdkEvent* );

		// WIDGETS
		Gtk::AboutDialog			*m_about_dialog;

		Gtk::HPaned					*m_hpaned_entry;
		Gtk::HPaned					*m_hpaned_main;

		sigc::connection			m_connection_backup;

        ViewLogin                   *m_view_login;
		DiaryView					*m_diary_view;
		CategoryTagsView			*m_category_tags_view;
		ChapterView					*m_chapter_view;
		ThemeView					*m_theme_view;

		// ACTIONS
		Glib::RefPtr< Gtk::Action >	m_action_undo;
		Glib::RefPtr< Gtk::Action >	m_action_redo;

		// VARIABLES
		const std::string			m_programpath;
		bool						m_flag_firsttimeuser;
        bool                        m_flag_force_welcome;
        bool                        m_flag_auto_logout_frozen;
};

} // end of namespace LIFEO

#endif
