/***********************************************************************************

	Copyright (C) 2007-2008 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HELPERS_HEADER
#define LIFEOGRAPH_HELPERS_HEADER

#include <iostream>
#include <fstream>

#include <gcrypt.h>

#include <gtkmm/image.h>
#include <gtkmm/menu.h>
#include <gtkmm/box.h>
#include <gtkmm/arrow.h>
#include <gtkmm/label.h>


namespace LIFEOHELPERS {

// these are not quite appropriate GTKaddon !!!
long		        convert_string (const std::string&);
std::ios::pos_type	get_file_size (std::ifstream&);

class CIPHER {
	public:
		static const int 	cCIPHER_ALGORITHM	= GCRY_CIPHER_AES256;
		static const int 	cCIPHER_MODE		= GCRY_CIPHER_MODE_CFB;
		static const int 	cIV_SIZE			= 16; // = 128 bits
		static const int	cSALT_SIZE			= 16; // = 128 bits
		static const int 	cKEY_SIZE			= 32; // = 256 bits
		static const int 	cHASH_ALGORITHM		= GCRY_MD_SHA256;

		static void			create_iv (unsigned char **);
		static void			expand_key (char const *, const unsigned char *,
                                        unsigned char **);
		static void			create_new_key (char const *, unsigned char **,
                                            unsigned char **);

		static void			encrypt_buffer (unsigned char *, size_t &,
                                            const unsigned char *, const unsigned char *);
		static void			decrypt_buffer (unsigned char *, size_t &,
                                            const unsigned char *, const unsigned char *);

	protected:


	private:

};


class ERROR {
	public:
		ERROR (const std::string& l_description) {
			std::cout << l_description << std::endl;
		}

		//~ std::string get_stream () {
			//~ return ErrorStream;
		//~ }

	protected:
		//~ virtual int get_type () {}

};

class MENU2 : public Gtk::Menu {
	public:
		MENU2 () {

		}

		//~ void set_widget (Gtk::Widget& tmp_widget) {
			//~ attach_to_widget (tmp_widget);
		//~ }

	protected:

	private:

	friend class MENUBUTTON;
};

class MENUBUTTON : public Gtk::ToggleButton {
	public:
		MENUBUTTON (const Gtk::StockID& l_stockid,
					const std::string& l_string,
					Gtk::ReliefStyle l_style = Gtk::RELIEF_NONE) {
			set_relief(l_style);
			menu = new MENU2;
			Gtk::HBox * l_hbox = Gtk::manage(
                    new Gtk::HBox );
			Gtk::Image * l_image = Gtk::manage(
                    new Gtk::Image(l_stockid, Gtk::ICON_SIZE_BUTTON) );
			label = Gtk::manage( new Gtk::Label(l_string) );
			Gtk::Arrow *l_arrow = Gtk::manage(
                    new Gtk::Arrow(Gtk::ARROW_DOWN, Gtk::SHADOW_IN) );

			l_hbox->pack_start(*l_image, Gtk::PACK_SHRINK);
			l_hbox->pack_start(*label, Gtk::PACK_SHRINK);
			l_hbox->pack_start(*l_arrow, Gtk::PACK_SHRINK);
			l_hbox->set_spacing(2);
			add(*l_hbox);
			menu->attach_to_widget(*this);
			menu->signal_deactivate().connect(sigc::mem_fun(*this, &MENUBUTTON::release));
			add_events (Gdk::BUTTON_PRESS_MASK);
		}

		~MENUBUTTON (void) {
			delete menu;
		}

		MENU2*& get_menu (void) {
			return (menu);
		}

		void release (void) {
			set_active (false);
		}

		void set_label (const Glib::ustring& l_string) {
			label->set_label(l_string);
		}

		void get_menu_position (int& x, int& y, bool& push_in) {
			get_window()->get_origin (x, y);
			x += get_allocation().get_x();
			y += get_allocation().get_y() + get_allocation().get_height();
			push_in = true;
		}

	protected:
		//~ bool on_button_press_event (GdkEventButton *l_event);
		bool on_button_press_event (GdkEventButton *l_event) {
			menu->popup(sigc::mem_fun(
                    *this, &MENUBUTTON::get_menu_position), l_event->button, l_event->time);

			set_active(true);

			return true;
		}

		MENU2				*menu;
		Gtk::Label			*label;

	private:

};

} // end of namespace LIFEOHELPERS


#endif

