/***********************************************************************************

	Copyright (C) 2007-2008 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_HEADER
#define LIFEOGRAPH_HEADER

#define LIFEOGRAPH_DEVELOPMENT_VERSION


#include <iostream>

#include <gconfmm.h>
#include <gtkmm.h>

#include <libintl.h>

// DEFINITIONS FOR LIBGETTEXT
#define _(String)               gettext(String)
#define gettext_noop(String)    String
#define N_(String)              gettext_noop(String)
//FIXME: these are temporary
#define PACKAGE     "lifeograph"
#define LOCALEDIR   "/usr/share/locale"
// END OF LIBGETTEXT DEFINITIONS

#include "helpers.hpp"
#include "password.hpp"
#include "lifeodata.hpp"

// is this the right way?
#define PIXMAPDIR   "/usr/share/pixmaps"


namespace LIFEO {
    const char          PROGRAM_NAME[] = "Lifeograph";
    const int           PROGRAM_VERSION_INT (41);
    const char          PROGRAM_VERSION_STRING[] = "0.4.1";
    const std::string   CONFIG_PATH = "/apps/lifeograph";

    // LONG AND EPIC TEXT MESSAGES
	namespace STRING {
        const char      SLOGAN[]    = N_("Personal, digital diary");
                
		const char      WRONG_PASSWORD[]
                                    = N_("Wrong password. Please retry...");

		const char      ENTER_PASSWORD[]
                                    = N_("Please enter password for selected diary...");

		const char      ENTER_PASSWORD_TIMEOUT[]
                                    = N_("Program logged out to protect your privacy. "
                                         "Please re-enter password...");

		const char      INCOMPATIBLE_DB[]
                                    = N_("Corrupt or incompatible diary. "
                                         "Please select another file...");

		const char      SELECT_DB[] = N_("Please select a diary...");

		const char      FAILED_TO_OPEN_DB[]
                                    = N_("Failed to open diary. "
                                         "Please select anoter file...");

		const char      DB_IS_NOT_ENCRYPTED[]
                                    = N_("Unencrypted diary. Press OK to open");

        const char      SALUTATION[]    /*  TRANSLATORS: this is the message
                                            shown to the fist time users */
                                    = N_("Knowing others is intelligence;\n"
                                         "knowing yourself is true wisdom.\n"
                                         "Mastering others is strength;\n"
                                         "mastering yourself is true power.\n\n"
                                         "<i>--Lao Tzu</i>");

        const char      QUIT_WITHOUT_SAVING[]
                                    = N_("All Changes of This Session Will Be Lost!");

        const char      QUIT_WITHOUT_SAVING_SUB[]
                                    = N_("If you exit normally, "
                                         "changes are saved automatically.");

        const char      CANNOT_WRITE[]
                                    = N_("Changes could not be written to diary!");

        const char      CANNOT_WRITE_SUB[]
                                    = N_("Check if you have write permissions on the "
                                         "file and containing folder");

	}
}


class COLRECENTRY : public Gtk::TreeModel::ColumnRecord {
	public:
	// CONSTRUCTOR
		COLRECENTRY () {
			add (Date);
			add (Favored);
			add (Title);
			add (Ptr);
			add (Order);
		}
	// COLUMNS
		Gtk::TreeModelColumn<Glib::ustring>     Date;
// 		Gtk::TreeModelColumn<bool>	            Favored;
		Gtk::TreeModelColumn< Glib::RefPtr<Gdk::Pixbuf> >	            Favored;
		Gtk::TreeModelColumn<Glib::ustring>	    Title;
		Gtk::TreeModelColumn<LIFEOENTRYITER>	Ptr;	// hidden
		Gtk::TreeModelColumn<int>	            Order;	// hidden
};


class LIFEOGRAPH {
	public:
		enum				UPDATEINDEX { UI_NONE=0, UI_CAL=1, UI_LIST=2, UI_BOTH=3 };

		enum				INTERNALOPERATION { INTOP_USER=0,
                                                INTOP_PARTIAL=1,
                                                INTOP_COMPLETE=2 };

        enum                LOGGINGSTATUS { LOGGED_OUT=0, LOGGED_IN=1, LOGGED_TIME_OUT=2 };

							LIFEOGRAPH (int, char **);
		virtual				~LIFEOGRAPH () { }

		void				run (void);

		bool				read_conf (void);

		void				draw_welcomescreen (void);
		void				draw_loginscreen (void);
		void				draw_editscreen (void);
		void				populate_listview_entries (void);
		void 				toggle_filterbar (void);

        void                show_entry (const Gtk::TreeModel::Row&, UPDATEINDEX=UI_NONE);
		bool				close_entry (bool=true);	// if empty, delete else save changes
                                                        // returning true if deleted
        void                delete_entry (Gtk::TreeRow&);
        void                toggle_entryfavoredness (Gtk::TreeRow&);
        void                show_today (void);

		void				update_indices (void);
		void				update_calendar (void);
		void				update_title (void);
        bool                update_toolbar (void);

		void				start_dialog_password (void);
		//void				end_dialog_password (void);

        bool                initialize_new_database (void);
        void                quit_withoutsaving (void);
        bool                logout (void);

	    // SIGNAL HANDLERS
        bool                handle_event (GdkEvent*);
		bool				handle_event_delete (GdkEventAny*);
        bool                handle_event_expose (GdkEventExpose*);
        bool                handle_idle (void);
        void                handle_filebutton_db_selectionchanged (void);
        void                handle_button_newdb_clicked (void);
		void 				handle_entry_password_changed (void);
		void 				handle_button_opendb_clicked (void);
		void 				handle_button_about_clicked (void);
		void 				handle_button_quit_clicked (void);

		void 				handle_button_backup_clicked (void);
        void                handle_button_logout_clicked (void);
		void 				handle_toolbutton_previous_clicked (void);
		void 				handle_toolbutton_next_clicked (void);

		void				handle_treeview_entries_selectionchanged (void);
		void				handle_treeview_entries_rowactivated
                                    (const Gtk::TreeModel::Path&, Gtk::TreeViewColumn*);
		void				handle_treeview_entries_event_buttonpress (GdkEventButton*);
        void                handle_treeview_sortcolumnchanged (void);

		void				handle_textview_entry_changed (void);

		void				handle_calendar_doubleclicked (void);
		void				handle_calendar_monthchanged (void);
		void				handle_calendar_dayselected (void);

        void                handle_entry_filter_changed (void);
        void                handle_button_filter_clicked (void);

        // TREEVIEW SORTER FUNCTIONS
        int                 sort_date_column
                                    (const Gtk::TreeModel::iterator&,
                                     const Gtk::TreeModel::iterator&);
        int                 sort_favored_column
                                    (const Gtk::TreeModel::iterator&,
                                     const Gtk::TreeModel::iterator&);

	protected:
        // WIDGETS
		Gtk::Window			        *WindowMain;
        Gtk::FileChooserDialog      *FilechoosedialogSave;
		Gtk::Label			        *LabelStartupMessage;
        Gtk::FileChooserButton      *FilebuttonDB;
		Gtk::Entry			        *EntryPassword;
		Gtk::Button			        *ButtonOpenDatabase;
		LIFEOHELPERS::MENUBUTTON    *MenubuttonEntry;
		LIFEOHELPERS::MENUBUTTON    *MenubuttonOptions;

		Gtk::HBox			        *HboxNavigation;
		Gtk::HBox			        *HboxFilter;
		Gtk::Calendar		        *Calendar;

        Gtk::Entry                  *EntryFilter;

		Glib::RefPtr<Gtk::ListStore>	ListstoreEntries;

		Gtk::ToolButton		        *ToolbuttonPrevious;
		Gtk::ToolButton		        *ToolbuttonNext;
		Gtk::ToolButton		        *ToolbuttonToday;
		Gtk::ToggleToolButton	    *ToolbuttonFilter;
		Gtk::ToolButton		        *ToolbuttonLogout;
		Gtk::TextView		        *TextviewEntry;
		Gtk::TreeView		        *TreeviewEntries;
        Gtk::Button                 *ButtonFilterClear;    
		COLRECENTRY	    	        ColrecEntry;
        
        Gtk::Menu                   *MenuEntry;

        Glib::RefPtr<Gdk::Pixbuf>   PixbufFavored;
        Glib::RefPtr<Gdk::Pixbuf>   PixbufUnfavored;

        Gtk::TreeModel::Row CurrentEntryRow;

        sigc::connection            SigconnectionEvent;
        sigc::connection            SigconnectionTimeout;
        sigc::connection            SigconnectionEventExpose;

		Glib::RefPtr<Gnome::Conf::Client>	GconfClient;
		DIALOGPASSWORD		        *DialogPassword;
        Glib::RefPtr<Gdk::Pixbuf>   PixbufBackground;

        // ACTIONS
        Glib::RefPtr<Gtk::Action>   ActionToggleFilter;
        Glib::RefPtr<Gtk::Action>   ActionPrevious;
        Glib::RefPtr<Gtk::Action>   ActionNext;
        Glib::RefPtr<Gtk::Action>   ActionToday;

        // VARIABLES
		const std::string	        ProgramPath;
		INTERNALOPERATION	        InternalOperation;
		LOGGINGSTATUS		        LoggingStatus;
        int                         EntryCount;
        bool                        EntryChanged;

	private:
		LIFEODATA			        Database;

};

#endif

