/***********************************************************************************

	Copyright (C) 2007-2008 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#include <iostream>

#include <libintl.h>

#include <gtkmm/table.h>
#include <gtkmm/label.h>
#include <gtkmm/stock.h>

#include "password.hpp"

// DEFINITIONS FOR LIBGETTEXT
#define _(String)               gettext(String)
#define gettext_noop(String)    String
#define N_(String)              gettext_noop(String)
// END OF LIBGETTEXT DEFINITIONS


DIALOGPASSWORD::DIALOGPASSWORD (const std::string& l_passphraseOld,
                                const Glib::ustring& l_title,
                                bool l_modal)
:   Gtk::Dialog(l_title, l_modal, true), PassphraseOld(l_passphraseOld),
    PassphraseIsSet(false) {
	Gtk::Table *l_table = Gtk::manage( new Gtk::Table(3, 2) );
	l_table->set_spacings(5);
	l_table->set_border_width(8);

	Gtk::Label *l_labelCurrent = Gtk::manage(
            new Gtk::Label(_("Current Password:"), Gtk::ALIGN_LEFT) );
	EntryCurrent = Gtk::manage( new Gtk::Entry );
	EntryCurrent->set_visibility(false);
    ButtonAuthenticate = Gtk::manage( new Gtk::Button );
    Gtk::Image *l_iconApply = Gtk::manage(
            new Gtk::Image(Gtk::Stock::APPLY, Gtk::ICON_SIZE_MENU) );
    ButtonAuthenticate->set_image(*l_iconApply);
    ButtonAuthenticate->set_tooltip_text(_("Authenticate"));

	if (l_passphraseOld.size() > 0) {
		l_table->attach(*l_labelCurrent, 0, 1, 0, 1, Gtk::SHRINK | Gtk::FILL);
		l_table->attach(*EntryCurrent, 1, 2, 0, 1, Gtk::EXPAND | Gtk::FILL);
		l_table->attach(*ButtonAuthenticate, 2, 3, 0, 1, Gtk::SHRINK);
	}

	Gtk::Label *l_labelNew = Gtk::manage(
            new Gtk::Label(_("New Password:"), Gtk::ALIGN_LEFT) );
	EntryNew = Gtk::manage( new Gtk::Entry );
	EntryNew->set_visibility(false);
	EntryNew->set_sensitive(l_passphraseOld.size() <= 0);
    l_table->attach(*l_labelNew, 0, 1, 1, 2, Gtk::SHRINK | Gtk::FILL);
	l_table->attach(*EntryNew, 1, 2, 1, 2, Gtk::EXPAND | Gtk::FILL);

	Gtk::Label *l_labelConfirm = Gtk::manage(
            new Gtk::Label(_("Confirm New Password:"), Gtk::ALIGN_LEFT) );
	EntryConfirm = Gtk::manage( new Gtk::Entry );
	EntryConfirm->set_visibility(false);
    EntryConfirm->set_sensitive(l_passphraseOld.size() <= 0);
	l_table->attach(*l_labelConfirm, 0, 1, 2, 3, Gtk::SHRINK | Gtk::FILL);
	l_table->attach(*EntryConfirm, 1, 2, 2, 3, Gtk::EXPAND | Gtk::FILL);

    ImageMatch = Gtk::manage(
            new Gtk::Image(Gtk::Stock::NO, Gtk::ICON_SIZE_MENU) );
	l_table->attach(*ImageMatch, 2, 3, 1, 3, Gtk::SHRINK);

	get_vbox()->pack_start(*l_table);
	get_vbox()->set_spacing(5);

    add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
	ButtonChange = add_button(_("C_hange"), Gtk::RESPONSE_OK);
    Gtk::Image *l_iconOk = Gtk::manage(
            new Gtk::Image(Gtk::Stock::OK, Gtk::ICON_SIZE_MENU) );
    ButtonChange->set_image(*l_iconOk);
	ButtonChange->set_sensitive(false);

    ButtonAuthenticate->signal_clicked().connect(
            sigc::mem_fun(*this, &DIALOGPASSWORD::authenticate));
	EntryNew->signal_changed().connect(
            sigc::mem_fun(*this, &DIALOGPASSWORD::check_match));
	EntryConfirm->signal_changed().connect(
            sigc::mem_fun(*this, &DIALOGPASSWORD::check_match));
}

void DIALOGPASSWORD::authenticate () {
    if (EntryCurrent->get_text() == PassphraseOld) {
        EntryNew->set_sensitive(true);
        EntryConfirm->set_sensitive(true);
        EntryNew->grab_focus();
        EntryCurrent->set_sensitive(false);
        ButtonAuthenticate->set_sensitive(false);
    }
}

void DIALOGPASSWORD::check_match() {
	if (    EntryConfirm->get_text().size() >= LIFEO::PASSPHRASE_MIN_SIZE &&
            EntryNew->get_text() == EntryConfirm->get_text()) {
        ImageMatch->set(Gtk::Stock::YES, Gtk::ICON_SIZE_MENU);
        ButtonChange->set_sensitive(true);
	}
    else {
        ImageMatch->set(Gtk::Stock::NO, Gtk::ICON_SIZE_MENU);
        ButtonChange->set_sensitive(false);
	}
}

void DIALOGPASSWORD::on_response (int l_response) {
    switch (l_response) {
        case Gtk::RESPONSE_OK:
            PassphraseNew = EntryConfirm->get_text();
            PassphraseIsSet = true;
        break;
        default:
        break;
    }
}

