/* ----------------------------------------------------------------------
LIGGGHTS - LAMMPS Improved for General Granular and Granular Heat
Transfer Simulations

www.liggghts.com | www.cfdem.com
Christoph Kloss, christoph.kloss@cfdem.com

LIGGGHTS is based on LAMMPS
LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
http://lammps.sandia.gov, Sandia National Laboratories
Steve Plimpton, sjplimp@sandia.gov

Copyright (2003) Sandia Corporation. Under the terms of Contract
DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
certain rights in this software. This software is distributed under
the GNU General Public License.

See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef CFD_REGIONMODEL_CLASS

   CfdRegionStyle(differentialregionmodel,CfdRegionmodelDifferential)

#else

#ifndef LMP_CFD_REGIONMODEL_DIFFERENTIAL_H
#define LMP_CFD_REGIONMODEL_DIFFERENTIAL_H

#include "cfd_regionmodel_none.h"

namespace LAMMPS_NS {

class CfdRegionmodelDifferential : public CfdRegionmodelNone {
 public:
  CfdRegionmodelDifferential(class LAMMPS *, int, int, char **,class FixCfdCoupling* fc);
  ~CfdRegionmodelDifferential();
  void init();

 protected:

 double limsqr;
 class FixPropertyAtom *pos_lastup;
 double **x_upd;

 class FixPropertyGlobal *arraypos_lastc;
 double *arraypos_lastcouple;

  virtual void rm_update();
  void special_settings();

};

}

#endif
#endif
