/* ----------------------------------------------------------------------
LIGGGHTS - LAMMPS Improved for General Granular and Granular Heat
Transfer Simulations

www.liggghts.com | www.cfdem.com
Christoph Kloss, christoph.kloss@cfdem.com

LIGGGHTS is based on LAMMPS
LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
http://lammps.sandia.gov, Sandia National Laboratories
Steve Plimpton, sjplimp@sandia.gov

Copyright (2003) Sandia Corporation. Under the terms of Contract
DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
certain rights in this software. This software is distributed under
the GNU General Public License.

See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(couple/cfd,FixCfdCoupling)

#else

#ifndef LMP_FIX_CFD_COUPLING_H
#define LMP_FIX_CFD_COUPLING_H

#include "fix.h"

namespace LAMMPS_NS {

class FixCfdCoupling : public Fix {
 friend class CfdRegionmodel;
 friend class CfdDatacoupling;

 public:

  FixCfdCoupling(class LAMMPS *, int, char **);
  ~FixCfdCoupling();
  void post_create();

  int setmask();
  void init();
  virtual void setup(int);
  virtual void min_setup(int);
  void end_of_step();
  void post_force_respa(int, int, int);
  void min_post_force(int);

  // pushing and pulling of properties
  //void pull(char *name,char *type,void *&ptr);
  //void push(char *name,char *type,void *&ptr);
  void add_push_property(char *name,char *type);
  void add_pull_property(char *name,char *type);
  void check_datatransfer();

  int coupleThis() {return couple_this_;}

  class CfdDatacoupling* get_dc(){return dc_;}
  //inline class FixRigidMultisphere* fix_rigid_ms() {return dc_->frm_;}

 protected:

  int iarg_;

  // data transfer is handled by this class
  class CfdDatacoupling *dc_;

 private:

  int couple_this_;

  // couple every couple_nevery_ timesteps
  // not used in case of MPI coupling
  int couple_nevery_,ts_create_;

  // regionmodels
  class CfdRegionmodel *rm_;

  int nlevels_respa;
};

}

#endif
#endif
