/* ----------------------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under 
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(wall/harmonic,FixWallHarmonic)

#else

#ifndef LMP_FIX_WALL_HARMONIC_H
#define LMP_FIX_WALL_HARMONIC_H

#include "fix_wall.h"

namespace LAMMPS_NS {

class FixWallHarmonic : public FixWall {
 public:
  FixWallHarmonic(class LAMMPS *, int, char **);
  void precompute(int) {}
  void wall_particle(int, double);

 private:
  double offset[6];
};

}

#endif
#endif
