/* ----------------------------------------------------------------------
   LAMMPS - Large-scale Atomic/Molecular Massively Parallel Simulator
   http://lammps.sandia.gov, Sandia National Laboratories
   Steve Plimpton, sjplimp@sandia.gov

   Copyright (2003) Sandia Corporation.  Under the terms of Contract
   DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government retains
   certain rights in this software.  This software is distributed under 
   the GNU General Public License.

   See the README file in the top-level LAMMPS directory.
------------------------------------------------------------------------- */

#ifdef FIX_CLASS

FixStyle(freeze,FixFreeze)

#else

#ifndef LMP_FIX_FREEZE_H
#define LMP_FIX_FREEZE_H

#include "fix.h"

namespace LAMMPS_NS {

class FixFreeze : public Fix {
 public:
  FixFreeze(class LAMMPS *, int, char **);
  int setmask();
  void init();
  void setup(int);
  void post_force(int);
  void post_force_respa(int, int, int);
  double compute_vector(int);

 private:
  int force_flag;
  double foriginal[3],foriginal_all[3];
};

}

#endif
#endif
