//  SspiExample.h
#ifndef _SSPI_EX_H_
#define _SSPI_EX_H_

#define ALIGN_UP(_p_,_s_) ((((_p_) + ((_s_)-1)) / (_s_)) * (_s_))
#define ALIGN_UP_LPWSTR(_p_) (ALIGN_UP((_p_),(__alignof(LPWSTR))))

#define WSZ_BYTECOUNT(_s_) ((ULONG)(wcslen((_s_)) * sizeof(WCHAR)))

#define OFFSET_TO_POINTER(_b_,_o_)  ((PCHAR)(((PCHAR)(_b_))+((ULONG_PTR)(_o_))))
#define POINTER_TO_OFFSET(_b_,_p_)  ((ULONG)(((PCHAR)(_p_)) - ((PCHAR)(_b_))))
#define POINTER_TO_OFFSET_S(_b_,_p_)  ((USHORT)(((PCHAR)(_p_)) - ((PCHAR)(_b_))))


#define SAFE_FREE(_p_)      if(_p_) LocalFree(_p_);
#define SEC_SUCCESS(Status) ((Status) >= 0)
#define MAX_TOKEN 20000
#define MAX_SERVERNAME 512 

DWORD 
SendMsg(
	SOCKET s,
	PBYTE pBuf, 
	DWORD cbBuf
    );


DWORD 
ReceiveMsg(
	SOCKET  s, 
	PBYTE   pBuf, 
	DWORD   cbBuf, 
	DWORD  *pcbRead
    );


void
DumpSecBuffer(
    char *msg,
    SecBuffer *sb,
    BOOL verbose
    );

DWORD
BuildAuthIdentity(
	  LPWSTR user,
	  LPWSTR password,
	  LPWSTR domain,
	  PSEC_WINNT_AUTH_IDENTITY_EXW *id
	  );

SECURITY_STATUS
EncryptBuffer(
    PCtxtHandle hCtxt,
    SecBuffer *in,
    SecBuffer *out,
    ULONG seq,
    ULONG qop,
    BOOL gss
    );

SECURITY_STATUS
DecryptBuffer(
	PCtxtHandle hCtxt,
	SecBuffer *in,
	SecBuffer *decrypted,
	ULONG *pQop,
	ULONG seq,
    BOOL gss
	);

DWORD
SendError(
    SOCKET  s,
    DWORD dwError
    );

#endif
