/****************************************************************************
**
** $Id: CvsBuffer.cpp,v 1.7 2004/02/11 01:09:26 hemer Exp $
**
** Copyright (C) 2001-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.at>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "CvsBuffer.h"

//only needed for Log stuff --> skip it if we are sure all works fine
#include "globals.h"
#include "LinCVSLog.h"


#ifdef Q_WS_WIN
#define LFOFFSET 2
#else
#define LFOFFSET 1
#endif

CvsBuffer::CvsBuffer() 
   : line(0)
{
  clear();
}

CvsBuffer::~CvsBuffer() {
  delete line;
  line = NULL;
}

void CvsBuffer::clear() {

  buff = "";
  delete line;

  line = new std::vector<unsigned int>;
  line->push_back(0);
  index = 0;
  linesCount = 0;
  m_bClippedLine = FALSE;
}

void CvsBuffer::append( const QString& s) {

  int pos = s.find('\n');

  if (m_bClippedLine) {
    line->pop_back();
    linesCount--;
    m_bClippedLine = FALSE;
  }

  while (pos>-1) {
    line->push_back(index + (unsigned int)pos + 1);
    linesCount++;
    pos = s.find('\n',pos+1);
  }

  if (s.at(s.length()-1) != '\n') {//string contains a line without a newline at the end
    m_bClippedLine = TRUE;
    line->push_back(index + (unsigned int)s.length());
    linesCount++;   //we increase here the number of lines but not if we append the next string for the first line
  }
  buff.append(s);
  index += s.length();
}

int CvsBuffer::numLines() const {
  return linesCount;
}

QString CvsBuffer::textLine(int l) const {

  if ( (l < 0) || (l >= linesCount) ) return QString::null;

  unsigned int from = (*line)[l];
  unsigned int to = (*line)[l+1];
  return buff.mid(from,to-from-LFOFFSET);
}

QString CvsBuffer::readAll() {
  return buff;
}
