/***************************************************************************
                          konqclient.h  -  description
                             -------------------
    begin                : Mon Jul 22 2002
    copyright            : (C) 2002 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KONQCLIENT_H
#define KONQCLIENT_H
#include <qcstring.h>
#include <dcopclient.h>

/**Controls konqueror via dcop.
  *@author Sheldon Lee Wen
  */
using namespace std;

class KonqClient {
public: 
    KonqClient(DCOPClient *idcop);
    virtual ~KonqClient();
    void forward();
    void back();
    void refresh();
    void newtab();
    void home();
    void stop();
    void addBookmark();
    bool isRunning();
    bool startKonqueror();
    QCString getActive();

  protected:
    DCOPClient *dcop;
    QCString konqid, objid;
    virtual void doDCOP(QCString objid, QCString func);

};

#endif
