/***************************************************************************
                          kdeplugin.cpp  -  description
                             -------------------
    begin                : 日 10月 26 2003
    copyright            : (C) 2003 by Sheldon Lee Wen
    email                : leewsb@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstringlist.h>
#include <qstring.h>
#include <dcopobject.h>
#include <dcopclient.h>
#include <kapplication.h>
#include <klocale.h>

#include "konqclient.h"

#include <config.h>
#include <lineak/lconfig.h>
#include <lineak/lkbd.h>
#include <lineak/lkey.h>
#include <lineak/lobject.h>
#include <lineak/plugin_definitions.h>
#include <lineak/displayctrl.h>

#include <iostream>
#include <sstream>
#include <stdlib.h>
using namespace std;

#include "konqplugin.h"

/** These are required */
#define NUM_MACROS 1
char* konq_symbols[NUM_MACROS] = { "KONQUEROR" };
macro_info* konq_macinfo = NULL;
identifier_info* konq_idinfo = NULL;
bool verbose = false;
bool enable;
displayCtrl* konq_Display = NULL;
DCOPClient* konq_dcop;

extern "C" int initialize(init_info init) {
        verbose = init.verbose;
	enable = init.global_enable;
	konq_dcop = new DCOPClient();
	if (!(konq_dcop->registerAs( "konqlineakdcop" )))
            if (verbose) cerr << "Could not register" << endl;
	if (!konq_dcop->attach()) {
            if (verbose) cerr << "Could not attach konq_dcop to dcop server" << endl;
        } else
            if (verbose) cout << "Registered" << endl;

	return true;
}
extern "C" identifier_info* identifier() {
	konq_idinfo = new (identifier_info);
	konq_idinfo->description = "Konqueror Plugin";
	konq_idinfo->identifier = "konqplugin";
	konq_idinfo->type = "MACRO";
	return konq_idinfo;
}
extern "C" int exec(LObject* imyKey, XEvent xev) {
	LCommand command;
	if (imyKey->getType() == CODE || imyKey->getType() == SYM)
           command = imyKey->getCommand(xev.xkey.state);
        if (imyKey->getType() == BUTTON)
           command = imyKey->getCommand(xev.xbutton.state);

        string dname;
        if (imyKey->isToggle())
           dname = imyKey->getNextToggleName();
        else
           dname = imyKey->getName();

	/* Give verbose output about the command and display name */
	if (verbose) {
		cout << "----------------------------------------" << endl;
		//cout << "For keycode: " << keycode << endl;
		cout << " Key: " << endl << *(imyKey) << endl;
	  	cout << "	XOSD Display: " << dname << endl;
		cout << "	Command: " << command << endl;
		cout << "----------------------------------------" << endl;
	}
        if ( command.getMacroType() == "KONQUEROR") { 
                macroKONQUEROR(command);
        } else if (command.isMacro())  /** If we are a macro, but we can't find one that matches, return false. */
                return false;

        if (imyKey->isToggle())
             imyKey->toggleState();


        return true;
}
extern "C" macro_info* macrolist() {
	konq_macinfo = new (macro_info);
	konq_macinfo->num_macros = NUM_MACROS;
	konq_macinfo->macro_list = konq_symbols;
        return konq_macinfo;
}
extern "C" void cleanup() {
        if (verbose) cout << "Cleaning up plugin konqueror" << endl;
	if (konq_macinfo != NULL) {
		delete (konq_macinfo);
		konq_macinfo = NULL;
	}
	if (konq_idinfo != NULL) {
		delete (konq_idinfo);
		konq_idinfo = NULL;
	}
 	if (konq_dcop != NULL) {
		konq_dcop->detach();
 		delete(konq_dcop);
 		konq_dcop = NULL;
 	}
	if (verbose) cout << "Done cleaning up plugin konqueror" << endl;
}
extern "C" int initialize_display(displayCtrl *imyDisplay) {
        if (verbose) cout << "Initializing on screen display!" << endl;
        konq_Display = imyDisplay;
	return true;
}

bool macroKONQUEROR(LCommand& command) {
   if (enable) {
	const vector<std::string>& args = command.getArgs();

	if (args.size() < 1)
		return false;

	QCString objid;
    	QCString function;
        QByteArray data;
	QCString foundApp;
	QCString foundObj;

	KonqClient konq(konq_dcop);
	if (!konq.isRunning()) {
	   if (!konq.startKonqueror()) {
              if (KApplication::startServiceByDesktopName("konqueror")) {
	         cout << i18n("No running instance of konqueror found.");
              }
           }
	}

	if (args.size() == 1) {
	   QString comm = QString((args[0]).c_str());
	   
	   if ( comm.upper() == "BACK" ) {
	      konq.back();
	   }
	   else if ( comm.upper() == "FORWARD" ) {
	      konq.forward();
	   }
	   else if ( comm.upper() == "HOME" ) {
	      konq.home();
	   }
	   else if ( comm.upper() == "STOP" ) {
	      konq.stop();
	   }
	   else if ( comm.upper() == "REFRESH" || comm.upper() == "RELOAD" ) {
	      konq.refresh();
	   }
	   else if ( comm.upper() == "NEWTAB" ) {
	      konq.newtab();
	   }
	   else if ( comm.upper() == "BOOKMARK" ) {
	      konq.addBookmark();
	   }
	   else {
	      if (verbose) {
		cerr << comm << " is an unknown KONQUEROR macro argument." << endl;
		cerr << "Valid arguments are: BACK, FORWARD, REFRESH or RELOAD, NEWTAB" << endl;
	      }
	      return false;
	   }
	konq_Display->show(comm.latin1());
	}
	return true;
   }
   return false;
}

