#include "srv_def.h"

#if HAVE_LIBCRYPT

// else we can't use crypt():
#define _GNU_SOURCE
#define _XOPEN_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>
#include <arpa/inet.h>

#include <pwd.h>
#include <sys/types.h>

#include "global_vars.h"
#include "ipvalidator.h"

#define USER_MAX_LINESIZE	1020

int vrfy_user(const char *name, const char *pass)
// 0 if valid, else -1, -2 on error
{
	char found = 0;
	char needshadow = 0;
	char salt[12];
	struct passwd *pwdata;
	char *password;

	setpwent();
	while ( (pwdata = getpwent()) )
	{
		if ( !strcmp(pwdata->pw_name, name) )
		{
			found++;
			break;
		}
	}

	if ( !found )
	{
		endpwent();
		return -1; // no such user
	}

	// now check wheather we need the shadow file
	if ( strlen(pwdata->pw_passwd) < 13 )
		switch ( *pwdata->pw_passwd )
		{
			case 'x': needshadow++;	break;
			case '*':
			default:
				endpwent();
				return -1;
		}

	if ( needshadow )
	{
		FILE *fsh;
		char found = 0;
		char line[500];
		char *idx;
		int len = strlen(name);

		endpwent();

		if ( !(fsh = fopen(SHADOW_PWD_FILE, "r")) )
		{
			syslog(LOG_ERR, "Opening '%s' to read password failed.",
						SHADOW_PWD_FILE);
			return -2;
		}
		while ( fgets(line, sizeof(line), fsh) )
			if ( !strncmp(line, name, len) )
			{
				found++;
				break;
			}
		fclose(fsh);
		if ( !found ) return -1;
		idx = line+len+1;
		while ( *idx && *idx != ':' ) idx++;
		if ( !*idx ) return -1;
		*idx = 0;
		password = strdup(line+len+1);
		if ( !password ) return -1;
	}
	else
	{
		password = strdup(pwdata->pw_passwd);
		endpwent();
		if ( !password ) return -1;
	}

	if ( !strncmp("$1$", password, 3) )
	{ // we're using MD5 passwords
		salt[11] = 0;
		memcpy(salt, password, 11);
	}
	else
	{ // we're using DES passwords
		salt[0] = *password;
		salt[1] = password[1];
		salt[2] = 0;
	}

	if ( !strcmp(crypt(pass, salt), password) )
	{
		#ifdef DEBUG
			syslog(LOG_DEBUG, "user %s supplied correct passwd.", name);
		#endif
		free(password);
		return 0; // ok, access granted
	}

	#ifdef DEBUG
		syslog(LOG_DEBUG, "user %s access denied: wrong passwd.", name);
	#endif
	free(password);
	return -1; // access denied
}

#ifdef SHUTDOWN_OK
int shutdown_allowed(struct client_t*who)
{
    struct sockaddr_in saddr;
    saddr.sin_addr.s_addr = who->ip;
    saddr.sin_family = AF_INET;
    saddr.sin_port = who->port;
    syslog(LOG_INFO, "SHUTDOWN: checking only against IP (+user-accounting if enabled)!");
    return(validate_ip(server->shtdn_ipl_type, &shtdn_ipl, &saddr));
}
#endif //SHUTDOWN_OK
#endif // HAVE_LIBCRYPT
