/*
 * Copyright (c) 2002-2003, The LingoTeach Team
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, 
 *   this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * * Neither the name of the Software nor the names of its contributors 
 *   may be used to endorse or promote products derived from this software 
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <libxml/xpath.h>
#include "filter.h"

/* 
 * filter for kvoctrain files 
 */
extern lingConfig *settings;

lingMeaning*
filter_kvoc (char *filename)
{
  
  int id = 1;
 
  xmlDocPtr  doc;
  xmlNodePtr child;
  xmlNodePtr translation;

  lingMeaning *meaning = NULL;
  lingMeaning *new = NULL;
  lingMeaning *prev;

  doc = xmlParseFile (filename);
  if (doc == NULL)
    return NULL;
  
  doc->parent = xmlDocGetRootElement (doc);
  if (doc->parent == NULL || doc->parent->name == NULL)
    return NULL;

  child = doc->parent->children;
  if (!child)
    return NULL;

  for (child = child->next; child != NULL; child = child->next)
    {
      if (xmlStrncmp (child->name, "e", strlen (child->name)) != 0)
	continue;
      
      for (translation = child->children; translation != NULL; 
	   translation = translation->next)
	{

 	  if (xmlStrncmp (translation->name, "o",
 			  strlen (translation->name)) == 0 
	      || xmlStrncmp (translation->name, "t",
			     strlen (translation->name)) == 0)
	    {
	      printf (":: %s\n", translation->name);
	      if (xmlIsBlankNode (translation) == 1)    /* skip blank ones */
		continue;
	      
	      if (meaning == NULL)
		{
		  meaning = ling_meaning_get_new ();
		  new = meaning;
		  new->prev = NULL;
	      new->next = NULL;
		}
	      else
		{
		  new->next = ling_meaning_get_new ();
		  prev = new;
		  new = prev->next;
		  new->prev = prev;
		  new->next = NULL;
		}
	      printf (":: %s\n", xmlNodeGetContent (translation));
	      /* fill the meaning */
	      new->id = id;
	      new->type = NULL;
	      new->language = NULL;
	      new->translation = xmlNodeGetContent (translation);
	    }
	  else continue;
	}
      id++;
    }
  if (!ling_meaning_save_meanings (meaning, "/tmp/test.xml", settings))
    printf ("dsadsadsa\n");
  return meaning;
}
