/* This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "lingoteach-i18n.h"
#include "editor.h"

extern lingConfig *settings; /* global settings */

struct 
{
  GtkWidget *cmb_language;
  GtkWidget *txt_type;
  GtkWidget *txt_trans;
} editMeaning;


/* prototypes */
GtkWidget* create_dlg_edit (lingMeaning *meaning, gboolean add);


/*********************
 * private functions *
 *********************/

GtkWidget*
create_dlg_edit (lingMeaning *meaning, gboolean add)
{
  GtkWidget *dlg_edit;
  GtkWidget *dlg_box;
  GtkWidget *tbl_main;
  GtkWidget *lbl_edit;
  GtkWidget *sep_1;

  GtkWidget *lbl_type;

  GtkWidget *lbl_lang;
  GtkWidget *combo_entry1;

  GtkWidget *lbl_translation;

  GtkWidget *dialog_action_area1;
  GtkWidget *btn_cancel;
  GtkWidget *btn_ok;

  GList *list = NULL;
  gint i = ling_lang_get_max_languages (settings);
  lingchar **lang = ling_lang_get_languages (settings);
  
  while (--i >= 0)
    list = g_list_append (list, lang[i]);

  dlg_edit = gtk_dialog_new ();
  
  (add) ?
    gtk_window_set_title (GTK_WINDOW (dlg_edit), _("Add Translation")) :
    gtk_window_set_title (GTK_WINDOW (dlg_edit), _("Edit Translation"));

  
  gtk_window_set_modal (GTK_WINDOW (dlg_edit), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (dlg_edit), TRUE);

  dlg_box = GTK_DIALOG (dlg_edit)->vbox;
  gtk_widget_show (dlg_box);

  tbl_main = gtk_table_new (5, 2, FALSE);
  gtk_widget_show (tbl_main);
  gtk_box_pack_start (GTK_BOX (dlg_box), tbl_main, TRUE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (tbl_main), 5);
  gtk_table_set_col_spacings (GTK_TABLE (tbl_main), 2);

  (add) ?
    (lbl_edit = gtk_label_new (_("Add Meaning:"))) :
    (lbl_edit = gtk_label_new (_("Edit Meaning:")));
  
  gtk_widget_show (lbl_edit);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_edit, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (lbl_edit), 0.5, 0);

  sep_1 = gtk_hseparator_new ();
  gtk_widget_show (sep_1);
  gtk_table_attach (GTK_TABLE (tbl_main), sep_1, 0, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);

  lbl_type = gtk_label_new (_("Type of the meaning:"));
  gtk_widget_show (lbl_type);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_type, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lbl_type), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lbl_type), 0, 0.5);

  editMeaning.txt_type = gtk_entry_new ();
  gtk_widget_show (editMeaning.txt_type);
  gtk_table_attach (GTK_TABLE (tbl_main), editMeaning.txt_type, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  if (meaning->type)
    gtk_entry_set_text (GTK_ENTRY (editMeaning.txt_type), meaning->type);

  lbl_lang = gtk_label_new (_("Language:"));
  gtk_widget_show (lbl_lang);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_lang, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lbl_lang), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lbl_lang), 0, 0.5);

  editMeaning.cmb_language = gtk_combo_new ();
  gtk_widget_show (editMeaning.cmb_language);
  gtk_table_attach (GTK_TABLE (tbl_main), editMeaning.cmb_language, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (editMeaning.cmb_language), 
			       TRUE, FALSE);

  if (list)
    gtk_combo_set_popdown_strings (GTK_COMBO (editMeaning.cmb_language), list);

  combo_entry1 = GTK_COMBO (editMeaning.cmb_language)->entry;
  gtk_widget_show (combo_entry1);

  if (meaning->language)
    gtk_entry_set_text (GTK_ENTRY (combo_entry1), meaning->language);

  lbl_translation = gtk_label_new (_("Translation:"));
  gtk_widget_show (lbl_translation);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_translation, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (lbl_translation), GTK_JUSTIFY_LEFT);
  gtk_misc_set_alignment (GTK_MISC (lbl_translation), 0, 0.5);

  editMeaning.txt_trans = gtk_entry_new ();
  gtk_widget_show (editMeaning.txt_trans);
  gtk_table_attach (GTK_TABLE (tbl_main), editMeaning.txt_trans, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  if (meaning->translation)
    gtk_entry_set_text (GTK_ENTRY (editMeaning.txt_trans), 
			meaning->translation);

  dialog_action_area1 = GTK_DIALOG (dlg_edit)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), 
			     GTK_BUTTONBOX_END);

  btn_cancel = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
  gtk_widget_show (btn_cancel);
  gtk_dialog_add_action_widget (GTK_DIALOG (dlg_edit), btn_cancel, 
				GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (btn_cancel, GTK_CAN_DEFAULT);

  btn_ok = gtk_button_new_from_stock (GTK_STOCK_OK);
  gtk_widget_show (btn_ok);
  gtk_dialog_add_action_widget (GTK_DIALOG (dlg_edit), btn_ok, 
				GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (btn_ok, GTK_CAN_DEFAULT);

  return dlg_edit;
}


/********************
 * public functions *
 ********************/

lingMeaning*
edit_meaning (lingMeaning *meaning)
{
  const gchar *type;
  const gchar *trans;
  const gchar *lang;
  lingMeaning *new  = NULL;
  GtkWidget   *edit = create_dlg_edit (meaning, FALSE);
  gint         result = gtk_dialog_run (GTK_DIALOG (edit));
  GtkWidget   *tmp;

  switch (result)
    {
      
    case GTK_RESPONSE_OK:
      tmp = (GTK_COMBO (editMeaning.cmb_language))->entry;
      lang = gtk_entry_get_text (GTK_ENTRY (tmp));
      type = gtk_entry_get_text (GTK_ENTRY (editMeaning.txt_type));
      trans = gtk_entry_get_text (GTK_ENTRY (editMeaning.txt_trans));
      new = ling_meaning_get_new ();

      new->id = meaning->id;

      new->language = ling_malloc (strlen (lang));
      strcpy (new->language, lang);

      new->type = ling_malloc (strlen (type));
      strcpy (new->type, type);

      new->translation = ling_malloc (strlen (trans));
      strcpy (new->translation, trans);
      gtk_widget_destroy (edit);

      break;
    case GTK_RESPONSE_CANCEL:
      gtk_widget_destroy (edit);
      break;
    default:
      gtk_widget_destroy (edit);
      break;
    }
  return new; 
}

lingMeaning*
add_meaning (lingMeaning *meaning)
{
  const gchar *type;
  const gchar *trans;
  const gchar *lang;
  lingMeaning *new  = NULL;
  GtkWidget   *edit = create_dlg_edit (meaning, TRUE);
  gint         result = gtk_dialog_run (GTK_DIALOG (edit));
  GtkWidget   *tmp;

  switch (result)
    {
      
    case GTK_RESPONSE_OK:
      tmp = (GTK_COMBO (editMeaning.cmb_language))->entry;
      lang = gtk_entry_get_text (GTK_ENTRY (tmp));
      type = gtk_entry_get_text (GTK_ENTRY (editMeaning.txt_type));
      trans = gtk_entry_get_text (GTK_ENTRY (editMeaning.txt_trans));
      new = ling_meaning_get_new ();

      new->id = meaning->id;

      new->language = ling_malloc (strlen (lang));
      strcpy (new->language, lang);

      new->type = ling_malloc (strlen (type));
      strcpy (new->type, type);

      new->translation = ling_malloc (strlen (trans));
      strcpy (new->translation, trans);
      gtk_widget_destroy (edit);

      break;
    case GTK_RESPONSE_CANCEL:
      gtk_widget_destroy (edit);
      break;
    default:
      gtk_widget_destroy (edit);
      break;
    }
  return new; 

}

