/*  This file is part of LingoTeach, the Language Teaching program 
 *  Copyright (C) 2001-2003 The LingoTeach Team
 *
 *  This program is free software; you can redistribute it and/or modify 
 *  it under the terms of the GNU General Public License as published by 
 *  the Free Software Foundation; either version 2 of the License, or 
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful, 
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 *  GNU General Public License for more details. 
 * 
 *  You should have received a copy of the GNU General Public License 
 *  along with this program; if not, write to the Free Software 
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */

#include <stdlib.h>
#include <lingoteach.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "lingoteach-i18n.h"
#include "errors.h"
#include "learningpref.h"
#include "util.h"
#include "multichoice.h"

#define CHOICES 4

/* external global variables */
extern lingLesson *lessons;
extern struct lpreferences genLprefs;

lingMeaning *mulcurrent[CHOICES];

static GtkWidget *box_trans;
static GtkWidget *lbl_langword;
static GtkWidget *lbl_word;
static int right = 0;           /* the current meaning */

/* prototypes */
GtkWidget* create_mul_button (lingLesson *lesson, gint i, gint lang, 
			      int wanted);
void mul_randomize (void);


/*********************
 * private functions *
 *********************/

GtkWidget* 
create_mul_button (lingLesson *lesson, gint i, gint lang, int wanted)
{
  GtkWidget   *btn_trans;
  lingMeaning *tmp;
 
  tmp = ling_meaning_get_by_word_id (lesson, i, genLprefs.languages[lang]);

  btn_trans = gtk_button_new_with_label (tmp->translation);
  gtk_widget_show (btn_trans);

  if (wanted == right)
    g_signal_connect (G_OBJECT (btn_trans), "clicked",
		      G_CALLBACK (on_btn_mul_next_clicked), NULL);

  ling_meaning_free_meaning (tmp);
  return btn_trans;
}

void
mul_randomize (void)
{
  right = 1 + (int) (1.0 * CHOICES * rand () / (RAND_MAX + 1.0));
  return;
}



/********************
 * public functions *
 ********************/

GtkWidget*
create_mul_box (void)
{
  GtkWidget *tbl_main;
  GtkWidget *sep_mul1;
  GtkWidget *lbl_langtrans;
  GtkWidget *tbl_temp;
  GtkWidget *scr_win_trans;
  GtkWidget *btn_trans;
  gint       i = 0;
  gint       id[CHOICES];
  gchar      *trans[CHOICES];
  lingLesson *tmp = NULL;
  
  PangoFontDescription* font = pango_font_description_new ();
  pango_font_description_set_style (font, PANGO_STYLE_ITALIC);
  pango_font_description_set_weight (font, PANGO_WEIGHT_BOLD);

  /* primary initialization */
  if (util_check_settings () == TRUE)
    {
      tmp = util_return_lesson (lessons, genLprefs.method);
      if (tmp == NULL)
	{
	  pango_font_description_free (font);    
  	  return NULL;
	}

      for (i = 0; i < CHOICES; i++)
	{
	  mulcurrent[i] = ling_meaning_get_another_meaning (tmp, RANDOM,
							    genLprefs.mlanguage);
	  id[i]    = mulcurrent[i]->id;
	  trans[i] = mulcurrent[i]->translation;
	}
      mul_randomize ();
      lbl_langword = gtk_label_new (genLprefs.mlanguage);
      lbl_word = gtk_label_new (trans[right - 1]);
    }
  else
    {
      lbl_langword = gtk_label_new ("");
      lbl_word = gtk_label_new ("");
    }

  tbl_main = gtk_table_new (3, 2, FALSE);
  gtk_widget_show (tbl_main);
  gtk_table_set_row_spacings (GTK_TABLE (tbl_main), 2);
  gtk_table_set_col_spacings (GTK_TABLE (tbl_main), 2);

  sep_mul1 = gtk_hseparator_new ();
  gtk_widget_show (sep_mul1);
  gtk_table_attach (GTK_TABLE (tbl_main), sep_mul1, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_SHRINK), 1, 4);

  gtk_widget_show (lbl_langword);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_langword, 0, 1, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 4, 4);
  gtk_label_set_justify (GTK_LABEL (lbl_langword), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (lbl_langword), 0.1, 0.5);
  gtk_widget_modify_font (lbl_langword, font);

  gtk_widget_show (lbl_word);
  gtk_table_attach (GTK_TABLE (tbl_main), lbl_word, 1, 2, 1, 2,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (0), 4, 4);

  scr_win_trans = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scr_win_trans);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scr_win_trans), 
				  GTK_POLICY_NEVER, 
				  GTK_POLICY_AUTOMATIC);
  gtk_table_attach (GTK_TABLE (tbl_main), scr_win_trans, 0, 2, 2, 3,
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
		    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 4);

  box_trans = gtk_vbox_new (FALSE, 2);
  gtk_widget_show (box_trans);
  gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW (scr_win_trans),
					 box_trans);

  i = 0;
  if (util_check_settings () == TRUE)
    while (genLprefs.languages[i] != NULL)
      {
	sep_mul1 = gtk_hseparator_new ();
	gtk_widget_show (sep_mul1);
	gtk_box_pack_start (GTK_BOX (box_trans), sep_mul1, FALSE, FALSE, 0);

	lbl_langtrans = gtk_label_new (genLprefs.languages[i]);
	gtk_widget_show (lbl_langtrans);
	gtk_widget_modify_font (lbl_langtrans, font);	
	gtk_box_pack_start (GTK_BOX (box_trans), lbl_langtrans, 
			    FALSE, FALSE, 0);

	tbl_temp = gtk_table_new (2, 2, TRUE);
	gtk_widget_show (tbl_temp);
	gtk_box_pack_start (GTK_BOX (box_trans), tbl_temp, FALSE, FALSE, 0);
      
	/* buttons */
	btn_trans = create_mul_button (tmp, id[0], i, 1);
	gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 0, 1, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) GTK_FILL, 2, 2);
	btn_trans = create_mul_button (tmp, id[1], i, 2);
	gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 0, 1, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) GTK_FILL, 2, 2);
	btn_trans = create_mul_button (tmp, id[2], i, 3);
	gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 1, 2, 0, 1,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) GTK_FILL, 2, 2);
	btn_trans = create_mul_button (tmp, id[3], i, 4);
	gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 1, 2, 1, 2,
			  (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			  (GtkAttachOptions) GTK_FILL, 2, 2);
	i++;
      }

  pango_font_description_free (font);    
  for (i = 0; i < CHOICES; i++)
    ling_meaning_free_meaning (mulcurrent[i]);
  return tbl_main;
}

void 
on_btn_mul_next_clicked (void)
{
  GtkWidget  *lbl_langtrans;
  GtkWidget  *tbl_temp;
  GtkWidget  *btn_trans;
  GtkWidget  *sep_mul1;
  GList      *children;
  gint        i = 0;
  gint        id[CHOICES];
  lingLesson *tmp;

  PangoFontDescription* font = pango_font_description_new ();
  pango_font_description_set_style (font, PANGO_STYLE_ITALIC);
  pango_font_description_set_weight (font, PANGO_WEIGHT_BOLD);

  if (util_check_settings () == FALSE)
    return;

  /* clear all items of both boxes */
  if ((children = gtk_container_get_children (GTK_CONTAINER (box_trans)))
      != NULL)
    {
      while (children->next != NULL)
	{
	  gtk_object_destroy (GTK_OBJECT (children->data));
	  children = children->next;
	}
      gtk_object_destroy (GTK_OBJECT (children->data));
      g_list_free (children);
    }

  /* new labels */
  tmp = util_return_lesson (lessons, genLprefs.method);
  if (tmp == NULL)
    {
      pango_font_description_free (font);    
      return;
    }
  
  for (i = 0; i < CHOICES; i++)
    {
      mulcurrent[i] = ling_meaning_get_another_meaning (tmp, RANDOM, 
							genLprefs.mlanguage);
      id[i] = mulcurrent[i]->id;
    }

  mul_randomize ();

  i = 0;
  while (genLprefs.languages[i] != NULL)
    {
      sep_mul1 = gtk_hseparator_new ();
      gtk_widget_show (sep_mul1);
      gtk_box_pack_start (GTK_BOX (box_trans), sep_mul1, FALSE, FALSE, 0);
      
      lbl_langtrans = gtk_label_new (genLprefs.languages[i]);
      gtk_widget_show (lbl_langtrans);
      gtk_widget_modify_font (lbl_langtrans, font);	
      gtk_box_pack_start (GTK_BOX (box_trans), lbl_langtrans, 
			  FALSE, FALSE, 0);
      
      tbl_temp = gtk_table_new (2, 2, TRUE);
      gtk_widget_show (tbl_temp);
      gtk_box_pack_start (GTK_BOX (box_trans), tbl_temp, FALSE, FALSE, 0);
      
      /* buttons */
      btn_trans = create_mul_button (tmp, id[0], i, 1);
      gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 0, 1, 0, 1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) GTK_FILL, 2, 2);
      btn_trans = create_mul_button (tmp, id[1], i, 2);
      gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 0, 1, 1, 2,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) GTK_FILL, 2, 2);
      btn_trans = create_mul_button (tmp, id[2], i, 3);
      gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 1, 2, 0, 1,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) GTK_FILL, 2, 2);
      btn_trans = create_mul_button (tmp, id[3], i, 4);
      gtk_table_attach (GTK_TABLE (tbl_temp), btn_trans, 1, 2, 1, 2,
			(GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
			(GtkAttachOptions) GTK_FILL, 2, 2);
      i++;
    }
  gtk_label_set_text (GTK_LABEL (lbl_word), 
		      mulcurrent[right - 1]->translation);
  gtk_label_set_text (GTK_LABEL (lbl_langword), genLprefs.mlanguage);
  gtk_widget_show_all (box_trans);
  pango_font_description_free (font);  
  for (i = 0; i < CHOICES; i++)
    ling_meaning_free_meaning (mulcurrent[i]);
  return;
}
