/***************************************************************************
                          friends.c  -  display of friend's list

                             -------------------
    begin                : Mon Dec 17 2001
    copyright            : (C) 2001 by Simon Morlat
    email                : simon.morlat@linphone.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "linphone.h"


#define get_friend_list() (&uiobj->main_window.friendlist)

enum{
	FRIEND_SIP_ADDRESS,
	FRIEND_PRESENCE_STATUS,
	FRIEND_LIST_NCOL
};

void friend_list_set_friend_status(FriendList *fl, const gchar *friend, const gchar *status){
	GtkTreeIter iter;
	gchar *tmp;
	GtkTreeModel *model=gtk_tree_view_get_model(GTK_TREE_VIEW(fl->friendlist));
	if (!gtk_tree_model_get_iter_first(model,&iter)) return;
	do{
		gtk_tree_model_get(model,&iter,FRIEND_SIP_ADDRESS,&tmp,-1);
		if (strcmp(friend,tmp)==0) {
			gtk_list_store_set(GTK_LIST_STORE(model),&iter,FRIEND_PRESENCE_STATUS,status,-1);
		}
		g_free(tmp);
	}while(gtk_tree_model_iter_next(model,&iter));
}

void friend_list_add(FriendList *fl, const char *friend){
	GtkTreeIter iter;
	GtkTreeModel *model=gtk_tree_view_get_model(GTK_TREE_VIEW(fl->friendlist));
	gtk_list_store_append(GTK_LIST_STORE(model),&iter);
	gtk_list_store_set(GTK_LIST_STORE(model),&iter,FRIEND_SIP_ADDRESS,friend,
	FRIEND_PRESENCE_STATUS,"unknown",-1);

}

void friend_list_add_address_book(FriendList *fl){
	GList *elem;
	elem=linphone_core_get_address_list(fl->lc);
	for(;elem!=NULL;elem=g_list_next(elem)){
		friend_list_add(fl,(char*)elem->data);
	}
	
}

void friend_list_remove_selected(FriendList *fl){
	GtkTreeSelection *select;
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *friend;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (fl->friendlist));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter,FRIEND_SIP_ADDRESS , &friend, -1);
		gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
		printf("Friend to remove: %s\n",friend);
		g_free(friend);
	}
}


void
on_addfriend_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=create_addfriend_dialog();
	gtk_widget_show(w);
}


void
on_removefriend_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	FriendList *fl=get_friend_list();
	friend_list_remove_selected(fl);
}


void
on_add_adbk_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	friend_list_add_address_book(get_friend_list());
}


void
on_addfriend_dialog_response           (GtkDialog       *dialog,
                                        gint             response_id,
                                        gpointer         user_data)
{
	GtkWidget *name,*url;
	char *friendname,*friendurl;
	char *sipurl;
	name=lookup_widget(GTK_WIDGET(dialog),"name");
	url=lookup_widget(GTK_WIDGET(dialog),"sipaddress");
	friendname=gtk_editable_get_chars(GTK_EDITABLE(name),0,-1);
	friendurl=gtk_editable_get_chars(GTK_EDITABLE(url),0,-1);
	sipurl=g_strdup_printf("%s <%s>",friendname,friendurl);
	
	if (response_id==GTK_RESPONSE_OK){
		friend_list_add(get_friend_list(),sipurl);
	}
	g_free(friendname);
	g_free(friendurl);
	gtk_widget_destroy(GTK_WIDGET(dialog));
}


void friend_list_init(FriendList *fl,LinphoneCore *lc,GtkWidget *mainwidget)
{
	GtkListStore *store;
	GtkTreeIter iter;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeSelection *select;
	GList *list,*elem;
	
	
	store = gtk_list_store_new (FRIEND_LIST_NCOL, G_TYPE_STRING, G_TYPE_STRING);
	fl->lc=lc;
	fl->friendlist=lookup_widget(mainwidget,"friendlist");
	/* need to add friends to the store here ...*/
	
	gtk_tree_view_set_model(GTK_TREE_VIEW(fl->friendlist),GTK_TREE_MODEL(store));
	g_object_unref(G_OBJECT(store));
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Friends",
                                                   renderer,
                                                   "text", FRIEND_SIP_ADDRESS,
                                                   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (fl->friendlist), column);
	column = gtk_tree_view_column_new_with_attributes ("Presence status",
                                                   renderer,
                                                   "text", FRIEND_PRESENCE_STATUS,
                                                   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (fl->friendlist), column);
	
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (fl->friendlist));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
}
