/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "msvideooutput.h"
#include "msvideosource.h"

static MSVideoOutputClass *ms_video_output_class=NULL;
	
	

void ms_video_output_init(MSVideoOutput *obj)
{
	gint error;
	GdkWindowAttr attr;
	MSVideoOutputClass *klass=MS_VIDEO_OUTPUT_CLASS(MS_FILTER(obj)->klass);
	attr.title="machin";
	attr.window_type=GDK_WINDOW_CHILD;
	attr.wclass=GDK_INPUT_OUTPUT;
	attr.x=0;
	attr.y=0;
	attr.width=300;
	attr.height=200;
	attr.visual=klass->visual;
	attr.colormap=klass->colormap;
	ms_filter_init(MS_FILTER(obj));
	MS_FILTER(obj)->inqueues=obj->input;
	obj->window=gdk_window_new(NULL,&attr,GDK_WA_TITLE|GDK_WA_X|GDK_WA_Y|GDK_WA_COLORMAP|GDK_WA_VISUAL);
	if (obj->window==NULL)
	{
		g_error("Could not create gdk video window");
	}
	obj->gc=gdk_gc_new(obj->window);
	gdk_window_show(obj->window);
	gdk_flush();
	//gdk_window_withdraw(obj->window);
	obj->width=300;
	obj->height=200;
	obj->bufsize=400*300*3;
	
}

void ms_video_output_setup(MSVideoOutput *vo, MSSync *sync)
{
	/* tries to find the video source of the stream */
	MSFilter *vs;
	vs=ms_filter_search_upstream_by_type(MS_FILTER(vo),MS_FILTER_VIDEO_IO);
	if (vs!=NULL){
		/* get video source properties */
		vo->width=MS_VIDEO_SOURCE(vs)->width;
		vo->height=MS_VIDEO_SOURCE(vs)->height;
		vo->palette=MS_VIDEO_SOURCE(vs)->format;
		/* we hope that the format will be RGB24 */
		if (strcmp(vo->palette,"RGB24")!=0){
			g_warning("ms_video_output_setup: Shit, this is not RGB24 but %s.",vo->palette);
		}
		ms_video_output_set_size(vo,vo->width,vo->height);
	}else g_warning("ms_video_output_setup: could not find the video source.");
}


void ms_video_output_class_init(MSVideoOutputClass *klass)
{
	gint status;
	ms_filter_class_init(MS_FILTER_CLASS(klass));
	MS_FILTER_CLASS(klass)->max_qinputs=1;
	MS_FILTER_CLASS(klass)->destroy=(MSFilterDestroyFunc)ms_video_output_destroy;
	MS_FILTER_CLASS(klass)->process=(MSFilterProcessFunc)ms_video_output_process;
	MS_FILTER_CLASS(klass)->setup=(MSFilterSetupFunc)ms_video_output_setup;
	ms_filter_class_set_name(MS_FILTER_CLASS(klass),"MSVideoOutput");
	status=gdk_init_check(0,NULL);
	if (status==0){
		g_error("Failed to initialize gdk.");
	}
	gdk_rgb_init();
	gdk_rgb_set_verbose(1);
	klass->visual=gdk_rgb_get_visual();
	klass->colormap=gdk_rgb_get_cmap();
}

void ms_video_output_uninit(MSVideoOutput *obj)
{
	gdk_gc_destroy(obj->gc);
	gdk_window_destroy(obj->window);
}

MSFilter * ms_video_output_new()
{
	MSVideoOutput *obj=g_malloc(sizeof(MSVideoOutput));
	
	if (ms_video_output_class==NULL)
	{
		ms_video_output_class=g_malloc(sizeof(MSVideoOutputClass));
		ms_video_output_class_init(ms_video_output_class);
	}
	MS_FILTER(obj)->klass=MS_FILTER_CLASS(ms_video_output_class);
	ms_video_output_init(obj);
	return MS_FILTER(obj);
}

void ms_video_output_start(MSVideoOutput *obj)
{
	
}

void ms_video_output_stop(MSVideoOutput *obj)
{
	
}

void ms_video_output_set_title(MSVideoOutput *obj,gchar *title)
{
	g_return_if_fail(obj->window);
	gdk_threads_enter();
	gdk_window_set_title(obj->window,title);
	gdk_flush();
	gdk_threads_leave();
}

void ms_video_output_set_size(MSVideoOutput *obj,gint width, gint height)
{
	gdk_threads_enter();
	obj->width=width;
	obj->height=height;
	obj->bufsize=width*height*3;
	gdk_window_resize(obj->window,width,height);
	gdk_flush();
	gdk_threads_leave();
}

void ms_video_output_process(MSVideoOutput *obj)
{
	MSQueue *q=obj->input[0];
	MSMessage *m;

	while((m=ms_queue_get(q))!=NULL)
	{
		g_message("Getting new buffer");
		gdk_threads_enter();
		if (m->size>=obj->bufsize)
			gdk_draw_rgb_image (obj->window,obj->gc,0,0,obj->width,obj->height,
							GDK_RGB_DITHER_NONE,m->data,obj->width*3);
		else g_warning("Image is too small for current window");
		gdk_flush();
		gdk_threads_leave();
		ms_message_destroy(m);
	}
}

void ms_video_output_destroy(MSVideoOutput *obj)
{
	ms_video_output_uninit(obj);
	g_free(obj);
}

