/*
  The mediastreamer library aims at providing modular media processing and I/O
        for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
                                                                                
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "mediastream.h"


/* this code is not part of the library itself, it is part of the mediastream program */
void
video_stream_free (VideoStream * stream)
{
	RtpSession *s;
	if (stream->rtprecv != NULL)
	{
		s = ms_rtp_recv_get_session (MS_RTP_RECV (stream->rtprecv));
		if (s != NULL)
		{
			rtp_session_destroy (s);
		}
		ms_filter_destroy (stream->rtprecv);
	}
	if (stream->rtpsend != NULL)
	{
		s = ms_rtp_send_get_session (MS_RTP_SEND (stream->rtpsend));
		if (s != NULL)
		{
			rtp_session_destroy (s);
		}
		ms_filter_destroy (stream->rtpsend);
	}
	if (stream->source != NULL)
		ms_filter_destroy (stream->source);
	if (stream->dispatcher != NULL)
		ms_filter_destroy (stream->dispatcher);
	if (stream->mpegwrite != NULL)
		ms_filter_destroy (stream->mpegwrite);
	if (stream->decoder != NULL)
		ms_filter_destroy (stream->decoder);
	if (stream->encoder != NULL)
		ms_filter_destroy (stream->encoder);
	if (stream->timer != NULL)
		ms_sync_destroy (stream->timer);
	g_free (stream);
}


VideoStream *
video_stream_start_full (int locport, char *remip4, int remport,
			 int payload, int jitt_comp, gchar * infile,
			 gchar * outfile)
{
	VideoStream *stream = g_new0 (VideoStream, 1);
	RtpSession *rtps, *rtpr;

	/* creates two rtp filters to recv send streams (remote part) */

	rtps = rtp_session_new (RTP_SESSION_SENDONLY);
	rtp_session_set_local_addr (rtps, "0.0.0.0", locport + 2);
	rtp_session_set_remote_addr (rtps, remip4, remport);
	rtp_session_set_scheduling_mode (rtps, 0);
	rtp_session_set_blocking_mode (rtps, 0);
	rtp_session_set_payload_type (rtps, payload);
	rtp_session_set_jitter_compensation (rtps, jitt_comp);

	stream->rtpsend = ms_rtp_send_new ();
	ms_rtp_send_set_session (MS_RTP_SEND (stream->rtpsend), rtps);

	rtpr = rtp_session_new (RTP_SESSION_RECVONLY);
	rtp_session_set_local_addr (rtpr, "0.0.0.0", locport);
	rtp_session_set_scheduling_mode (rtpr, 0);
	rtp_session_set_blocking_mode (rtpr, 0);
	rtp_session_set_payload_type (rtpr, payload);
	rtp_session_set_jitter_compensation (rtpr, jitt_comp);

	stream->rtprecv = ms_rtp_recv_new ();
	ms_rtp_recv_set_session (MS_RTP_RECV (stream->rtprecv), rtpr);


	/* creates the local part */
	stream->source = ms_v4l_new ();
	ms_v4l_set_device (MS_V4L (stream->source), "/dev/video0");
	stream->dispatcher = ms_qdispatcher_new ();
	stream->mpegwrite = ms_video_output_new ();

	/* creates the encoder/decoder */
	stream->encoder = ms_mpeg_encoder_new ();
	stream->decoder = ms_mpeg_decoder_new ();

	/* create the synchronisation source */
	stream->timer = ms_timer_new ();

	ms_video_output_set_size (MS_VIDEO_OUTPUT (stream->mpegwrite), 352,
				  288);
	ms_AVdecoder_set_format (MS_AVDECODER (stream->decoder), "RGB24");

	/* and then connect all */
	ms_filter_add_link (stream->source, stream->dispatcher);
	ms_filter_add_link (stream->dispatcher, stream->encoder);
	ms_filter_add_link (stream->encoder, stream->rtpsend);
	ms_filter_add_link (stream->rtprecv, stream->decoder);
	ms_filter_add_link (stream->decoder, stream->mpegwrite);

	ms_sync_attach (stream->timer, stream->source);
	ms_sync_attach (stream->timer, stream->rtprecv);

	/* and start */
	ms_start (stream->timer);
	ms_v4l_start (MS_V4L (stream->source));

	return stream;
}



void
video_stream_stop (VideoStream * stream)
{

ms_v4l_stop (MS_SMPEG (stream->source);
		     ms_stop (stream->timer);
		     ortp_global_stats_display ();
		     ms_sync_detach (stream->timer, stream->source);
		     ms_sync_detach (stream->timer, stream->rtprecv);
		     ms_filter_remove_links (stream->source,
						     stream->
						     dispatcher);
		     ms_filter_remove_links (stream->dispatcher,
						     stream->encoder);
		     ms_filter_remove_links (stream->encoder,
						     stream->rtpsend);
		     ms_filter_remove_links (stream->rtprecv,
						     stream->decoder);
		     ms_filter_remove_links (stream->decoder,
						     stream->
						     mpegwrite);
		     video_stream_free (stream);}
