/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef UTILS_H
#define UTILS_H

#include "osipua.h"



/* profiles is a list of profiles supported by remote host, and ua_profile is the list for local user agent. The return value is the preferred profile for ua, compatible with
remote host 's list. */
int get_compatible_profile(list_t *ua_profiles,list_t *profiles);


/* respond to a request*/
void respond_to_request(osip_t *config, transaction_t *transaction, int code);

sip_t * msg_make_template_reply (sip_t * request, int code);

/* returns an sdp message with properties given as argument*/
char *sdp_compose(int sess_id, char *user, char *ip4addr,char *subject, list_t *media_list);


/*search element el in list, and remove it*/
int list_remove_el(list_t *list,void *el);

/* copy callid_t source to dest, by allocating fields inside dest*/
void callid_getcopy(call_id_t	*dest,call_id_t *source);

#define LIST_ELEM_DESTRUCTOR(func)     ((void (*)(void *))func)
/* free a list with all its elements and nodes. destructor() is used ot free elements*/
void list_free(list_t *li, void (*destructor)(void *));

struct hostent *resolv(char *name);

/* from2 has tag parameter that we should copy to from1 if it does not have one */
int from_copy_tag(from_t *from1,from_t *from2);


/* allocate a random tag string */
#define tag_init(pc) _tag_init( (pc),5)

int _tag_init(char **tag,int length);

#define from_tag_add(_from,_tag) from_param_add((_from),sgetcopy("tag"),(_tag))

#define from_tag_add_random(_from) \
	do \
	{\
		char *_tag; \
		tag_init(&_tag); \
		from_param_add((_from),sgetcopy("tag"),_tag); \
	}while (0)

	
/* BKO: similar to from_tag_add */
#define to_tag_add(_to,_tag) to_param_add((_to),sgetcopy("tag"),(_tag))	
	

int msg_getbody_by_mime(sip_t *sipmsg,char *mime,body_t **body);

char *content_type_get_type(content_type_t *ct);

int
osip_create_proxy_authorization_header(sip_t *previous_answer,
				       char *rquri, char *username, char *passwd,
				       proxy_authorization_t **auth);

int
osip_create_authorization_header(sip_t *previous_answer,
				 char *rquri, char *username, char *passwd,
				 authorization_t **auth);

char * int_2char(int a);

void *srealloc (void *p, int i);

static char *sstrdup_sprintf(const char *fmt, ...)
{
	/* Guess we need no more than 100 bytes. */
	int n, size = 100;
	char *p;
	va_list ap;
	if ((p = smalloc (size)) == NULL)
		return NULL;
	while (1)
	{
		/* Try to print in the allocated space. */
		va_start (ap, fmt);
		n = vsnprintf (p, size, fmt, ap);
		va_end (ap);
		/* If that worked, return the string. */
		if (n > -1 && n < size)
			return p;
		//printf("Reallocing space.\n");
		/* Else try again with more space. */
		if (n > -1)	/* glibc 2.1 */
			size = n + 1;	/* precisely what is needed */
		else		/* glibc 2.0 */
			size *= 2;	/* twice the old size */
		if ((p = srealloc (p, size)) == NULL)
			return NULL;
	}
}

#define keywordcmp(key,str)  strncmp(key,str,strlen(key))

/* return the value of attr "field" for payload pt at line pos (field=rtpmap,fmtp...)*/
char *sdp_a_attr_value_get_with_pt(sdp_t *sdp,int pos,int pt,char *field);

int sdp_b_bandwidth_get_with_pt(sdp_t *sdp,int pos,int pt);

int guess_local_address(char *address_to_reach,char **loc);

#endif
