/***************************************************************************
                          crxwindow.cpp  -  description
                             -------------------
    begin                : Mon Mar 6 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "crxwindow.h"
#include <qvbox.h>
#include <qlineedit.h>
#include <qfontmetrics.h>

#include "parameter.h"

extern Parameter settings;
/* 
 *  Constructs a CRxWindow which is a child of 'parent', with the 
 *  name 'name'.' 
 */
CRxWindow::CRxWindow( QWidget* parent,  const char* name )
    : QScrollView( parent, name )
{
QFontMetrics fm(font());
DisplayBox=new QVBox(viewport());
addChild(DisplayBox);
setResizePolicy(AutoOne);
trigger=false;
TriggerText="";
TexttoTrigger="";
save=false;
stream=0;

for (int i=0;i<RxWindowBuffer;i++)
  {

  ScrollBuffer[i]=new QLineEdit(DisplayBox);

  ScrollBuffer[i]->setFrameShape( QLineEdit::NoFrame );
  ScrollBuffer[i]->setReadOnly(true);
  ScrollBuffer[i]->setFixedWidth(620);
  ScrollBuffer[i]->setMaxLength(80);
  ScrollBuffer[i]->setFixedHeight(fm.height());
  }
verticalScrollBar()->setFixedWidth(16);
setVScrollBarMode(AlwaysOn);
setHScrollBarMode(Auto);
horizontalScrollBar()->setFixedHeight(16);
Row=0;
Column=0;
AutoScroll=true;
}

/*
 *  Destroys the object and frees any allocated resources
 */
CRxWindow::~CRxWindow()
{
    // no need to delete child widgets, Qt does it all for us
}
void CRxWindow::updateRx(char c)
{
switch(c)
        {
        case '\n':
        case '\r':
         NeueZeile();
       break;

        case '\b':
         if (Column >0)
          {
           Column--;
           QString s=ScrollBuffer[Row]->text();
           s.truncate(Column);
           ScrollBuffer[Row]->setText(s);
           if(trigger && ( settings.Status == OFF ))
            {
             if (TriggerText.length() > 0 )
              TriggerText.remove(TriggerText.length(),1);  
            }  
           }
         break;

         case '0':
                if(settings.slashed0)
                            c= 0xF8;
        default:
         if(trigger && ( settings.Status == OFF ))
          {
           TriggerText.append(c);
           if (TriggerText.length() > TexttoTrigger.length())
            {
             TriggerText.remove(0,1);
             if ( TriggerText.lower() ==  TexttoTrigger.lower() )
              {
               trigger =false; // Stop
               emit Triggered();
              }   
            }   
          }          
         QString s=ScrollBuffer[Row]->text()+QString(QChar(c));
         ScrollBuffer[Row]->setText(s);
         Column++;

         if (Column>=80)
            NeueZeile();
         if ((Column > 40 ) && AutoScroll)// Check if Character is still visible
             {
              int x,y,pos;
              pos=ScrollBuffer[Row]->fontMetrics().width(s);
              contentsToViewport(pos,0,x,y);
              y = visibleWidth();
              if(x > y)
                scrollBy(x-y+40,0);
              }

          }


}

void CRxWindow::clearRxWindow()
{
Column=0;
Row=0;
for(int i=0;i <RxWindowBuffer;i++)
  ScrollBuffer[i]->setText("");
setContentsPos(Column,Row);
}


void CRxWindow::RemoveFirstLine()
{
for(int i=1; i < RxWindowBuffer; i++)
  ScrollBuffer[i-1]->setText(ScrollBuffer[i]->text());
ScrollBuffer[RxWindowBuffer-1]->setText("");
}

void CRxWindow::NeueZeile()
{
int x,y;
Column=0;
Row++;
if (Row >= RxWindowBuffer)
 {
   if ( save && stream != 0)
    *stream << ScrollBuffer[0]->text() << "\n";
   RemoveFirstLine();
   Row--;
 }
if (! AutoScroll)
  return;
contentsToViewport(ScrollBuffer[Row]->x(),ScrollBuffer[Row]->y(),x,y);
if ( ((y+ ScrollBuffer[Row]->height()) < visibleHeight()) && (y>0) )
  {
    if (x < 0 )
      scrollBy(x,0);
    return;
  }
// We have to Scroll;
if (y > 0)
  {
    
    scrollBy(x,3*ScrollBuffer[0]->height());
  }  
else
  ensureVisible(ScrollBuffer[Row]->x(),ScrollBuffer[Row]->y());
}
void CRxWindow::setColor(QColor color)
{
for(int i=0;i<RxWindowBuffer;i++)
  ScrollBuffer[i]->setPaletteForegroundColor(color);
}

void CRxWindow::fontChange(const QFont &)
{
QFontMetrics fm(font());
for (int i=0;i<RxWindowBuffer;i++)
       ScrollBuffer[i]->setFixedHeight(fm.height());
}
void CRxWindow::activateTrigger(QString s)
{
trigger=true;
TexttoTrigger=s;
TriggerText="";
}
void CRxWindow::deactivateTrigger()
{
trigger=false;
}
bool CRxWindow::getTriggerStatus()
{
  return trigger;
}  
QString CRxWindow::getTriggerText()
{
 return TexttoTrigger;
}
  
void CRxWindow::stopRecording()
{
/** Save all lines in Buffer **/
for(int i=0; i <= Row; i++)
 *stream << ScrollBuffer[i]->text() << "\n";
File.close();
save=false;
delete stream;   
}  
void CRxWindow::startRecording(QString Datei)
{
File.setName(Datei);
File.open(IO_WriteOnly);
save=true;
stream =new QTextStream(&File);  
}
bool CRxWindow::getRecordingState()
{
  return save;
}  
