/***************************************************************************
                          cspectrumdisplay.cpp  -  description
                             -------------------
    begin                : Son Dez 8 2002
    copyright            : (C) 2002 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/


#include <qradiobutton.h>
#include <qspinbox.h>
#include <qpixmap.h>
#include <qpainter.h>

#include "cspectrumdisplay.h"
#include "crxchannel.h"
#include "parameter.h"
#include "color.h"
#include "cdisplay.h"
#define SPECTRUMHEIGHT 80
#define WATERFALLHEIGHT 20
#define distance 3

extern Parameter settings;

CSpectrumDisplay::CSpectrumDisplay( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{

    Display=new CDisplay(this,"Spectrum");
    MaxFreq = new QSpinBox( this, "MaxFreq" );
    MaxFreq->setMaxValue( 2500 );
    MaxFreq->setMinValue( 1300 );
    MaxFreq->setValue( 2500 );
    MaxFreq->setLineStep(100);

    MinFreq = new QSpinBox( this, "MinFreq" );
    MinFreq->setButtonSymbols( QSpinBox::UpDownArrows );
    MinFreq->setMaxValue( 1200 );
    MinFreq->setMinValue( 100 );
    MinFreq->setLineStep( 100);

//    Slow = new QRadioButton( this, "Slow" );
    languageChange();
    calculateSizeofComponents();

    inputdata=0;
    // Creating Variables for the fft

    output = new fftw_real[BUF_SIZE/2];

    plan=rfftw_create_plan(BUF_SIZE/2,FFTW_REAL_TO_COMPLEX,FFTW_ESTIMATE);

    pdisplay = 0;
    pwaterfall=0;
    overload=false;
    Phase=0;
    Farbe=0;
// Connections
   connect(Display,SIGNAL(frequencyChanged(int)),this,SLOT(setnewFrequency(int)));
}

/*
 *  Destroys the object and frees any allocated resources
 */
CSpectrumDisplay::~CSpectrumDisplay()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void CSpectrumDisplay::languageChange()
{

    MaxFreq->setSuffix( tr( " Hz" ) );
    MinFreq->setSuffix( tr( " Hz" ) );
//    Slow->setText( tr( "Slow" ) );
}
void CSpectrumDisplay::resizeEvent( QResizeEvent * )
{
 
calculateSizeofComponents();
translate();
if (pdisplay != 0)
  pdisplay->resize(Display->width(),Display->height());
else
  pdisplay = new QPixmap(Display->width(),Display->height());
if (pwaterfall != 0)
  pwaterfall->resize(Display->width(),30);
else
  pwaterfall = new QPixmap(Display->width(),30);
pwaterfall->fill(black);
plotspectrum();

}

void CSpectrumDisplay::calculateSizeofComponents()
{
int xpos,ypos,width,height,innerheight,innerwidth,xdist;
width=this->width();
height=this->height();
/** Display **/
xpos=0;
ypos=height*distance/100;
innerwidth=width;
innerheight=height*SPECTRUMHEIGHT/100;
Display->setGeometry(xpos,ypos,innerwidth,innerheight);

/** Controlelements of the display **/
ypos=ypos+innerheight+distance*height/100;
innerheight=height-ypos-distance*height/100;
innerwidth=(width-2*xpos)/3;
xdist=innerwidth/2;
MinFreq->setGeometry(xpos,ypos,innerwidth,innerheight);
//xpos=xpos+innerwidth+xdist;
//Slow->setGeometry(xpos,ypos,innerwidth,innerheight);
xpos=width-innerwidth;
MaxFreq->setGeometry(xpos,ypos,innerwidth,innerheight);

}

void CSpectrumDisplay::setInputPointer(double *x)
{
inputdata =x;
}

// Plot Spectrum of decimated Input
void CSpectrumDisplay::plotspectrum()
{

QPainter p;


int dist,y,z,ymax,xmax;
int minfreq,maxfreq;
float IMD;
double scale;
if (pdisplay !=0 )
  scale = (pdisplay->height()-40)/512.;
else
scale =0.0 ;

minfreq=MinFreq->value();
maxfreq=MaxFreq->value();
ymax=pdisplay->height();
dist=(ymax-40)/10;
y=ymax-dist-40;
xmax=pdisplay->width();

pdisplay->fill();
p.begin(pdisplay);
p.setBrush(white);

p.setPen(black);
//Plot Frequencylines for the different Rx- Windows

  for (CRxChannel *pRx=settings.ChannelChain;pRx != 0;pRx= pRx->getNextChannel())
  {
    if ( Farbe > 0)
     {
       int ID = pRx->getID();
       if ( ID >= 0 && ID < Farbe->size() )
         p.setPen(Farbe->at(ID));
     } 
    // Calculate Centerfrequency Coordinates
    z=(( (int) pRx->getRxFrequency()-minfreq)*xmax)/(maxfreq-minfreq);
    p.drawLine(z,0,z,ymax);

    if ( pRx->getModulationType() == RTTY ) // RTTY demands to lines
      {
        z=(( (int) pRx->getRxFrequency()-minfreq+170)*xmax)/(maxfreq-minfreq);
        p.drawLine(z,0,z,ymax);
      }
 }
p.setPen(black);
// Plot Lineal
paintLineal(&p,y,ymax-33);

// Plot Grid
for (int i=1;i<10; i++)
	{

   p.drawLine(0,y,xmax,y);
   y -=dist;
  }


if(overload)
	p.setPen(red);
else
	p.setPen(blue);
  p.moveTo(0,ymax);
if ( inputdata != 0)
  {
    for(int i=0;i<pdisplay->width();i++)
     {
      z=xtranslate[i];
      y=ymax-(int)(scale*fftdata[z])-40;
      p.lineTo(i,y);
     }
  }
if (Phase !=0)
  plotVector(&p);
p.end();
bitBlt(pwaterfall,0,2,pwaterfall);

p.begin(pwaterfall);
p.setBrush(white);

for (int i=0;i<xmax;i++)
 {
	z=xtranslate[i];
	y=fftdata[z];
  if ( y > 255)
    y = 255;
  p.setPen(color[y]);
	p.drawPoint(i,0);
	p.drawPoint(i,1);
 }
p.end();

bitBlt(pdisplay,0,ymax-30,pwaterfall);
Display->setBufferPointer(pdisplay);
Display->repaint();

// Calculate IMD
if ( ( (settings.ActChannel->getModulationType() == BPSK) ||
     (settings.ActChannel->getModulationType() == QPSK) ) && (*inputdata != 0) )
  {

    int Freq1,Freq2;
    double Frequency;
    Frequency=settings.ActChannel->getRxFrequency();
    Freq1=(int) ( (Frequency+ 15.625)*1024./2756.25);
    Freq2=(int) ( (Frequency+ 46.875)*1024./2756.25);
    IMD=power_spectrum[Freq2]/power_spectrum[Freq1];
    Freq1=(int) ( (Frequency- 15.625)*1024./2756.25);
    Freq2=(int) ( (Frequency- 46.875)*1024./2756.25);
    IMD = 10.*log10( (IMD + power_spectrum[Freq2]/power_spectrum[Freq1])/2);
  }
else
  IMD=0.0;
 emit new_IMD(IMD);
}
void CSpectrumDisplay::calcFFT()
{
int N;

N=BUF_SIZE/2;
if (inputdata == 0)
  return;          // No data available
// Check for Overload
overload=false;
for (int i=0;i<N;i++)
  
    if(inputdata[i] >16384.0)
      overload=true;
     
  
rfftw_one(plan,inputdata,output);

//Calculate power spectrum and normalize

for(int i=1;i<(N-1)/2;i++)
     power_spectrum[i] =output[i]*output[i] + output[N-i]*output[N-i];
//     fftdata[i] =(int) (scale*log10(output[i]*output[i] + output[N-i]*output[N-i]));

for(int i=0;i<Display->width();i++)     // 38.25 = 1.5 *255/10 slightly scale up for colors
//     fftdata[xtranslate[i]]=(int) (51.2*(log10(power_spectrum[xtranslate[i]]+1.1258312e5)-5.051473275));
     fftdata[xtranslate[i]]=(int) (38.25*(log10(power_spectrum[xtranslate[i]]+1.1258312e5)-5.051473275));

  
}

void CSpectrumDisplay::translate(void)
{
int i,to,minfreq,maxfreq,displaywidth;
minfreq=MinFreq->value();
maxfreq=MaxFreq->value();
to=int(maxfreq*1024/2756.25);
displaywidth=Display->width();
for (i=0;i<displaywidth;i++)
  xtranslate[i]=(((maxfreq-minfreq)*i*to/displaywidth)+minfreq*to)/maxfreq;
}

void CSpectrumDisplay::startPlot()
{
translate();
calcFFT();
plotspectrum();
}

void CSpectrumDisplay::setnewFrequency(int position)
{
double freq;
freq= (position*(MaxFreq->value()-MinFreq->value()))/Display->width()+MinFreq->value();
settings.ActChannel->setRxFrequency(freq);
emit FrequencyChanged(freq);
}

void CSpectrumDisplay::paintLineal(QPainter* p,int y1,int y2)
{

int stepfrequency,stepwidth;
int i,ix,NumberofFreqs,diff;
QString frequency;
QFontMetrics fm(Display->font());

// Calcalute Frequency- Steps
diff=(MaxFreq->value()-MinFreq->value());
NumberofFreqs=7;
while(NumberofFreqs >4)
  {
    stepfrequency=diff/NumberofFreqs;
    if ( stepfrequency * NumberofFreqs != diff )
      NumberofFreqs--;
    else
      break;
  }
stepwidth=Display->width()/NumberofFreqs;
//iy=fm.height()+2;

for( i=1; i < NumberofFreqs; i++)
{
  frequency.setNum(MinFreq->value()+stepfrequency*i);
  ix=i*stepwidth-fm.width(frequency)/2;
  p->drawText(ix,y2,frequency);
  ix=i*stepwidth;
p->drawLine(ix,y1,ix,y1+2);
}

}

void CSpectrumDisplay::plotVector(QPainter *p)
{

//int x,y,x1,y1,
int xc,yc;
double mag;
//double tmpx;
//double tmpy;


xc=Display->width()/8;
yc=Display->height()/8;
p->drawEllipse(xc,yc,40,40);
xc=xc+20;
yc=yc+20;
p->setPen(green);
/**
  for( x=196,y=0; x<10*196; y+=196, x+=196 )// 196 = (612.5/31.25)*10
	{
		x1 = x/10;
		y1 = y/10;
		tmpx =Phase[y1].real() * Phase[x1].real() +
				Phase[y1].imag() * Phase[x1].imag();
		tmpy = Phase[y1].imag() * Phase[x1].real() -
				Phase[y1].real() * Phase[x1].imag();
		p->moveTo( xc,  yc );
		mag = 2*sqrt(tmpx * tmpx + tmpy * tmpy);

		p->lineTo( xc+(int)(yc*tmpy/mag), yc-(int)(yc*tmpx/mag) );

	}
**/
for(int i=0; i< 11; i++)
 {
   p->moveTo( xc,yc);
   mag=abs(Phase[i]);
   if ( mag > 0.001)
     p->lineTo(xc - (int)(20.*Phase[i].imag()/mag), yc - (int)(20.*Phase[i].real()/mag) );
 }  
}

void CSpectrumDisplay::setPhasePointer(std::complex<float> *p)
{
Phase=p;
}
void CSpectrumDisplay::setColorList(std::vector<QColor> *c)
{
  Farbe=c;
}
  

