/***************************************************************************
                          |FILENAME|  -  description
                             -------------------
    begin                : |DATE|
    copyright            : (C) |YEAR| by |AUTHOR|
    email                : |EMAIL|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qvariant.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qstyle.h>
#include <qlabel.h>

#include "csquelch.h"
#include "color.h"

#define Black color[0]
#define Grey  color[64]
#define Cyan  color[127]
#define Yellow color[192]

mySlider::mySlider(QWidget *parent, const char *name = 0) :
QSlider(parent,name)
{
    setOrientation( QSlider::Vertical );
    setTickmarks( QSlider::NoMarks );
    setTickInterval( 10 );
    setMinValue(0);
    setMaxValue(100);

setBackgroundColor(Black);
setValue(50);
SquelchLevel=0;


}

mySlider::~mySlider()
{
}
/** Painting Slider Background depending on Threshold and Signal Strength
*/
void mySlider::paintEvent(QPaintEvent *)
{
QPainter p;
int scale;
scale=height()*(100-SquelchLevel)/100;
p.begin(this);
p.setBrush(black);
if (SquelchLevel > (100-value()) )
  p.fillRect(0,scale,width(),height()-scale,Yellow);
else
  p.fillRect(0,scale,width(),height()-scale,Cyan);
p.fillRect(0,0,width(),scale,Black);
    QStyle::SFlags flags = QStyle::Style_Default;

    QStyle::SCFlags sub = QStyle::SC_SliderGroove | QStyle::SC_SliderHandle;

    style().drawComplexControl( QStyle::CC_Slider, &p, this, rect(), colorGroup(),
                                flags, sub,  QStyle::SC_SliderHandle  );

p.end();


}

void mySlider::setSquelchLevel(int level)
{
SquelchLevel=level;
repaint();
}

int mySlider::getThreshold()
{
return 100-value();
}

/* 
 *  Constructs a CSquelch which is a child of 'parent', with the 
 *  name 'name'.' 
 */
CSquelch::CSquelch( QWidget* parent,  const char* name )
    : QGroupBox( parent, name )
{
    setFrameShape( QGroupBox::WinPanel );
    setFrameShadow( QGroupBox::Raised );
    setAlignment( int( QGroupBox::AlignHCenter ) );

    Activate = new QRadioButton( this, "Activate" );
    Activate->setGeometry( QRect( 120, 340, 60, 41 ) );
    ActivateText = new QLabel(this,"ActivateText");
    ActivateText->setAlignment(AlignHCenter);
 

    Squelch = new mySlider( this, "Squelch" );
    Squelch->setPaletteBackgroundColor( QColor( 0, 0, 0 ) );
    Squelch->setOrientation( QSlider::Vertical );
    Squelch->setTickmarks( QSlider::NoMarks );
    Squelch->setTickInterval( 10 );
    Squelch->setMinValue(0);
    Squelch->setMaxValue(100);

   
    languageChange();

}

/*
 *  Destroys the object and frees any allocated resources
 */
CSquelch::~CSquelch()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void CSquelch::languageChange()
{
    setTitle( tr( "Squelch" ) );
    ActivateText->setText( tr( "On/Off" ) );
}
void CSquelch::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();
}

void CSquelch::calculateSizeofComponents()
{
/** Margins **/
#define TOPMARGIN 10
/** WIDTH and Height in % **/
#define SQUELCHWIDTH 20
#define SQUELCHHEIGHT 70
#define BUTTONWIDTH 90
#define BUTTONHEIGHT 10

int xpos,ypos, width,height,innerwidth,innerheight;

width=this->width();
height=this->height();
innerwidth=width*SQUELCHWIDTH/100;
xpos=(width-innerwidth)/2;
ypos=height*TOPMARGIN/100;
innerheight=height*SQUELCHHEIGHT/100;
Squelch->setGeometry(xpos,ypos,innerwidth,innerheight);
ypos=ypos+innerheight;
innerheight=height*BUTTONHEIGHT/100;
Activate->setGeometry(xpos,ypos,innerwidth,innerheight);
innerwidth=width*BUTTONWIDTH/100;
xpos=(width-innerwidth)/2;
ypos=ypos+innerheight;
ActivateText->setGeometry(xpos,ypos,innerwidth,innerheight);

this->setFrameRect(QRect(0,0,width,height));
}


void CSquelch::setSquelchLevel(int level)
{
Squelch->setSquelchLevel(level);
repaint();

}
int CSquelch::getThreshold()
{
return Squelch->getThreshold();
}
bool CSquelch::getSquelchState()
{
return Activate->isOn();
}
void CSquelch::setSquelchState(bool state)
{
Activate->setChecked(state);
}
void CSquelch::setThreshold(int Threshold)
{
Squelch->setValue(100-Threshold);
}
