/***************************************************************************
                          fskdemodulator.cpp  -  description
                             -------------------
    begin                : Fre Jan 31 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatly, AE4JY             *
 ***************************************************************************/

#include "fskdemodulator.h"

FSKDemodulator::FSKDemodulator():CDemodulator()
{
init_filter(0.05, 0.45);
twiddles=0;
bins=0;
Filterptr=0;
for (int i=0; i <HilbertFilterLength; i++)
  FilterBuffer[i]=0.;
}
FSKDemodulator::~FSKDemodulator()
{
}

void FSKDemodulator::init_filter(double f1,double f2)
{
int i;
double t,h,x,y;
  for (i = 0; i < HilbertFilterLength; i++)
  {
    t = i - (HilbertFilterLength - 1.0) / 2.0;
    h = i * (1.0 / (HilbertFilterLength - 1.0));

		x = (2 * f2 * sinc(2 * f2 * t) -
		     2 * f1 * sinc(2 * f1 * t)) * hamming(h);

		/*
		 * The actual filter code assumes the impulse response
		 * is in time reversed order. This will be anti-
		 * symmetric so the minus sign handles that for us.
		 */
		y = (2 * f2 * cosc(2 * f2 * t) -
		     2 * f1 * cosc(2 * f1 * t)) * hamming(h);
    filter[i]=complex<double>(x,-y);
  }

}

/*
 * Sinc done properly.
 */
double FSKDemodulator::sinc(double x)
{
	if (fabs(x) < 1e-10)
		return 1.0;
	else
		return sin(M_PI * x) / (M_PI * x);
}

/*
 * Don't ask...
 */
double FSKDemodulator::cosc(double x)
{
	if (fabs(x) < 1e-10)
		return 0.0;
	else
		return (1.0 - cos(M_PI * x)) / (M_PI * x);
}

/*
 * Hamming window function.
 */
double FSKDemodulator::hamming(double x)
{
	return 0.54 - 0.46 * cos(2 * M_PI * x);
}
/**
bool FSKDemodulator::init(double,int)
{
if ( (bins = new complex<float> [NumberofTones]) == NULL )
	return false;
if ( (twiddles = new complex<float> [SamplesPerBit]) == NULL )
	return false;

}
**/
complex<double> FSKDemodulator::Hilbert(double in)
{
complex<double> sum;
complex<double> *z;
int i,j;
sum= complex<double>(0.,0.);
FilterBuffer[Filterptr]=in;
z=filter+HilbertFilterLength-1;
//z=filter;
for(i=0;i<HilbertFilterLength;i++)
  {
   j = ( Filterptr - i + HilbertFilterLength ) % HilbertFilterLength;
  sum +=FilterBuffer[j] * (*z);
  z--;
  }
Filterptr = (Filterptr + 1) % HilbertFilterLength;
return sum;
}
