/***************************************************************************
                          |FILENAME|  -  description
                             -------------------
    begin                : |DATE|
    copyright            : (C) |YEAR| by |AUTHOR|
    email                : |EMAIL|
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatly, AE4JY             *
 ***************************************************************************/

#include "linpsk.h"

#include <qvariant.h>
#include <qfiledialog.h>
#include <qstring.h>
#include <qlayout.h>

#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qstatusbar.h>
#include <qlabel.h>
#include <qregexp.h>
#include <qtimer.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qspinbox.h>
#include <qmessagebox.h>
#include <qcolordialog.h>
#include <qcolor.h>
#include <qfontdialog.h>
#include <qtextedit.h>
#include <qdom.h>
#include <qradiobutton.h>

#include <unistd.h>

#include <vector>

#include "controlpanel.h"
#include "crxdisplay.h"
#include "ctxdisplay.h"
#include "ctxfunctions.h"
#include "parameter.h"
#include "addrxwindow.h"
#include "cspectrumdisplay.h"
#include "frequencyselect.h"
#include "cledbutton.h"
#include "rttymodulator.h"
#include "pskmodulator.h"
#include "bpskmodulator.h"
#include "qpskmodulator.h"
#include "mfskmodulator.h"
#include "ctxbuffer.h"
#include "crxchannel.h"
#include "input.h"
#include "textinput.h"
#include "waveinput.h"
#include "csound.h"
#include "generalsettings.h"
#include "utils.h"
#include "modemenu.h"
#include "macrowindow.h"
#include "addmacro.h"
#include "macros.h"
#include "qsodata.h"
#include "editmacro.h"
#include "color.h"
#include "crecording.h"
#include "config.h"

extern Parameter settings;
/* 
 *  Constructs a LinPSK as a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 */
LinPSK::LinPSK( QWidget* parent, const char* name, WFlags fl )
    : QMainWindow( parent, name, fl )
{
   RxDisplay = 0;
   TxDisplay = 0;
   Control = 0;
   Macro =new Macros(); // Macros will be used in read_config  
      if (! read_config())
      QMessageBox::information(0,"LinPsk",
        "LinPSK.config not found, using default values\nFile will be generated if you save the settings");
    if(WindowColors.size() == 0 )
      WindowColors.push_back(color[0]);
    Modulator = 0;
    setCentralWidget( new QWidget( this, "LinPsk 0.7.1" ) );
    centralWidget()->setMinimumSize(settings.MinimumWindowWidth,settings.MinimumWindowHeight);
    centralWidget()->setMaximumSize( 950, 700  );
    setMaximumSize(950,690);
#ifndef LINPSK_FOR_MAC
    setCaption(QString ("LinPSK " ) + QString(VERSION));
#else
    setCaption(QString ("DarwinPSK ") + QString(VERSION) );
#endif            

    apply_settings();
    QStatusBar *StatusBar=this->statusBar();
    StatusBar->setFixedHeight(settings.StatusBarHeight);

//Messages
	msg=new QLabel(StatusBar);
	StatusBar->addWidget(msg,2,true);
	msg->setText(tr("Ready"));

//AFC- Debugging
#ifdef AFC_DEBUG
	Error = new QLabel(StatusBar);
	StatusBar -> addWidget(Error,1,true);
	Df = new QLabel(StatusBar);
	StatusBar -> addWidget(Df,1,true);
	Dp = new QLabel(StatusBar);
	StatusBar -> addWidget(Dp,1,true);
#endif

// IMD
IMD = new QLabel(StatusBar);
StatusBar -> addWidget(IMD,1,true);


//Clockadjust
#ifndef AFC_DEBUG
clockadj=new QLabel(StatusBar);
clockadj->setText("CLK ppm = 0");
StatusBar->addWidget(clockadj,1,true);
#endif
// Time
zeit=new QLabel(StatusBar);
StatusBar->addWidget(zeit,1,true);

// date
datum=new QLabel(StatusBar);
StatusBar ->addWidget(datum,1,true);
setclock();

// Let the time pass
QTimer *clock=new QTimer(this);
connect(clock,SIGNAL(timeout()),SLOT(setclock()));
clock->start(60000,false);



    RxDisplay = new CRxDisplay( centralWidget(), "RxDisplay" );
    RxDisplay->setColorList(&WindowColors);
    TxDisplay = new CTxDisplay( centralWidget(), "TxDisplay" );

    Control = new ControlPanel( centralWidget(), "Control" );
    Control->SpectrumDisplay->setInputPointer(RxDisplay->FFTValues());
    Control->SpectrumDisplay->setColorList(&WindowColors);
    Control->MacroBox->updateMacroWindow(Macro);

    // actions
    // ================= File Actions ========
    Open_Demo_File = new QAction( this, "Open_Demo_File" );
    add_Rx_Window = new QAction( this, "add_Rx_Window" );
    fileExitAction = new QAction( this, "fileExitAction" );
    // ================= Help Actions =========
    helpContentsAction = new QAction( this, "helpContentsAction" );
    helpIndexAction = new QAction( this, "helpIndexAction" );
    helpAboutAction = new QAction( this, "helpAboutAction" );
    // ================= Settings =================    
    General_Settings = new QAction( this, "General_Settings" );
    AddMacros = new QAction( this, "AddMacros" );
    FontSettings = new QAction( this, "FontSettings" );
    ColorSettings = new QAction( this, "ColorSettings" );
    EditMacros = new QAction( this, "EditMacros" );
//    EditFiles = new QAction( this, "EditFiles" );
    SaveSettings = new QAction( this, "SaveSettings" );
    //================Actions for RX Window ===========
    Clear_RxWindow = new QAction (this,"Clear_Rx_Window");
    ChangeRxMode = new QAction(this,"Change_Rx_Mode");


    // menubar
    menubar = new QMenuBar( this, "menubar" );

    fileMenu = new QPopupMenu( this );
    // File Menu
    Open_Demo_File->addTo( fileMenu );
    add_Rx_Window->addTo( fileMenu );
    fileMenu->insertSeparator();
    fileMenu->insertSeparator();
    fileExitAction->addTo( fileMenu );
    menubar->insertItem( "", fileMenu, 0 );
    editMenu = new QPopupMenu( this );
    // Settings Menu
    General_Settings->addTo( editMenu );
    AddMacros->addTo( editMenu );
    editMenu->insertSeparator();
    FontSettings->addTo( editMenu );
    ColorSettings->addTo( editMenu );
    editMenu->insertSeparator();
    EditMacros->addTo( editMenu );
//    EditFiles->addTo( editMenu );
    editMenu->insertSeparator();
    SaveSettings->addTo( editMenu );
    menubar->insertItem( "", editMenu, 1 );
// ChangeRxParams
    changeRxParams = new QPopupMenu(this);
    ChangeRxMode->addTo(changeRxParams);
    changeRxParams->insertSeparator();
    Clear_RxWindow->addTo(changeRxParams);
    menubar->insertItem("",changeRxParams,2);
//
    menubar->insertSeparator(3);
// Helpmenu
    helpMenu = new QPopupMenu( this );

    helpContentsAction->addTo( helpMenu );
    helpIndexAction->addTo( helpMenu );
    helpMenu->insertSeparator();
    helpAboutAction->addTo( helpMenu );
    menubar->insertItem( "", helpMenu, 4 );

    languageChange();

    // signals and slots connections
    connect( fileExitAction, SIGNAL( activated() ), this, SLOT( Exit() ) );
    connect( helpIndexAction, SIGNAL( activated() ), this, SLOT( helpIndex() ) );
    connect( helpContentsAction, SIGNAL( activated() ), this, SLOT( helpContents() ) );
    connect( helpAboutAction, SIGNAL( activated() ), this, SLOT( helpAbout() ) );
    connect( Open_Demo_File, SIGNAL( activated() ), this, SLOT( fileOpen() ) );
    connect( add_Rx_Window, SIGNAL( activated() ), this, SLOT( addRxWindow() ) );
//=================================Settings Menu==================
    connect( General_Settings, SIGNAL( activated() ),this, SLOT(generalSettings() ) );
    connect( AddMacros,SIGNAL( activated() ), this, SLOT(addMacro()));
    connect( ColorSettings   , SIGNAL( activated() ),this, SLOT(chooseColor() ) );
    connect( FontSettings    , SIGNAL( activated() ),this, SLOT(FontSetup()   ) );
    connect( EditMacros      , SIGNAL( activated() ),this, SLOT(editMacro()   ) );
    connect( SaveSettings    , SIGNAL( activated() ),this, SLOT(saveSettings() ));
//================================= Rx Parames ===================
    connect ( ChangeRxMode   , SIGNAL( activated() ),this, SLOT(setRxMode()));
    connect ( Clear_RxWindow , SIGNAL( activated() ),settings.ActChannel, SLOT(clearRxWindow()));
//================================================================
    connect(TxDisplay,SIGNAL(startRx()),this,SLOT(startRx()));
    connect(TxDisplay,SIGNAL(startTx()),this,SLOT(startTx()));
    connect(Macro,SIGNAL(StartRx()),this,SLOT(startRx()));
    connect(Macro,SIGNAL(StartTx()),this,SLOT(startTx()));

    connect(RxDisplay,SIGNAL(startPlotting()),Control->SpectrumDisplay,SLOT(startPlot()));
    connect(Control->SpectrumDisplay,SIGNAL(FrequencyChanged(double)),RxDisplay->RxFreq,SLOT(setFrequency(double)));
    connect(Control->SpectrumDisplay,SIGNAL(new_IMD(float)),this,SLOT(setIMD(float)));
    connect(Control->MacroBox,SIGNAL(callMacro(int)),this,SLOT(executeMacro(int)));
    connect(RxDisplay,SIGNAL(newActiveChannel()),this,SLOT(setChannelParams()));
    connect(RxDisplay->Recording->Record,SIGNAL(toggled(bool)),this,SLOT(recording(bool)));
//===================================================================
TxBuffer = new CTxBuffer();
TxDisplay->TxWindow->setTxBuffer(TxBuffer);
TxTimer = new QTimer(this);
connect(TxTimer,SIGNAL(timeout()),this,SLOT(process_txdata()));
}

/*
 *  Destroys the object and frees any allocated resources
 */
LinPSK::~LinPSK()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void LinPSK::languageChange()
{

// File
    Open_Demo_File->setText( tr( "Open Demo File" ) );
    Open_Demo_File->setMenuText( tr( "&Open Demo File" ) );
    Open_Demo_File->setAccel( tr( "Ctrl+O" ) );
    fileExitAction->setText( tr( "Exit" ) );
    fileExitAction->setMenuText( tr( "E&xit" ) );
    fileExitAction->setAccel( QString::null );
// Help    
    helpContentsAction->setText( tr( "Contents" ) );
    helpContentsAction->setMenuText( tr( "&Contents..." ) );
    helpContentsAction->setAccel( QString::null );
    helpIndexAction->setText( tr( "Index" ) );
    helpIndexAction->setMenuText( tr( "&Index..." ) );
    helpIndexAction->setAccel( QString::null );
    helpAboutAction->setText( tr( "About" ) );
    helpAboutAction->setMenuText( tr( "&About" ) );
    helpAboutAction->setAccel( QString::null );
    add_Rx_Window->setText( tr( "add Rx Window" ) );
    add_Rx_Window->setMenuText( tr( "&Add another RxWindow" ) );
// Settings
    General_Settings->setText( tr( "General Settings" ) );
    AddMacros->setText( tr( "Add Macro" ) );
    FontSettings->setText( tr( "Font Settings" ) );
    ColorSettings->setText( tr( "Color Settings" ) );
    EditMacros->setText( tr( "Edit Macro" ) );
//    EditFiles->setText( tr( "Edit Files" ) );
    SaveSettings->setText( tr( "Save Settings" ) );
// Rx Params
    Clear_RxWindow->setMenuText( tr ("Clear active RX Channel") );
    ChangeRxMode->setMenuText( tr ("Change Mode of active Rx Channel") );
        
    menubar->findItem( 0 )->setText( tr( "&File" ) );
    menubar->findItem( 1 )->setText( tr( "&Settings" ) );
    menubar->findItem( 2 )->setText( tr( "&RxParams" ) );
    menubar->findItem( 4 )->setText( tr( "&Help" ) );
}

void LinPSK::fileOpen()
{
QString fileName;

    fileName = QFileDialog::getOpenFileName(0, settings.DemoModeFileType[settings.DemoTypeNumber],this);
  if (!fileName.isEmpty())
     settings.inputFilename = fileName;
}

void LinPSK::Exit()
{
    qApp->quit();

}

void LinPSK::helpIndex()
{

}

void LinPSK::helpContents()
{

}

void LinPSK::helpAbout()
{

}


void LinPSK::addRxWindow()
{

AddRxWindow *Channel=new AddRxWindow();
if ( Channel->exec() != 0)
  {
  if (WindowColors.size() <= settings.RxChannels )  
    WindowColors.push_back(color[(settings.RxChannels*51)% 256]);  
  RxDisplay->addRxWindow(Channel->Frequency->value(),
                         (Mode) Channel->RxMode->currentItem(),
                         Channel->TitleText->text());

  settings.ActChannel->setWindowColor(WindowColors.at(settings.RxChannels));
  settings.RxChannels++;  
  }

}



void LinPSK::calculateSizeofComponents()
{
/** Anteile in percent of mainwindow **/
/** RXDisplay **/
#define RXPART 36
/** TXDisplay **/
#define TXPART 20
/** Controlpanel **/
#define CONTROLPART 35
/** Statuspart **/
#define STATUSPART 3
int width,height;
int xpos,ypos;
int windowsheight;

width=this->width();
height=this->height();

xpos=0;
ypos=0;;
windowsheight=height*RXPART/100;
if (RxDisplay !=0 )
  RxDisplay->setGeometry(xpos,ypos,width,windowsheight);

ypos=ypos+windowsheight;
windowsheight=height*TXPART/100;
if (TxDisplay !=0)
  TxDisplay->setGeometry(xpos,ypos,width,windowsheight);
ypos=ypos+windowsheight;

windowsheight=height*CONTROLPART/100;
if (Control !=0)
  Control->setGeometry(xpos,ypos,width,windowsheight);
}



void LinPSK::resizeEvent( QResizeEvent * )
{
calculateSizeofComponents();
}


void LinPSK::setclock()
{
QCString s;
QDateTime t;
 t=QDateTime::currentDateTime();
 t=t.addSecs(settings.timeoffset*3600);
 s.sprintf(" %2d:%2d UTC",t.time().hour(),t.time().minute());
 s.replace(QRegExp(": "),":0");
 zeit->setText(s);
 zeit->update();
 s.sprintf("%2d.  %s.%4d",t.date().day(),t.date().monthName(t.date().month()).data(),t.date().year());
 datum->setText(s);
}

void LinPSK::setIMD(float IMDvalue)
{
QString s;
if ( IMDvalue != 0.0)
  s.sprintf(" IMD = %6.2f dB",IMDvalue);
else
  s.sprintf(" IMD " );
IMD->setText(s);
}
void LinPSK::startRx()
{
if ( Modulator != 0 )
  {
    while(TxBuffer->Filled()) // Wait until Buffer is not filled
      qApp->processEvents(100);
    TxBuffer->insert(TXOFF_CODE);
   }   
else  
  {
    if (Sound > 0)
     Sound->PTT(false); 
    if (RxDisplay->start_process_loop())
     {
      TxDisplay->TxFunctions->RXTX->setStatus(OFF);
      msg->setText(tr("Receiving"));
     } 
    else
    TxDisplay->TxFunctions->RXTX->setStatus(UNDEF);
   Control->SpectrumDisplay->show(); 
  }
settings.Status=TxDisplay->TxFunctions->RXTX->getstatus();  
}

void LinPSK::startTx()
{
Mode ModulationType;
QString errorstring;
QString Info;
double Frequency;

 
RxDisplay->stop_process_loop();
if (settings.ActChannel == 0 )
  {
   QMessageBox::critical(0," Programm Error! LinPsk","No active Channel available");
   TxDisplay->TxFunctions->RXTX->setStatus(UNDEF);
   return;
  }
ModulationType = settings.ActChannel->getModulationType();
if (TxDisplay->TxFreq->State()) // net ?
  TxDisplay->TxFreq->setFrequency(settings.ActChannel->getRxFrequency());
Frequency=TxDisplay->TxFreq->getFrequency();
switch (ModulationType)
  {
  case QPSK:
    Modulator = new QPskModulator(11025,Frequency,TxBuffer);
    Info="QPSK";
    break;
  case BPSK:
    Modulator = new BPSKModulator(11025,Frequency,TxBuffer);
    Info="BPSK";
    break;

  case RTTY:
    Modulator = new RTTYModulator(11025,Frequency,TxBuffer);
    Info="RTTY";
    break;
  case MFSK16:
    Modulator = new MFSKModulator(11025,Frequency,TxBuffer);
    Info="MFSK16";
    break;

  default:
    Modulator = new BPSKModulator(11025,Frequency,TxBuffer);
    Info="BPSK";
    break;
  }

if (settings.DemoMode)
  {
    if (settings.DemoTypeNumber == 0)
      Sound = new WaveInput(-1);
     else
      Sound = new TextInput(-1);
     msg->setText(tr("Transmitting (Demo)")); 
  }
else
  {
   settings.inputFilename=settings.SoundDevice; 
   Sound = new CSound(settings.serial);
  } 
if ( Sound <= 0 )
  {
    QMessageBox::critical(0," Programm Error! LinPsk","Could not open Sound Device for Output");
    TxDisplay->TxFunctions->RXTX->setStatus(ON);
    return;
  }

Sound->open_Device_write(settings.inputFilename);
if (!Sound->setParams(&errorstring))
  {
    QMessageBox::information(0,"LinPsk",errorstring);
    TxDisplay->TxFunctions->RXTX->setStatus(ON);
    return;
  }

connect(Modulator,SIGNAL(charSend(char)),settings.ActChannel,SLOT(updateRx(char)));
TxTimer->start(300,false);
TxDisplay->TxFunctions->RXTX->setStatus(ON);
Txcount=BUF_SIZE;
Sound->PTT(true);
msg->setText(tr("Transmitting ")+Info);
TxDisplay->TxWindow->setFocus();
settings.Status=TxDisplay->TxFunctions->RXTX->getstatus();
Control->SpectrumDisplay->hide();
}

void LinPSK::process_txdata()
{
int length;

if (Txcount >0)
  {
   length = Modulator->CalcSignal(Output,BUF_SIZE);
   if (length < 0)
     {
       length = -length;
       while ( (Txcount=Sound->putSamples(Output,length)) == 0 )
         qApp->processEvents(100);
       stopTx();
       return;  
      }
   }     
else
  length = BUF_SIZE;

Txcount=Sound->putSamples(Output,length); // If Txcount >= 0 and length < BUF_SIZE
                                          // we've reached end of Transmiision
                                       
}

void LinPSK::generalSettings()
{
GeneralSettings *LocalSettings=new GeneralSettings(this);
if ( LocalSettings->exec() != 0)
  settings = LocalSettings->getSettings();
delete LocalSettings;
apply_settings();  
}
void LinPSK::chooseColor()
{
int ID =settings.ActChannel->getID();  
QColor color=QColorDialog::getColor(WindowColors[ID],this);
if (color.isValid())
 {
   settings.ActChannel->setWindowColor(color);
   WindowColors[ID]=color;
   RxDisplay->repaint();
   RxDisplay->RxHeader->repaint();
  } 
    
}
void LinPSK::FontSetup()
{
bool ok;
QFont f=QFontDialog::getFont(&ok,font(),this);
if (ok)
  qApp->setFont(f,true);
}
void LinPSK::stopTx()
{
   TxTimer->stop();
   Modulator->disconnect();
   delete Modulator;
   Modulator = 0;
if ( Sound != 0)
  Sound->close_Device();
startRx();  
}

void LinPSK::apply_settings()
{
setVolume(settings.InputSource,settings.InputVolume);
setOutputVolume(settings.OutputVolume);
selectPTTDevice();    
}
void LinPSK::setChannelParams()
{
Control->SpectrumDisplay->setPhasePointer(settings.ActChannel->getPhasePointer());
Clear_RxWindow->disconnect();
Control->QSO->init();
connect ( Clear_RxWindow , SIGNAL( activated() ),settings.ActChannel, SLOT(clearRxWindow()));
}
void LinPSK::setRxMode()
{
ModeMenu *Menu = new ModeMenu();
 if ( Menu->exec() != 0)
  {
    settings.ActChannel->setMode((Mode) Menu->RxMode->currentItem());
    Control->SpectrumDisplay->setPhasePointer(settings.ActChannel->getPhasePointer());
  }  
}
void LinPSK::saveSettings()
{
QFile ConfigFile("LinPSKConfig.xml");
if( QDir::setCurrent(QDir::homeDirPath()) )
 {
  if ( ConfigFile.open(IO_WriteOnly) )	// File is writable
    {
      QDomDocument Configuration("LinpskConfiguration");
      QDomElement root=Configuration.createElement("Parameters");
      Configuration.appendChild(root);
/** Windows Parameter **/      
      QDomElement Element=Configuration.createElement("WindowsParameter");
      root.appendChild(Element);
      QDomElement MinimumWindowWidth=Configuration.createElement("MinimumWindowWidth");
      Element.appendChild(MinimumWindowWidth);
      MinimumWindowWidth.setAttribute("Value",settings.MinimumWindowWidth);
      QDomElement MinimumWindowHeight=Configuration.createElement("MinimumWindowHeight");
      Element.appendChild(MinimumWindowHeight);
      MinimumWindowHeight.setAttribute("Value",settings.MinimumWindowHeight);
      QDomElement StatusBarHeight=Configuration.createElement("StatusBarHeight");
      Element.appendChild(StatusBarHeight);
      StatusBarHeight.setAttribute("Value",settings.StatusBarHeight);
      QDomElement Windowfont=Configuration.createElement("Font");
      Element.appendChild(Windowfont);
      Windowfont.setAttribute("Name",qApp->font().family());
      Windowfont.setAttribute("Size",qApp->font().pointSize());
/** Colors **/
      if (WindowColors.size() > 0 )
      {
        QDomElement Colors=Configuration.createElement("Colors");
        root.appendChild(Colors);
        for(unsigned int i=0; i<WindowColors.size();i++)
        {
         QDomElement Color=Configuration.createElement("Color");

         Color.setAttribute("r",WindowColors[i].red());
         Color.setAttribute("g",WindowColors[i].green());
         Color.setAttribute("b",WindowColors[i].blue());
         Colors.appendChild(Color);        }
      }    
/** DemoMode **/            
      QDomElement DemoMode=Configuration.createElement("Mode");
      root.appendChild(DemoMode);
      if (settings.DemoMode)
        DemoMode.setAttribute("DemoMode","true");
      else
        DemoMode.setAttribute("DemoMode","false");
      DemoMode.setAttribute("DemoTypeNumber",settings.DemoTypeNumber);
      
      QDomElement Operating=Configuration.createElement("Operating");
      root.appendChild(Operating);
      QDomElement Callsign=Configuration.createElement("Callsign");
      Operating.appendChild(Callsign);
      Callsign.appendChild(Configuration.createTextNode(settings.callsign));

      QDomElement Ptt=Configuration.createElement("PTT");
      Operating.appendChild(Ptt);
      Ptt.setAttribute("Value",settings.ptt);
      Ptt.setAttribute("Device",settings.SerialDevice);
      QDomElement TimeOffset=Configuration.createElement("Timeoffset");
      Operating.appendChild(TimeOffset);
      TimeOffset.setAttribute("Value",settings.timeoffset);
      
      QDomElement Slashed0=Configuration.createElement("Slashed0");
      Operating.appendChild(Slashed0)            ;
      if ( settings.slashed0 )
       Slashed0.setAttribute("Value","true");
      else 
       Slashed0.setAttribute("Value","false");

      QDomElement InputSource=Configuration.createElement("InputSource");
      Operating.appendChild(InputSource);
      InputSource.setAttribute("Value",settings.InputSource);
      InputSource.setAttribute("Device",settings.SoundDevice);
      
      QDomElement InputVolume=Configuration.createElement("InputVolume");
      Operating.appendChild(InputVolume);
      InputVolume.setAttribute("Value",settings.InputVolume);

      QDomElement OutputVolume=Configuration.createElement("OutputVolume");
      Operating.appendChild(OutputVolume);
      OutputVolume.setAttribute("Value",settings.OutputVolume);
       if ( Macro->MacroNames.size() > 0 )
        {
         QDomElement Macrosection=Configuration.createElement("Macros");
         root.appendChild(Macrosection);
         for(unsigned int i=0; i<Macro->MacroNames.size();i++)
          {
            QDomElement Macrodefinition=Configuration.createElement("Macro");
            Macrosection.appendChild(Macrodefinition);
            QDomElement Name=Configuration.createElement("Name");
            Macrodefinition.appendChild(Name);
            Name.appendChild(Configuration.createTextNode(Macro->MacroNames[i]));
            QDomElement Definition=Configuration.createElement("Definition");
            Macrodefinition.appendChild(Definition);
            Definition.appendChild(Configuration.createTextNode(Macro->MacroText[i]));
            QDomElement Accelerator=Configuration.createElement("Accelerator");
            Macrodefinition.appendChild(Accelerator);
            Accelerator.appendChild(Configuration.createTextNode(Macro->Accelerator[i]));
            
          }
           
        }  

      QString s=Configuration.toString();
      ConfigFile.writeBlock(s,s.length());      
      ConfigFile.close();  
    }
  else
    QMessageBox::critical(0,"LinPSK","Could not write LinPskConfig.xml in home directory\n");      
 }
else
 QMessageBox::critical(0,"LinPSK","Could not switch to  home directory \n");    
}

void LinPSK::executeMacro(int MacroNumber)
{
Macro->executeMacro(MacroNumber,TxBuffer);
}

void LinPSK::addMacro()
{

AddMacro *NewMacro = new AddMacro();
NewMacro->setKeywords(Macro);
if ( NewMacro->exec() !=0 )
 {
  Macro->insert(NewMacro->MacroName->text(),
               NewMacro->MacroDefinition->text(),NewMacro->Accelerator->text(),NewMacro->Position->value());
  Control->MacroBox->updateMacroWindow(Macro);
 }
}
void LinPSK::editMacro()
{
 if ( Macro->MacroNames.size() > 0 )
  {  
    EditMacro *Edit = new EditMacro();
    Edit->init(Macro);
    if ( Edit->exec() !=0 )
      Control->MacroBox->updateMacroWindow(Macro);
   }   
}
bool LinPSK::read_config()
{
QFile ConfigFile("LinPSKConfig.xml");
QDomDocument Configuration("LinpskConfiguration");
QString s;

// Try to read settings from Configfile
s=QDir::homeDirPath();
QDir d=QDir::home();
d.setCurrent(s.data());
if ( ConfigFile.open(IO_ReadOnly) )	// File exists and is readable
	{
    if ( !Configuration.setContent(&ConfigFile) )
      {
        ConfigFile.close();
        return false;
       }
    QDomElement root = Configuration.documentElement();
    QDomNode n = root.firstChild();
    while( !n.isNull() )
    {
      s = n.nodeName();
       if (s == "WindowsParameter")
        {
         if (n.hasChildNodes() )
          {
           for(QDomNode n1=n.firstChild(); !n1.isNull(); n1=n1.nextSibling())
            {
             QDomElement e=n1.toElement();
             QString Name = e.tagName();
             if (Name == "Font")
              {
               QFont f(e.attribute("Name",qApp->font().family()),e.attribute("Size","10").toInt());
               qApp->setFont(f,true);
               }
              else
               {
                int Value=e.attribute("Value","0").toInt();
                if ( Value > 0)
                  {
                   if ( Name == "MinimumWindowWidth")
                     settings.MinimumWindowWidth=Value;
                    if ( Name == "MinimumWindowHeight")
                     settings.MinimumWindowHeight = Value;
                    if ( Name == "StatusBarHeight")
                     settings.StatusBarHeight = Value;
                   }   
                 }  // else
               }   // for
           }
        }
        else
         {
           if ( s == "Colors" )
            {
             int count=0;
             for(QDomNode n1=n.firstChild(); !n1.isNull(); n1=n1.nextSibling())
              count++;
             WindowColors.reserve(count);
             count =0;
             for(QDomNode n1=n.firstChild(); !n1.isNull(); n1=n1.nextSibling())
              {
                int r= n1.toElement().attribute("r","0").toInt();
                int g= n1.toElement().attribute("g","0").toInt();
                int b= n1.toElement().attribute("b","0").toInt();
                WindowColors.push_back(QColor(r,g,b));
              }
             } 
          if ( s == "Mode" )
            {
             settings.DemoTypeNumber =n.toElement().attribute("DemoTypeNumber","0").toInt();
             if  (n.toElement().attribute("DemoMode","true") == "true" )
              settings.DemoMode =true;
             else
             {
              settings.DemoMode=false;
              settings.inputFilename="";
             }       
            }
          if  ( s == "Operating" )
            {
             for(QDomNode n1=n.firstChild(); !n1.isNull(); n1=n1.nextSibling())
              {
                QString Value;
                QDomElement e=n1.toElement();
                QString Name = e.tagName();
                if ( Name == "Callsign")
                 settings.callsign=e.text();
                else
                  Value = e.attribute("Value","0");
                if ( Name == "PTT")
                 {
                  settings.ptt = Value.toInt();
                  settings.SerialDevice=e.attribute("Device",settings.SerialDevice);
                 } 
                if ( Name == "Timeoffset" )
                 settings.timeoffset = Value.toInt();
                if ( Name == "InputSource")
                 {
                  settings.InputSource = Value.toInt();
                  settings.SoundDevice = e.attribute("Device",settings.SoundDevice);
                 } 
                if ( Name == "InputVolume" )
                 settings.InputVolume = Value.toInt();
                if ( Name == "OutputVolume" )
                 settings.OutputVolume = Value.toInt();
                if ( Name == "Slasched0")
                 if ( Value == "true" )
                  settings.slashed0=true;
                 else
                  settings.slashed0=false;

              }
            }
           if ( s == "Macros" )
            {
             int count=0;
             for(QDomNode n1=n.firstChild(); !n1.isNull(); n1=n1.nextSibling())
              count++;
             Macro->MacroNames.reserve(count);
             Macro->MacroText.reserve(count);
             for(QDomNode n1=n.firstChild(); !n1.isNull(); n1=n1.nextSibling())
              {
               if ( n1.hasChildNodes() )
                {
                 QString s4=""; 
                 for(QDomNode n2=n1.firstChild(); !n2.isNull();n2=n2.nextSibling())
                  {
                   QString s3;
                    s3=n2.toElement().tagName(); 
                   if( s3 == "Name")
                    Macro->MacroNames.push_back(n2.toElement().text());
                   if(s3 == "Definition")
                    Macro->MacroText.push_back(n2.toElement().text());
                   if(s3 =="Accelerator" )
                    s4 = n2.toElement().text(); 
                  }
                  Macro->Accelerator.push_back(s4);
                }   
              }

             

            }
         }
        n = n.nextSibling();

    }
  ConfigFile.close();
  return true;
	}
else
  return false;
}
void LinPSK::selectPTTDevice()
{
#ifndef LINPSK_FOR_MAC

//if (settings.serial >0 )   // leads to crash, seems to overwrite call stack
//  close(settings.serial);
//settings.serial = -1;    
if (settings.ptt>0)
     settings.serial=open(settings.SerialDevice,O_EXCL);
int flags=TIOCM_RTS|TIOCM_DTR;
if (settings.serial >0)
 ioctl(settings.serial,TIOCMBIC,&flags);
else
 settings.ptt=0; //Their seems to be a wrong Value in the ConfigFile
#endif 
}
void LinPSK::recording(bool on)
{
  settings.ActChannel->record(on);
}
