/***************************************************************************
                          mfskdemodulator.h  -  description
                             -------------------
    begin                : Mit Jan 29 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   The PSK part is based on WinPSK 1.0 by Moe Wheatley, AE4JY            *              
 ***************************************************************************/

#ifndef MFSKDEMODULATOR_H
#define MFSKDEMODULATOR_H

#include <fskdemodulator.h>
#include <complex>
#include <vector>

using namespace std;
class Deinterleaver;
class Viterbi;
class MFSKVaricode;
/**
  *@author Volker Schroer
  */

class MFSKDemodulator : public FSKDemodulator  {
public: 
  MFSKDemodulator();
  ~MFSKDemodulator();
	/** Prozess the input */
	void ProcessInput(double * input);
  int getSquelchValue();
	bool Init(double,int);

private:

	/*
	 * Common stuff
	 */
	float phaseacc;
  int NumberofTones;

	/*
	 * RX related stuff
	 */
// Dimensions are 2 * SymbolLength, NumberofTones
// Switch later to Vector Construct
  complex<double> Pipe[1412][16];
//vector < vector< complex<double> > >  Pipe;

	unsigned int pipeptr;

	unsigned int datashreg;

	complex<double> currvector;
	complex<double> prev1vector;
	complex<double> prev2vector;

	int currsymbol;
	int prev1symbol;
	int prev2symbol;


	unsigned int symbolphase;
	unsigned int symboltime;
	float syncaverage;
	int synccounter;
MFSKVaricode *Decoder;
bool init_sfft(int);
Deinterleaver * leave;
complex<double> *history;
Viterbi * viterbi;
void sfft(complex<double>);
int decodesymbol(complex<double> *);
void recvsymbol(complex<double> *);
void synchronize();
void afc();
void recvbit(int);
int ptr;

inline unsigned char graydecode(unsigned char data)
{
	return data ^ (data >> 1);
}
inline unsigned char clamp(double x)
{
	return (x < 0) ? 0 : ((x > 255) ? 255 :(unsigned char) x);
}
};

#endif
