/***************************************************************************
                          parameter.h  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef PARAMETER_H
#define PARAMETER_H

#include <qapplication.h>
#include <qfont.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "portaudio.h"
#include <cledbutton.h>
#include "constants.h"

class CRxChannel;
class QString;
class QFont;

/**Contains parameters for transmitting and receiving

some of them are set by settup
  *@author Volker Schroer
  */

class Parameter
{

public: 
	Parameter();
	~Parameter();
void setupDevices();
// Variables

/** MinimumWindowWidth */
int MinimumWindowWidth;
/** MinimumWindowHeight */
int MinimumWindowHeight;
/** Height of Statusbar */
int StatusBarHeight;


QString callsign;                    // Callsign

QString inputFilename;              //Name of Demofile
QString DemoModeFileType[2];        // File Type of DemoFile
int DemoTypeNumber;                 // Index of selected FileType
int serial;                         // Filedescriptor for serial Device for PTT
QString SerialDevice;               //Filename for PTT Device
QString QSOFileName;                 // Name of the file, where qsodata will be stored
bool DemoMode;                      // DemoMode ?


int timeoffset;                     // offset to UTC
int clockerror;

/** DeviceSection */
bool isInitialized;
PaDeviceID *InputDevices;    // List of available InputDevices
int ActualInputDevice;       // Number of actual Device in List of InputDevices
int NumberofInputDevices;
PaDeviceID *OutputDevices;   // List of avaliable OutputDevices
int ActualOutputDevice;      // Number of actual Device in List of OutputDevices
int NumberofOutputDevices; 
int InputVolume;				//Input Volume off Mic
int OutputVolume;				//OutputVolume (line)

bool slashed0; 				// True if to print 0 slashed

unsigned int  RxChannels;
CRxChannel * ChannelChain;
CRxChannel * ActChannel;
QsoInfo *QslData;
BUTTONSTATUS Status;
QFont *ApplicationFont;

};

#endif
