/*
 *
 * Linup - Uptimes Project Client for Linux
 * Copyright (C) 2002  Joao Sena Ribeiro
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "linup.h"

/* crash(char*, char*) -> (void)
 *
 * Exits the program with EXIT_FAILURE error level.
 * Prints a message that tries to describe the problem (using perror()).
 *
 */
void crash(char *progname, char *arg) {
  char buff[BUFFSIZE];

  snprintf(buff, sizeof(buff), "%s: %s", progname, arg);

  perror(buff);

  exit(EXIT_FAILURE);
}

/* help_message(char*) -> (void)
 *
 * Displays an help message (which includes program name, author
 * and version - through version_message()).
 *
 */
void help_message(char *progname) {
  version_message();

  fprintf(stderr, "Usage:\n\n");

  fprintf(stderr, "  %s [OPTIONS] [-f <file> | -a <key>]\n\n", progname);

  fprintf(stderr, "  OPTIONS are optional and may be:\n");
  fprintf(stderr, "    -h\t\tPrints this help information and exits.\n");
  fprintf(stderr, "    -v\t\tPrints version information and exits.\n");
  fprintf(stderr, "    -o\t\tUses the old (TCP-based) 4.20 protocol.\n\n");

  fprintf(stderr, "  Additional OPTIONS when using old (4.20) protocol:\n");
  fprintf(stderr, "    -p <proxy>\tUses <proxy> as an HTTP proxy.\n");
  fprintf(stderr,
      "    -l <port>\tUses <port> to connect to the HTTP proxy.\n");
  fprintf(stderr,
      "      \t\tDefaults to port %d, if not given. \n", DEFAULTPROXYPORT);
  fprintf(stderr, "    -u <user>:<password>\n");
  fprintf(stderr,
      "      \t\tIf your proxy requires you to authenticate, you must use\n");
  fprintf(stderr,
      "      \t\tthis option, supplying your username and password.\n\n");

  fprintf(stderr, "  You must use either \"-f\" or \"-a\":\n");
  fprintf(stderr,
      "    -f <file>\tUses <file> as the file containing the auth key.\n");
  fprintf(stderr, "    -a <key> \tUses <key> as the auth key to use.\n\n");
}

/* version_message() -> (void)
 *
 * Displays program name, author and version.
 *
 */
void version_message(void) {
  fprintf(stderr, "%s %s, by %s.\n", PROGNAME, VERSION, AUTHOR);
}
