/*
 * da9052 RTC module declarations.
 *
 * Copyright(c) 2009 Dialog Semiconductor Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef __LINUX_MFD_DA9052_RTC_H
#define __LINUX_MFD_DA9052_RTC_H

#define DA9052_RTC_DEVICE_NAME				"da9052_rtc"

/*  Limit values */
#define DA9052_RTC_SECONDS_LIMIT			59
#define DA9052_RTC_MINUTES_LIMIT			59
#define DA9052_RTC_HOURS_LIMIT				23
#define DA9052_RTC_DAYS_LIMIT				31
#define DA9052_RTC_MONTHS_LIMIT				12
#define DA9052_RTC_YEARS_LIMIT				63

/* Months */
#define FEBRUARY					2
#define APRIL						4
#define JUNE						6
#define	SEPTEMBER					9
#define NOVEMBER					11

/* BYTE shifts */
#define DA9052_RTC_FOURTH_BYTE				24
#define DA9052_RTC_THIRD_BYTE				16
#define DA9052_RTC_SECOND_BYTE				8
#define DA9052_RTC_FIRST_BYTE				0

/* Oscillator trim values */
#define DA9052_RTC_OSC_FRQ_0_0ppm			0
#define DA9052_RTC_OSC_FRQ_1_9ppm			1
#define DA9052_RTC_OSC_FRQ_3_8ppm			2
#define DA9052_RTC_OSC_FRQ_5_7ppm			3
#define DA9052_RTC_OSC_FRQ_7_6ppm			4
#define DA9052_RTC_OSC_FRQ_9_5ppm			5
#define DA9052_RTC_OSC_FRQ_11_4ppm			6
#define DA9052_RTC_OSC_FRQ_13_3ppm			7
#define DA9052_RTC_OSC_FRQ_15_2ppm			8
#define DA9052_RTC_OSC_FRQ_17_1ppm			9
#define DA9052_RTC_OSC_FRQ_19_0ppm			10
#define DA9052_RTC_OSC_FRQ_20_9ppm			11
#define DA9052_RTC_OSC_FRQ_22_8ppm			12
#define DA9052_RTC_OSC_FRQ_24_7ppm			13
#define DA9052_RTC_OSC_FRQ_26_7ppm			14
#define DA9052_RTC_OSC_FRQ_28_6ppm			15
#define DA9052_RTC_OSC_FRQ_30_5ppm			16
#define DA9052_RTC_OSC_FRQ_32_4ppm			17
#define DA9052_RTC_OSC_FRQ_34_3ppm			18
#define DA9052_RTC_OSC_FRQ_36_2ppm			19
#define DA9052_RTC_OSC_FRQ_38_1ppm			20
#define DA9052_RTC_OSC_FRQ_40_0ppm			21
#define DA9052_RTC_OSC_FRQ_41_9ppm			22
#define DA9052_RTC_OSC_FRQ_43_8ppm			23
#define DA9052_RTC_OSC_FRQ_45_7ppm			24
#define DA9052_RTC_OSC_FRQ_47_6ppm			25
#define DA9052_RTC_OSC_FRQ_49_5ppm			26
#define DA9052_RTC_OSC_FRQ_51_4ppm			27
#define DA9052_RTC_OSC_FRQ_53_4ppm			28
#define DA9052_RTC_OSC_FRQ_55_3ppm			29
#define DA9052_RTC_OSC_FRQ_57_2ppm			30
#define DA9052_RTC_OSC_FRQ_59_1ppm			31
#define DA9052_RTC_OSC_FRQ_61_0ppm			32
#define DA9052_RTC_OSC_FRQ_62_9ppm			33
#define DA9052_RTC_OSC_FRQ_64_8ppm			34
#define DA9052_RTC_OSC_FRQ_66_7ppm			35
#define DA9052_RTC_OSC_FRQ_68_6ppm			36
#define DA9052_RTC_OSC_FRQ_70_5ppm			37
#define DA9052_RTC_OSC_FRQ_72_4ppm			38
#define DA9052_RTC_OSC_FRQ_74_3ppm			39
#define DA9052_RTC_OSC_FRQ_76_2ppm			40
#define DA9052_RTC_OSC_FRQ_78_2ppm			41
#define DA9052_RTC_OSC_FRQ_80_1ppm			42
#define DA9052_RTC_OSC_FRQ_82_0ppm			43
#define DA9052_RTC_OSC_FRQ_83_9ppm			44
#define DA9052_RTC_OSC_FRQ_85_8ppm			45
#define DA9052_RTC_OSC_FRQ_87_7ppm			46
#define DA9052_RTC_OSC_FRQ_89_6ppm			47
#define DA9052_RTC_OSC_FRQ_91_5ppm			48
#define DA9052_RTC_OSC_FRQ_93_4ppm			49
#define DA9052_RTC_OSC_FRQ_95_3ppm			50
#define DA9052_RTC_OSC_FRQ_97_2ppm			51
#define DA9052_RTC_OSC_FRQ_99_1ppm			52
#define DA9052_RTC_OSC_FRQ_101_0ppm			53
#define DA9052_RTC_OSC_FRQ_102_9ppm			54
#define DA9052_RTC_OSC_FRQ_104_9ppm			55
#define DA9052_RTC_OSC_FRQ_106_8ppm			56
#define DA9052_RTC_OSC_FRQ_108_7ppm			57
#define DA9052_RTC_OSC_FRQ_110_6ppm			58
#define DA9052_RTC_OSC_FRQ_112_5ppm			59
#define DA9052_RTC_OSC_FRQ_114_4ppm			60
#define DA9052_RTC_OSC_FRQ_116_3ppm			61
#define DA9052_RTC_OSC_FRQ_118_2ppm			62
#define DA9052_RTC_OSC_FRQ_120_1ppm			63
#define DA9052_RTC_OSC_FRQ_122_0ppm			64
#define DA9052_RTC_OSC_FRQ_123_9ppm			65
#define DA9052_RTC_OSC_FRQ_125_8ppm			66
#define DA9052_RTC_OSC_FRQ_127_7ppm			67
#define DA9052_RTC_OSC_FRQ_129_6ppm			68
#define DA9052_RTC_OSC_FRQ_131_6ppm			69
#define DA9052_RTC_OSC_FRQ_133_5ppm			70
#define DA9052_RTC_OSC_FRQ_135_4ppm			71
#define DA9052_RTC_OSC_FRQ_137_3ppm			72
#define DA9052_RTC_OSC_FRQ_139_2ppm			73
#define DA9052_RTC_OSC_FRQ_141_1ppm			74
#define DA9052_RTC_OSC_FRQ_143_0ppm			75
#define DA9052_RTC_OSC_FRQ_144_9ppm			76
#define DA9052_RTC_OSC_FRQ_146_8ppm			77
#define DA9052_RTC_OSC_FRQ_148_7ppm			78
#define DA9052_RTC_OSC_FRQ_150_6ppm			79
#define DA9052_RTC_OSC_FRQ_152_5ppm			80
#define DA9052_RTC_OSC_FRQ_154_4ppm			81
#define DA9052_RTC_OSC_FRQ_156_4ppm			82
#define DA9052_RTC_OSC_FRQ_158_3ppm			83
#define DA9052_RTC_OSC_FRQ_160_2ppm			84
#define DA9052_RTC_OSC_FRQ_162_1ppm			85
#define DA9052_RTC_OSC_FRQ_164_0ppm			86
#define DA9052_RTC_OSC_FRQ_165_9ppm			87
#define DA9052_RTC_OSC_FRQ_167_8ppm			88
#define DA9052_RTC_OSC_FRQ_169_7ppm			89
#define DA9052_RTC_OSC_FRQ_171_6ppm			90
#define DA9052_RTC_OSC_FRQ_173_5ppm			91
#define DA9052_RTC_OSC_FRQ_175_4ppm			92
#define DA9052_RTC_OSC_FRQ_177_3ppm			93
#define DA9052_RTC_OSC_FRQ_179_2ppm			94
#define DA9052_RTC_OSC_FRQ_181_1ppm			95
#define DA9052_RTC_OSC_FRQ_183_1ppm			96
#define DA9052_RTC_OSC_FRQ_185_0ppm			97
#define DA9052_RTC_OSC_FRQ_186_9ppm			98
#define DA9052_RTC_OSC_FRQ_188_8ppm			99
#define DA9052_RTC_OSC_FRQ_190_7ppm			100
#define DA9052_RTC_OSC_FRQ_192_6ppm			101
#define DA9052_RTC_OSC_FRQ_194_5ppm			102
#define DA9052_RTC_OSC_FRQ_196_4ppm			103
#define DA9052_RTC_OSC_FRQ_198_3ppm			104
#define DA9052_RTC_OSC_FRQ_200_2ppm			105
#define DA9052_RTC_OSC_FRQ_202_1ppm			106
#define DA9052_RTC_OSC_FRQ_204_0ppm			107
#define DA9052_RTC_OSC_FRQ_205_9ppm			108
#define DA9052_RTC_OSC_FRQ_207_9ppm			109
#define DA9052_RTC_OSC_FRQ_209_8ppm			110
#define DA9052_RTC_OSC_FRQ_211_7ppm			111
#define DA9052_RTC_OSC_FRQ_213_6ppm			112
#define DA9052_RTC_OSC_FRQ_215_5ppm			113
#define DA9052_RTC_OSC_FRQ_217_4ppm			114
#define DA9052_RTC_OSC_FRQ_219_3ppm			115
#define DA9052_RTC_OSC_FRQ_221_2ppm			116
#define DA9052_RTC_OSC_FRQ_223_1ppm			117
#define DA9052_RTC_OSC_FRQ_225_0ppm			118
#define DA9052_RTC_OSC_FRQ_226_9ppm			119
#define DA9052_RTC_OSC_FRQ_228_8ppm			120
#define DA9052_RTC_OSC_FRQ_230_7ppm			121
#define DA9052_RTC_OSC_FRQ_232_6ppm			122
#define DA9052_RTC_OSC_FRQ_234_6ppm			123
#define DA9052_RTC_OSC_FRQ_236_5ppm			124
#define DA9052_RTC_OSC_FRQ_238_4ppm			125
#define DA9052_RTC_OSC_FRQ_240_3ppm			126
#define DA9052_RTC_OSC_FRQ_242_2ppm			127
#define DA9052_RTC_OSC_FRQ_MINUS_244_1ppm		128
#define DA9052_RTC_OSC_FRQ_MINUS_242_2ppm		129
#define DA9052_RTC_OSC_FRQ_MINUS_240_3ppm		130
#define DA9052_RTC_OSC_FRQ_MINUS_238_4ppm		131
#define DA9052_RTC_OSC_FRQ_MINUS_236_5ppm		132
#define DA9052_RTC_OSC_FRQ_MINUS_234_6ppm		133
#define DA9052_RTC_OSC_FRQ_MINUS_232_6ppm		134
#define DA9052_RTC_OSC_FRQ_MINUS_230_7ppm		135
#define DA9052_RTC_OSC_FRQ_MINUS_228_8ppm		136
#define DA9052_RTC_OSC_FRQ_MINUS_226_9ppm		137
#define DA9052_RTC_OSC_FRQ_MINUS_225_0ppm		138
#define DA9052_RTC_OSC_FRQ_MINUS_223_1ppm		139
#define DA9052_RTC_OSC_FRQ_MINUS_221_2ppm		140
#define DA9052_RTC_OSC_FRQ_MINUS_219_3ppm		141
#define DA9052_RTC_OSC_FRQ_MINUS_217_4ppm		142
#define DA9052_RTC_OSC_FRQ_MINUS_215_5ppm		143
#define DA9052_RTC_OSC_FRQ_MINUS_213_6ppm		144
#define DA9052_RTC_OSC_FRQ_MINUS_211_7ppm		145
#define DA9052_RTC_OSC_FRQ_MINUS_209_8ppm		146
#define DA9052_RTC_OSC_FRQ_MINUS_207_9ppm		147
#define DA9052_RTC_OSC_FRQ_MINUS_205_9ppm		148
#define DA9052_RTC_OSC_FRQ_MINUS_204_0ppm		149
#define DA9052_RTC_OSC_FRQ_MINUS_202_1ppm		150
#define DA9052_RTC_OSC_FRQ_MINUS_200_2ppm		151
#define DA9052_RTC_OSC_FRQ_MINUS_198_3ppm		152
#define DA9052_RTC_OSC_FRQ_MINUS_196_4ppm		153
#define DA9052_RTC_OSC_FRQ_MINUS_194_5ppm		154
#define DA9052_RTC_OSC_FRQ_MINUS_192_6ppm		155
#define DA9052_RTC_OSC_FRQ_MINUS_190_7ppm		156
#define DA9052_RTC_OSC_FRQ_MINUS_188_8ppm		157
#define DA9052_RTC_OSC_FRQ_MINUS_186_9ppm		158
#define DA9052_RTC_OSC_FRQ_MINUS_185_0ppm		159
#define DA9052_RTC_OSC_FRQ_MINUS_183_1ppm		160
#define DA9052_RTC_OSC_FRQ_MINUS_181_1ppm		161
#define DA9052_RTC_OSC_FRQ_MINUS_179_2ppm		162
#define DA9052_RTC_OSC_FRQ_MINUS_177_3ppm		163
#define DA9052_RTC_OSC_FRQ_MINUS_175_4ppm		164
#define DA9052_RTC_OSC_FRQ_MINUS_173_5ppm		165
#define DA9052_RTC_OSC_FRQ_MINUS_171_6ppm		166
#define DA9052_RTC_OSC_FRQ_MINUS_169_7ppm		167
#define DA9052_RTC_OSC_FRQ_MINUS_167_8ppm		168
#define DA9052_RTC_OSC_FRQ_MINUS_165_9ppm		169
#define DA9052_RTC_OSC_FRQ_MINUS_164_0ppm		170
#define DA9052_RTC_OSC_FRQ_MINUS_162_1ppm		171
#define DA9052_RTC_OSC_FRQ_MINUS_160_2ppm		172
#define DA9052_RTC_OSC_FRQ_MINUS_158_3ppm		173
#define DA9052_RTC_OSC_FRQ_MINUS_156_4ppm		174
#define DA9052_RTC_OSC_FRQ_MINUS_154_4ppm		175
#define DA9052_RTC_OSC_FRQ_MINUS_152_5ppm		176
#define DA9052_RTC_OSC_FRQ_MINUS_150_6ppm		177
#define DA9052_RTC_OSC_FRQ_MINUS_148_7ppm		178
#define DA9052_RTC_OSC_FRQ_MINUS_146_8ppm		179
#define DA9052_RTC_OSC_FRQ_MINUS_144_9ppm		180
#define DA9052_RTC_OSC_FRQ_MINUS_143_0ppm		181
#define DA9052_RTC_OSC_FRQ_MINUS_141_1ppm		182
#define DA9052_RTC_OSC_FRQ_MINUS_139_2ppm		183
#define DA9052_RTC_OSC_FRQ_MINUS_137_3ppm		184
#define DA9052_RTC_OSC_FRQ_MINUS_135_4ppm		185
#define DA9052_RTC_OSC_FRQ_MINUS_133_5ppm		186
#define DA9052_RTC_OSC_FRQ_MINUS_131_6ppm		187
#define DA9052_RTC_OSC_FRQ_MINUS_129_6ppm		188
#define DA9052_RTC_OSC_FRQ_MINUS_127_7ppm		189
#define DA9052_RTC_OSC_FRQ_MINUS_125_8ppm		190
#define DA9052_RTC_OSC_FRQ_MINUS_123_9ppm		191
#define DA9052_RTC_OSC_FRQ_MINUS_122_0ppm		192
#define DA9052_RTC_OSC_FRQ_MINUS_120_1ppm		193
#define DA9052_RTC_OSC_FRQ_MINUS_118_2ppm		194
#define DA9052_RTC_OSC_FRQ_MINUS_116_3ppm		195
#define DA9052_RTC_OSC_FRQ_MINUS_114_4ppm		196
#define DA9052_RTC_OSC_FRQ_MINUS_112_5ppm		197
#define DA9052_RTC_OSC_FRQ_MINUS_110_6ppm		198
#define DA9052_RTC_OSC_FRQ_MINUS_108_7ppm		199
#define DA9052_RTC_OSC_FRQ_MINUS_106_8ppm		200
#define DA9052_RTC_OSC_FRQ_MINUS_104_9ppm		201
#define DA9052_RTC_OSC_FRQ_MINUS_102_9ppm		202
#define DA9052_RTC_OSC_FRQ_MINUS_101_0ppm		203
#define DA9052_RTC_OSC_FRQ_MINUS_99_1ppm		204
#define DA9052_RTC_OSC_FRQ_MINUS_97_2ppm		205
#define DA9052_RTC_OSC_FRQ_MINUS_95_3ppm		206
#define DA9052_RTC_OSC_FRQ_MINUS_93_4ppm		207
#define DA9052_RTC_OSC_FRQ_MINUS_91_5ppm		208
#define DA9052_RTC_OSC_FRQ_MINUS_89_6ppm		209
#define DA9052_RTC_OSC_FRQ_MINUS_87_7ppm		210
#define DA9052_RTC_OSC_FRQ_MINUS_85_8ppm		211
#define DA9052_RTC_OSC_FRQ_MINUS_83_9ppm		212
#define DA9052_RTC_OSC_FRQ_MINUS_82_0ppm		213
#define DA9052_RTC_OSC_FRQ_MINUS_80_1ppm		214
#define DA9052_RTC_OSC_FRQ_MINUS_78_2ppm		215
#define DA9052_RTC_OSC_FRQ_MINUS_76_2ppm		216
#define DA9052_RTC_OSC_FRQ_MINUS_74_3ppm		217
#define DA9052_RTC_OSC_FRQ_MINUS_72_4ppm		218
#define DA9052_RTC_OSC_FRQ_MINUS_70_5ppm		219
#define DA9052_RTC_OSC_FRQ_MINUS_68_6ppm		220
#define DA9052_RTC_OSC_FRQ_MINUS_66_7ppm		221
#define DA9052_RTC_OSC_FRQ_MINUS_64_8ppm		222
#define DA9052_RTC_OSC_FRQ_MINUS_62_9ppm		223
#define DA9052_RTC_OSC_FRQ_MINUS_61_0ppm		224
#define DA9052_RTC_OSC_FRQ_MINUS_59_1ppm		225
#define DA9052_RTC_OSC_FRQ_MINUS_57_2ppm		226
#define DA9052_RTC_OSC_FRQ_MINUS_55_3ppm		227
#define DA9052_RTC_OSC_FRQ_MINUS_53_4ppm		228
#define DA9052_RTC_OSC_FRQ_MINUS_51_4ppm		229
#define DA9052_RTC_OSC_FRQ_MINUS_49_5ppm		230
#define DA9052_RTC_OSC_FRQ_MINUS_47_6ppm		231
#define DA9052_RTC_OSC_FRQ_MINUS_45_7ppm		232
#define DA9052_RTC_OSC_FRQ_MINUS_43_8ppm		233
#define DA9052_RTC_OSC_FRQ_MINUS_41_9ppm		234
#define DA9052_RTC_OSC_FRQ_MINUS_40_0ppm		235
#define DA9052_RTC_OSC_FRQ_MINUS_38_1ppm		236
#define DA9052_RTC_OSC_FRQ_MINUS_36_2ppm		237
#define DA9052_RTC_OSC_FRQ_MINUS_34_3ppm		238
#define DA9052_RTC_OSC_FRQ_MINUS_32_4ppm		239
#define DA9052_RTC_OSC_FRQ_MINUS_30_5ppm		240
#define DA9052_RTC_OSC_FRQ_MINUS_28_6ppm		241
#define DA9052_RTC_OSC_FRQ_MINUS_26_7ppm		242
#define DA9052_RTC_OSC_FRQ_MINUS_24_7ppm		243
#define DA9052_RTC_OSC_FRQ_MINUS_22_8ppm		244
#define DA9052_RTC_OSC_FRQ_MINUS_20_9ppm		245
#define DA9052_RTC_OSC_FRQ_MINUS_19_0ppm		246
#define DA9052_RTC_OSC_FRQ_MINUS_17_1ppm		247
#define DA9052_RTC_OSC_FRQ_MINUS_15_2ppm		248
#define DA9052_RTC_OSC_FRQ_MINUS_13_3ppm		249
#define DA9052_RTC_OSC_FRQ_MINUS_11_4ppm		250
#define DA9052_RTC_OSC_FRQ_MINUS_9_5ppm			251
#define DA9052_RTC_OSC_FRQ_MINUS_7_6ppm			252
#define DA9052_RTC_OSC_FRQ_MINUS_5_7ppm			253
#define DA9052_RTC_OSC_FRQ_MINUS_3_8ppm			254
#define DA9052_RTC_OSC_FRQ_MINUS_1_9ppm			255

/* RTC error codes */
#define DA9052_RTC_INVALID_SECONDS			3
#define DA9052_RTC_INVALID_MINUTES			4
#define DA9052_RTC_INVALID_HOURS			5
#define DA9052_RTC_INVALID_DAYS				6
#define DA9052_RTC_INVALID_MONTHS			7
#define DA9052_RTC_INVALID_YEARS			8
#define DA9052_RTC_INVALID_EVENT			9
#define DA9052_RTC_INVALID_IOCTL			10
#define DA9052_RTC_INVALID_SETTING			11
#define DA9052_RTC_EVENT_ALREADY_REGISTERED		12
#define DA9052_RTC_EVENT_UNREGISTERED			13
#define DA9052_RTC_EVENT_REGISTRATION_FAILED		14
#define DA9052_RTC_EVENT_UNREGISTRATION_FAILED		15

#endif
/* __LINUX_MFD_DA9052_RTC_H */
