/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Frame_H
#define	FSK441Frame_H

#include <wx/wx.h>
#include <wx/listctrl.h>
#include <wx/notebook.h>

#include "commongui/RecordControl.h"
#include "commongui/TransmitControl.h"
#include "commongui/RemoteControl.h"
#include "commongui/MessageControl.h"
#include "commongui/ErrorEvent.h"
#include "commongui/ClockPanel.h"

#include "fsk441/FSK441Levels.h"
#include "fsk441/FSK441Spectrum.h"
#include "fsk441/FSK441Message.h"

#include "FSK441Display.h"
#include "FSK441LevelEvent.h"
#include "FSK441MessageEvent.h"
#include "FSK441SettingsControl.h"
#include "FSK441SpectrumEvent.h"

class CFSK441Frame : public wxFrame {
    public:
	CFSK441Frame();
	virtual ~CFSK441Frame();

	virtual void onOpen(const wxCommandEvent& event);
	virtual void onSaving(const wxCommandEvent& event);
	virtual void onDelete(const wxCommandEvent& event);
	virtual void onQuit(const wxCommandEvent& event);
	virtual void onPreferences(const wxCommandEvent& event);
	virtual void onAbout(const wxCommandEvent& event);

	virtual void onRecord(const wxCommandEvent& event);
	virtual void onTXOrder(const wxCommandEvent& event);
	virtual void onTXEnable(const wxCommandEvent& event);
	virtual void onUpdate(const wxCommandEvent& event);
	virtual void onMinLength(const wxSpinEvent& event);
	virtual void onMinStrength(const wxSpinEvent& event);
	virtual void onText(const wxCommandEvent& event);
	virtual void onMessage(const wxCommandEvent& event);

	virtual void onCardLevels(const CFSK441LevelEvent& event);
	virtual void onFileLevels(const CFSK441LevelEvent& event);

	virtual void onCardMessage(const CFSK441MessageEvent& event);
	virtual void onFileMessage(const CFSK441MessageEvent& event);

	virtual void onCardSpectrum(const CFSK441SpectrumEvent& event);
	virtual void onFileSpectrum(const CFSK441SpectrumEvent& event);

	virtual void onError(const CErrorEvent& event);

	virtual void showCardLevels(CFSK441Levels* levels);
	virtual void showFileLevels(CFSK441Levels* levels);

	virtual void showCardMessage(CFSK441Message* message);
	virtual void showFileMessage(CFSK441Message* message);

	virtual void showCardSpectrum(CFSK441Spectrum* spectrum);
	virtual void showFileSpectrum(CFSK441Spectrum* spectrum);

	virtual void setMinStrength(int strength);
	virtual void setMinLength(int length);

	virtual void error(const wxString& error);

    private:
	CFSK441Display*         m_cardDisplay;
	CFSK441Display*         m_fileDisplay;
	CRecordControl*         m_record;
	CTransmitControl*       m_transmit;
	CRemoteControl*         m_remote;
	CClockPanel*            m_clock;
	CFSK441SettingsControl* m_settings;
	CMessageControl*        m_message;
	int                     m_messageNo;

	DECLARE_EVENT_TABLE()

	wxMenuBar* createMenuBar();
};

#endif
