/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441SpectrumGraph.h"

#include "fsk441/FSK441Defs.h"

BEGIN_EVENT_TABLE(CFSK441SpectrumGraph, wxWindow)
	EVT_PAINT(CFSK441SpectrumGraph::onPaint)
END_EVENT_TABLE()

CFSK441SpectrumGraph::CFSK441SpectrumGraph(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size, long style, const wxString& name) :
wxWindow(parent, id, pos, size, style, name),
m_bitmap(NULL)
{
	m_bitmap = new wxBitmap(FSK441_SPECTRUM_WIDTH, FSK441_GRAPH_HEIGHT);

	// Flood the graph area with black to start with
	clearGraph();
}

CFSK441SpectrumGraph::~CFSK441SpectrumGraph()
{
	delete m_bitmap;
}

void CFSK441SpectrumGraph::addData(CFSK441Spectrum* spectrum)
{
	wxASSERT(spectrum != NULL);

	clearGraph();

	wxMemoryDC memoryDC;
	memoryDC.SelectObject(*m_bitmap);
	memoryDC.BeginDrawing();

	for (int i = 0; i < 4; i++) {
		double val = spectrum->getSpectrum(i);

		if (val < 0.0) val = 0.0;

		int n = int(val + 0.5);

		if (n > 16) n = 16;

		for (int j = 0; j < n; j++) {
			int y = FSK441_GRAPH_HEIGHT - j * (FSK441_GRAPH_HEIGHT / 16) - 7;
			int x = i * (FSK441_SPECTRUM_WIDTH / 4) + 3;

			memoryDC.SetPen(*wxRED_PEN);
			memoryDC.SetBrush(*wxRED_BRUSH);
			memoryDC.DrawRectangle(x, y, FSK441_SPECTRUM_WIDTH / 4 - 5, FSK441_GRAPH_HEIGHT / 16 - 1);
		}
	}

	memoryDC.EndDrawing();
	memoryDC.SelectObject(wxNullBitmap);

	wxClientDC clientDC(this);
	show(clientDC);
}

void CFSK441SpectrumGraph::onPaint(wxPaintEvent& event)
{
	wxPaintDC dc(this);

	show(dc);
}

void CFSK441SpectrumGraph::show(wxDC& dc)
{
	dc.BeginDrawing();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
	dc.EndDrawing();
}

void CFSK441SpectrumGraph::clearGraph()
{
	// Flood the graph area with black to start with
	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);
	dc.BeginDrawing();

	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();

	wxFont font(12, wxDEFAULT, wxNORMAL, wxNORMAL);
	dc.SetFont(font);
	dc.SetTextForeground(*wxWHITE);

	dc.DrawText(wxT("0"), 0 * FSK441_SPECTRUM_WIDTH / 4 + 15, 0);
	dc.DrawText(wxT("1"), 1 * FSK441_SPECTRUM_WIDTH / 4 + 15, 0);
	dc.DrawText(wxT("2"), 2 * FSK441_SPECTRUM_WIDTH / 4 + 15, 0);
	dc.DrawText(wxT("3"), 3 * FSK441_SPECTRUM_WIDTH / 4 + 15, 0);

	for (int i = 0; i < 4; i++) {
		for (int j = 0; j < 16; j++) {
			int y = FSK441_GRAPH_HEIGHT - j * (FSK441_GRAPH_HEIGHT / 16) - 7;
			int x = i * (FSK441_SPECTRUM_WIDTH / 4) + 3;

			dc.SetPen(*wxGREY_PEN);
			dc.SetBrush(*wxGREY_BRUSH);
			dc.DrawRectangle(x, y, FSK441_SPECTRUM_WIDTH / 4 - 5, FSK441_GRAPH_HEIGHT / 16 - 1);
		}
	}

	dc.EndDrawing();
}
