/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT44Decoder_H
#define	JT44Decoder_H

#include <wx/string.h>

#include "common/Average.h"

class CJT44Decoder {

    public:
	CJT44Decoder(const wxString& fileName);
	~CJT44Decoder();

	void run();

    private:
	wxString m_fileName;
	CAverage m_noise;

	void   storeCorrelations(CAverage** correlations, double* data, int samples) const;
	void   storeNoise(double* data);
	void   findCorrelation(CAverage** correlations, int& syncBin, int& offset) const;
	void   correlate(double* audioSamples, int samples, int syncBin, int& offset, double& quality) const;
	void   decode(double* audioSamples, int samples, int syncBin, int offset) const;
};

#endif
