package Lire::AsciiDlf::DerivedRecordsCreator;

use strict;

# We need to use Lire::DerivedSchema to see the subclass
use base qw/ Lire::DerivedSchema::DerivedRecordsCreator /;

use Carp;

use Lire::DerivedSchema;

sub init_computation {
    my ( $self, $dlf_info, $writer_cb ) = @_;
}

# Called once for each DLF record there is in the base source.
#
# When the DerivedRecordsCreator want's has completed a DLF record,
# it should call $writer_cb->write_dlf( $dlf );
#
sub dlf_record {
    my ( $self, $dlf, $writer_cb ) = @_;

    croak __PACKAGE__, "::dlf_record unimplemented method\n";
}

sub end_computation {
    my ( $self, $writer_cb ) = @_;
}

# keep perl happy
1;

__END__

=pod

=head1 NAME

Lire::AsciiDlf::ExtendedFieldsCreator -

=head1 SYNOPSIS


=head1 DESCRIPTION

=head1 VERSION

$Id: DerivedRecordsCreator.pm,v 1.6 2004/03/26 00:27:34 wsourdeau Exp $

=head1 COPYRIGHT

Copyright (C) 2001 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=cut


