package Lire::Config::DlfConverterSpec;

use strict;

=pod

=head1 Lire::Config::DlfConverterSpec

Type that represents a DLF converter name. Values of this type are names that
refer to any of the DLF converters.

=cut

use base qw/Lire::Config::PluginSpec/;

use Lire::Config::OptionSpec;
use Lire::DlfConverterManager;
use Carp;

sub is_valid {
    my ( $self, $val ) = @_;

    return 0 unless defined $val;

    return defined Lire::DlfConverterManager->instance()->get_converter($val);
}

sub normalize {
    my ( $self, $val ) = @_;

    return $self->is_valid( $val ) ? $val : undef;
}

sub add {
    croak( 'Lire::Config::DlfConverterSpec cannot contain any components' );
}

sub options {
    my $self = $_[0];

    my @options;

    my $mgr = Lire::DlfConverterManager->instance();
    my @names = map { new Lire::Config::OptionSpec( 'name' => $_ ) }
      $mgr->converter_names();

    return sort { $a->name() cmp $b->name() } @names;
}

1;

__END__

=pod

=head1 VERSION

$Id: DlfConverterSpec.pm,v 1.3 2004/03/28 23:09:45 wsourdeau Exp $

=head1 AUTHORS

Francis J. Lacoste <flacoste@logreport.org>
Wessel Dankers <wsl@logreport.org>
Wolfgang Sourdeau <wolfgang@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002-2004  Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut
