package Lire::Config::Legacy;

use strict;

use vars qw/ %map /;

BEGIN {
    %map = (
        'LR_GZIP' => 'gzip_path',
        'LR_TAR' => 'tar_path',
        'LR_ZIP' => 'zip_path',
        'LR_SENDMAIL' => 'sendmail_path',
        'LR_PLOTICUS' => 'ploticus_path',
        'LR_GHOSTSCRIPT' => 'ghostscript_path',
        'LR_SKIP_ID_TEST' => 'lr_test_uid',
        'LR_KEEP' => 'lr_keep',
        'LR_ARCHIVE' => 'lr_archive',
        'LR_ARCHIVEDIR' => 'lr_archive_dir',
        'LR_DEBUG' => 'lr_debug',
        'LR_LOGGING' => 'lr_logging_method',
        'LR_FACILITY' => 'lr_logging_facility',
        'LR_LOGGERTAG' => 'lr_logging_tag',
        'LR_DEFAULT_OUTPUT_FORMAT' => 'lr_output_format',
        'LR_INCLUDEIMAGES' => 'lr_images',
        'LR_IMAGE_FORMAT' => 'lr_image_format',
        'LR_IMAGE_STYLE' => 'lr_image_style',
        'LR_IMAGE_RESOLUTION' => 'lr_image_resolution',
        'LR_SCALE_BYTES' => 'lr_scale_bytes',
        'LR_SCALE_SEC' => 'lr_scale_seconds',
        'LR_SCALE_NUMBER' => 'lr_scale_numbers',
        'LR_USERLEVEL' => 'lr_user_level',
        'LR_WEEK_NUMBERING' => 'lr_week_numbering',
        'LR_PDF_STYLE' => 'lr_pdf_style',
        'LR_DBK_XML_DTD' => 'lr_dbk_xml_dtd',
        'LR_DBK_HTML_XSL' => 'lr_dbk_html_xsl',
        'LR_DBK_HTML_ONEPAGE_XSL' => 'lr_dbk_html_onepage_xsl',
        'LR_DBK_XHTML_XSL' => 'lr_dbk_xhtml_xsl',
        'LR_DBK_XHTML_ONEPAGE_XSL' => 'lr_dbk_xhtml_onepage_xsl',
        'LR_DBK_FO_XSL' => 'lr_dbk_fo_xsl',
        'LR_XMLCATALOG' => 'xmlcatalog_path',
        'LR_XSLT_PROCESSOR' => 'lr_xslt_processor',
        'LR_XSLTPROC' => 'xsltproc_path',
        'LR_JADE' => 'jade_path',
        'LR_PDFJADETEX' => 'pdfjadetex_path',
        'LR_PDFXMLTEX' => 'pdfxmltex_path',
        'LR_DBK_PRINT_STYLESHEET' => 'lr_dbk_print_stylesheet',
        'LR_DBK_XML_DTD' => 'lr_dbk_xml_dtd',
        'LR_SPOOLDIR' => 'lr_spool_dir',
        'LR_SPOOLINTERVAL' => 'lr_spool_interval',
        'LR_EXPLANATIONFILE' => 'lr_mail_explanation',
        'LR_DISCLAIMERFILE' => 'lr_mail_disclaimer',
        'LR_SIGNATUREFILE' => 'lr_mail_signature',
    );
}

1;

__END__

=pod

=head1 NAME

Lire::Config::Legacy - Legacy configuration mapping.

=head1 DESCRIPTION

This module contains a %map which maps old environment variable
to their newer XML configuration names.

=head1 VERSION

$Id: Legacy.pm,v 1.19 2004/04/07 22:27:11 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2003, 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=head1 AUTHOR

Wessel Dankers <wsl@logreport.org>

=cut

