package tests::ExtendedSchemaTest;

use strict;

use base qw/ Lire::Test::TestCase /;

use Lire::DlfSchema;
use Lire::ExtendedSchema;
use File::Basename qw/dirname/;
use Cwd qw/realpath/;

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->{'directory'} = realpath( dirname(__FILE__) . "/schemas" );

    # Make sure the Lire::DlfSchema can find our test schemas.
    $self->{'cfg'}{'lr_schemas_path'} = [ $self->{'directory'} ];
    $self->{'schema'} = Lire::DlfSchema::load_schema( "test-extended" );
}

sub test_id {
    my $self = $_[0];

    $self->assert_not_null( $self->{'schema'}, "schema is undefined" );
    $self->assert_equals( "test-extended", $self->{'schema'}->id );
}

sub test_superservice {
    my $self = $_[0];

    $self->assert_not_null( $self->{'schema'}, "schema is undefined" );
    $self->assert_equals( "test", $self->{'schema'}->superservice );
}

sub test_base {
    my $self = $_[0];

    $self->assert_not_null( $self->{'schema'}, "schema is undefined" );

    my $base = $self->{'schema'}->base;
    $self->assert_not_null( $self->{'schema'}, "base returned undef" );
    $self->assert_equals( "test", $base->id );
}

sub test_extended_fields {
    my $self = $_[0];

    my $mockfield = bless { 'name'	   => 'dirname',
                            'type'	   => 'filename',
                            'pos'	   => 9,
                            'description'  => "\n   <para>Contains the file's directory.</para>\n  ",
                            'default'	   => undef,
                            'label'	   => 'Directory',
                            'i18n_domain'  => 'lire-test',
                          }, 'Lire::Field';

    $self->assert_deep_equals( [ $mockfield ],
                               $self->{'schema'}->extended_fields() );
}

1;



