package tests::MaxTest;

use strict;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::Max;
use Lire::ReportSpec;
use tests::MockAggregator;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = shift->SUPER::set_up();

    $self->set_up_test_schema();

    $self->{'spec'} = new Lire::ReportSpec();
    $self->{'spec'}->superservice( 'test' );
    $self->{'spec'}->id( 'test-max' );

    my $mock = new tests::MockAggregator( 'report_spec' => $self->{'spec'} );

    $self->{'max'} = new Lire::Max( 'report_spec' => $self->{'spec'},
                                    'parent' => $mock,
                                    'field' => 'file_size',
                                    'name' => 'max' );

    return  $self;
}

sub test_sql_aggr_expr {
    my $self = $_[0];

    $self->{'max'}{'field'} = 'file-size';
    $self->assert_equals( 'max("file-size")', $self->{'max'}->sql_aggr_expr() );
}

1;
