package tests::OldDlfAdapterTest;

use strict;

use base qw/ Lire::Test::DlfConverterTestCase /;

use vars qw/$converter_script/;

use Lire::OldDlfAdapter;
use Lire::DlfConverterProcess;
use File::Basename qw/dirname/;
use Cwd qw/realpath/;
use Lire::Utils qw/tempdir create_file/;

BEGIN {
    $converter_script =
      realpath( dirname(__FILE__)  . '/helpers' ) . '/oldconverter2dlf';
    chmod 0755, $converter_script;
};

sub schema_fixtures {
    return
      {
       'message' => <<EOF,
<lire:dlf-schema superservice="message" timestamp="ts"
 xmlns:lire="http://www.logreport.org/LDSML/">
<lire:field name="ts"  type="timestamp"/>
<lire:field name="host"    type="hostname"/>
<lire:field name="ipaddr"  type="ip"/>
<lire:field name="message" type="string"/>
<lire:field name="status"  type="string"/>
</lire:dlf-schema>

EOF
      };
}

sub import_job_fixtures {
    return
      {
       'test' => <<EOF,
ts=1030000000;ipaddr=127.0.0.1;host=localhost;message=Test
ts=1030000100;ipaddr=192.168.1.1;message=Ping
ts=;message=Corrupted
ignored=field;ts=1030000200;host=host.test.com;message=This is a msg.
EOF
      };
}

my %results =
  (
   'test' =>
   {
    'line_count'  => 4,
    'error_count' => 1,
    'dlf_count'   => 3,
    'ignored_count' => 0,
    'saved_count' => 0,
    'dlf' =>
    {
     'message' =>
     [
      {
       'ts'      => 1030000000,
       'ipaddr'  => "127.0.0.1",
       'host'    => "localhost",
       'message' => "Test",
       'status'  => undef,
      },
      {
       'ts'      => 1030000100,
       'host'    => "-",
       'ipaddr'  => "192.168.1.1",
       'message' => "Ping",
       'status'  => undef,
      },
      {
       'ts'      => 1030000200,
       'host'    => "host.test.com",
       'ipaddr'  => "-",
       'message' => "This_is_a_msg.",
       'status'  => undef,
      },
     ],
    },
   },
  );



sub converter_fixtures {
    return
      [
       new Lire::OldDlfAdapter( "message", $converter_script ),
      ];
}

sub test_old_conversion {
    my $self = $_[0];

    local $ENV{'OldDlfAdapterTest'} = join( ":", @{Lire::Config->get( 'lr_schemas_path' )});
    my $p = $self->create_dlf_converter_process( "test", "oldconverter" );
    $p->run_import_job();
    $self->assert_dlf_converter_match_results( $results{'test'}, $p );
}

sub test_new {
    my $self = $_[0];

    $self->assert_died( sub { new Lire::OldDlfAdapter() },
                        qr/missing \'schema\' parameter/ );

    $self->assert_died( sub { new Lire::OldDlfAdapter( 'unknown', $converter_script ) },
                        qr/invalid schema name:/ );

    $self->assert_died( sub { new Lire::OldDlfAdapter( 'message' ) },
                        qr/missing \'script\' parameter/ );

    my $tmpdir = tempdir( "old_dlf_adapter_XXXXXX", 'CLEANUP' => 1 );
    create_file( $tmpdir . "oldconverter" );
    $self->assert_died( sub { new Lire::OldDlfAdapter( 'message', "$tmpdir/old_dlf_adapter" ) },
                        qr/script is not executable: \'/ );

    my $adapter = new Lire::OldDlfAdapter( "message", $converter_script );
    $self->assert_not_null( $adapter, "new() returned undef" );
    $self->assert( UNIVERSAL::isa( $adapter, "Lire::OldDlfAdapter" ),
                   "new() didn't return a Lire::OldDlfAdapter instance" );
}

1;
