package tests::OutputFormatTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::OutputFormat;
use Lire::Utils qw/tempfile/;

sub new {
    my $self = shift()->SUPER::new( @_ );

    $self->init();

    return $self;
}

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->init();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    unlink $self->{'unlink'}
      if $self->{'unlink'};

    return;
}

sub test_new {
    my $self = $_[0];

    $self->assert_dies( qr/'format' parameter should be one of 'docbook', 'excel95', 'html', 'pdf', 'txt' or 'xml'/,
                        sub { new Lire::OutputFormat( 'format' ) } );
}

sub test_new_docbook {
    my $self = $_[0];

    my $fmt = new Lire::OutputFormat( 'docbook', 'charts' => 1 );
    $self->assert_isa( 'Lire::OutputFormat::DocBook', $fmt );
    $self->assert_num_equals( 1, $fmt->{'_charts'} );
    $self->assert_num_equals( 1, $fmt->charts() );

    $self->assert_str_equals( '-i -o docbookx', $fmt->xml2mail_params() );
}

sub test_new_excel95 {
    my $self = $_[0];

    my $fmt = new Lire::OutputFormat( 'excel95' );
    $self->assert_isa( 'Lire::OutputFormat::Excel95', $fmt );

    $self->assert_str_equals( '-o excel95', $fmt->xml2mail_params() );
}

sub test_output_to_file_excel95 {
    my $self = $_[0];

    my ($fh, $file ) = tempfile( 'report_XXXXXX', 'SUFFIX' => 'xls' );
    $self->{'unlink'} = $file;
    close $fh;

    my $fmt = new Lire::OutputFormat( 'excel95' );
    $fmt->output_to_file( "$self->{'testdir'}/data/test-sqlite.xml",
                          $file );
    $self->assert( -s $file, "$file shouldn't be empty" );
}

sub test_new_html {
    my $self = $_[0];

    my $fmt = new Lire::OutputFormat( 'html', 'charts' => 1, 'one_page' => 1,);
    $self->assert_isa( 'Lire::OutputFormat::HTML', $fmt );
    $self->assert_num_equals( 1, $fmt->{'_charts'} );
    $self->assert_num_equals( 1, $fmt->charts() );
    $self->assert_num_equals( 1, $fmt->{'_one_page'} );
    $self->assert_num_equals( 1, $fmt->one_page() );
    $self->assert_num_equals( 1, $fmt->{'_xhtml'} );
    $self->assert_num_equals( 1, $fmt->xhtml() );
    $self->assert_str_equals( '-i -o xhtml_page', $fmt->xml2mail_params() );

    $fmt = new Lire::OutputFormat( 'html', 'xhtml' => 0 );
    $self->assert_isa( 'Lire::OutputFormat::HTML', $fmt );
    $self->assert_num_equals( 0, $fmt->{'_xhtml'} );
    $self->assert_str_equals( '-o html', $fmt->xml2mail_params() );
}

sub test_new_pdf {
    my $self = $_[0];

    my $fmt = new Lire::OutputFormat( 'pdf', 'charts' => 1 );
    $self->assert_isa( 'Lire::OutputFormat::PDF', $fmt );
    $self->assert_num_equals( 1, $fmt->{'_charts'} );
    $self->assert_num_equals( 1, $fmt->charts() );
    $self->assert_str_equals( '-i -o pdf', $fmt->xml2mail_params() );
}

sub test_new_txt {
    my $self = $_[0];

    my $fmt = new Lire::OutputFormat( 'txt', 'encoding' => 'UTF-8' );
    $self->assert_isa( 'Lire::OutputFormat::Text', $fmt );
    $self->assert_str_equals( 'UTF-8', $fmt->{'_encoding'} );
    $self->assert_str_equals( 'UTF-8', $fmt->encoding() );
    $self->assert_str_equals( '-o txt', $fmt->xml2mail_params() );
}

sub test_output_to_file_txt {
    my $self = $_[0];

    my ($fh, $file ) = tempfile( 'report_XXXXXX', 'SUFFIX' => 'txt' );
    $self->{'unlink'} = $file;
    close $fh;

    my $fmt = new Lire::OutputFormat( 'txt' );
    $fmt->output_to_file( "$self->{'testdir'}/data/test-sqlite.xml",
                          $file );
    $self->assert( -s $file, "$file shouldn't be empty" );
}

sub test_new_xml {
    my $self = $_[0];

    my $fmt = new Lire::OutputFormat( 'xml' );
    $self->assert_isa( 'Lire::OutputFormat::XML', $fmt );
    $self->assert_str_equals( '-o xml', $fmt->xml2mail_params() );
}

sub test_output_to_file_xml {
    my $self = $_[0];

    my ($fh, $file ) = tempfile( 'report_XXXXXX', 'SUFFIX' => 'xml' );
    $self->{'unlink'} = $file;
    close $fh;

    my $fmt = new Lire::OutputFormat( 'xml' );
    $fmt->output_to_file( "$self->{'testdir'}/data/test-sqlite.xml",
                          $file );
    $self->assert_str_equals( -s "$self->{'testdir'}/data/test-sqlite.xml",
                              -s $file );
}

1;
